/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring;

import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.components.JBList;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jet.runtime.typeinfo.KotlinSignature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.AsJavaPackage;
import org.jetbrains.kotlin.asJava.KotlinLightMethod;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.CodeInsightUtils;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.refactoring.JetRefactoringBundle;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.string.StringPackage;
import org.jetbrains.kotlin.lexer.JetModifierKeywordToken;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetCallElement;
import org.jetbrains.kotlin.psi.JetClassBody;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetFunctionLiteral;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetOperationExpression;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetQualifiedExpression;
import org.jetbrains.kotlin.psi.JetStatementExpression;
import org.jetbrains.kotlin.psi.JetSuperExpression;
import org.jetbrains.kotlin.psi.JetThisExpression;
import org.jetbrains.kotlin.psi.JetTypeElement;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilPackage;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.JetType;

public class JetRefactoringUtil {
    private JetRefactoringUtil() {
    }

    @NotNull
    public static JetModifierKeywordToken getVisibilityToken(@NotNull Visibility visibility) {
        if (visibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibility", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "getVisibilityToken"));
        }
        Visibility normalized = visibility.normalize();
        if (normalized == Visibilities.PUBLIC) {
            JetModifierKeywordToken jetModifierKeywordToken = JetTokens.PUBLIC_KEYWORD;
            if (jetModifierKeywordToken == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "getVisibilityToken"));
            }
            return jetModifierKeywordToken;
        }
        if (normalized == Visibilities.PROTECTED) {
            JetModifierKeywordToken jetModifierKeywordToken = JetTokens.PROTECTED_KEYWORD;
            if (jetModifierKeywordToken == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "getVisibilityToken"));
            }
            return jetModifierKeywordToken;
        }
        if (normalized == Visibilities.INTERNAL) {
            JetModifierKeywordToken jetModifierKeywordToken = JetTokens.INTERNAL_KEYWORD;
            if (jetModifierKeywordToken == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "getVisibilityToken"));
            }
            return jetModifierKeywordToken;
        }
        if (Visibilities.isPrivate(normalized)) {
            JetModifierKeywordToken jetModifierKeywordToken = JetTokens.PRIVATE_KEYWORD;
            if (jetModifierKeywordToken == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "getVisibilityToken"));
            }
            return jetModifierKeywordToken;
        }
        throw new IllegalArgumentException("Unexpected visibility '" + normalized + "'");
    }

    @NotNull
    public static String wrapOrSkip(@NotNull String s, boolean inCode) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "wrapOrSkip"));
        }
        String string = inCode ? "<code>" + s + "</code>" : s;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "wrapOrSkip"));
        }
        return string;
    }

    @NotNull
    public static String formatClassDescriptor(@NotNull DeclarationDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "formatClassDescriptor"));
        }
        String string = IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_IN_TYPES.render(classDescriptor);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "formatClassDescriptor"));
        }
        return string;
    }

    @NotNull
    public static String formatPsiClass(@NotNull PsiClass psiClass, boolean markAsJava, boolean inCode) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "formatPsiClass"));
        }
        String kind2 = psiClass.isInterface() ? "interface " : "class ";
        String description = kind2 + PsiFormatUtil.formatClass((PsiClass)psiClass, (int)4355);
        description = JetRefactoringUtil.wrapOrSkip(description, inCode);
        String string = markAsJava ? "[Java] " + description : description;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "formatPsiClass"));
        }
        return string;
    }

    @NotNull
    public static List<? extends PsiElement> checkSuperMethods(@NotNull JetDeclaration declaration, @Nullable Collection<PsiElement> ignore, @NotNull String actionStringKey) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "checkSuperMethods"));
        }
        if (actionStringKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionStringKey", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "checkSuperMethods"));
        }
        BindingContext bindingContext2 = ResolutionUtils.analyze(declaration, BodyResolveMode.FULL);
        CallableDescriptor declarationDescriptor = (CallableDescriptor)bindingContext2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, declaration);
        if (declarationDescriptor == null || declarationDescriptor instanceof LocalVariableDescriptor) {
            List<JetDeclaration> list = Collections.singletonList(declaration);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "checkSuperMethods"));
            }
            return list;
        }
        Project project = declaration.getProject();
        HashMap<PsiElement, CallableDescriptor> overriddenElementsToDescriptor = new HashMap<PsiElement, CallableDescriptor>();
        for (CallableDescriptor overriddenDescriptor : DescriptorUtils.getAllOverriddenDescriptors(declarationDescriptor)) {
            PsiElement overriddenDeclaration = DescriptorToSourceUtilsIde.INSTANCE$.getAnyDeclaration(project, overriddenDescriptor);
            if (!PsiTreeUtil.instanceOf((Object)overriddenDeclaration, (Class[])new Class[]{JetNamedFunction.class, JetProperty.class, PsiMethod.class})) continue;
            overriddenElementsToDescriptor.put(overriddenDeclaration, overriddenDescriptor);
        }
        if (ignore != null) {
            overriddenElementsToDescriptor.keySet().removeAll(ignore);
        }
        if (overriddenElementsToDescriptor.isEmpty()) {
            List<JetDeclaration> list = Collections.singletonList(declaration);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "checkSuperMethods"));
            }
            return list;
        }
        List<String> superClasses2 = JetRefactoringUtil.getClassDescriptions(overriddenElementsToDescriptor);
        List<? extends PsiElement> list = JetRefactoringUtil.askUserForMethodsToSearch(declaration, declarationDescriptor, overriddenElementsToDescriptor, superClasses2, actionStringKey);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "checkSuperMethods"));
        }
        return list;
    }

    @NotNull
    private static List<? extends PsiElement> askUserForMethodsToSearch(@NotNull JetDeclaration declaration, @NotNull CallableDescriptor declarationDescriptor, @NotNull Map<PsiElement, CallableDescriptor> overriddenElementsToDescriptor, @NotNull List<String> superClasses2, @NotNull String actionStringKey) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "askUserForMethodsToSearch"));
        }
        if (declarationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationDescriptor", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "askUserForMethodsToSearch"));
        }
        if (overriddenElementsToDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overriddenElementsToDescriptor", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "askUserForMethodsToSearch"));
        }
        if (superClasses2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClasses", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "askUserForMethodsToSearch"));
        }
        if (actionStringKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionStringKey", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "askUserForMethodsToSearch"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ArrayList arrayList = ContainerUtil.newArrayList(overriddenElementsToDescriptor.keySet());
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "askUserForMethodsToSearch"));
            }
            return arrayList;
        }
        String superClassesStr = "\n" + StringUtil.join(superClasses2, (String)"");
        String message = JetBundle.message("x.overrides.y.in.class.list", DescriptorRenderer.COMPACT_WITH_SHORT_TYPES.render(declarationDescriptor), IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_IN_TYPES.render(declarationDescriptor.getContainingDeclaration()), superClassesStr, JetBundle.message(actionStringKey, new Object[0]));
        int exitCode = Messages.showYesNoCancelDialog((Project)declaration.getProject(), (String)message, (String)IdeBundle.message((String)"title.warning", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
        switch (exitCode) {
            case 0: {
                ArrayList arrayList = ContainerUtil.newArrayList(overriddenElementsToDescriptor.keySet());
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "askUserForMethodsToSearch"));
                }
                return arrayList;
            }
            case 1: {
                List<JetDeclaration> list = Collections.singletonList(declaration);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "askUserForMethodsToSearch"));
                }
                return list;
            }
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "askUserForMethodsToSearch"));
        }
        return list;
    }

    @NotNull
    private static List<String> getClassDescriptions(@NotNull Map<PsiElement, CallableDescriptor> overriddenElementsToDescriptor) {
        if (overriddenElementsToDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overriddenElementsToDescriptor", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "getClassDescriptions"));
        }
        List list = ContainerUtil.map(overriddenElementsToDescriptor.entrySet(), (Function)new Function<Map.Entry<PsiElement, CallableDescriptor>, String>(){

            public String fun(Map.Entry<PsiElement, CallableDescriptor> entry) {
                String description;
                PsiElement element2 = entry.getKey();
                CallableDescriptor descriptor2 = entry.getValue();
                if (element2 instanceof JetNamedFunction || element2 instanceof JetProperty) {
                    description = JetRefactoringUtil.formatClassDescriptor(descriptor2.getContainingDeclaration());
                } else {
                    assert (element2 instanceof PsiMethod) : "Invalid element: " + element2.getText();
                    PsiClass psiClass = ((PsiMethod)element2).getContainingClass();
                    assert (psiClass != null) : "Invalid element: " + element2.getText();
                    description = JetRefactoringUtil.formatPsiClass(psiClass, true, false);
                }
                return "    " + description + "\n";
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "getClassDescriptions"));
        }
        return list;
    }

    @NotNull
    public static String formatClass(@NotNull DeclarationDescriptor classDescriptor, boolean inCode) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "formatClass"));
        }
        PsiElement element2 = DescriptorToSourceUtils.descriptorToDeclaration(classDescriptor);
        if (element2 instanceof PsiClass) {
            String string = JetRefactoringUtil.formatPsiClass((PsiClass)element2, false, inCode);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "formatClass"));
            }
            return string;
        }
        String string = JetRefactoringUtil.wrapOrSkip(JetRefactoringUtil.formatClassDescriptor(classDescriptor), inCode);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "formatClass"));
        }
        return string;
    }

    @NotNull
    public static String formatFunction(@NotNull DeclarationDescriptor functionDescriptor, boolean inCode) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "formatFunction"));
        }
        PsiElement element2 = DescriptorToSourceUtils.descriptorToDeclaration(functionDescriptor);
        if (element2 instanceof PsiMethod) {
            String string = JetRefactoringUtil.formatPsiMethod((PsiMethod)element2, false, inCode);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "formatFunction"));
            }
            return string;
        }
        String string = JetRefactoringUtil.wrapOrSkip(JetRefactoringUtil.formatFunctionDescriptor(functionDescriptor), inCode);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "formatFunction"));
        }
        return string;
    }

    @NotNull
    private static String formatFunctionDescriptor(@NotNull DeclarationDescriptor functionDescriptor) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "formatFunctionDescriptor"));
        }
        String string = DescriptorRenderer.COMPACT.render(functionDescriptor);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "formatFunctionDescriptor"));
        }
        return string;
    }

    @NotNull
    public static String formatPsiMethod(@NotNull PsiMethod psiMethod, boolean showContainingClass, boolean inCode) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "formatPsiMethod"));
        }
        int options = 259;
        if (showContainingClass) {
            options |= 0x1000;
        }
        String description = PsiFormatUtil.formatMethod((PsiMethod)psiMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)options, (int)2);
        description = JetRefactoringUtil.wrapOrSkip(description, inCode);
        String string = "[Java] " + description;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "formatPsiMethod"));
        }
        return string;
    }

    @NotNull
    public static String formatJavaOrLightMethod(@NotNull PsiMethod method) {
        JetDeclaration jetDeclaration;
        BindingContext bindingContext2;
        DeclarationDescriptor descriptor2;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "formatJavaOrLightMethod"));
        }
        PsiElement originalDeclaration = AsJavaPackage.getUnwrapped((PsiElement)method);
        if (originalDeclaration instanceof JetDeclaration && (descriptor2 = (bindingContext2 = ResolutionUtils.analyze(jetDeclaration = (JetDeclaration)originalDeclaration, BodyResolveMode.FULL)).get(BindingContext.DECLARATION_TO_DESCRIPTOR, jetDeclaration)) != null) {
            String string = JetRefactoringUtil.formatFunctionDescriptor(descriptor2);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "formatJavaOrLightMethod"));
            }
            return string;
        }
        String string = JetRefactoringUtil.formatPsiMethod(method, false, false);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "formatJavaOrLightMethod"));
        }
        return string;
    }

    @NotNull
    public static String formatClass(@NotNull JetClassOrObject classOrObject) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "formatClass"));
        }
        BindingContext bindingContext2 = ResolutionUtils.analyze(classOrObject, BodyResolveMode.FULL);
        DeclarationDescriptor descriptor2 = bindingContext2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, classOrObject);
        if (descriptor2 instanceof ClassDescriptor) {
            String string = JetRefactoringUtil.formatClassDescriptor(descriptor2);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "formatClass"));
            }
            return string;
        }
        String string = "class " + classOrObject.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "formatClass"));
        }
        return string;
    }

    @KotlinSignature(value="fun checkParametersInMethodHierarchy(parameter: PsiParameter): MutableCollection<out PsiElement>?")
    @Nullable
    public static Collection<? extends PsiElement> checkParametersInMethodHierarchy(@NotNull PsiParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "checkParametersInMethodHierarchy"));
        }
        PsiMethod method = (PsiMethod)parameter.getDeclarationScope();
        Set<PsiElement> parametersToDelete = JetRefactoringUtil.collectParametersHierarchy(method, parameter);
        if (parametersToDelete.size() > 1) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return parametersToDelete;
            }
            String message = JetBundle.message("delete.param.in.method.hierarchy", JetRefactoringUtil.formatJavaOrLightMethod(method));
            int exitCode = Messages.showOkCancelDialog((Project)parameter.getProject(), (String)message, (String)IdeBundle.message((String)"title.warning", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
            if (exitCode == 0) {
                return parametersToDelete;
            }
            return null;
        }
        return parametersToDelete;
    }

    @NotNull
    private static Set<PsiElement> collectParametersHierarchy(@NotNull PsiMethod method, @NotNull PsiParameter parameter) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "collectParametersHierarchy"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "collectParametersHierarchy"));
        }
        ArrayDeque<PsiMethod> queue = new ArrayDeque<PsiMethod>();
        HashSet<PsiMethod> visited = new HashSet<PsiMethod>();
        HashSet<PsiElement> parametersToDelete = new HashSet<PsiElement>();
        queue.add(method);
        while (!queue.isEmpty()) {
            PsiMethod currentMethod = (PsiMethod)queue.poll();
            visited.add(currentMethod);
            JetRefactoringUtil.addParameter(currentMethod, parametersToDelete, parameter);
            for (PsiMethod superMethod : currentMethod.findSuperMethods(true)) {
                if (visited.contains(superMethod)) continue;
                queue.offer(superMethod);
            }
            for (PsiMethod overrider : OverridingMethodsSearch.search((PsiMethod)currentMethod)) {
                if (visited.contains(overrider)) continue;
                queue.offer(overrider);
            }
        }
        HashSet<PsiElement> hashSet = parametersToDelete;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "collectParametersHierarchy"));
        }
        return hashSet;
    }

    private static void addParameter(@NotNull PsiMethod method, @NotNull Set<PsiElement> result2, @NotNull PsiParameter parameter) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "addParameter"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "addParameter"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "addParameter"));
        }
        int parameterIndex = PsiUtilPackage.parameterIndex(AsJavaPackage.getUnwrapped((PsiElement)parameter));
        if (method instanceof KotlinLightMethod) {
            JetDeclaration declaration = ((KotlinLightMethod)method).getOrigin();
            if (declaration instanceof JetFunction) {
                result2.add(((JetFunction)declaration).getValueParameters().get(parameterIndex));
            }
        } else {
            result2.add((PsiElement)method.getParameterList().getParameters()[parameterIndex]);
        }
    }

    public static void selectExpression(@NotNull Editor editor, @NotNull PsiFile file, @NotNull SelectExpressionCallback callback) throws IntroduceRefactoringException {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "selectExpression"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "selectExpression"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "selectExpression"));
        }
        JetRefactoringUtil.selectExpression(editor, file, true, callback);
    }

    public static void selectExpression(@NotNull Editor editor, @NotNull PsiFile file, boolean failOnEmptySuggestion, @NotNull SelectExpressionCallback callback) throws IntroduceRefactoringException {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "selectExpression"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "selectExpression"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "selectExpression"));
        }
        if (editor.getSelectionModel().hasSelection()) {
            int selectionStart;
            int selectionEnd = editor.getSelectionModel().getSelectionEnd();
            String text = file.getText();
            for (selectionStart = editor.getSelectionModel().getSelectionStart(); selectionStart < selectionEnd && Character.isSpaceChar(text.charAt(selectionStart)); ++selectionStart) {
            }
            while (selectionStart < selectionEnd && Character.isSpaceChar(text.charAt(selectionEnd - 1))) {
                --selectionEnd;
            }
            callback.run(JetRefactoringUtil.findExpression(file, selectionStart, selectionEnd, failOnEmptySuggestion));
        } else {
            int offset2 = editor.getCaretModel().getOffset();
            JetRefactoringUtil.smartSelectExpression(editor, file, offset2, failOnEmptySuggestion, callback);
        }
    }

    public static List<JetExpression> getSmartSelectSuggestions(@NotNull PsiFile file, int offset2) throws IntroduceRefactoringException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "getSmartSelectSuggestions"));
        }
        if (offset2 < 0) {
            return new ArrayList<JetExpression>();
        }
        PsiElement element2 = file.findElementAt(offset2);
        if (element2 == null) {
            return new ArrayList<JetExpression>();
        }
        if (element2 instanceof PsiWhiteSpace) {
            return JetRefactoringUtil.getSmartSelectSuggestions(file, offset2 - 1);
        }
        ArrayList<JetExpression> expressions = new ArrayList<JetExpression>();
        while (!(element2 == null || element2 instanceof JetBlockExpression && !(element2.getParent() instanceof JetFunctionLiteral) || element2 instanceof JetNamedFunction || element2 instanceof JetClassBody)) {
            if (element2 instanceof JetExpression && !(element2 instanceof JetStatementExpression)) {
                JetExpression expression2;
                BindingContext bindingContext2;
                JetType expressionType;
                JetOperationExpression operationExpression;
                boolean addExpression = true;
                if (JetPsiUtil.isLabelIdentifierExpression(element2)) {
                    addExpression = false;
                } else if (element2.getParent() instanceof JetQualifiedExpression) {
                    JetQualifiedExpression qualifiedExpression = (JetQualifiedExpression)element2.getParent();
                    if (qualifiedExpression.getReceiverExpression() != element2) {
                        addExpression = false;
                    }
                } else if (element2.getParent() instanceof JetCallElement || element2.getParent() instanceof JetThisExpression || PsiTreeUtil.getParentOfType((PsiElement)element2, JetSuperExpression.class) != null) {
                    addExpression = false;
                } else if (element2.getParent() instanceof JetOperationExpression && (operationExpression = (JetOperationExpression)element2.getParent()).getOperationReference() == element2) {
                    addExpression = false;
                }
                if (addExpression && ((expressionType = (bindingContext2 = ResolutionUtils.analyze(expression2 = (JetExpression)element2, BodyResolveMode.FULL)).getType(expression2)) == null || !KotlinBuiltIns.isUnit(expressionType))) {
                    expressions.add(expression2);
                }
            } else if (element2 instanceof JetTypeElement) {
                expressions.clear();
            }
            element2 = element2.getParent();
        }
        return expressions;
    }

    private static void smartSelectExpression(@NotNull Editor editor, @NotNull PsiFile file, int offset2, boolean failOnEmptySuggestion, final @NotNull SelectExpressionCallback callback) throws IntroduceRefactoringException {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "smartSelectExpression"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "smartSelectExpression"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "smartSelectExpression"));
        }
        List<JetExpression> expressions = JetRefactoringUtil.getSmartSelectSuggestions(file, offset2);
        if (expressions.size() == 0) {
            if (failOnEmptySuggestion) {
                throw new IntroduceRefactoringException(JetRefactoringBundle.message("cannot.refactor.not.expression", new Object[0]));
            }
            return;
        }
        if (expressions.size() == 1 || ApplicationManager.getApplication().isUnitTestMode()) {
            callback.run(expressions.get(0));
            return;
        }
        DefaultListModel<JetExpression> model = new DefaultListModel<JetExpression>();
        for (JetExpression expression2 : expressions) {
            model.addElement(expression2);
        }
        final ScopeHighlighter highlighter = new ScopeHighlighter(editor);
        JBList list = new JBList(model);
        list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(@NotNull JList list, Object value2, int index2, boolean isSelected, boolean cellHasFocus) {
                if (list == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil$2", "getListCellRendererComponent"));
                }
                Component rendererComponent = super.getListCellRendererComponent((JList<?>)list, value2, index2, isSelected, cellHasFocus);
                JetExpression element2 = (JetExpression)value2;
                if (element2.isValid()) {
                    this.setText(JetRefactoringUtil.getExpressionShortText(element2));
                }
                return rendererComponent;
            }
        });
        list.addListSelectionListener(new ListSelectionListener((JList)list, model){
            final /* synthetic */ JList val$list;
            final /* synthetic */ DefaultListModel val$model;
            {
                this.val$list = jList;
                this.val$model = defaultListModel;
            }

            @Override
            public void valueChanged(@NotNull ListSelectionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil$3", "valueChanged"));
                }
                highlighter.dropHighlight();
                int selectedIndex = this.val$list.getSelectedIndex();
                if (selectedIndex < 0) {
                    return;
                }
                JetExpression expression2 = (JetExpression)this.val$model.get(selectedIndex);
                ArrayList<JetExpression> toExtract = new ArrayList<JetExpression>();
                toExtract.add(expression2);
                highlighter.highlight((PsiElement)expression2, toExtract);
            }
        });
        JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle(JetRefactoringBundle.message("expressions.title", new Object[0])).setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(new Runnable((JList)list){
            final /* synthetic */ JList val$list;
            {
                this.val$list = jList;
            }

            @Override
            public void run() {
                callback.run((JetExpression)this.val$list.getSelectedValue());
            }
        }).addListener((JBPopupListener)new JBPopupAdapter(){

            public void onClosed(LightweightWindowEvent event) {
                highlighter.dropHighlight();
            }
        }).createPopup().showInBestPositionFor(editor);
    }

    public static String getExpressionShortText(@NotNull JetElement element2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "getExpressionShortText"));
        }
        return StringPackage.collapseSpaces(StringUtil.shortenTextWithEllipsis((String)element2.getText(), (int)53, (int)0));
    }

    @Nullable
    private static JetExpression findExpression(@NotNull PsiFile file, int startOffset, int endOffset, boolean failOnNoExpression) throws IntroduceRefactoringException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/refactoring/JetRefactoringUtil", "findExpression"));
        }
        JetExpression element2 = CodeInsightUtils.findExpression(file, startOffset, endOffset);
        if (element2 == null) {
            if (failOnNoExpression) {
                throw new IntroduceRefactoringException(JetRefactoringBundle.message("cannot.refactor.not.expression", new Object[0]));
            }
            return null;
        }
        return element2;
    }

    public static class IntroduceRefactoringException
    extends Exception {
        private final String myMessage;

        public IntroduceRefactoringException(String message) {
            this.myMessage = message;
        }

        @Override
        public String getMessage() {
            return this.myMessage;
        }
    }

    public static interface SelectExpressionCallback {
        public void run(@Nullable JetExpression var1);
    }
}

