/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.changeSignature;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.changeSignature.CallerUsageInfo;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureUsageProcessor;
import com.intellij.refactoring.changeSignature.JavaChangeInfo;
import com.intellij.refactoring.changeSignature.OverriderUsageInfo;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import com.intellij.refactoring.rename.ResolveSnapshotProvider;
import com.intellij.refactoring.rename.UnresolvableCollisionUsageInfo;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinPackage;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.AsJavaPackage;
import org.jetbrains.kotlin.asJava.KotlinLightMethod;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.idea.JetFileType;
import org.jetbrains.kotlin.idea.analysis.AnalysisPackage;
import org.jetbrains.kotlin.idea.caches.resolve.JavaResolutionUtils;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.codeInsight.JetFileReferencesResolver;
import org.jetbrains.kotlin.idea.refactoring.RefactoringPackage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.ChangeSignaturePackage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetChangeInfo;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetChangeSignatureData;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetMethodDescriptor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetParameterInfo;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetValVar;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.DeferredJavaMethodKotlinCallerUsage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.DeferredJavaMethodOverrideOrSAMUsage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.JavaConstructorDeferredUsageInDelegationCall;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.JavaMethodDeferredKotlinUsage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.JavaMethodKotlinCallUsage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.JavaMethodKotlinUsageWithDelegate;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.JetCallableDefinitionUsage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.JetConstructorDelegationCallUsage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.JetEnumEntryWithoutSuperCallUsage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.JetFunctionCallUsage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.JetImplicitThisToParameterUsage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.JetImplicitThisUsage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.JetNonQualifiedOuterThisUsage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.JetParameterUsage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.JetPropertyCallUsage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.JetUsageInfo;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.KotlinCallerCallUsage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.KotlinCallerUsage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.KotlinWrapperForJavaUsageInfos;
import org.jetbrains.kotlin.idea.references.JetSimpleNameReference;
import org.jetbrains.kotlin.idea.references.ReferencesPackage;
import org.jetbrains.kotlin.idea.search.usagesSearch.UsagesSearchPackage;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.ScopeUtils;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocName;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetCallElement;
import org.jetbrains.kotlin.psi.JetCallExpression;
import org.jetbrains.kotlin.psi.JetCallableDeclaration;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.JetConstructorDelegationCall;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetDelegatorToSuperCall;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetEnumEntry;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetFunctionLiteral;
import org.jetbrains.kotlin.psi.JetFunctionLiteralExpression;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetParameterList;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPsiFactory;
import org.jetbrains.kotlin.psi.JetQualifiedExpression;
import org.jetbrains.kotlin.psi.JetReferenceExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetThisExpression;
import org.jetbrains.kotlin.psi.JetTreeVisitor;
import org.jetbrains.kotlin.psi.JetTreeVisitorVoid;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetUserType;
import org.jetbrains.kotlin.psi.JetValueArgument;
import org.jetbrains.kotlin.psi.JetValueArgumentName;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilPackage;
import org.jetbrains.kotlin.psi.typeRefHelpers.TypeRefHelpersPackage;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.ThisReceiver;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.types.JetType;

public class JetChangeSignatureUsageProcessor
implements ChangeSignatureUsageProcessor {
    private boolean initializedOriginalDescriptor;

    @Nullable
    private static OriginalJavaMethodDescriptorWrapper getOriginalJavaMethodDescriptorWrapper(@NotNull UsageInfo[] usages2) {
        if (usages2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureUsageProcessor", "getOriginalJavaMethodDescriptorWrapper"));
        }
        return (OriginalJavaMethodDescriptorWrapper)((Object)KotlinPackage.firstOrNull((List)KotlinPackage.filterIsInstance((Object[])usages2, OriginalJavaMethodDescriptorWrapper.class)));
    }

    public UsageInfo[] findUsages(ChangeInfo info) {
        this.initializedOriginalDescriptor = false;
        HashSet result2 = new HashSet();
        result2.add(new OriginalJavaMethodDescriptorWrapper(info.getMethod()));
        if (info instanceof JetChangeInfo) {
            JetChangeSignatureUsageProcessor.findAllMethodUsages((JetChangeInfo)info, (Set<UsageInfo>)result2);
        } else {
            JetChangeSignatureUsageProcessor.findSAMUsages(info, (Set<UsageInfo>)result2);
            JetChangeSignatureUsageProcessor.findConstructorDelegationUsages(info, (Set<UsageInfo>)result2);
            JetChangeSignatureUsageProcessor.findKotlinOverrides(info, (Set<UsageInfo>)result2);
            if (info instanceof JavaChangeInfo) {
                JetChangeSignatureUsageProcessor.findKotlinCallers((JavaChangeInfo)info, (Set<UsageInfo>)result2);
            }
        }
        return result2.toArray(new UsageInfo[result2.size()]);
    }

    private static void findAllMethodUsages(JetChangeInfo changeInfo, Set<UsageInfo> result2) {
        for (UsageInfo functionUsageInfo : ChangeSignaturePackage.getAffectedCallables(changeInfo)) {
            boolean propagationTarget;
            if (functionUsageInfo instanceof JetCallableDefinitionUsage) {
                JetChangeSignatureUsageProcessor.findOneMethodUsages((JetCallableDefinitionUsage)functionUsageInfo, changeInfo, result2);
                continue;
            }
            if (functionUsageInfo instanceof KotlinCallerUsage) {
                JetChangeSignatureUsageProcessor.findCallerUsages((KotlinCallerUsage)functionUsageInfo, changeInfo, result2);
                continue;
            }
            result2.add(functionUsageInfo);
            boolean bl = propagationTarget = functionUsageInfo instanceof CallerUsageInfo || functionUsageInfo instanceof OverriderUsageInfo && !((OverriderUsageInfo)functionUsageInfo).isOriginalOverrider();
            PsiElement callee = functionUsageInfo.getElement();
            if (callee == null) continue;
            SearchScope scope2 = callee.getUseScope();
            if (scope2 instanceof GlobalSearchScope) {
                scope2 = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)((GlobalSearchScope)scope2), (FileType[])new FileType[]{JetFileType.INSTANCE});
            }
            for (PsiReference reference : ReferencesSearch.search((PsiElement)callee, (SearchScope)scope2)) {
                PsiElement element2 = reference.getElement();
                JetCallElement callElement2 = (JetCallElement)PsiTreeUtil.getParentOfType((PsiElement)element2, JetCallElement.class);
                JetExpression calleeExpression = callElement2 != null ? callElement2.getCalleeExpression() : null;
                if (calleeExpression == null || !PsiTreeUtil.isAncestor((PsiElement)calleeExpression, (PsiElement)element2, (boolean)false)) continue;
                result2.add(propagationTarget ? new KotlinCallerCallUsage(callElement2) : new JetFunctionCallUsage(callElement2, changeInfo.getMethodDescriptor().getOriginalPrimaryCallable()));
            }
        }
    }

    private static void findCallerUsages(KotlinCallerUsage callerUsage, JetChangeInfo changeInfo, final Set<UsageInfo> result2) {
        result2.add(callerUsage);
        JetNamedDeclaration element2 = (JetNamedDeclaration)callerUsage.getElement();
        if (element2 == null) {
            return;
        }
        for (PsiReference ref : ReferencesSearch.search((PsiElement)element2, (SearchScope)element2.getUseScope())) {
            PsiElement refElement = ref.getElement();
            JetCallElement callElement2 = (JetCallElement)PsiTreeUtil.getParentOfType((PsiElement)refElement, JetCallElement.class);
            if (callElement2 == null || !PsiTreeUtil.isAncestor((PsiElement)callElement2.getCalleeExpression(), (PsiElement)refElement, (boolean)false)) continue;
            result2.add(new KotlinCallerCallUsage(callElement2));
        }
        JetElement body2 = ChangeSignaturePackage.getDeclarationBody(element2);
        final Set newParameterNames = (Set)KotlinPackage.mapTo(changeInfo.getNonReceiverParameters(), (Collection)new HashSet(), (Function1)new Function1<JetParameterInfo, String>(){

            public String invoke(JetParameterInfo info) {
                return info.getName();
            }
        });
        if (body2 != null) {
            final DeclarationDescriptor callerDescriptor = ResolutionUtils.resolveToDescriptor(element2);
            final BindingContext context = ResolutionUtils.analyze(body2);
            body2.accept(new JetTreeVisitorVoid(){

                @Override
                public void visitSimpleNameExpression(@NotNull JetSimpleNameExpression expression2) {
                    if (expression2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureUsageProcessor$2", "visitSimpleNameExpression"));
                    }
                    final String currentName = expression2.getReferencedName();
                    if (!newParameterNames.contains(currentName)) {
                        return;
                    }
                    ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage.getResolvedCall(expression2, context);
                    if (resolvedCall == null) {
                        return;
                    }
                    if (resolvedCall.getExplicitReceiverKind() != ExplicitReceiverKind.NO_EXPLICIT_RECEIVER) {
                        return;
                    }
                    CallableDescriptor resultingDescriptor = resolvedCall.getResultingDescriptor();
                    if (!(resultingDescriptor instanceof VariableDescriptor)) {
                        return;
                    }
                    if (resultingDescriptor instanceof ValueParameterDescriptor && resultingDescriptor.getContainingDeclaration() == callerDescriptor) {
                        return;
                    }
                    JetElement callElement2 = resolvedCall.getCall().getCallElement();
                    ReceiverValue receiver = resolvedCall.getExtensionReceiver();
                    if (!(receiver instanceof ThisReceiver)) {
                        receiver = resolvedCall.getDispatchReceiver();
                    }
                    if (receiver instanceof ThisReceiver) {
                        result2.add(new JetImplicitThisUsage(callElement2, ((ThisReceiver)receiver).getDeclarationDescriptor()));
                    } else if (!receiver.exists()) {
                        result2.add(new UnresolvableCollisionUsageInfo((PsiElement)callElement2, null){

                            public String getDescription() {
                                return "There is already a variable '" + currentName + "' in " + IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_IN_TYPES.render(callerDescriptor) + ". It will conflict with the new parameter.";
                            }
                        });
                    }
                }
            });
        }
    }

    private static void findOneMethodUsages(final @NotNull JetCallableDefinitionUsage<?> functionUsageInfo, final JetChangeInfo changeInfo, final Set<UsageInfo> result2) {
        Object functionPsi;
        if (functionUsageInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionUsageInfo", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureUsageProcessor", "findOneMethodUsages"));
        }
        boolean isInherited = functionUsageInfo.isInherited();
        if (isInherited) {
            result2.add(functionUsageInfo);
        }
        if ((functionPsi = functionUsageInfo.getElement()) == null) {
            return;
        }
        for (PsiReference reference : ReferencesSearch.search(functionPsi, (SearchScope)functionPsi.getUseScope())) {
            PsiElement element2 = reference.getElement();
            if (functionPsi instanceof JetClass && reference.resolve() != functionPsi || !(element2 instanceof JetReferenceExpression)) continue;
            PsiElement parent = element2.getParent();
            if (parent instanceof JetCallExpression) {
                result2.add(new JetFunctionCallUsage((JetCallExpression)parent, functionUsageInfo));
                continue;
            }
            if (parent instanceof JetUserType && parent.getParent() instanceof JetTypeReference) {
                if (!((parent = parent.getParent().getParent()) instanceof JetConstructorCalleeExpression) || !(parent.getParent() instanceof JetDelegatorToSuperCall)) continue;
                result2.add(new JetFunctionCallUsage((JetDelegatorToSuperCall)parent.getParent(), functionUsageInfo));
                continue;
            }
            if (!(element2 instanceof JetSimpleNameExpression) || !(functionPsi instanceof JetProperty) && !(functionPsi instanceof JetParameter)) continue;
            result2.add(new JetPropertyCallUsage((JetSimpleNameExpression)element2));
        }
        String oldName = ChangeSignaturePackage.getOldName(changeInfo);
        if (oldName != null) {
            TextOccurrencesUtil.findNonCodeUsages(functionPsi, (String)oldName, (boolean)true, (boolean)true, (String)changeInfo.getNewName(), result2);
        }
        List<JetParameter> oldParameters = PsiUtilPackage.getValueParameters((JetNamedDeclaration)functionPsi);
        JetParameterInfo newReceiverInfo = changeInfo.getReceiverParameterInfo();
        for (JetParameterInfo parameterInfo : changeInfo.getNewParameters()) {
            if (parameterInfo.getOldIndex() < 0 || parameterInfo.getOldIndex() >= oldParameters.size()) continue;
            JetParameter oldParam = oldParameters.get(parameterInfo.getOldIndex());
            String oldParamName = oldParam.getName();
            if (parameterInfo != newReceiverInfo && (oldParamName == null || oldParamName.equals(parameterInfo.getName()))) continue;
            for (PsiReference reference : ReferencesSearch.search((PsiElement)oldParam, (SearchScope)oldParam.getUseScope())) {
                PsiElement element3 = reference.getElement();
                if (!(element3 instanceof JetSimpleNameExpression) && !(element3 instanceof KDocName) || element3.getParent() instanceof JetValueArgumentName) continue;
                JetParameterUsage parameterUsage = new JetParameterUsage((JetElement)element3, parameterInfo, functionUsageInfo);
                result2.add(parameterUsage);
            }
        }
        if (functionPsi instanceof JetFunction && newReceiverInfo != changeInfo.getMethodDescriptor().getReceiver()) {
            JetChangeSignatureUsageProcessor.findOriginalReceiversUsages(functionUsageInfo, result2, changeInfo);
        }
        if (functionPsi instanceof JetClass && ((JetClass)functionPsi).isEnum()) {
            for (JetDeclaration declaration : ((JetClass)functionPsi).getDeclarations()) {
                if (!(declaration instanceof JetEnumEntry) || !((JetEnumEntry)declaration).getDelegationSpecifiers().isEmpty()) continue;
                result2.add(new JetEnumEntryWithoutSuperCallUsage((JetEnumEntry)declaration));
            }
        }
        UsagesSearchPackage.processDelegationCallConstructorUsages(functionPsi, functionPsi.getUseScope(), (Function1<? super JetCallElement, ? extends Boolean>)new Function1<JetCallElement, Boolean>(){

            public Boolean invoke(JetCallElement element2) {
                if (element2 instanceof JetConstructorDelegationCall) {
                    result2.add(new JetConstructorDelegationCallUsage((JetConstructorDelegationCall)element2, changeInfo));
                } else if (element2 instanceof JetDelegatorToSuperCall) {
                    result2.add(new JetFunctionCallUsage(element2, functionUsageInfo));
                }
                return true;
            }
        });
    }

    private static void processInternalReferences(JetCallableDefinitionUsage functionUsageInfo, JetTreeVisitor<BindingContext> visitor2) {
        JetFunction jetFunction = (JetFunction)functionUsageInfo.getDeclaration();
        JetExpression body2 = jetFunction.getBodyExpression();
        if (body2 != null) {
            body2.accept(visitor2, ResolutionUtils.analyze(body2, BodyResolveMode.FULL));
        }
        for (JetParameter parameter : jetFunction.getValueParameters()) {
            JetExpression defaultValue = parameter.getDefaultValue();
            if (defaultValue == null) continue;
            defaultValue.accept(visitor2, ResolutionUtils.analyze(defaultValue, BodyResolveMode.FULL));
        }
    }

    private static void findOriginalReceiversUsages(final @NotNull JetCallableDefinitionUsage<?> functionUsageInfo, final @NotNull Set<UsageInfo> result2, final @NotNull JetChangeInfo changeInfo) {
        if (functionUsageInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionUsageInfo", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureUsageProcessor", "findOriginalReceiversUsages"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureUsageProcessor", "findOriginalReceiversUsages"));
        }
        if (changeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeInfo", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureUsageProcessor", "findOriginalReceiversUsages"));
        }
        final JetParameterInfo originalReceiverInfo = changeInfo.getMethodDescriptor().getReceiver();
        final CallableDescriptor callableDescriptor = functionUsageInfo.getOriginalCallableDescriptor();
        JetChangeSignatureUsageProcessor.processInternalReferences(functionUsageInfo, new JetTreeVisitor<BindingContext>(){

            private void processExplicitThis(@NotNull JetSimpleNameExpression expression2, @NotNull ReceiverParameterDescriptor receiverDescriptor) {
                if (expression2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureUsageProcessor$4", "processExplicitThis"));
                }
                if (receiverDescriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverDescriptor", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureUsageProcessor$4", "processExplicitThis"));
                }
                if (originalReceiverInfo != null && !changeInfo.hasParameter(originalReceiverInfo)) {
                    return;
                }
                if (!(expression2.getParent() instanceof JetThisExpression)) {
                    return;
                }
                if (receiverDescriptor == callableDescriptor.getExtensionReceiverParameter()) {
                    assert (originalReceiverInfo != null) : "No original receiver info provided: " + functionUsageInfo.getDeclaration().getText();
                    result2.add(new JetParameterUsage(expression2, originalReceiverInfo, functionUsageInfo));
                } else {
                    ClassifierDescriptor targetDescriptor = receiverDescriptor.getType().getConstructor().getDeclarationDescriptor();
                    assert (targetDescriptor != null) : "Receiver type has no descriptor: " + functionUsageInfo.getDeclaration().getText();
                    result2.add(new JetNonQualifiedOuterThisUsage((JetThisExpression)expression2.getParent(), targetDescriptor));
                }
            }

            private void processImplicitThis(@NotNull JetElement callElement2, @NotNull ThisReceiver receiverValue) {
                if (callElement2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callElement", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureUsageProcessor$4", "processImplicitThis"));
                }
                if (receiverValue == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverValue", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureUsageProcessor$4", "processImplicitThis"));
                }
                DeclarationDescriptor targetDescriptor = receiverValue.getDeclarationDescriptor();
                if (targetDescriptor == callableDescriptor) {
                    assert (originalReceiverInfo != null) : "No original receiver info provided: " + functionUsageInfo.getDeclaration().getText();
                    result2.add(new JetImplicitThisToParameterUsage(callElement2, originalReceiverInfo, functionUsageInfo));
                } else {
                    result2.add(new JetImplicitThisUsage(callElement2, targetDescriptor));
                }
            }

            @Override
            public Void visitSimpleNameExpression(@NotNull JetSimpleNameExpression expression2, BindingContext context) {
                if (expression2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureUsageProcessor$4", "visitSimpleNameExpression"));
                }
                ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage.getResolvedCall(expression2, context);
                if (resolvedCall == null) {
                    return null;
                }
                CallableDescriptor resultingDescriptor = resolvedCall.getResultingDescriptor();
                if (resultingDescriptor instanceof ReceiverParameterDescriptor) {
                    this.processExplicitThis(expression2, (ReceiverParameterDescriptor)resultingDescriptor);
                    return null;
                }
                ReceiverValue receiverValue = resolvedCall.getExtensionReceiver();
                if (!receiverValue.exists()) {
                    receiverValue = resolvedCall.getDispatchReceiver();
                }
                if (receiverValue instanceof ThisReceiver) {
                    this.processImplicitThis(resolvedCall.getCall().getCallElement(), (ThisReceiver)receiverValue);
                }
                return null;
            }
        });
    }

    private static void findSAMUsages(ChangeInfo changeInfo, Set<UsageInfo> result2) {
        PsiElement method = changeInfo.getMethod();
        if (!org.jetbrains.kotlin.idea.core.refactoring.RefactoringPackage.isTrueJavaMethod(method)) {
            return;
        }
        if (((PsiMethod)method).getContainingClass() == null) {
            return;
        }
        FunctionDescriptor methodDescriptor = JavaResolutionUtils.getJavaMethodDescriptor((PsiMethod)method);
        assert (methodDescriptor != null);
        DeclarationDescriptor containingDescriptor = methodDescriptor.getContainingDeclaration();
        if (!(containingDescriptor instanceof JavaClassDescriptor)) {
            return;
        }
        if (((JavaClassDescriptor)containingDescriptor).getFunctionTypeForSamInterface() == null) {
            return;
        }
        PsiClass samClass = ((PsiMethod)method).getContainingClass();
        if (samClass == null) {
            return;
        }
        for (PsiReference ref : ReferencesSearch.search((PsiElement)samClass)) {
            JetExpression argExpression;
            List<JetValueArgument> arguments2;
            JetSimpleNameExpression callee;
            JetCallExpression callExpression;
            if (!(ref instanceof JetSimpleNameReference) || (callExpression = (JetCallExpression)PsiTreeUtil.getParentOfType((PsiElement)(callee = (JetSimpleNameExpression)((JetSimpleNameReference)ref).getExpression()), JetCallExpression.class)) == null || callExpression.getCalleeExpression() != callee || (arguments2 = callExpression.getValueArguments()).size() != 1 || !((argExpression = ((ValueArgument)arguments2.get(0)).getArgumentExpression()) instanceof JetFunctionLiteralExpression)) continue;
            BindingContext context = ResolutionUtils.analyze(callExpression, BodyResolveMode.FULL);
            JetFunctionLiteral functionLiteral = ((JetFunctionLiteralExpression)argExpression).getFunctionLiteral();
            FunctionDescriptor functionDescriptor = context.get(BindingContext.FUNCTION, functionLiteral);
            assert (functionDescriptor != null) : "No descriptor for " + functionLiteral.getText();
            JetType samCallType = context.getType(callExpression);
            if (samCallType == null) continue;
            result2.add(new DeferredJavaMethodOverrideOrSAMUsage(functionLiteral, functionDescriptor, samCallType));
        }
    }

    private static void findConstructorDelegationUsages(@NotNull ChangeInfo changeInfo, final @NotNull Set<UsageInfo> result2) {
        if (changeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeInfo", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureUsageProcessor", "findConstructorDelegationUsages"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureUsageProcessor", "findConstructorDelegationUsages"));
        }
        PsiElement method = changeInfo.getMethod();
        if (!org.jetbrains.kotlin.idea.core.refactoring.RefactoringPackage.isTrueJavaMethod(method)) {
            return;
        }
        PsiMethod psiMethod = (PsiMethod)method;
        if (!psiMethod.isConstructor()) {
            return;
        }
        UsagesSearchPackage.processDelegationCallConstructorUsages((PsiElement)psiMethod, psiMethod.getUseScope(), (Function1<? super JetCallElement, ? extends Boolean>)new Function1<JetCallElement, Boolean>(){

            public Boolean invoke(JetCallElement element2) {
                if (element2 instanceof JetConstructorDelegationCall) {
                    result2.add(new JavaConstructorDeferredUsageInDelegationCall((JetConstructorDelegationCall)element2));
                }
                return true;
            }
        });
    }

    private static void findKotlinOverrides(ChangeInfo changeInfo, Set<UsageInfo> result2) {
        PsiElement method = changeInfo.getMethod();
        if (!org.jetbrains.kotlin.idea.core.refactoring.RefactoringPackage.isTrueJavaMethod(method)) {
            return;
        }
        for (PsiMethod overridingMethod : OverridingMethodsSearch.search((PsiMethod)((PsiMethod)method))) {
            PsiNamedElement unwrappedElement = AsJavaPackage.getNamedUnwrappedElement((PsiElement)overridingMethod);
            if (!(unwrappedElement instanceof JetNamedFunction)) continue;
            JetNamedFunction function2 = (JetNamedFunction)unwrappedElement;
            FunctionDescriptor functionDescriptor = (FunctionDescriptor)ResolutionUtils.resolveToDescriptor(function2);
            result2.add(new DeferredJavaMethodOverrideOrSAMUsage(function2, functionDescriptor, null));
            JetChangeSignatureUsageProcessor.findDeferredUsagesOfParameters(changeInfo, result2, function2, functionDescriptor);
        }
    }

    private static void findKotlinCallers(JavaChangeInfo changeInfo, Set<UsageInfo> result2) {
        PsiMethod method = changeInfo.getMethod();
        if (!org.jetbrains.kotlin.idea.core.refactoring.RefactoringPackage.isTrueJavaMethod((PsiElement)method)) {
            return;
        }
        for (PsiMethod primaryCaller : changeInfo.getMethodsToPropagateParameters()) {
            JetChangeSignatureUsageProcessor.addDeferredCallerIfPossible(result2, primaryCaller);
            for (PsiMethod overridingCaller : OverridingMethodsSearch.search((PsiMethod)primaryCaller)) {
                JetChangeSignatureUsageProcessor.addDeferredCallerIfPossible(result2, overridingCaller);
            }
        }
    }

    private static void addDeferredCallerIfPossible(Set<UsageInfo> result2, PsiMethod overridingCaller) {
        PsiNamedElement unwrappedElement = AsJavaPackage.getNamedUnwrappedElement((PsiElement)overridingCaller);
        if (unwrappedElement instanceof JetFunction || unwrappedElement instanceof JetClass) {
            result2.add(new DeferredJavaMethodKotlinCallerUsage((JetNamedDeclaration)unwrappedElement));
        }
    }

    private static void findDeferredUsagesOfParameters(ChangeInfo changeInfo, Set<UsageInfo> result2, JetNamedFunction function2, FunctionDescriptor functionDescriptor) {
        final JetCallableDefinitionUsage<JetNamedFunction> functionInfoForParameters = new JetCallableDefinitionUsage<JetNamedFunction>(function2, functionDescriptor, null, null);
        List<JetParameter> oldParameters = PsiUtilPackage.getValueParameters(function2);
        ParameterInfo[] parameters2 = changeInfo.getNewParameters();
        for (int i = 0; i < parameters2.length; ++i) {
            JetParameter oldParam;
            String oldParamName;
            final int paramIndex = i;
            ParameterInfo parameterInfo = parameters2[paramIndex];
            if (parameterInfo.getOldIndex() < 0 || parameterInfo.getOldIndex() >= oldParameters.size() || (oldParamName = (oldParam = oldParameters.get(parameterInfo.getOldIndex())).getName()) == null || oldParamName.equals(parameterInfo.getName())) continue;
            for (PsiReference reference : ReferencesSearch.search((PsiElement)oldParam, (SearchScope)oldParam.getUseScope())) {
                final PsiElement element2 = reference.getElement();
                if (!(element2 instanceof JetSimpleNameExpression) && !(element2 instanceof KDocName) || element2.getParent() instanceof JetValueArgumentName) continue;
                result2.add(new JavaMethodDeferredKotlinUsage<JetElement>((JetElement)element2){

                    @Override
                    @NotNull
                    public JavaMethodKotlinUsageWithDelegate<JetElement> resolve(@NotNull JetChangeInfo javaMethodChangeInfo) {
                        if (javaMethodChangeInfo == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaMethodChangeInfo", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureUsageProcessor$6", "resolve"));
                        }
                        JavaMethodKotlinUsageWithDelegate<JetElement> javaMethodKotlinUsageWithDelegate = new JavaMethodKotlinUsageWithDelegate<JetElement>((JetElement)element2, javaMethodChangeInfo){

                            @Override
                            @NotNull
                            public JetUsageInfo<JetElement> getDelegateUsage() {
                                JetParameterUsage jetParameterUsage = new JetParameterUsage((JetElement)element2, this.getJavaMethodChangeInfo().getNewParameters()[paramIndex], functionInfoForParameters);
                                if (jetParameterUsage == null) {
                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureUsageProcessor$6$1", "getDelegateUsage"));
                                }
                                return jetParameterUsage;
                            }
                        };
                        if (javaMethodKotlinUsageWithDelegate == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureUsageProcessor$6", "resolve"));
                        }
                        return javaMethodKotlinUsageWithDelegate;
                    }
                });
            }
        }
    }

    public MultiMap<PsiElement, String> findConflicts(ChangeInfo info, Ref<UsageInfo[]> refUsages) {
        MultiMap result2 = new MultiMap();
        Object[] usageInfos = (UsageInfo[])refUsages.get();
        List adjustedUsages = KotlinPackage.filterNot((Object[])usageInfos, (Function1)new Function1<UsageInfo, Boolean>(){

            public Boolean invoke(UsageInfo info) {
                return JetChangeSignatureUsageProcessor.getOverriderOrCaller(info) instanceof KotlinLightMethod;
            }
        });
        if (adjustedUsages.size() < usageInfos.length) {
            refUsages.set((Object)adjustedUsages.toArray(new UsageInfo[adjustedUsages.size()]));
        }
        if (!(info instanceof JetChangeInfo)) {
            return result2;
        }
        HashSet parameterNames2 = new HashSet();
        JetChangeInfo changeInfo = (JetChangeInfo)info;
        PsiElement function2 = info.getMethod();
        PsiElement element2 = function2 != null ? function2 : changeInfo.getContext();
        BindingContext bindingContext2 = ResolutionUtils.analyze((JetElement)element2, BodyResolveMode.FULL);
        CallableDescriptor oldDescriptor = ChangeSignaturePackage.getOriginalBaseFunctionDescriptor(changeInfo);
        DeclarationDescriptor containingDeclaration = oldDescriptor.getContainingDeclaration();
        JetScope parametersScope = null;
        if (oldDescriptor instanceof ConstructorDescriptor && containingDeclaration instanceof ClassDescriptorWithResolutionScopes) {
            parametersScope = ScopeUtilsKt.asJetScope(((ClassDescriptorWithResolutionScopes)containingDeclaration).getScopeForInitializerResolution());
        } else if (function2 instanceof JetFunction) {
            parametersScope = RefactoringPackage.getBodyScope((JetFunction)function2, bindingContext2);
        }
        JetScope callableScope = RefactoringPackage.getContainingScope(oldDescriptor, bindingContext2);
        JetMethodDescriptor.Kind kind2 = ChangeSignaturePackage.getKind(changeInfo);
        if (!kind2.getIsConstructor() && callableScope != null && !info.getNewName().isEmpty()) {
            Name newName = Name.identifier(info.getNewName());
            Collection<CallableDescriptor> conflicts2 = oldDescriptor instanceof FunctionDescriptor ? ScopeUtils.getAllAccessibleFunctions(callableScope, newName) : ScopeUtils.getAllAccessibleVariables(callableScope, newName);
            for (CallableDescriptor conflict : conflicts2) {
                PsiElement conflictElement;
                if (conflict == oldDescriptor || (conflictElement = DescriptorToSourceUtils.descriptorToDeclaration(conflict)) == changeInfo.getMethod() || !((Object)JetChangeSignatureUsageProcessor.getCallableParameterTypes(conflict)).equals(JetChangeSignatureUsageProcessor.getCallableParameterTypes(oldDescriptor))) continue;
                result2.putValue((Object)conflictElement, (Object)("Function already exists: '" + DescriptorRenderer.SHORT_NAMES_IN_TYPES.render(conflict) + "'"));
                break;
            }
        }
        block1: for (JetParameterInfo parameter : changeInfo.getNonReceiverParameters()) {
            VariableDescriptor variable;
            JetValVar valOrVar = parameter.getValOrVar();
            String parameterName = parameter.getName();
            if (!parameterNames2.add(parameterName)) {
                result2.putValue((Object)element2, (Object)("Duplicating parameter '" + parameterName + "'"));
            }
            if (parametersScope == null) continue;
            if (kind2 == JetMethodDescriptor.Kind.PRIMARY_CONSTRUCTOR && valOrVar != JetValVar.None) {
                for (VariableDescriptor property : ScopeUtils.getVariablesFromImplicitReceivers(parametersScope, Name.identifier(parameterName))) {
                    PsiElement propertyDeclaration = DescriptorToSourceUtils.descriptorToDeclaration(property);
                    if (propertyDeclaration == null || propertyDeclaration.getParent() instanceof JetParameterList) continue;
                    result2.putValue((Object)propertyDeclaration, (Object)("Duplicating property '" + parameterName + "'"));
                    continue block1;
                }
                continue;
            }
            if (!(function2 instanceof JetFunction) || (variable = parametersScope.getLocalVariable(Name.identifier(parameterName))) == null || variable instanceof ValueParameterDescriptor) continue;
            PsiElement conflictElement = DescriptorToSourceUtils.descriptorToDeclaration(variable);
            result2.putValue((Object)conflictElement, (Object)("Duplicating local variable '" + parameterName + "'"));
        }
        JetParameterInfo newReceiverInfo = changeInfo.getReceiverParameterInfo();
        JetParameterInfo originalReceiverInfo = changeInfo.getMethodDescriptor().getReceiver();
        if (function2 instanceof JetCallableDeclaration && newReceiverInfo != originalReceiverInfo) {
            JetChangeSignatureUsageProcessor.findReceiverIntroducingConflicts((MultiMap<PsiElement, String>)result2, function2, newReceiverInfo);
            JetChangeSignatureUsageProcessor.findInternalExplicitReceiverConflicts((UsageInfo[])refUsages.get(), (MultiMap<PsiElement, String>)result2, originalReceiverInfo);
            JetChangeSignatureUsageProcessor.findThisLabelConflicts((JetChangeInfo)info, refUsages, (MultiMap<PsiElement, String>)result2, changeInfo, function2);
        }
        for (Object usageInfo : usageInfos) {
            if (!(usageInfo instanceof KotlinCallerUsage)) continue;
            JetNamedDeclaration caller = (JetNamedDeclaration)usageInfo.getElement();
            DeclarationDescriptor callerDescriptor = ResolutionUtils.resolveToDescriptor(caller);
            JetChangeSignatureUsageProcessor.findParameterDuplicationInCaller((MultiMap<PsiElement, String>)result2, changeInfo, caller, callerDescriptor);
        }
        return result2;
    }

    private static void findParameterDuplicationInCaller(MultiMap<PsiElement, String> result2, JetChangeInfo changeInfo, JetNamedDeclaration caller, DeclarationDescriptor callerDescriptor) {
        List<JetParameter> valueParameters = PsiUtilPackage.getValueParameters(caller);
        Map existingParameters = KotlinPackage.toMap(valueParameters, (Function1)new Function1<JetParameter, String>(){

            public String invoke(JetParameter parameter) {
                return parameter.getName();
            }
        });
        for (JetParameterInfo parameterInfo : changeInfo.getNonReceiverParameters()) {
            String name2;
            JetParameter parameter;
            if (!parameterInfo.getIsNewParameter() || (parameter = (JetParameter)existingParameters.get(name2 = parameterInfo.getName())) == null) continue;
            result2.putValue((Object)parameter, (Object)("There is already a parameter '" + name2 + "' in " + IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_IN_TYPES.render(callerDescriptor) + ". It will conflict with the new parameter."));
        }
    }

    private static void findThisLabelConflicts(JetChangeInfo info, Ref<UsageInfo[]> refUsages, MultiMap<PsiElement, String> result2, JetChangeInfo changeInfo, PsiElement function2) {
        JetPsiFactory psiFactory = new JetPsiFactory(function2.getProject());
        for (UsageInfo usageInfo : (UsageInfo[])refUsages.get()) {
            BindingContext newContext;
            JetThisExpression newExpr;
            JetSimpleNameExpression labelExpr;
            JetExpression originalExpr;
            JetScope scope2;
            String newExprText;
            if (!(usageInfo instanceof JetParameterUsage) || !(newExprText = ((JetParameterUsage)usageInfo).getReplacementText(changeInfo)).startsWith("this@") || usageInfo.getElement() instanceof KDocName || (scope2 = ResolutionUtils.analyze(originalExpr = (JetExpression)usageInfo.getElement(), BodyResolveMode.FULL).get(BindingContext.RESOLUTION_SCOPE, originalExpr)) == null || (labelExpr = (newExpr = (JetThisExpression)psiFactory.createExpression(newExprText)).getTargetLabel()) == null || (newContext = AnalysisPackage.analyzeInContext(newExpr, scope2, originalExpr)).get(BindingContext.AMBIGUOUS_LABEL_TARGET, labelExpr) == null) continue;
            result2.putValue((Object)originalExpr, (Object)("Parameter reference can't be safely replaced with " + newExprText + " since " + labelExpr.getText() + " is ambiguous in this context"));
        }
    }

    private static void findInternalExplicitReceiverConflicts(UsageInfo[] usages2, MultiMap<PsiElement, String> result2, JetParameterInfo originalReceiverInfo) {
        if (originalReceiverInfo == null) {
            for (UsageInfo usageInfo : usages2) {
                PsiElement parent;
                JetElement callElement2;
                if (!(usageInfo instanceof JetFunctionCallUsage) && !(usageInfo instanceof JetPropertyCallUsage) || (callElement2 = (JetElement)usageInfo.getElement()) == null || !((parent = callElement2.getParent()) instanceof JetQualifiedExpression) || ((JetQualifiedExpression)parent).getSelectorExpression() != callElement2) continue;
                String message = "Explicit receiver is already present in call element: " + CommonRefactoringUtil.htmlEmphasize((String)parent.getText());
                result2.putValue((Object)callElement2, (Object)message);
            }
        }
    }

    private static void findReceiverIntroducingConflicts(MultiMap<PsiElement, String> result2, PsiElement callable, JetParameterInfo newReceiverInfo) {
        if (newReceiverInfo != null && callable instanceof JetNamedFunction && ((JetNamedFunction)callable).getBodyExpression() != null) {
            Map noReceiverRefToContext = KotlinPackage.filter(JetFileReferencesResolver.INSTANCE$.resolve((JetNamedFunction)callable, true, true), (Function1)new Function1<Map.Entry<? extends JetReferenceExpression, ? extends BindingContext>, Boolean>(){

                public Boolean invoke(Map.Entry<? extends JetReferenceExpression, ? extends BindingContext> entry) {
                    ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage.getResolvedCall(entry.getKey(), entry.getValue());
                    return resolvedCall != null && !resolvedCall.getDispatchReceiver().exists() && !resolvedCall.getExtensionReceiver().exists();
                }
            });
            JetPsiFactory psiFactory = new JetPsiFactory(callable.getProject());
            JetFile tempFile = org.jetbrains.kotlin.idea.core.refactoring.RefactoringPackage.createTempCopy((JetFile)callable.getContainingFile(), (Function1<? super String, ? extends String>)new Function1<String, String>(){

                public String invoke(String s) {
                    return s;
                }
            });
            JetNamedFunction functionWithReceiver = (JetNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)tempFile.findElementAt(callable.getTextOffset()), JetNamedFunction.class);
            JetTypeReference receiverTypeRef = psiFactory.createType(newReceiverInfo.getCurrentTypeText());
            TypeRefHelpersPackage.setReceiverTypeReference(functionWithReceiver, receiverTypeRef);
            BindingContext newContext = ResolutionUtils.analyze(functionWithReceiver.getBodyExpression(), BodyResolveMode.FULL);
            int originalOffset = ((JetNamedFunction)callable).getBodyExpression().getTextOffset();
            JetExpression newBody = functionWithReceiver.getBodyExpression();
            for (Map.Entry entry : noReceiverRefToContext.entrySet()) {
                JetReferenceExpression originalRef = (JetReferenceExpression)entry.getKey();
                BindingContext originalContext = (BindingContext)entry.getValue();
                JetReferenceExpression newRef = (JetReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)newBody.findElementAt(originalRef.getTextOffset() - originalOffset), JetReferenceExpression.class);
                ResolvedCall<? extends CallableDescriptor> newResolvedCall = CallUtilPackage.getResolvedCall(newRef, newContext);
                if (newResolvedCall != null && !newResolvedCall.getExtensionReceiver().exists() && !newResolvedCall.getDispatchReceiver().exists()) continue;
                CallableDescriptor descriptor2 = CallUtilPackage.getResolvedCall(originalRef, originalContext).getCandidateDescriptor();
                PsiElement declaration = DescriptorToSourceUtilsIde.INSTANCE$.getAnyDeclaration(callable.getProject(), descriptor2);
                String prefix = declaration != null ? RefactoringUIUtil.getDescription((PsiElement)declaration, (boolean)true) : originalRef.getText();
                result2.putValue((Object)originalRef, (Object)KotlinPackage.capitalize((String)(prefix + " will no longer be accessible after signature change")));
            }
        }
    }

    private static List<JetType> getCallableParameterTypes(CallableDescriptor descriptor2) {
        return ContainerUtil.map(descriptor2.getValueParameters(), (Function)new Function<ValueParameterDescriptor, JetType>(){

            public JetType fun(ValueParameterDescriptor descriptor2) {
                return descriptor2.getType();
            }
        });
    }

    private static boolean isJavaMethodUsage(UsageInfo usageInfo) {
        return usageInfo instanceof JavaMethodDeferredKotlinUsage || usageInfo instanceof MoveRenameUsageInfo;
    }

    @Nullable
    private static UsageInfo createReplacementUsage(UsageInfo originalUsageInfo, JetChangeInfo javaMethodChangeInfo, UsageInfo[] allUsages) {
        if (originalUsageInfo instanceof JavaMethodDeferredKotlinUsage) {
            return ((JavaMethodDeferredKotlinUsage)originalUsageInfo).resolve(javaMethodChangeInfo);
        }
        JetCallElement callElement2 = (JetCallElement)PsiTreeUtil.getParentOfType((PsiElement)originalUsageInfo.getElement(), JetCallElement.class);
        if (callElement2 == null) {
            return null;
        }
        PsiReference ref = originalUsageInfo.getReference();
        PsiElement refTarget = ref != null ? ref.resolve() : null;
        return new JavaMethodKotlinCallUsage(callElement2, javaMethodChangeInfo, refTarget != null && ChangeSignaturePackage.isCaller(refTarget, allUsages));
    }

    private static boolean canCreateReplacementUsage(UsageInfo originalUsageInfo) {
        if (originalUsageInfo instanceof JavaMethodDeferredKotlinUsage) {
            return true;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)originalUsageInfo.getElement(), JetCallElement.class) != null;
    }

    private static boolean isOverriderOrCaller(UsageInfo usage) {
        return usage instanceof OverriderUsageInfo || usage instanceof CallerUsageInfo;
    }

    @Nullable
    private static PsiMethod getOverriderOrCaller(UsageInfo usage) {
        if (usage instanceof OverriderUsageInfo) {
            return ((OverriderUsageInfo)usage).getOverridingMethod();
        }
        if (usage instanceof CallerUsageInfo) {
            PsiElement element2 = usage.getElement();
            return element2 instanceof PsiMethod ? (PsiMethod)element2 : null;
        }
        return null;
    }

    public boolean processUsage(ChangeInfo changeInfo, UsageInfo usageInfo, boolean beforeMethodChange, UsageInfo[] usages2) {
        PsiElement method = changeInfo.getMethod();
        boolean isJavaMethodUsage = JetChangeSignatureUsageProcessor.isJavaMethodUsage(usageInfo);
        if (usageInfo instanceof KotlinWrapperForJavaUsageInfos) {
            List<JavaChangeInfo> javaChangeInfos = ((JetChangeInfo)changeInfo).getOrCreateJavaChangeInfos(false);
            assert (javaChangeInfos != null) : "JavaChangeInfo not found: " + method.getText();
            KotlinWrapperForJavaUsageInfos wrapperForJavaUsageInfos = (KotlinWrapperForJavaUsageInfos)usageInfo;
            UsageInfo[] javaUsageInfos = wrapperForJavaUsageInfos.getJavaUsageInfos();
            ChangeSignatureUsageProcessor[] processors = (ChangeSignatureUsageProcessor[])ChangeSignatureUsageProcessor.EP_NAME.getExtensions();
            for (JavaChangeInfo javaChangeInfo : javaChangeInfos) {
                if (!javaChangeInfo.getOldName().equals(wrapperForJavaUsageInfos.getJavaChangeInfo().getOldName())) continue;
                NullabilityPropagator nullabilityPropagator = new NullabilityPropagator(javaChangeInfo.getMethod());
                for (UsageInfo usage : javaUsageInfos) {
                    PsiMethod overridingMethod;
                    if (JetChangeSignatureUsageProcessor.isOverriderOrCaller(usage) && beforeMethodChange) continue;
                    for (ChangeSignatureUsageProcessor processor2 : processors) {
                        if (processor2 instanceof JetChangeSignatureUsageProcessor) continue;
                        if (JetChangeSignatureUsageProcessor.isOverriderOrCaller(usage)) {
                            processor2.processUsage((ChangeInfo)javaChangeInfo, usage, true, javaUsageInfos);
                        }
                        if (processor2.processUsage((ChangeInfo)javaChangeInfo, usage, beforeMethodChange, javaUsageInfos)) break;
                    }
                    if (!(usage instanceof OverriderUsageInfo) || !((OverriderUsageInfo)usage).isOriginalOverrider() || (overridingMethod = ((OverriderUsageInfo)usage).getOverridingMethod()) == null || overridingMethod instanceof KotlinLightMethod) continue;
                    nullabilityPropagator.processMethod(overridingMethod);
                }
            }
        }
        if (beforeMethodChange) {
            if (!(method instanceof PsiMethod) || this.initializedOriginalDescriptor) {
                return true;
            }
            OriginalJavaMethodDescriptorWrapper descriptorWrapper = JetChangeSignatureUsageProcessor.getOriginalJavaMethodDescriptorWrapper(usages2);
            if (descriptorWrapper == null || descriptorWrapper.originalJavaMethodDescriptor != null) {
                return true;
            }
            FunctionDescriptor methodDescriptor = JavaResolutionUtils.getJavaMethodDescriptor((PsiMethod)method);
            assert (methodDescriptor != null);
            descriptorWrapper.originalJavaMethodDescriptor = new JetChangeSignatureData(methodDescriptor, method, Collections.singletonList(methodDescriptor));
            DummyJetChangeInfo dummyChangeInfo = new DummyJetChangeInfo(changeInfo.getMethod(), descriptorWrapper.originalJavaMethodDescriptor);
            for (int i = 0; i < usages2.length; ++i) {
                UsageInfo newUsageInfo;
                UsageInfo oldUsageInfo = usages2[i];
                if (!JetChangeSignatureUsageProcessor.isJavaMethodUsage(oldUsageInfo) || (newUsageInfo = JetChangeSignatureUsageProcessor.createReplacementUsage(oldUsageInfo, dummyChangeInfo, usages2)) == null) continue;
                usages2[i] = newUsageInfo;
            }
            this.initializedOriginalDescriptor = true;
            return true;
        }
        PsiElement element2 = usageInfo.getElement();
        if (element2 == null) {
            return false;
        }
        if (usageInfo instanceof JavaMethodKotlinUsageWithDelegate) {
            JavaMethodKotlinUsageWithDelegate usageWithDelegate = (JavaMethodKotlinUsageWithDelegate)usageInfo;
            if (((JavaMethodKotlinUsageWithDelegate)usageInfo).getJavaMethodChangeInfo() instanceof DummyJetChangeInfo) {
                JetMethodDescriptor methodDescriptor;
                OriginalJavaMethodDescriptorWrapper descriptorWrapper = JetChangeSignatureUsageProcessor.getOriginalJavaMethodDescriptorWrapper(usages2);
                JetMethodDescriptor jetMethodDescriptor = methodDescriptor = descriptorWrapper != null ? descriptorWrapper.originalJavaMethodDescriptor : null;
                if (methodDescriptor == null) {
                    return true;
                }
                JetChangeInfo javaMethodChangeInfo = ChangeSignaturePackage.toJetChangeInfo(changeInfo, methodDescriptor);
                for (UsageInfo info : usages2) {
                    if (!(info instanceof JavaMethodKotlinUsageWithDelegate)) continue;
                    ((JavaMethodKotlinUsageWithDelegate)info).setJavaMethodChangeInfo(javaMethodChangeInfo);
                }
            }
            return usageWithDelegate.processUsage(usages2);
        }
        if (usageInfo instanceof MoveRenameUsageInfo && isJavaMethodUsage) {
            JetSimpleNameReference ref;
            JetSimpleNameExpression callee = (JetSimpleNameExpression)PsiTreeUtil.getParentOfType((PsiElement)usageInfo.getElement(), JetSimpleNameExpression.class, (boolean)false);
            JetSimpleNameReference jetSimpleNameReference = ref = callee != null ? ReferencesPackage.getMainReference(callee) : null;
            if (ref instanceof JetSimpleNameReference) {
                ref.handleElementRename(((PsiMethod)method).getName());
                return true;
            }
            return false;
        }
        return usageInfo instanceof JetUsageInfo ? ((JetUsageInfo)usageInfo).processUsage((JetChangeInfo)changeInfo, element2, usages2) : true;
    }

    public boolean processPrimaryMethod(ChangeInfo changeInfo) {
        if (!(changeInfo instanceof JetChangeInfo)) {
            return false;
        }
        JetChangeInfo jetChangeInfo = (JetChangeInfo)changeInfo;
        for (JetCallableDefinitionUsage<PsiElement> primaryFunction : jetChangeInfo.getMethodDescriptor().getPrimaryCallables()) {
            primaryFunction.processUsage(jetChangeInfo, primaryFunction.getDeclaration(), UsageInfo.EMPTY_ARRAY);
        }
        jetChangeInfo.primaryMethodUpdated();
        return true;
    }

    public boolean shouldPreviewUsages(ChangeInfo changeInfo, UsageInfo[] usages2) {
        return false;
    }

    public boolean setupDefaultValues(ChangeInfo changeInfo, Ref<UsageInfo[]> refUsages, Project project) {
        return true;
    }

    public void registerConflictResolvers(List<ResolveSnapshotProvider.ResolveSnapshot> snapshots, @NotNull ResolveSnapshotProvider resolveSnapshotProvider, UsageInfo[] usages2, ChangeInfo changeInfo) {
        if (resolveSnapshotProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveSnapshotProvider", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureUsageProcessor", "registerConflictResolvers"));
        }
    }

    private static class NullabilityPropagator {
        private final NullableNotNullManager nullManager;
        private final JavaPsiFacade javaPsiFacade;
        private final JavaCodeStyleManager javaCodeStyleManager;
        private final PsiAnnotation methodAnnotation;
        private final PsiAnnotation[] parameterAnnotations;

        public NullabilityPropagator(@NotNull PsiMethod baseMethod) {
            if (baseMethod == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseMethod", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureUsageProcessor$NullabilityPropagator", "<init>"));
            }
            Project project = baseMethod.getProject();
            this.nullManager = NullableNotNullManager.getInstance((Project)project);
            this.javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
            this.javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            this.methodAnnotation = this.getNullabilityAnnotation((PsiModifierListOwner)baseMethod);
            this.parameterAnnotations = (PsiAnnotation[])ContainerUtil.map2Array((Object[])baseMethod.getParameterList().getParameters(), PsiAnnotation.class, (Function)new Function<PsiParameter, PsiAnnotation>(){

                public PsiAnnotation fun(PsiParameter parameter) {
                    return NullabilityPropagator.this.getNullabilityAnnotation((PsiModifierListOwner)parameter);
                }
            });
        }

        @Nullable
        private PsiAnnotation getNullabilityAnnotation(@NotNull PsiModifierListOwner element2) {
            PsiAnnotation notNullAnnotation;
            if (element2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureUsageProcessor$NullabilityPropagator", "getNullabilityAnnotation"));
            }
            PsiAnnotation nullAnnotation = this.nullManager.getNullableAnnotation(element2, false);
            if (nullAnnotation == null == ((notNullAnnotation = this.nullManager.getNotNullAnnotation(element2, false)) == null)) {
                return null;
            }
            return nullAnnotation != null ? nullAnnotation : notNullAnnotation;
        }

        private void addNullabilityAnnotationIfApplicable(@NotNull PsiModifierListOwner element2, @Nullable PsiAnnotation annotation2) {
            String annotationQualifiedName;
            if (element2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureUsageProcessor$NullabilityPropagator", "addNullabilityAnnotationIfApplicable"));
            }
            PsiAnnotation nullableAnnotation = this.nullManager.getNullableAnnotation(element2, false);
            PsiAnnotation notNullAnnotation = this.nullManager.getNotNullAnnotation(element2, false);
            if (notNullAnnotation != null && nullableAnnotation == null && element2 instanceof PsiMethod) {
                return;
            }
            String string = annotationQualifiedName = annotation2 != null ? annotation2.getQualifiedName() : null;
            if (annotationQualifiedName != null && this.javaPsiFacade.findClass(annotationQualifiedName, element2.getResolveScope()) == null) {
                return;
            }
            if (notNullAnnotation != null) {
                notNullAnnotation.delete();
            }
            if (nullableAnnotation != null) {
                nullableAnnotation.delete();
            }
            if (annotationQualifiedName == null) {
                return;
            }
            PsiModifierList modifierList = element2.getModifierList();
            if (modifierList != null) {
                modifierList.addAnnotation(annotationQualifiedName);
                this.javaCodeStyleManager.shortenClassReferences((PsiElement)element2);
            }
        }

        public void processMethod(@NotNull PsiMethod currentMethod) {
            if (currentMethod == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentMethod", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureUsageProcessor$NullabilityPropagator", "processMethod"));
            }
            PsiParameter[] currentParameters = currentMethod.getParameterList().getParameters();
            this.addNullabilityAnnotationIfApplicable((PsiModifierListOwner)currentMethod, this.methodAnnotation);
            for (int i = 0; i < this.parameterAnnotations.length; ++i) {
                this.addNullabilityAnnotationIfApplicable((PsiModifierListOwner)currentParameters[i], this.parameterAnnotations[i]);
            }
        }
    }

    private static class DummyJetChangeInfo
    extends JetChangeInfo {
        public DummyJetChangeInfo(@NotNull PsiElement method, @NotNull JetMethodDescriptor methodDescriptor) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureUsageProcessor$DummyJetChangeInfo", "<init>"));
            }
            if (methodDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodDescriptor", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureUsageProcessor$DummyJetChangeInfo", "<init>"));
            }
            super(methodDescriptor, "", null, "", Visibilities.DEFAULT_VISIBILITY, Collections.emptyList(), null, method, Collections.emptyList());
        }
    }

    private static class OriginalJavaMethodDescriptorWrapper
    extends UsageInfo {
        JetMethodDescriptor originalJavaMethodDescriptor;

        public OriginalJavaMethodDescriptorWrapper(@NotNull PsiElement element2) {
            if (element2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/refactoring/changeSignature/JetChangeSignatureUsageProcessor$OriginalJavaMethodDescriptorWrapper", "<init>"));
            }
            super(element2);
        }
    }
}

