/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.changeSignature.usages;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntProcedure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.shorten.ShortenPackage;
import org.jetbrains.kotlin.idea.core.CorePackage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.ChangeSignaturePackage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetChangeInfo;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetParameterInfo;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.JetCallableDefinitionUsage;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.usages.JetUsageInfo;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine.ExtractionEnginePackage;
import org.jetbrains.kotlin.idea.refactoring.introduce.introduceVariable.KotlinIntroduceVariableHandler;
import org.jetbrains.kotlin.idea.util.ShortenReferences;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.load.java.descriptors.JavaMethodDescriptor;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.psi.JetCallElement;
import org.jetbrains.kotlin.psi.JetCallExpression;
import org.jetbrains.kotlin.psi.JetConstantExpression;
import org.jetbrains.kotlin.psi.JetConstructorDelegationCall;
import org.jetbrains.kotlin.psi.JetDelegationSpecifier;
import org.jetbrains.kotlin.psi.JetDelegatorToSuperCall;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetEnumEntry;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFunctionLiteralArgument;
import org.jetbrains.kotlin.psi.JetInitializerList;
import org.jetbrains.kotlin.psi.JetOperationExpression;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPsiFactory;
import org.jetbrains.kotlin.psi.JetQualifiedExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetThisExpression;
import org.jetbrains.kotlin.psi.JetUnaryExpression;
import org.jetbrains.kotlin.psi.JetValueArgument;
import org.jetbrains.kotlin.psi.JetValueArgumentList;
import org.jetbrains.kotlin.psi.PsiPackage;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.ValueArgumentName;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.ThisReceiver;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

public class JetFunctionCallUsage
extends JetUsageInfo<JetCallElement> {
    private static final Comparator<Pair<JetElement, JetElement>> REVERSED_TEXT_OFFSET_COMPARATOR = new Comparator<Pair<JetElement, JetElement>>(){

        @Override
        public int compare(@NotNull Pair<JetElement, JetElement> p1, @NotNull Pair<JetElement, JetElement> p2) {
            int offset2;
            if (p1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p1", "org/jetbrains/kotlin/idea/refactoring/changeSignature/usages/JetFunctionCallUsage$1", "compare"));
            }
            if (p2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p2", "org/jetbrains/kotlin/idea/refactoring/changeSignature/usages/JetFunctionCallUsage$1", "compare"));
            }
            int offset1 = ((JetElement)p1.getFirst()).getTextRange().getStartOffset();
            return offset1 < (offset2 = ((JetElement)p2.getFirst()).getTextRange().getStartOffset()) ? 1 : (offset1 > offset2 ? -1 : 0);
        }
    };
    private static final ShortenReferences.Options SHORTEN_ARGUMENTS_OPTIONS = new ShortenReferences.Options(true, true);
    private final JetCallableDefinitionUsage<?> callee;
    private final BindingContext context;
    private final ResolvedCall<? extends CallableDescriptor> resolvedCall;

    public JetFunctionCallUsage(@NotNull JetCallElement element2, JetCallableDefinitionUsage callee) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/refactoring/changeSignature/usages/JetFunctionCallUsage", "<init>"));
        }
        super(element2);
        this.callee = callee;
        this.context = ResolutionUtils.analyze(element2, BodyResolveMode.FULL);
        this.resolvedCall = CallUtilPackage.getResolvedCall(element2, this.context);
    }

    @Override
    public boolean processUsage(@NotNull JetChangeInfo changeInfo, @NotNull JetCallElement element2, @NotNull UsageInfo[] allUsages) {
        JetEnumEntry enumEntry;
        if (changeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeInfo", "org/jetbrains/kotlin/idea/refactoring/changeSignature/usages/JetFunctionCallUsage", "processUsage"));
        }
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/refactoring/changeSignature/usages/JetFunctionCallUsage", "processUsage"));
        }
        if (allUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allUsages", "org/jetbrains/kotlin/idea/refactoring/changeSignature/usages/JetFunctionCallUsage", "processUsage"));
        }
        if (this.shouldSkipUsage(element2)) {
            return true;
        }
        this.changeNameIfNeeded(changeInfo, element2);
        if (element2.getValueArgumentList() != null) {
            if (changeInfo.isParameterSetOrOrderChanged()) {
                this.updateArgumentsAndReceiver(changeInfo, element2, allUsages);
            } else {
                this.changeArgumentNames(changeInfo, element2);
            }
        }
        if (changeInfo.getNewParametersCount() == 0 && element2 instanceof JetDelegatorToSuperCall && (enumEntry = (JetEnumEntry)PsiTreeUtil.getParentOfType((PsiElement)element2, JetEnumEntry.class, (boolean)true)) != null && enumEntry.getInitializerList() == element2.getParent()) {
            PsiElement colon = enumEntry.getColon();
            JetInitializerList initializerList = enumEntry.getInitializerList();
            enumEntry.deleteChildRange((PsiElement)(colon != null ? colon : initializerList), (PsiElement)initializerList);
        }
        return true;
    }

    private boolean shouldSkipUsage(JetCallElement element2) {
        if (this.resolvedCall == null && !(element2 instanceof JetDelegatorToSuperCall)) {
            return true;
        }
        if (this.resolvedCall != null && !this.resolvedCall.getStatus().isSuccess()) {
            if (element2 instanceof JetDelegatorToSuperCall && element2.getParent().getParent() instanceof JetEnumEntry) {
                return false;
            }
            for (ValueArgument valueArgument : this.resolvedCall.getCall().getValueArguments()) {
                if (this.resolvedCall.getArgumentMapping(valueArgument) instanceof ArgumentMatch) continue;
                return true;
            }
            Map<ValueParameterDescriptor, ResolvedValueArgument> arguments2 = this.resolvedCall.getValueArguments();
            for (ValueParameterDescriptor valueParameter : this.resolvedCall.getResultingDescriptor().getValueParameters()) {
                if (arguments2.containsKey(valueParameter)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isPropertyJavaUsage() {
        Object calleeElement = this.callee.getElement();
        return (calleeElement instanceof JetProperty || calleeElement instanceof JetParameter) && this.resolvedCall != null && this.resolvedCall.getResultingDescriptor() instanceof JavaMethodDescriptor;
    }

    protected void changeNameIfNeeded(JetChangeInfo changeInfo, JetCallElement element2) {
        if (!changeInfo.isNameChanged()) {
            return;
        }
        JetExpression callee = element2.getCalleeExpression();
        if (!(callee instanceof JetSimpleNameExpression)) {
            return;
        }
        String newName = changeInfo.getNewName();
        if (this.isPropertyJavaUsage()) {
            String currentName = ((JetSimpleNameExpression)callee).getReferencedName();
            if (currentName.startsWith("get")) {
                newName = JvmAbi.getterName(newName);
            } else if (currentName.startsWith("set")) {
                newName = JvmAbi.setterName(newName);
            }
        }
        callee.replace((PsiElement)PsiPackage.JetPsiFactory(this.getProject()).createSimpleName(newName));
    }

    @Nullable
    private JetExpression getReceiverExpressionIfMatched(@NotNull ReceiverValue receiverValue, @NotNull DeclarationDescriptor originalDescriptor, @NotNull JetPsiFactory psiFactory) {
        JetType originalType;
        boolean originalIsExtension;
        if (receiverValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverValue", "org/jetbrains/kotlin/idea/refactoring/changeSignature/usages/JetFunctionCallUsage", "getReceiverExpressionIfMatched"));
        }
        if (originalDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalDescriptor", "org/jetbrains/kotlin/idea/refactoring/changeSignature/usages/JetFunctionCallUsage", "getReceiverExpressionIfMatched"));
        }
        if (psiFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFactory", "org/jetbrains/kotlin/idea/refactoring/changeSignature/usages/JetFunctionCallUsage", "getReceiverExpressionIfMatched"));
        }
        if (!receiverValue.exists()) {
            return null;
        }
        if (originalDescriptor instanceof CallableDescriptor && !(originalDescriptor instanceof ReceiverParameterDescriptor)) {
            ReceiverParameterDescriptor receiverParameter = ((CallableDescriptor)originalDescriptor).getExtensionReceiverParameter();
            if (receiverParameter == null) {
                return null;
            }
            originalDescriptor = receiverParameter;
        }
        boolean currentIsExtension = this.resolvedCall.getExtensionReceiver() == receiverValue;
        boolean bl = originalIsExtension = originalDescriptor instanceof ReceiverParameterDescriptor && ((ReceiverParameterDescriptor)originalDescriptor).getValue() instanceof ExtensionReceiver;
        if (currentIsExtension != originalIsExtension) {
            return null;
        }
        JetType jetType = originalDescriptor instanceof ReceiverParameterDescriptor ? ((ReceiverParameterDescriptor)originalDescriptor).getType() : (originalType = originalDescriptor instanceof ClassDescriptor ? ((ClassDescriptor)originalDescriptor).getDefaultType() : null);
        if (originalType == null || !JetTypeChecker.DEFAULT.isSubtypeOf(receiverValue.getType(), originalType)) {
            return null;
        }
        return JetFunctionCallUsage.getReceiverExpression(receiverValue, psiFactory);
    }

    private boolean needSeparateVariable(@NotNull PsiElement element2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/refactoring/changeSignature/usages/JetFunctionCallUsage", "needSeparateVariable"));
        }
        if (element2 instanceof JetConstantExpression) {
            return false;
        }
        if (element2 instanceof JetThisExpression) {
            return false;
        }
        if (element2 instanceof JetSimpleNameExpression) {
            return false;
        }
        if (element2 instanceof JetBinaryExpression && OperatorConventions.ASSIGNMENT_OPERATIONS.containsKey((Object)((JetBinaryExpression)element2).getOperationToken())) {
            return true;
        }
        if (element2 instanceof JetUnaryExpression && OperatorConventions.INCREMENT_OPERATIONS.contains((Object)((JetUnaryExpression)element2).getOperationToken())) {
            return true;
        }
        if (element2 instanceof JetCallExpression) {
            ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilPackage.getResolvedCall((JetCallExpression)element2, this.context);
            return resolvedCall != null && resolvedCall.getResultingDescriptor() instanceof ConstructorDescriptor;
        }
        for (PsiElement child : element2.getChildren()) {
            if (!this.needSeparateVariable(child)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private JetExpression substituteReferences(@NotNull JetExpression expression2, @NotNull Map<PsiReference, DeclarationDescriptor> referenceMap, final @NotNull JetPsiFactory psiFactory) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/refactoring/changeSignature/usages/JetFunctionCallUsage", "substituteReferences"));
        }
        if (referenceMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceMap", "org/jetbrains/kotlin/idea/refactoring/changeSignature/usages/JetFunctionCallUsage", "substituteReferences"));
        }
        if (psiFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFactory", "org/jetbrains/kotlin/idea/refactoring/changeSignature/usages/JetFunctionCallUsage", "substituteReferences"));
        }
        if (referenceMap.isEmpty() || this.resolvedCall == null) {
            JetExpression jetExpression = expression2;
            if (jetExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/changeSignature/usages/JetFunctionCallUsage", "substituteReferences"));
            }
            return jetExpression;
        }
        JetExpression newExpression2 = (JetExpression)expression2.copy();
        Map<JetSimpleNameExpression, JetSimpleNameExpression> nameCounterpartMap = ExtractionEnginePackage.createNameCounterpartMap(expression2, newExpression2);
        Map<ValueParameterDescriptor, ResolvedValueArgument> valueArguments2 = this.resolvedCall.getValueArguments();
        ArrayList<Pair> replacements = new ArrayList<Pair>();
        for (Map.Entry<PsiReference, DeclarationDescriptor> e : referenceMap.entrySet()) {
            JetExpression expressionToReplace;
            JetExpression argumentExpression;
            DeclarationDescriptor descriptor2 = e.getValue();
            boolean addReceiver = false;
            if (descriptor2 instanceof ValueParameterDescriptor) {
                ValueArgument argument;
                ValueParameterDescriptor parameterDescriptor = this.resolvedCall.getResultingDescriptor().getValueParameters().get(((ValueParameterDescriptor)descriptor2).getIndex());
                ResolvedValueArgument resolvedValueArgument = valueArguments2.get(parameterDescriptor);
                if (!(resolvedValueArgument instanceof ExpressionValueArgument) || (argument = ((ExpressionValueArgument)resolvedValueArgument).getValueArgument()) == null) continue;
                argumentExpression = argument.getArgumentExpression();
            } else {
                addReceiver = !(descriptor2 instanceof ReceiverParameterDescriptor);
                argumentExpression = this.getReceiverExpressionIfMatched(this.resolvedCall.getExtensionReceiver(), descriptor2, psiFactory);
                if (argumentExpression == null) {
                    argumentExpression = this.getReceiverExpressionIfMatched(this.resolvedCall.getDispatchReceiver(), descriptor2, psiFactory);
                }
            }
            if (argumentExpression == null) continue;
            if (this.needSeparateVariable((PsiElement)argumentExpression) && PsiTreeUtil.getNonStrictParentOfType(this.getElement(), (Class[])new Class[]{JetConstructorDelegationCall.class, JetDelegationSpecifier.class, JetParameter.class}) == null) {
                final Ref newExpressionRef = new Ref();
                KotlinIntroduceVariableHandler.doRefactoring(this.getProject(), null, argumentExpression, Collections.singletonList(argumentExpression), new Function1<JetProperty, Unit>(){

                    public Unit invoke(JetProperty property) {
                        newExpressionRef.set((Object)psiFactory.createExpression(property.getName()));
                        return null;
                    }
                });
                argumentExpression = (JetExpression)newExpressionRef.get();
            }
            if ((expressionToReplace = (JetExpression)nameCounterpartMap.get(e.getKey().getElement())) == null) continue;
            PsiElement parent = expressionToReplace.getParent();
            if (parent instanceof JetThisExpression) {
                expressionToReplace = (JetThisExpression)parent;
            }
            if (addReceiver) {
                JetCallExpression callExpression = (JetCallExpression)PsiTreeUtil.getParentOfType((PsiElement)expressionToReplace, JetCallExpression.class, (boolean)true);
                if (callExpression != null && PsiTreeUtil.isAncestor((PsiElement)callExpression.getCalleeExpression(), (PsiElement)expressionToReplace, (boolean)false)) {
                    expressionToReplace = callExpression;
                } else if (parent instanceof JetOperationExpression && ((JetOperationExpression)parent).getOperationReference() == expressionToReplace) continue;
                replacements.add(new Pair((Object)expressionToReplace, (Object)psiFactory.createExpression(argumentExpression.getText() + "." + expressionToReplace.getText())));
                continue;
            }
            replacements.add(new Pair((Object)expressionToReplace, (Object)argumentExpression));
        }
        ContainerUtil.sort(replacements, REVERSED_TEXT_OFFSET_COMPARATOR);
        for (Pair replacement : replacements) {
            ((JetElement)replacement.getFirst()).replace((PsiElement)replacement.getSecond());
        }
        JetExpression jetExpression = newExpression2;
        if (jetExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/refactoring/changeSignature/usages/JetFunctionCallUsage", "substituteReferences"));
        }
        return jetExpression;
    }

    private void updateArgumentsAndReceiver(JetChangeInfo changeInfo, JetCallElement element2, @NotNull UsageInfo[] allUsages) {
        JetValueArgument lastArgument;
        if (allUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allUsages", "org/jetbrains/kotlin/idea/refactoring/changeSignature/usages/JetFunctionCallUsage", "updateArgumentsAndReceiver"));
        }
        JetValueArgumentList arguments2 = element2.getValueArgumentList();
        assert (arguments2 != null) : "Argument list is expected: " + element2.getText();
        List<? extends ValueArgument> oldArguments = element2.getValueArguments();
        if (this.isPropertyJavaUsage()) {
            JetFunctionCallUsage.updateJavaPropertyCall(changeInfo, element2);
            return;
        }
        boolean isNamedCall = oldArguments.size() > 1 && oldArguments.get(0).isNamed();
        StringBuilder parametersBuilder = new StringBuilder("(");
        boolean isFirst = true;
        TIntArrayList indicesOfArgumentsWithDefaultValues = new TIntArrayList();
        JetPsiFactory psiFactory = new JetPsiFactory(element2.getProject());
        List<JetParameterInfo> newSignatureParameters = changeInfo.getNonReceiverParameters();
        for (JetParameterInfo parameterInfo : newSignatureParameters) {
            String defaultValueText;
            if (isFirst) {
                isFirst = false;
            } else {
                parametersBuilder.append(',');
            }
            JetExpression defaultValueForCall = parameterInfo.getDefaultValueForCall();
            if (ChangeSignaturePackage.isInsideOfCallerBody(element2, allUsages)) {
                defaultValueText = parameterInfo.getName();
            } else {
                String string = defaultValueText = defaultValueForCall != null ? this.substituteReferences(defaultValueForCall, parameterInfo.getDefaultValueParameterReferences(), psiFactory).getText() : "";
            }
            if (isNamedCall) {
                String newName = parameterInfo.getInheritedName(this.callee);
                parametersBuilder.append(newName).append('=');
            }
            parametersBuilder.append(defaultValueText.isEmpty() ? Character.valueOf('0') : defaultValueText);
        }
        parametersBuilder.append(')');
        JetValueArgumentList newArgumentList = PsiPackage.JetPsiFactory(this.getProject()).createCallArguments(parametersBuilder.toString());
        Map<Integer, ? extends ValueArgument> argumentMap = JetFunctionCallUsage.getParamIndexToArgumentMap(changeInfo, oldArguments);
        JetParameterInfo newReceiverInfo = changeInfo.getReceiverParameterInfo();
        JetParameterInfo originalReceiverInfo = changeInfo.getMethodDescriptor().getReceiver();
        ReceiverValue extensionReceiver = this.resolvedCall != null ? this.resolvedCall.getExtensionReceiver() : ReceiverValue.NO_RECEIVER;
        ReceiverValue dispatchReceiver = this.resolvedCall != null ? this.resolvedCall.getDispatchReceiver() : ReceiverValue.NO_RECEIVER;
        JetCallElement elementToReplace = element2;
        PsiElement parent = element2.getParent();
        if (parent instanceof JetQualifiedExpression && ((JetQualifiedExpression)parent).getSelectorExpression() == element2) {
            elementToReplace = parent;
        }
        if (newReceiverInfo != null && elementToReplace instanceof JetQualifiedExpression && dispatchReceiver instanceof ExpressionReceiver) {
            return;
        }
        List<JetValueArgument> newArguments = newArgumentList.getArguments();
        int actualIndex = 0;
        for (int i = 0; i < newArguments.size(); ++i) {
            JetValueArgument newArgument = newArguments.get(i);
            JetParameterInfo parameterInfo = newSignatureParameters.get(i);
            if (parameterInfo == originalReceiverInfo) {
                JetExpression receiverExpression = JetFunctionCallUsage.getReceiverExpression(extensionReceiver, psiFactory);
                if (receiverExpression != null) {
                    newArgument.replace((PsiElement)receiverExpression);
                }
                ++actualIndex;
                continue;
            }
            ValueArgument oldArgument = argumentMap.get(parameterInfo.getOldIndex());
            if (oldArgument != null) {
                ValueArgumentName argumentName2 = oldArgument.getArgumentName();
                JetSimpleNameExpression argumentNameExpression = argumentName2 != null ? argumentName2.getReferenceExpression() : null;
                this.changeArgumentName(argumentNameExpression, parameterInfo);
                newArgument.replace((PsiElement)(oldArgument instanceof JetFunctionLiteralArgument ? psiFactory.createArgument(oldArgument.getArgumentExpression(), null, false) : oldArgument.asElement()));
                continue;
            }
            if (parameterInfo.getDefaultValueForCall() == null) {
                if (parameterInfo.getDefaultValueForParameter() != null) {
                    newArgumentList.removeArgument(newArgument);
                    continue;
                }
                newArgument.delete();
                continue;
            }
            indicesOfArgumentsWithDefaultValues.add(actualIndex++);
        }
        List<JetFunctionLiteralArgument> lambdaArguments = element2.getFunctionLiteralArguments();
        if (!lambdaArguments.isEmpty()) {
            element2.deleteChildRange((PsiElement)KotlinPackage.first(lambdaArguments), (PsiElement)KotlinPackage.last(lambdaArguments));
        }
        boolean hasTrailingLambdaInArgumentListAfter = (lastArgument = (JetValueArgument)KotlinPackage.lastOrNull(newArgumentList.getArguments())) != null && PsiPackage.unpackFunctionLiteral(lastArgument.getArgumentExpression()) != null;
        arguments2 = (JetValueArgumentList)arguments2.replace((PsiElement)newArgumentList);
        final ArrayList argumentsToShorten = new ArrayList(indicesOfArgumentsWithDefaultValues.size());
        final List<JetValueArgument> argumentList2 = arguments2.getArguments();
        indicesOfArgumentsWithDefaultValues.forEach(new TIntProcedure(){

            public boolean execute(int i) {
                argumentsToShorten.add(argumentList2.get(i));
                return true;
            }
        });
        for (JetElement argument : argumentsToShorten) {
            ShortenPackage.addToShorteningWaitSet(argument, SHORTEN_ARGUMENTS_OPTIONS);
        }
        JetElement newElement = element2;
        if (newReceiverInfo != originalReceiverInfo) {
            JetExpression replacingElement;
            if (newReceiverInfo != null) {
                ValueArgument receiverArgument = argumentMap.get(newReceiverInfo.getOldIndex());
                JetExpression extensionReceiverExpression = receiverArgument != null ? receiverArgument.getArgumentExpression() : null;
                JetExpression defaultValueForCall = newReceiverInfo.getDefaultValueForCall();
                JetExpression receiver = extensionReceiverExpression != null ? psiFactory.createExpression(extensionReceiverExpression.getText()) : (defaultValueForCall != null ? defaultValueForCall : psiFactory.createExpression("_"));
                replacingElement = PsiPackage.createExpressionByPattern(psiFactory, "$0.$1", receiver, element2);
            } else {
                replacingElement = psiFactory.createExpression(element2.getText());
            }
            newElement = (JetElement)elementToReplace.replace((PsiElement)replacingElement);
        }
        if (hasTrailingLambdaInArgumentListAfter) {
            JetCallExpression newCallExpression = (JetCallExpression)(newElement instanceof JetQualifiedExpression ? ((JetQualifiedExpression)newElement).getSelectorExpression() : newElement);
            CorePackage.moveFunctionLiteralOutsideParentheses(newCallExpression);
        }
    }

    private static void updateJavaPropertyCall(JetChangeInfo changeInfo, JetCallElement element2) {
        JetValueArgument firstArgument;
        JetParameterInfo originalReceiverInfo;
        JetParameterInfo newReceiverInfo = changeInfo.getReceiverParameterInfo();
        if (newReceiverInfo == (originalReceiverInfo = changeInfo.getMethodDescriptor().getReceiver())) {
            return;
        }
        JetValueArgumentList arguments2 = element2.getValueArgumentList();
        assert (arguments2 != null) : "Argument list is expected: " + element2.getText();
        List<? extends ValueArgument> oldArguments = element2.getValueArguments();
        JetPsiFactory psiFactory = new JetPsiFactory(element2.getProject());
        JetValueArgument jetValueArgument = firstArgument = oldArguments.isEmpty() ? null : (JetValueArgument)oldArguments.get(0);
        if (newReceiverInfo == null) {
            if (firstArgument != null) {
                arguments2.removeArgument(firstArgument);
            }
        } else {
            JetExpression defaultValueForCall = newReceiverInfo.getDefaultValueForCall();
            if (defaultValueForCall == null) {
                defaultValueForCall = psiFactory.createExpression("_");
            }
            JetValueArgument newReceiverArgument = psiFactory.createArgument(defaultValueForCall, null, false);
            if (originalReceiverInfo != null) {
                if (firstArgument != null) {
                    firstArgument.replace((PsiElement)newReceiverArgument);
                }
            } else {
                arguments2.addArgumentAfter(newReceiverArgument, null);
            }
        }
    }

    @Nullable
    private static JetExpression getReceiverExpression(@NotNull ReceiverValue receiver, @NotNull JetPsiFactory psiFactory) {
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/idea/refactoring/changeSignature/usages/JetFunctionCallUsage", "getReceiverExpression"));
        }
        if (psiFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFactory", "org/jetbrains/kotlin/idea/refactoring/changeSignature/usages/JetFunctionCallUsage", "getReceiverExpression"));
        }
        if (receiver instanceof ExpressionReceiver) {
            return ((ExpressionReceiver)receiver).getExpression();
        }
        if (receiver instanceof ThisReceiver) {
            DeclarationDescriptor descriptor2 = ((ThisReceiver)receiver).getDeclarationDescriptor();
            String thisText = descriptor2 instanceof ClassDescriptor ? "this@" + descriptor2.getName().asString() : "this";
            return psiFactory.createExpression(thisText);
        }
        return null;
    }

    private static Map<Integer, ? extends ValueArgument> getParamIndexToArgumentMap(JetChangeInfo changeInfo, List<? extends ValueArgument> oldArguments) {
        HashMap<Integer, ValueArgument> argumentMap = new HashMap<Integer, ValueArgument>();
        for (int i = 0; i < oldArguments.size(); ++i) {
            String oldParameterName;
            ValueArgument argument = oldArguments.get(i);
            ValueArgumentName argumentName2 = argument.getArgumentName();
            String string = oldParameterName = argumentName2 != null ? argumentName2.getAsName().asString() : null;
            if (oldParameterName != null) {
                Integer oldParameterIndex = changeInfo.getOldParameterIndex(oldParameterName);
                if (oldParameterIndex == null) continue;
                argumentMap.put(oldParameterIndex, argument);
                continue;
            }
            argumentMap.put(i, argument);
        }
        return argumentMap;
    }

    private void changeArgumentNames(JetChangeInfo changeInfo, JetCallElement element2) {
        for (ValueArgument valueArgument : element2.getValueArguments()) {
            Integer oldParameterIndex;
            ValueArgumentName argumentName2 = valueArgument.getArgumentName();
            JetSimpleNameExpression argumentNameExpression = argumentName2 != null ? argumentName2.getReferenceExpression() : null;
            if (argumentNameExpression == null || (oldParameterIndex = changeInfo.getOldParameterIndex(argumentNameExpression.getReferencedName())) == null) continue;
            JetParameterInfo parameterInfo = changeInfo.getNewParameters()[oldParameterIndex];
            this.changeArgumentName(argumentNameExpression, parameterInfo);
        }
    }

    private void changeArgumentName(JetSimpleNameExpression argumentNameExpression, JetParameterInfo parameterInfo) {
        PsiElement identifier;
        PsiElement psiElement2 = identifier = argumentNameExpression != null ? argumentNameExpression.getIdentifier() : null;
        if (identifier != null) {
            String newName = parameterInfo.getInheritedName(this.callee);
            identifier.replace(PsiPackage.JetPsiFactory(this.getProject()).createIdentifier(newName));
        }
    }
}

