/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.inline;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.lang.Language;
import com.intellij.lang.refactoring.InlineActionHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringMessageDialog;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.JetLanguage;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.ShortenReferences;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.psi.JetCallExpression;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetFunctionLiteral;
import org.jetbrains.kotlin.psi.JetFunctionLiteralExpression;
import org.jetbrains.kotlin.psi.JetParameterList;
import org.jetbrains.kotlin.psi.JetParenthesizedExpression;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPsiFactory;
import org.jetbrains.kotlin.psi.JetQualifiedExpression;
import org.jetbrains.kotlin.psi.PsiPackage;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.JetType;

public class KotlinInlineValHandler
extends InlineActionHandler {
    public boolean isEnabledForLanguage(Language l) {
        return l.equals((Object)JetLanguage.INSTANCE);
    }

    public boolean canInlineElement(PsiElement element2) {
        if (!(element2 instanceof JetProperty)) {
            return false;
        }
        JetProperty property = (JetProperty)element2;
        return !property.isVar() && property.getGetter() == null && property.getReceiverTypeReference() == null;
    }

    public void inlineElement(final Project project, final Editor editor, PsiElement element2) {
        JetExpression initializer;
        final JetProperty val = (JetProperty)element2;
        final JetFile file = val.getContainingJetFile();
        String name2 = val.getName();
        JetExpression initializerInDeclaration = val.getInitializer();
        final List<JetExpression> referenceExpressions = KotlinInlineValHandler.findReferenceExpressions(val);
        final HashSet assignments = Sets.newHashSet();
        for (JetExpression expression2 : referenceExpressions) {
            PsiElement parent = expression2.getParent();
            if (!(parent instanceof JetBinaryExpression) || ((JetBinaryExpression)parent).getOperationToken() != JetTokens.EQ || ((JetBinaryExpression)parent).getLeft() != expression2) continue;
            assignments.add(parent);
        }
        if (initializerInDeclaration != null) {
            initializer = initializerInDeclaration;
        } else {
            initializer = assignments.size() == 1 ? ((JetBinaryExpression)assignments.iterator().next()).getRight() : null;
            if (initializer == null) {
                String key = assignments.isEmpty() ? "variable.has.no.initializer" : "variable.has.no.dominating.definition";
                String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)key, (Object[])new Object[]{name2}));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)RefactoringBundle.message((String)"inline.variable.title"), (String)"refactoring.inlineVariable");
                return;
            }
        }
        final String typeArgumentsForCall = KotlinInlineValHandler.getTypeArgumentsStringForCall(initializer);
        final String parametersForFunctionLiteral = KotlinInlineValHandler.getParametersForFunctionLiteral(initializer);
        final boolean canHighlight = KotlinPackage.all(referenceExpressions, (Function1)new Function1<JetExpression, Boolean>(){

            public Boolean invoke(JetExpression expression2) {
                return expression2.getContainingFile() == file;
            }
        });
        if (canHighlight) {
            KotlinInlineValHandler.highlightExpressions(project, editor, referenceExpressions);
        }
        if (!KotlinInlineValHandler.showDialog(project, name2, referenceExpressions)) {
            StatusBar statusBar;
            if (canHighlight && (statusBar = WindowManager.getInstance().getStatusBar(project)) != null) {
                statusBar.setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
            }
            return;
        }
        final ArrayList inlinedExpressions = Lists.newArrayList();
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        for (JetExpression referenceExpression : referenceExpressions) {
                            if (assignments.contains(referenceExpression.getParent())) continue;
                            inlinedExpressions.add((JetExpression)referenceExpression.replace((PsiElement)initializer));
                        }
                        for (PsiElement assignment : assignments) {
                            assignment.delete();
                        }
                        val.delete();
                        if (typeArgumentsForCall != null) {
                            KotlinInlineValHandler.addTypeArguments(typeArgumentsForCall, inlinedExpressions);
                        }
                        if (parametersForFunctionLiteral != null) {
                            KotlinInlineValHandler.addFunctionLiteralParameterTypes(parametersForFunctionLiteral, inlinedExpressions);
                        }
                        if (canHighlight) {
                            KotlinInlineValHandler.highlightExpressions(project, editor, inlinedExpressions);
                        }
                    }
                });
            }
        }, RefactoringBundle.message((String)"inline.command", (Object[])new Object[]{name2}), null);
    }

    private static void highlightExpressions(Project project, Editor editor, List<? extends PsiElement> elements) {
        if (editor == null || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        TextAttributes searchResultsAttributes = editorColorsManager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        PsiElement[] elementsArray = elements.toArray(new PsiElement[elements.size()]);
        highlightManager.addOccurrenceHighlights(editor, elementsArray, searchResultsAttributes, true, null);
    }

    private static List<JetExpression> findReferenceExpressions(JetProperty val) {
        ArrayList result2 = Lists.newArrayList();
        for (PsiReference reference : ReferencesSearch.search((PsiElement)val, (SearchScope)GlobalSearchScope.allScope((Project)val.getProject()), (boolean)false).findAll()) {
            JetExpression expression2 = (JetExpression)reference.getElement();
            PsiElement parent = expression2.getParent();
            if (parent instanceof JetQualifiedExpression && ((JetQualifiedExpression)parent).getSelectorExpression() == expression2) {
                result2.add((JetQualifiedExpression)parent);
                continue;
            }
            result2.add(expression2);
        }
        return result2;
    }

    private static boolean showDialog(Project project, String name2, List<JetExpression> referenceExpressions) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        RefactoringMessageDialog dialog2 = new RefactoringMessageDialog(RefactoringBundle.message((String)"inline.variable.title"), RefactoringBundle.message((String)"inline.local.variable.prompt", (Object[])new Object[]{name2}) + " " + RefactoringBundle.message((String)"occurences.string", (Object[])new Object[]{referenceExpressions.size()}), "refactoring.inlineVariable", "OptionPane.questionIcon", true, project);
        dialog2.show();
        return dialog2.isOK();
    }

    @Nullable
    private static String getParametersForFunctionLiteral(JetExpression initializer) {
        JetFunctionLiteralExpression functionLiteralExpression = KotlinInlineValHandler.getFunctionLiteralExpression(initializer);
        if (functionLiteralExpression == null) {
            return null;
        }
        BindingContext context = ResolutionUtils.analyze(initializer, BodyResolveMode.FULL);
        SimpleFunctionDescriptor fun2 = context.get(BindingContext.FUNCTION, functionLiteralExpression.getFunctionLiteral());
        if (fun2 == null || ErrorUtils.containsErrorType(fun2)) {
            return null;
        }
        return StringUtil.join(fun2.getValueParameters(), (Function)new Function<ValueParameterDescriptor, String>(){

            public String fun(ValueParameterDescriptor descriptor2) {
                return descriptor2.getName() + ": " + IdeDescriptorRenderers.SOURCE_CODE.renderType(descriptor2.getType());
            }
        }, (String)", ");
    }

    @Nullable
    private static JetFunctionLiteralExpression getFunctionLiteralExpression(@NotNull JetExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/refactoring/inline/KotlinInlineValHandler", "getFunctionLiteralExpression"));
        }
        if (expression2 instanceof JetParenthesizedExpression) {
            JetExpression inner = ((JetParenthesizedExpression)expression2).getExpression();
            return inner == null ? null : KotlinInlineValHandler.getFunctionLiteralExpression(inner);
        }
        if (expression2 instanceof JetFunctionLiteralExpression) {
            return (JetFunctionLiteralExpression)expression2;
        }
        return null;
    }

    private static void addFunctionLiteralParameterTypes(@NotNull String parameters2, @NotNull List<JetExpression> inlinedExpressions) {
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/kotlin/idea/refactoring/inline/KotlinInlineValHandler", "addFunctionLiteralParameterTypes"));
        }
        if (inlinedExpressions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inlinedExpressions", "org/jetbrains/kotlin/idea/refactoring/inline/KotlinInlineValHandler", "addFunctionLiteralParameterTypes"));
        }
        JetFile containingFile = inlinedExpressions.get(0).getContainingJetFile();
        ArrayList functionsToAddParameters = Lists.newArrayList();
        ResolutionFacade resolutionFacade = ResolutionUtils.getResolutionFacade(containingFile);
        for (JetExpression inlinedExpression : inlinedExpressions) {
            JetFunctionLiteralExpression functionLiteralExpression = KotlinInlineValHandler.getFunctionLiteralExpression(inlinedExpression);
            assert (functionLiteralExpression != null) : "can't find function literal expression for " + inlinedExpression.getText();
            if (!KotlinInlineValHandler.needToAddParameterTypes(functionLiteralExpression, resolutionFacade)) continue;
            functionsToAddParameters.add(functionLiteralExpression);
        }
        JetPsiFactory psiFactory = PsiPackage.JetPsiFactory((PsiElement)containingFile);
        for (JetFunctionLiteralExpression functionLiteralExpression : functionsToAddParameters) {
            JetFunctionLiteral functionLiteral = functionLiteralExpression.getFunctionLiteral();
            JetParameterList currentParameterList = functionLiteral.getValueParameterList();
            JetParameterList newParameterList = psiFactory.createParameterList("(" + parameters2 + ")");
            if (currentParameterList != null) {
                currentParameterList.replace((PsiElement)newParameterList);
            } else {
                PsiElement openBraceElement = functionLiteral.getLBrace();
                PsiElement nextSibling = openBraceElement.getNextSibling();
                PsiElement whitespaceToAdd = nextSibling instanceof PsiWhiteSpace && nextSibling.getText().contains("\n") ? nextSibling.copy() : null;
                Pair<PsiElement, PsiElement> whitespaceAndArrow = psiFactory.createWhitespaceAndArrow();
                functionLiteral.addRangeAfter((PsiElement)whitespaceAndArrow.getFirst(), (PsiElement)whitespaceAndArrow.getSecond(), openBraceElement);
                functionLiteral.addAfter((PsiElement)newParameterList, openBraceElement);
                if (whitespaceToAdd != null) {
                    functionLiteral.addAfter(whitespaceToAdd, openBraceElement);
                }
            }
            ShortenReferences.DEFAULT.process(functionLiteralExpression.getValueParameters());
        }
    }

    private static boolean needToAddParameterTypes(@NotNull JetFunctionLiteralExpression functionLiteralExpression, @NotNull ResolutionFacade resolutionFacade) {
        if (functionLiteralExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionLiteralExpression", "org/jetbrains/kotlin/idea/refactoring/inline/KotlinInlineValHandler", "needToAddParameterTypes"));
        }
        if (resolutionFacade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolutionFacade", "org/jetbrains/kotlin/idea/refactoring/inline/KotlinInlineValHandler", "needToAddParameterTypes"));
        }
        JetFunctionLiteral functionLiteral = functionLiteralExpression.getFunctionLiteral();
        BindingContext context = resolutionFacade.analyze(functionLiteralExpression, BodyResolveMode.FULL);
        for (Diagnostic diagnostic : context.getDiagnostics()) {
            boolean hasUnresolvedItOrThis;
            DiagnosticFactory<?> factory2 = diagnostic.getFactory();
            PsiElement element2 = diagnostic.getPsiElement();
            boolean hasCantInferParameter = factory2 == Errors.CANNOT_INFER_PARAMETER_TYPE && element2.getParent().getParent() == functionLiteral;
            boolean bl = hasUnresolvedItOrThis = factory2 == Errors.UNRESOLVED_REFERENCE && element2.getText().equals("it") && PsiTreeUtil.getParentOfType((PsiElement)element2, JetFunctionLiteral.class) == functionLiteral;
            if (!hasCantInferParameter && !hasUnresolvedItOrThis) continue;
            return true;
        }
        return false;
    }

    private static void addTypeArguments(@NotNull String typeArguments, @NotNull List<JetExpression> inlinedExpressions) {
        if (typeArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeArguments", "org/jetbrains/kotlin/idea/refactoring/inline/KotlinInlineValHandler", "addTypeArguments"));
        }
        if (inlinedExpressions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inlinedExpressions", "org/jetbrains/kotlin/idea/refactoring/inline/KotlinInlineValHandler", "addTypeArguments"));
        }
        JetFile containingFile = inlinedExpressions.get(0).getContainingJetFile();
        ArrayList callsToAddArguments = Lists.newArrayList();
        ResolutionFacade resolutionFacade = ResolutionUtils.getResolutionFacade(containingFile);
        for (JetExpression inlinedExpression : inlinedExpressions) {
            BindingContext context;
            Call call = CallUtilPackage.getCallWithAssert(inlinedExpression, context = resolutionFacade.analyze(inlinedExpression, BodyResolveMode.FULL));
            JetElement callElement2 = call.getCallElement();
            if (!(callElement2 instanceof JetCallExpression) || !KotlinInlineValHandler.hasIncompleteTypeInferenceDiagnostic(call, context) || call.getTypeArgumentList() != null) continue;
            callsToAddArguments.add((JetCallExpression)callElement2);
        }
        JetPsiFactory psiFactory = PsiPackage.JetPsiFactory((PsiElement)containingFile);
        for (JetCallExpression call : callsToAddArguments) {
            call.addAfter((PsiElement)psiFactory.createTypeArguments("<" + typeArguments + ">"), (PsiElement)call.getCalleeExpression());
            ShortenReferences.DEFAULT.process(call.getTypeArgumentList());
        }
    }

    @Nullable
    private static String getTypeArgumentsStringForCall(@NotNull JetExpression initializer) {
        if (initializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "org/jetbrains/kotlin/idea/refactoring/inline/KotlinInlineValHandler", "getTypeArgumentsStringForCall"));
        }
        BindingContext context = ResolutionUtils.analyze(initializer, BodyResolveMode.FULL);
        ResolvedCall<? extends CallableDescriptor> call = CallUtilPackage.getResolvedCall(initializer, context);
        if (call == null) {
            return null;
        }
        ArrayList typeArguments = Lists.newArrayList();
        Map<TypeParameterDescriptor, JetType> typeArgumentMap = call.getTypeArguments();
        for (TypeParameterDescriptor typeParameter : call.getCandidateDescriptor().getTypeParameters()) {
            typeArguments.add(typeArgumentMap.get(typeParameter));
        }
        return StringUtil.join((Collection)typeArguments, (Function)new Function<JetType, String>(){

            public String fun(JetType type2) {
                return IdeDescriptorRenderers.SOURCE_CODE_FOR_TYPE_ARGUMENTS.renderType(type2);
            }
        }, (String)", ");
    }

    private static boolean hasIncompleteTypeInferenceDiagnostic(@NotNull Call call, @NotNull BindingContext context) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/idea/refactoring/inline/KotlinInlineValHandler", "hasIncompleteTypeInferenceDiagnostic"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/idea/refactoring/inline/KotlinInlineValHandler", "hasIncompleteTypeInferenceDiagnostic"));
        }
        JetExpression callee = call.getCalleeExpression();
        for (Diagnostic diagnostic : context.getDiagnostics()) {
            if (diagnostic.getFactory() != Errors.TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER || diagnostic.getPsiElement() != callee) continue;
            return true;
        }
        return false;
    }
}

