/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move.changePackage;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.idea.core.refactoring.JetRefactoringUtilKt;
import org.jetbrains.kotlin.idea.intentions.JetSelfTargetingOffsetIndependentIntention;
import org.jetbrains.kotlin.idea.refactoring.move.changePackage.KotlinChangePackageRefactoring;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetPackageDirective;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"\u001c\u0006)13\t[1oO\u0016\u0004\u0016mY6bO\u0016$v.T1uG\"$\u0015N]3di>\u0014\u00180\u00138uK:$\u0018n\u001c8\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*11n\u001c;mS:TA!\u001b3fC*Y!/\u001a4bGR|'/\u001b8h\u0015\u0011iwN^3\u000b\u001b\rD\u0017M\\4f!\u0006\u001c7.Y4f\u0015)RU\r^*fY\u001a$\u0016M]4fi&twm\u00144gg\u0016$\u0018J\u001c3fa\u0016tG-\u001a8u\u0013:$XM\u001c;j_:T!\"\u001b8uK:$\u0018n\u001c8t\u0015MQU\r\u001e)bG.\fw-\u001a#je\u0016\u001cG/\u001b<f\u0015\r\u00018/\u001b\u0006\u0007y%t\u0017\u000e\u001e \u000b\u000f\u0005\u0004\b\u000f\\=U_*9Q\r\\3nK:$(BB3eSR|'O\u0003\u0004FI&$xN\u001d\u0006\u0004G>l'\u0002C5oi\u0016dG.\u001b6\u000b\u000f=\u0004XM\\1qS*!QK\\5u\u00159I7/\u00119qY&\u001c\u0017M\u00197f)>TqAQ8pY\u0016\fgNc\u0001\u000b\u0005A\t!\u0002\u0002\u0005\u0001!\tQA\u0001C\u0001\u0011\u0007)!\u0001B\u0001\t\u0005\u0015\u0011A1\u0001E\u0003\u000b\t!!\u0001C\u0002\u0006\u0005\u0011\u0015\u0001rA\u0003\u0004\t\rA\u0001\u0001\u0004\u0001\u0006\u0005\u0011\r\u0001\u0012B\u0003\u0004\t\u0011AA\u0001\u0004\u0001\u0006\u0005\u0011\t\u00012B\u0003\u0004\t\u0015AQ\u0001\u0004\u0001\u0006\u0003!EQA\u0001\u0003\u0007\u0011%)!\u0001\"\u0004\t\u0014\u0015\u0011Aa\u0002E\b\u000b\r!y\u0001\u0003\u0005\r\u0001\u0015\t\u00012A\u0003\u0004\t#A!\u0002\u0004\u0001\u0006\u0005\u0011)\u0001\"B\u0003\u0003\t\u001fA\u0001\"B\u0002\u0005\u0012!YA\u0002\u0001\u0003\u0004\u0019\u000fI\u0002\"B\u0001\t\n%!\u0011bA\u0003\u0002\u0011\u0017AZ\u0001'\u0003.@\u0011Y\u0001TBO\b\t\u0001Aq!D\u0002\u0006\u0003!-\u00014\u0002)\u0004\u0001u=A\u0001\u0001E\b\u001b\r)\u0011\u0001\u0003\u0005\u0019\u0011A\u001b\t!I\u0002\u0006\u0003!I\u0001$C)\u0004\u000f\u00115\u0011\"\u0001\u0003\u0001\u001b\u0005A\u0019\"D\u0001\t\u00155*Ba\u0003M\u000b;\u001f!\u0001\u0001C\u0004\u000e\u0007\u0015\t\u00012\u0002M\u0006!\u000e\u0001\u0011eA\u0003\u0002\u0011+A*\"U\u0002\u0006\t+I\u0011\u0001\"\u0001\u000e\u0003!MQ\u0007D\u0003\f\t\r\b\u0001DB\u0011\u0004\u000b\u0005A9\u0001g\u0002R\u0007\r!a!C\u0001\u0005\u0001\u0001"})
public final class ChangePackageToMatchDirectoryIntention
extends JetSelfTargetingOffsetIndependentIntention<JetPackageDirective> {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(ChangePackageToMatchDirectoryIntention.class);
    }

    @Override
    public boolean isApplicableTo(@NotNull JetPackageDirective element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        JetFile file = element2.getContainingJetFile();
        if (PackageUtilsKt.packageMatchesDirectory(file)) {
            return false;
        }
        FqName fqNameByDirectory = PackageUtilsKt.getFqNameByDirectory((PsiFile)file);
        if (!JetRefactoringUtilKt.hasIdentifiersOnly(fqNameByDirectory)) {
            Project project = file.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
            if (this.isIntentionBaseInspectionEnabled(project, (JetElement)element2)) {
                this.setText("File package doesn't match directory");
                return true;
            }
            return false;
        }
        this.setText("Change file's package to '" + fqNameByDirectory.asString() + "'");
        return true;
    }

    @Override
    public void applyTo(@NotNull JetPackageDirective element2, @NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        JetFile file = element2.getContainingJetFile();
        FqName newFqName = PackageUtilsKt.getFqNameByDirectory((PsiFile)file);
        if (!JetRefactoringUtilKt.hasIdentifiersOnly(newFqName)) {
            return;
        }
        new KotlinChangePackageRefactoring(file).run(newFqName);
    }

    public ChangePackageToMatchDirectoryIntention() {
        super(JetPackageDirective.class, "", "Change file's package to match directory");
    }
}

