/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move.moveTopLevelDeclarations;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.Set;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.refactoring.JetRefactoringUtilKt;
import org.jetbrains.kotlin.idea.intentions.JetSelfTargetingRangeIntention;
import org.jetbrains.kotlin.idea.quickfix.GenerateUtilKt;
import org.jetbrains.kotlin.idea.refactoring.move.moveTopLevelDeclarations.DeferredJetFileKotlinMoveTarget;
import org.jetbrains.kotlin.idea.refactoring.move.moveTopLevelDeclarations.MoveKotlinTopLevelDeclarationsOptions;
import org.jetbrains.kotlin.idea.refactoring.move.moveTopLevelDeclarations.MoveKotlinTopLevelDeclarationsProcessor;
import org.jetbrains.kotlin.idea.refactoring.move.moveTopLevelDeclarations.ui.MoveKotlinTopLevelDeclarationsDialog;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"O\u0006)1Sj\u001c<f\t\u0016\u001cG.\u0019:bi&|g\u000eV8TKB\f'/\u0019;f\r&dW-\u00138uK:$\u0018n\u001c8\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*11n\u001c;mS:TA!\u001b3fC*Y!/\u001a4bGR|'/\u001b8h\u0015\u0011iwN^3\u000b15|g/\u001a+pa2+g/\u001a7EK\u000ed\u0017M]1uS>t7O\u0003\u0010KKR\u001cV\r\u001c4UCJ<W\r^5oOJ\u000bgnZ3J]R,g\u000e^5p]*Q\u0011N\u001c;f]RLwN\\:\u000b!)+Go\u00117bgN|%o\u00142kK\u000e$(b\u00019tS*\tBj\\<Qe&|'/\u001b;z\u0003\u000e$\u0018n\u001c8\u000b\u0007\r|WN\u0003\u0005j]R,G\u000e\\5k\u0015-\u0019w\u000eZ3J]NLw\r\u001b;\u000b\u0013%tG/\u001a8uS>t'B\u0002\u001fj]&$hH\u0003\nbaBd\u0017nY1cS2LG/\u001f*b]\u001e,'bB3mK6,g\u000e\u001e\u0006\n)\u0016DHOU1oO\u0016Tqa\u001c9f]\u0006\u0004\u0018N\u0003\u0003vi&d'bB1qa2LHk\u001c\u0006\u0007K\u0012LGo\u001c:\u000b\r\u0015#\u0017\u000e^8s\u0015\u0011)f.\u001b;+\u0004)\u0011\u0001#\u0001\u0006\u0005\u0011\u0001\u0001\"A\u0003\u0003\t\u0003A\u0019!\u0002\u0002\u0005\u0003!\u0011QA\u0001C\u0002\u0011\u000b)!\u0001\u0002\u0002\t\u0007\u0015\u0011AQ\u0001E\u0004\u000b\r!1\u0001\u0003\u0001\r\u0001\u0015\u0011A1\u0001E\u0005\u000b\r!A\u0001\u0003\u0003\r\u0001\u0015\u0011A!\u0001E\u0006\u000b\r!Q\u0001C\u0003\r\u0001\u0015\t\u0001RB\u0003\u0003\t\u0019Aq!\u0002\u0002\u0005\u000e!=QA\u0001\u0003\b\u0011!)1\u0001b\u0004\t\r1\u0001QA\u0001C\u0007\u0011+)!\u0001\"\u0005\t\u0017\u0015\u0019A!\u0003\u0005\u000b\u0019\u0001)!\u0001B\u0005\t\u0015\u0015\u0011A!\u0002\u0005\u0006\u000b\t!\t\u0002\u0003\u0007\u0006\u0007\u0011Y\u0001\u0012\u0004\u0007\u0001\u000b\u0005A\u0019!B\u0002\u0005\u0019!iA\u0002A\u0003\u0003\t-AI\u0002B\u0002\r\beAQ!\u0001E\u0005\u0013\u0011I1!B\u0001\t\fa-\u0001\u0014B\r\u0004\u000b\u0005A\u0001\u0002\u0007\u0005.-\u0011Y\u0001$CO\b\t\u0001A\u0019\"D\u0002\u0006\u0003!-\u00014\u0002)\u0004\u0001\u0005\"Q!\u0001E\n\u0019\u0003A\u001a\"U\u0002\u0006\t%I\u0011\u0001\u0003\u0006\u000e\u0003!UQv\b\u0003\f1/iz\u0001\u0002\u0001\t\u00145\u0019Q!\u0001E\u00061\u0017\u00016\u0001AO\b\t\u0001AA\"D\u0002\u0006\u0003!]\u0001t\u0003)\u0004\u0002\u0005\u001aQ!\u0001E\r13\t6a\u0002C\f\u0013\u0005!\u0001!D\u0001\t\u00165\t\u0001\"D\u001b\r\u000b-!1\u001d\u0001M\tC\r)\u0011\u0001c\u0002\u0019\bE\u001b1\u0001\"\u0005\n\u0003\u0011\u0001\u0001"})
public final class MoveDeclarationToSeparateFileIntention
extends JetSelfTargetingRangeIntention<JetClassOrObject>
implements LowPriorityAction {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(MoveDeclarationToSeparateFileIntention.class);
    }

    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull JetClassOrObject element2) {
        PsiElement keyword;
        PsiElement psiElement2;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (element2.getName() == null) {
            return null;
        }
        if (!(element2.getParent() instanceof JetFile)) {
            return null;
        }
        if (element2.hasModifier(JetTokens.PRIVATE_KEYWORD)) {
            return null;
        }
        if (element2.getContainingJetFile().getDeclarations().size() == 1) {
            return null;
        }
        JetClassOrObject jetClassOrObject = element2;
        if (jetClassOrObject instanceof JetClass) {
            psiElement2 = ((JetClass)element2).getClassOrInterfaceKeyword();
        } else if (jetClassOrObject instanceof JetObjectDeclaration) {
            psiElement2 = ((JetObjectDeclaration)element2).getObjectKeyword();
        } else {
            return null;
        }
        PsiElement psiElement3 = keyword = psiElement2;
        if (psiElement3 == null) {
            return null;
        }
        int startOffset = PsiUtilsKt.getStartOffset(psiElement3);
        PsiElement psiElement4 = element2.getNameIdentifier();
        if (psiElement4 == null) {
            return null;
        }
        int endOffset = PsiUtilsKt.getEndOffset(psiElement4);
        this.setText("Move '" + element2.getName() + "' to separate file");
        return new TextRange(startOffset, endOffset);
    }

    @Override
    public void applyTo(@NotNull JetClassOrObject element2, @NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        JetFile file = element2.getContainingJetFile();
        Project project = file.getProject();
        int originalOffset = editor.getCaretModel().getOffset() - PsiUtilsKt.getStartOffset(element2);
        PsiDirectory psiDirectory = file.getContainingDirectory();
        if (psiDirectory == null) {
            return;
        }
        PsiDirectory directory = psiDirectory;
        FqName packageName = file.getPackageFqName();
        String targetFileName = element2.getName() + ".kt";
        PsiFile targetFile = directory.findFile(targetFileName);
        if (targetFile != null) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw (Throwable)new CommonRefactoringUtil.RefactoringErrorHintException("File " + targetFileName + " already exists");
            }
            ApplicationManager.getApplication().invokeLater(new Runnable(project, element2, packageName, directory, targetFile){
                final /* synthetic */ Project $project;
                final /* synthetic */ JetClassOrObject $element;
                final /* synthetic */ FqName $packageName;
                final /* synthetic */ PsiDirectory $directory;
                final /* synthetic */ PsiFile $targetFile;

                public final void run() {
                    Set set = KotlinPackage.setOf((Object)this.$element);
                    String string = this.$packageName.asString();
                    PsiFile psiFile = this.$targetFile;
                    if (!(psiFile instanceof JetFile)) {
                        psiFile = null;
                    }
                    new MoveKotlinTopLevelDeclarationsDialog(this.$project, set, string, this.$directory, (JetFile)psiFile, true, true, true, null).show();
                }
                {
                    this.$project = project;
                    this.$element = jetClassOrObject;
                    this.$packageName = fqName2;
                    this.$directory = psiDirectory;
                    this.$targetFile = psiFile;
                }
            });
            return;
        }
        Project project2 = project;
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        FqName fqName2 = packageName;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"packageName");
        DeferredJetFileKotlinMoveTarget moveTarget2 = new DeferredJetFileKotlinMoveTarget(project2, fqName2, (Function1<? super JetFile, ? extends JetFile>)((Function1)new Function1<JetFile, JetFile>(targetFileName, directory, packageName){
            final /* synthetic */ String $targetFileName;
            final /* synthetic */ PsiDirectory $directory;
            final /* synthetic */ FqName $packageName;

            @NotNull
            public final JetFile invoke(@NotNull JetFile it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                PsiDirectory psiDirectory = this.$directory;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiDirectory, (String)"directory");
                return JetRefactoringUtilKt.createKotlinFile(this.$targetFileName, psiDirectory, this.$packageName.asString());
            }
            {
                this.$targetFileName = string;
                this.$directory = psiDirectory;
                this.$packageName = fqName2;
                super(1);
            }
        }));
        MoveKotlinTopLevelDeclarationsOptions moveOptions2 = new MoveKotlinTopLevelDeclarationsOptions(KotlinPackage.listOf((Object)element2), moveTarget2, false, false, false, false, new MoveCallback(directory, targetFileName, project, originalOffset){
            final /* synthetic */ PsiDirectory $directory;
            final /* synthetic */ String $targetFileName;
            final /* synthetic */ Project $project;
            final /* synthetic */ int $originalOffset;

            public final void refactoringCompleted() {
                Unit unit;
                PsiFile psiFile = this.$directory.findFile(this.$targetFileName);
                if (psiFile == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.JetFile");
                }
                JetFile newFile = (JetFile)psiFile;
                JetDeclaration newDeclaration = (JetDeclaration)KotlinPackage.first(newFile.getDeclarations());
                NavigationUtil.activateFileWithPsiElement((PsiElement)((PsiElement)newFile));
                Editor editor = FileEditorManager.getInstance((Project)this.$project).getSelectedTextEditor();
                if (editor != null) {
                    GenerateUtilKt.moveCaret$default(editor, PsiUtilsKt.getStartOffset(newDeclaration) + this.$originalOffset, null, 2);
                    unit = Unit.INSTANCE$;
                } else {
                    unit = null;
                }
            }
            {
                this.$directory = psiDirectory;
                this.$targetFileName = string;
                this.$project = project;
                this.$originalOffset = n;
            }
        }, 32, null);
        Project project3 = project;
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        new MoveKotlinTopLevelDeclarationsProcessor(project3, moveOptions2, null, 4, null).run();
    }

    public MoveDeclarationToSeparateFileIntention() {
        super(JetClassOrObject.class, "Move declaration to separate file", null, 4, null);
    }
}

