/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.rename.RenamePsiFileProcessor;
import java.util.Map;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.idea.JetFileType;
import org.jetbrains.kotlin.idea.search.SearchUtilKt;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetFile;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"'\u0006)I\"+\u001a8b[\u0016\\u\u000e\u001e7j]\u001aKG.\u001a)s_\u000e,7o]8s\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'\u0002B5eK\u0006T1B]3gC\u000e$xN]5oO*1!/\u001a8b[\u0016TaCU3oC6,\u0007k]5GS2,\u0007K]8dKN\u001cxN\u001d\u0006\u0004G>l'\u0002C5oi\u0016dG.\u001b6\u000b\rqJg.\u001b;?\u0015E\u0019\u0017M\u001c)s_\u000e,7o]#mK6,g\u000e\u001e\u0006\bK2,W.\u001a8u\u0015)\u00016/[#mK6,g\u000e\u001e\u0006\u0004aNL'b\u0002\"p_2,\u0017M\u001c\u0006\u0010aJ,\u0007/\u0019:f%\u0016t\u0017-\\5oO*9a.Z<OC6,'BB*ue&twM\u0003\u0006bY2\u0014VM\\1nKNT!\"T;uC\ndW-T1q\u0015\u0015\u00198m\u001c9f\u0015-\u0019V-\u0019:dQN\u001bw\u000e]3\u000b\rM,\u0017M]2i\u0015\u0011)f.\u001b;\u000b\t)\fg/\u0019\u0006\u0005Y\u0006twM\u0003\u0003vi&d'bA'baB\u000e!B\u0001\t\u0002\u0015\u0011A\u0001\u0001\u0005\u0002\u000b\t!\t\u0001c\u0001\u0006\u0005\u0011\t\u0001BA\u0003\u0003\t\u0007A)!\u0002\u0002\u0005\u0005!\u0019Qa\u0001C\u0003\u0011\u0001a\u0001!B\u0001\t\t\u0015\u0011Aq\u0001E\u0005\u000b\t!A\u0001#\u0002\u0006\u0005\u0011%\u0001bA\u0003\u0004\t\u0015A9\u0001\u0004\u0001\u0006\u0005\u0011!\u0001bB\u0003\u0004\t\u0019Ai\u0001\u0004\u0001\u0006\u0003!\rQa\u0001\u0003\b\u0011\u001fa\u0001!\u0002\u0002\u0005\r!5Qa\u0001\u0003\b\u0011%a\u0001!B\u0002\u0005\u000f!QA\u0002A\u0003\u0003\t\u0019A9\"B\u0002\u0005\u0014!YA\u0002A\u0003\u0004\t\u001dAA\u0002\u0004\u0001\u0006\u0003!eQA\u0001\u0003\f\u00115)!\u0001b\u0006\t\u0013\u0015\u0011Aa\u0003E\u000e\u000b\t!I\u0002\u0003\b\u0006\u0005\u0011M\u0001b\u0003\u0003\u0004\u0019\rI2!B\u0001\t\fa-Q&\u0006\u0003\f1\u0017iz\u0001\u0002\u0001\t\r5\u0019Q!\u0001E\u00071\u001b\u00016\u0001A\u0011\u0004\u000b\u0005Ay\u0001g\u0004R\u0007\u0015!Y!C\u0001\u0005\u00025\t\u0001\u0002CW@\t-A\u0002\"(\u0005\u0005\u0001!1Q\u0002B\u0003\u0002\u0011\u001ba\t\u0001'\u0004Q\u0007\u0001iz\u0001\u0002\u0001\t\u00125\u0019Q!\u0001E\t1#\u00016\u0011AO\u0012\t\u0001A\u0019\"D\u0007\u0006\u0003!I\u0011\u0002B\u0005\u0004\u000b\u0005Ai\u0001'\u0004\n\t%\u0019Q!\u0001E\t1#A\u0012\u0002U\u0002\u0002;\u001f!\u0001\u0001#\u0006\u000e\u0007\u0015\t\u0001B\u0003\r\u000b!\u000e\r\u0011eA\u0003\u0002\u0011+A*\"U\u0002\f\t!I\u0011\u0001\u0002\u0001\u000e\u0003!AQ\"\u0001\u0005\r\u001b\u0005AQ\"D\u0001\t\u001cUbQa\u0003\u0003d\u0002a)\u0011eA\u0003\u0002\u0011\rA2!U\u0002\u0004\t\u0015I\u0011\u0001\u0002\u0001"})
public final class RenameKotlinFileProcessor
extends RenamePsiFileProcessor {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(RenameKotlinFileProcessor.class);
    }

    public boolean canProcessElement(@NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        return element2 instanceof JetFile;
    }

    public void prepareRenaming(@Nullable PsiElement element2, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames, @NotNull SearchScope scope2) {
        Intrinsics.checkParameterIsNotNull((Object)newName, (String)"newName");
        Intrinsics.checkParameterIsNotNull(allRenames, (String)"allRenames");
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        PsiElement psiElement2 = element2;
        if (!(psiElement2 instanceof JetFile)) {
            psiElement2 = null;
        }
        JetFile jetFile = (JetFile)psiElement2;
        if (jetFile == null) {
            return;
        }
        JetFile jetFile2 = jetFile;
        if (Intrinsics.areEqual((Object)FileTypeManager.getInstance().getFileTypeByFileName(newName), (Object)((Object)JetFileType.INSTANCE)) ^ true) {
            return;
        }
        JvmFileClassInfo fileInfo = JvmFileClassUtil.getFileClassInfoNoResolve(jetFile2);
        if (!fileInfo.getIsWithJvmName()) {
            FqName facadeFqName = fileInfo.getFacadeClassFqName();
            Project project = jetFile2.getProject();
            PsiClass facadeClass = JavaPsiFacade.getInstance((Project)project).findClass(facadeFqName.asString(), SearchUtilKt.allScope(project));
            if (facadeClass != null) {
                KotlinPackage.set(allRenames, (Object)facadeClass, (Object)PackagePartClassUtils.getFilePartShortName(newName));
            }
        }
    }
}

