/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.references;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.MultiRangeReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.references.JetSimpleReference;
import org.jetbrains.kotlin.idea.references.ReferencesPackage;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetArrayAccessExpression;
import org.jetbrains.kotlin.psi.JetContainerNode;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

public class JetArrayAccessReference
extends JetSimpleReference<JetArrayAccessExpression>
implements MultiRangeReference {
    public JetArrayAccessReference(@NotNull JetArrayAccessExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/references/JetArrayAccessReference", "<init>"));
        }
        super(expression2);
    }

    public TextRange getRangeInElement() {
        return ((JetArrayAccessExpression)this.getElement()).getTextRange().shiftRight(-((JetArrayAccessExpression)this.getElement()).getTextOffset());
    }

    @Override
    @NotNull
    protected Collection<DeclarationDescriptor> getTargetDescriptors(@NotNull BindingContext context) {
        ResolvedCall<FunctionDescriptor> setFunction;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/idea/references/JetArrayAccessReference", "getTargetDescriptors"));
        }
        ArrayList result2 = Lists.newArrayList();
        ResolvedCall<FunctionDescriptor> getFunction = context.get(BindingContext.INDEXED_LVALUE_GET, this.getExpression());
        if (getFunction != null) {
            result2.add(getFunction.getCandidateDescriptor());
        }
        if ((setFunction = context.get(BindingContext.INDEXED_LVALUE_SET, this.getExpression())) != null) {
            result2.add(setFunction.getCandidateDescriptor());
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/references/JetArrayAccessReference", "getTargetDescriptors"));
        }
        return arrayList;
    }

    public List<TextRange> getRanges() {
        ArrayList<TextRange> list = new ArrayList<TextRange>();
        JetContainerNode indices = ((JetArrayAccessExpression)this.getExpression()).getIndicesNode();
        TextRange textRange = indices.getNode().findChildByType((IElementType)JetTokens.LBRACKET).getTextRange();
        TextRange lBracketRange = textRange.shiftRight(-((JetArrayAccessExpression)this.getExpression()).getTextOffset());
        list.add(lBracketRange);
        ASTNode rBracket = indices.getNode().findChildByType((IElementType)JetTokens.RBRACKET);
        if (rBracket != null) {
            textRange = rBracket.getTextRange();
            TextRange rBracketRange = textRange.shiftRight(-((JetArrayAccessExpression)this.getExpression()).getTextOffset());
            list.add(rBracketRange);
        }
        return list;
    }

    @Override
    public boolean canRename() {
        return true;
    }

    @Override
    @Nullable
    public PsiElement handleElementRename(@Nullable String newElementName) {
        return ReferencesPackage.renameImplicitConventionalCall(this, newElementName);
    }
}

