/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.run;

import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.configuration.TestNGConfigurationProducer;
import com.theoryinpractice.testng.util.TestNGUtil;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.idea.project.ProjectStructureUtil;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetNamedFunction;

public class JetTestNgConfigurationProducer
extends TestNGConfigurationProducer {
    protected boolean setupConfigurationFromContext(TestNGConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        JetClass jetClass;
        PsiClass delegate2;
        JetElement owner;
        Location location2 = context.getLocation();
        if (location2 == null) {
            return false;
        }
        Project project = context.getProject();
        PsiElement leaf = location2.getPsiElement();
        if (!ProjectRootsUtil.isInProjectOrLibSource(leaf)) {
            return false;
        }
        if (!(leaf.getContainingFile() instanceof JetFile)) {
            return false;
        }
        JetFile jetFile = (JetFile)leaf.getContainingFile();
        if (ProjectStructureUtil.isJsKotlinModule(jetFile)) {
            return false;
        }
        JetNamedFunction function2 = (JetNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)leaf, JetNamedFunction.class, (boolean)false);
        if (function2 != null && (owner = (JetElement)PsiTreeUtil.getParentOfType((PsiElement)function2, (Class[])new Class[]{JetFunction.class, JetClass.class})) instanceof JetClass && (delegate2 = LightClassUtil.INSTANCE$.getPsiClass((JetClass)owner)) != null) {
            for (PsiMethod method : delegate2.getMethods()) {
                if (method.getNavigationElement() != function2) continue;
                if (!TestNGUtil.hasTest((PsiModifierListOwner)method)) break;
                return this.configure(configuration, location2, context, project, delegate2, method);
            }
        }
        if ((jetClass = (JetClass)PsiTreeUtil.getParentOfType((PsiElement)leaf, JetClass.class, (boolean)false)) == null) {
            jetClass = JetTestNgConfigurationProducer.getClassDeclarationInFile(jetFile);
        }
        if (jetClass == null) {
            return false;
        }
        delegate2 = LightClassUtil.INSTANCE$.getPsiClass(jetClass);
        if (!JetTestNgConfigurationProducer.isTestNGClass(delegate2)) {
            return false;
        }
        return this.configure(configuration, location2, context, project, delegate2, null);
    }

    private boolean configure(TestNGConfiguration configuration, Location location2, ConfigurationContext context, Project project, @Nullable PsiClass delegate2, @Nullable PsiMethod method) {
        if (delegate2 == null) {
            return false;
        }
        this.setupConfigurationModule(context, (ModuleBasedConfiguration)configuration);
        Module originalModule = ((JavaRunConfigurationModule)configuration.getConfigurationModule()).getModule();
        configuration.setClassConfiguration(delegate2);
        if (method != null) {
            configuration.setMethodConfiguration(PsiLocation.fromPsiElement((Project)project, (PsiElement)method));
        }
        configuration.restoreOriginalModule(originalModule);
        configuration.setName(configuration.getName());
        JavaRunConfigurationExtensionManager.getInstance().extendCreatedConfiguration((RunConfigurationBase)configuration, location2);
        return true;
    }

    private static boolean isTestNGClass(PsiClass psiClass) {
        return psiClass != null && PsiClassUtil.isRunnableClass((PsiClass)psiClass, (boolean)true, (boolean)false) && TestNGUtil.hasTest((PsiModifierListOwner)psiClass);
    }

    @Nullable
    static JetClass getClassDeclarationInFile(JetFile jetFile) {
        JetClass tempSingleDeclaration = null;
        for (JetDeclaration jetDeclaration : jetFile.getDeclarations()) {
            if (!(jetDeclaration instanceof JetClass)) continue;
            JetClass declaration = (JetClass)jetDeclaration;
            if (tempSingleDeclaration == null) {
                tempSingleDeclaration = declaration;
                continue;
            }
            return null;
        }
        return tempSingleDeclaration;
    }
}

