/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search.ideaExtensions;

import com.intellij.codeInsight.navigation.MethodImplementationsSearch;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.DefinitionsScopedSearch;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.KotlinLightMethod;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPropertyAccessor;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetSecondaryConstructor;

public class KotlinDefinitionsSearcher
implements QueryExecutor<PsiElement, DefinitionsScopedSearch.SearchParameters> {
    public boolean execute(@NotNull DefinitionsScopedSearch.SearchParameters queryParameters, @NotNull Processor<PsiElement> consumer2) {
        JetParameter parameter;
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "org/jetbrains/kotlin/idea/search/ideaExtensions/KotlinDefinitionsSearcher", "execute"));
        }
        if (consumer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/kotlin/idea/search/ideaExtensions/KotlinDefinitionsSearcher", "execute"));
        }
        PsiElement element2 = queryParameters.getElement();
        SearchScope scope2 = queryParameters.getScope();
        if (element2 instanceof JetClass) {
            return KotlinDefinitionsSearcher.processClassImplementations((JetClass)element2, consumer2);
        }
        if (element2 instanceof JetNamedFunction || element2 instanceof JetSecondaryConstructor) {
            return KotlinDefinitionsSearcher.processFunctionImplementations((JetFunction)element2, scope2, consumer2);
        }
        if (element2 instanceof JetProperty) {
            return KotlinDefinitionsSearcher.processPropertyImplementations((JetProperty)element2, scope2, consumer2);
        }
        if (element2 instanceof JetParameter && JetPsiUtil.getClassIfParameterIsProperty(parameter = (JetParameter)element2) != null) {
            return KotlinDefinitionsSearcher.processPropertyImplementations((JetParameter)element2, scope2, consumer2);
        }
        return true;
    }

    private static boolean processClassImplementations(final JetClass klass, Processor<PsiElement> consumer2) {
        PsiClass psiClass = (PsiClass)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass>(){

            public PsiClass compute() {
                return LightClassUtil.INSTANCE$.getPsiClass(klass);
            }
        });
        if (psiClass != null) {
            return ContainerUtil.process((Iterable)ClassInheritorsSearch.search((PsiClass)psiClass, (boolean)true), consumer2);
        }
        return true;
    }

    private static boolean processFunctionImplementations(final JetFunction function2, SearchScope scope2, Processor<PsiElement> consumer2) {
        PsiMethod psiMethod = (PsiMethod)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiMethod>(){

            public PsiMethod compute() {
                return LightClassUtil.INSTANCE$.getLightClassMethod(function2);
            }
        });
        if (psiMethod != null) {
            MethodImplementationsSearch.processImplementations((PsiMethod)psiMethod, consumer2, (SearchScope)scope2);
        }
        return true;
    }

    private static boolean processPropertyImplementations(final @NotNull JetParameter parameter, @NotNull SearchScope scope2, @NotNull Processor<PsiElement> consumer2) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/idea/search/ideaExtensions/KotlinDefinitionsSearcher", "processPropertyImplementations"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/idea/search/ideaExtensions/KotlinDefinitionsSearcher", "processPropertyImplementations"));
        }
        if (consumer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/kotlin/idea/search/ideaExtensions/KotlinDefinitionsSearcher", "processPropertyImplementations"));
        }
        LightClassUtil.PropertyAccessorsPsiMethods accessorsPsiMethods = (LightClassUtil.PropertyAccessorsPsiMethods)ApplicationManager.getApplication().runReadAction((Computable)new Computable<LightClassUtil.PropertyAccessorsPsiMethods>(){

            public LightClassUtil.PropertyAccessorsPsiMethods compute() {
                return LightClassUtil.INSTANCE$.getLightClassPropertyMethods(parameter);
            }
        });
        return KotlinDefinitionsSearcher.processPropertyImplementationsMethods(accessorsPsiMethods, scope2, consumer2);
    }

    private static boolean processPropertyImplementations(final @NotNull JetProperty property, @NotNull SearchScope scope2, @NotNull Processor<PsiElement> consumer2) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/idea/search/ideaExtensions/KotlinDefinitionsSearcher", "processPropertyImplementations"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/idea/search/ideaExtensions/KotlinDefinitionsSearcher", "processPropertyImplementations"));
        }
        if (consumer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/kotlin/idea/search/ideaExtensions/KotlinDefinitionsSearcher", "processPropertyImplementations"));
        }
        LightClassUtil.PropertyAccessorsPsiMethods accessorsPsiMethods = (LightClassUtil.PropertyAccessorsPsiMethods)ApplicationManager.getApplication().runReadAction((Computable)new Computable<LightClassUtil.PropertyAccessorsPsiMethods>(){

            public LightClassUtil.PropertyAccessorsPsiMethods compute() {
                return LightClassUtil.INSTANCE$.getLightClassPropertyMethods(property);
            }
        });
        return KotlinDefinitionsSearcher.processPropertyImplementationsMethods(accessorsPsiMethods, scope2, consumer2);
    }

    public static boolean processPropertyImplementationsMethods(LightClassUtil.PropertyAccessorsPsiMethods accessors, @NotNull SearchScope scope2, @NotNull Processor<PsiElement> consumer2) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/idea/search/ideaExtensions/KotlinDefinitionsSearcher", "processPropertyImplementationsMethods"));
        }
        if (consumer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/kotlin/idea/search/ideaExtensions/KotlinDefinitionsSearcher", "processPropertyImplementationsMethods"));
        }
        for (PsiMethod method : accessors) {
            ArrayList implementations = new ArrayList();
            MethodImplementationsSearch.getOverridingMethods((PsiMethod)method, implementations, (SearchScope)scope2);
            for (PsiMethod implementation : implementations) {
                JetDeclaration mirrorElement;
                JetDeclaration jetDeclaration = mirrorElement = implementation instanceof KotlinLightMethod ? ((KotlinLightMethod)implementation).getOrigin() : null;
                if (!(mirrorElement instanceof JetProperty || mirrorElement instanceof JetParameter ? !consumer2.process((Object)mirrorElement) : (mirrorElement instanceof JetPropertyAccessor && mirrorElement.getParent() instanceof JetProperty ? !consumer2.process((Object)mirrorElement.getParent()) : !consumer2.process((Object)implementation)))) continue;
                return false;
            }
        }
        return true;
    }
}

