/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.stubindex;

import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.idea.stubindex.JetAnnotationsIndex;
import org.jetbrains.kotlin.idea.stubindex.JetClassShortNameIndex;
import org.jetbrains.kotlin.idea.stubindex.JetExactPackagesIndex;
import org.jetbrains.kotlin.idea.stubindex.JetFileFacadeClassByPackageIndex;
import org.jetbrains.kotlin.idea.stubindex.JetFileFacadeFqNameIndex;
import org.jetbrains.kotlin.idea.stubindex.JetFileFacadeShortNameIndex;
import org.jetbrains.kotlin.idea.stubindex.JetFilePartClassIndex;
import org.jetbrains.kotlin.idea.stubindex.JetFullClassNameIndex;
import org.jetbrains.kotlin.idea.stubindex.JetFunctionShortNameIndex;
import org.jetbrains.kotlin.idea.stubindex.JetMultifileClassPartIndex;
import org.jetbrains.kotlin.idea.stubindex.JetProbablyNothingFunctionShortNameIndex;
import org.jetbrains.kotlin.idea.stubindex.JetProbablyNothingPropertyShortNameIndex;
import org.jetbrains.kotlin.idea.stubindex.JetPropertyShortNameIndex;
import org.jetbrains.kotlin.idea.stubindex.JetSuperClassIndex;
import org.jetbrains.kotlin.idea.stubindex.JetTopLevelClassByPackageIndex;
import org.jetbrains.kotlin.idea.stubindex.JetTopLevelFunctionByPackageIndex;
import org.jetbrains.kotlin.idea.stubindex.JetTopLevelFunctionFqnNameIndex;
import org.jetbrains.kotlin.idea.stubindex.JetTopLevelPropertyByPackageIndex;
import org.jetbrains.kotlin.idea.stubindex.JetTopLevelPropertyFqnNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinFileStubForIde;
import org.jetbrains.kotlin.idea.stubindex.StubindexPackage;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.stubs.KotlinAnnotationEntryStub;
import org.jetbrains.kotlin.psi.stubs.KotlinClassOrObjectStub;
import org.jetbrains.kotlin.psi.stubs.KotlinClassStub;
import org.jetbrains.kotlin.psi.stubs.KotlinFileStub;
import org.jetbrains.kotlin.psi.stubs.KotlinFunctionStub;
import org.jetbrains.kotlin.psi.stubs.KotlinImportDirectiveStub;
import org.jetbrains.kotlin.psi.stubs.KotlinObjectStub;
import org.jetbrains.kotlin.psi.stubs.KotlinPropertyStub;
import org.jetbrains.kotlin.psi.stubs.elements.StubIndexService;
import org.jetbrains.kotlin.util.TypeIndexUtilKt;

public class IdeStubIndexService
extends StubIndexService {
    @Override
    public void indexFile(KotlinFileStub stub, IndexSink sink) {
        List<StringRef> partNames;
        JetFile jetFile;
        FqName partFqName;
        FqName packageFqName = stub.getPackageFqName();
        sink.occurrence(JetExactPackagesIndex.getInstance().getKey(), (Object)packageFqName.asString());
        FqName facadeFqName = ((KotlinFileStubForIde)stub).getFacadeFqName();
        if (facadeFqName != null) {
            sink.occurrence(JetFileFacadeFqNameIndex.INSTANCE.getKey(), (Object)facadeFqName.asString());
            sink.occurrence(JetFileFacadeShortNameIndex.INSTANCE.getKey(), (Object)facadeFqName.shortName().asString());
            sink.occurrence(JetFileFacadeClassByPackageIndex.INSTANCE.getKey(), (Object)packageFqName.asString());
        }
        if ((partFqName = ((KotlinFileStubForIde)stub).getPartFqName()) != null) {
            sink.occurrence(JetFilePartClassIndex.INSTANCE.getKey(), (Object)partFqName.asString());
        }
        if ((jetFile = (JetFile)stub.getPsi()) != null) {
            JvmFileClassInfo fileClassInfo = JvmFileClassUtil.getFileClassInfoNoResolve(jetFile);
            sink.occurrence(JetFileFacadeFqNameIndex.INSTANCE.getKey(), (Object)fileClassInfo.getFacadeClassFqName().asString());
            sink.occurrence(JetFilePartClassIndex.INSTANCE.getKey(), (Object)fileClassInfo.getFileClassFqName().asString());
        }
        if ((partNames = ((KotlinFileStubForIde)stub).getFacadePartSimpleNames()) != null) {
            for (StringRef partName : partNames) {
                String partSimpleName = StringRef.toString((StringRef)partName);
                if (partSimpleName == null) continue;
                FqName multifileClassPartFqName = packageFqName.child(Name.identifier(partSimpleName));
                sink.occurrence(JetMultifileClassPartIndex.INSTANCE.getKey(), (Object)multifileClassPartFqName.asString());
            }
        }
    }

    @Override
    public void indexClass(KotlinClassStub stub, IndexSink sink) {
        FqName fqName2;
        String name2 = stub.getName();
        if (name2 != null) {
            sink.occurrence(JetClassShortNameIndex.getInstance().getKey(), (Object)name2);
        }
        if ((fqName2 = stub.getFqName()) != null) {
            sink.occurrence(JetFullClassNameIndex.getInstance().getKey(), (Object)fqName2.asString());
            if (stub.isTopLevel()) {
                sink.occurrence(JetTopLevelClassByPackageIndex.getInstance().getKey(), (Object)fqName2.parent().asString());
            }
        }
        IdeStubIndexService.indexSuperNames(stub, sink);
    }

    @Override
    public void indexObject(KotlinObjectStub stub, IndexSink sink) {
        FqName fqName2;
        String name2 = stub.getName();
        if (name2 != null) {
            sink.occurrence(JetClassShortNameIndex.getInstance().getKey(), (Object)name2);
        }
        if ((fqName2 = stub.getFqName()) != null) {
            sink.occurrence(JetFullClassNameIndex.getInstance().getKey(), (Object)fqName2.asString());
            if (stub.isTopLevel()) {
                sink.occurrence(JetTopLevelClassByPackageIndex.getInstance().getKey(), (Object)fqName2.parent().asString());
            }
        }
        IdeStubIndexService.indexSuperNames(stub, sink);
    }

    private static void indexSuperNames(KotlinClassOrObjectStub<? extends JetClassOrObject> stub, IndexSink sink) {
        for (String superName : stub.getSuperNames()) {
            sink.occurrence(JetSuperClassIndex.getInstance().getKey(), (Object)superName);
        }
    }

    @Override
    public void indexFunction(KotlinFunctionStub stub, IndexSink sink) {
        FqName fqName2;
        String name2 = stub.getName();
        if (name2 != null) {
            sink.occurrence(JetFunctionShortNameIndex.getInstance().getKey(), (Object)name2);
            if (TypeIndexUtilKt.isProbablyNothing(((JetNamedFunction)stub.getPsi()).getTypeReference())) {
                sink.occurrence(JetProbablyNothingFunctionShortNameIndex.getInstance().getKey(), (Object)name2);
            }
        }
        if (stub.isTopLevel() && (fqName2 = stub.getFqName()) != null) {
            sink.occurrence(JetTopLevelFunctionFqnNameIndex.getInstance().getKey(), (Object)fqName2.asString());
            sink.occurrence(JetTopLevelFunctionByPackageIndex.getInstance().getKey(), (Object)fqName2.parent().asString());
            StubindexPackage.indexTopLevelExtension(stub, sink);
        }
    }

    @Override
    public void indexProperty(KotlinPropertyStub stub, IndexSink sink) {
        FqName fqName2;
        String name2 = stub.getName();
        if (name2 != null) {
            sink.occurrence(JetPropertyShortNameIndex.getInstance().getKey(), (Object)name2);
            if (TypeIndexUtilKt.isProbablyNothing(((JetProperty)stub.getPsi()).getTypeReference())) {
                sink.occurrence(JetProbablyNothingPropertyShortNameIndex.getInstance().getKey(), (Object)name2);
            }
        }
        if (stub.isTopLevel() && (fqName2 = stub.getFqName()) != null) {
            sink.occurrence(JetTopLevelPropertyFqnNameIndex.getInstance().getKey(), (Object)fqName2.asString());
            sink.occurrence(JetTopLevelPropertyByPackageIndex.getInstance().getKey(), (Object)fqName2.parent().asString());
            StubindexPackage.indexTopLevelExtension(stub, sink);
        }
    }

    @Override
    public void indexAnnotation(KotlinAnnotationEntryStub stub, IndexSink sink) {
        sink.occurrence(JetAnnotationsIndex.getInstance().getKey(), (Object)stub.getShortName());
        KotlinFileStub fileStub = IdeStubIndexService.getContainingFileStub(stub);
        if (fileStub != null) {
            List<KotlinImportDirectiveStub> aliasImportStubs = fileStub.findImportsByAlias(stub.getShortName());
            for (KotlinImportDirectiveStub importStub : aliasImportStubs) {
                sink.occurrence(JetAnnotationsIndex.getInstance().getKey(), (Object)importStub.getImportedFqName().shortName().asString());
            }
        }
    }

    private static KotlinFileStub getContainingFileStub(StubElement stub) {
        for (StubElement parent = stub.getParentStub(); parent != null; parent = parent.getParentStub()) {
            if (!(parent instanceof KotlinFileStub)) continue;
            return (KotlinFileStub)parent;
        }
        return null;
    }

    @Override
    @NotNull
    public KotlinFileStub createFileStub(@NotNull JetFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/stubindex/IdeStubIndexService", "createFileStub"));
        }
        StringRef packageFqName = StringRef.fromString((String)file.getPackageFqNameByTree().asString());
        boolean isScript = file.isScriptByTree();
        if (PackagePartClassUtils.fileHasTopLevelCallables(file)) {
            JvmFileClassInfo fileClassInfo = JvmFileClassUtil.getFileClassInfoNoResolve(file);
            StringRef facadeSimpleName = StringRef.fromString((String)fileClassInfo.getFacadeClassFqName().shortName().asString());
            StringRef partSimpleName = StringRef.fromString((String)fileClassInfo.getFileClassFqName().shortName().asString());
            KotlinFileStubForIde kotlinFileStubForIde = new KotlinFileStubForIde(file, packageFqName, isScript, facadeSimpleName, partSimpleName, null);
            if (kotlinFileStubForIde == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/stubindex/IdeStubIndexService", "createFileStub"));
            }
            return kotlinFileStubForIde;
        }
        KotlinFileStubForIde kotlinFileStubForIde = new KotlinFileStubForIde(file, packageFqName, isScript, null, null, null);
        if (kotlinFileStubForIde == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/stubindex/IdeStubIndexService", "createFileStub"));
        }
        return kotlinFileStubForIde;
    }

    @Override
    public void serializeFileStub(@NotNull KotlinFileStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/idea/stubindex/IdeStubIndexService", "serializeFileStub"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/kotlin/idea/stubindex/IdeStubIndexService", "serializeFileStub"));
        }
        KotlinFileStubForIde fileStub = (KotlinFileStubForIde)stub;
        dataStream.writeName(fileStub.getPackageFqName().asString());
        dataStream.writeBoolean(fileStub.isScript());
        dataStream.writeName(StringRef.toString((StringRef)fileStub.getFacadeSimpleName()));
        dataStream.writeName(StringRef.toString((StringRef)fileStub.getPartSimpleName()));
        List<StringRef> facadePartNames = fileStub.getFacadePartSimpleNames();
        if (facadePartNames == null) {
            dataStream.writeInt(0);
        } else {
            dataStream.writeInt(facadePartNames.size());
            for (StringRef partName : facadePartNames) {
                dataStream.writeName(StringRef.toString((StringRef)partName));
            }
        }
    }

    @Override
    @NotNull
    public KotlinFileStub deserializeFileStub(@NotNull StubInputStream dataStream) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/kotlin/idea/stubindex/IdeStubIndexService", "deserializeFileStub"));
        }
        StringRef packageFqNameAsString = dataStream.readName();
        boolean isScript = dataStream.readBoolean();
        StringRef facadeSimpleName = dataStream.readName();
        StringRef partSimpleName = dataStream.readName();
        int numPartNames = dataStream.readInt();
        ArrayList<StringRef> facadePartNames = new ArrayList<StringRef>();
        for (int i = 0; i < numPartNames; ++i) {
            StringRef partNameRef = dataStream.readName();
            facadePartNames.add(partNameRef);
        }
        KotlinFileStubForIde kotlinFileStubForIde = new KotlinFileStubForIde(null, packageFqNameAsString, isScript, facadeSimpleName, partSimpleName, facadePartNames);
        if (kotlinFileStubForIde == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/stubindex/IdeStubIndexService", "deserializeFileStub"));
        }
        return kotlinFileStubForIde;
    }
}

