/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.stubindex;

import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubIndexKey;
import kotlin.KotlinPackage;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.stubindex.JetTopLevelExtensionsByReceiverTypeIndex;
import org.jetbrains.kotlin.psi.JetCallableDeclaration;
import org.jetbrains.kotlin.psi.JetDynamicType;
import org.jetbrains.kotlin.psi.JetFunctionType;
import org.jetbrains.kotlin.psi.JetNullableType;
import org.jetbrains.kotlin.psi.JetTypeElement;
import org.jetbrains.kotlin.psi.JetTypeParameter;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetUserType;
import org.jetbrains.kotlin.psi.stubs.KotlinCallableStubBase;
import org.jetbrains.kotlin.util.TypeIndexUtilKt;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"Y\u0004)aA\u000bR3dY\u0006\u0014\u0018\r^5p]*1\"*\u001a;DC2d\u0017M\u00197f\t\u0016\u001cG.\u0019:bi&|gNC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\r\u00018/\u001b\u0006\u0017S:$W\r\u001f+pa2+g/\u001a7FqR,gn]5p]*!1\u000f^;c\u0015YYu\u000e\u001e7j]\u000e\u000bG\u000e\\1cY\u0016\u001cF/\u001e2CCN,'\"B:uk\n\u001c(\u0002B:j].T\u0011\"\u00138eKb\u001c\u0016N\\6\u000b\u0007\r|WN\u0003\u0005j]R,G\u000e\\5k\u0015\u0011)f.\u001b;\u000b\u0019%sG-\u001a=Vi&d7o\u0013;\u000b\u001d)+G\u000fV=qK\u0016cW-\\3oi*)\u0011N\u001c3fq*YA-Z2mCJ\fG/[8om*\u0011\u0001C\u0001\u0006\u0005\u0011\u0001\u00012A\u0003\u0003\t\u0003A!!\u0002\u0002\u0005\u0003!\u0015Qa\u0001C\u0002\u0011\u0003a\u0001!\u0002\u0002\u0005\u0004!%Qa\u0001C\u0003\u0011\u0011a\u0001!B\u0001\t\r\u0015\u0011Aq\u0001E\u0007\u000b\t!A\u0001#\u0002\u0006\u0005\u0011%\u0001\u0012B\u0003\u0004\t\u0015AY\u0001\u0004\u0001\u0006\u0003!\u0011Qa\u0001\u0003\u0007\u0011\u001da\u0001!\u0002\u0002\u0005\u0006!!QA\u0001\u0003\u0006\u0011\u0017)1\u0001b\u0001\t\u00111\u0001QA\u0001C\u0002\u0011!)!\u0001b\u0001\t\u0002\u0015qCaA\t\u0007\t\u0001A\u0001!F\u0002\u0006\u0003!\u0011\u0001D\u0001\r\u0004;7!\u0001\u0001c\u0002\u000e\u0013\u0015\t\u0001bA\u0005\u0006\u0013\u0011)!\u0001\"\u0001\t\u0001q\u0001\u0001d\u0001)\u0004\u0001u=A\u0001\u0001\u0005\u0006\u001b\r)\u0011\u0001c\u0003\u0019\fA\u001b\t!I\u0002\u0006\u0003!5\u0001TB)\u0004\u000f\u0011\u0019\u0011\"\u0001\u0003\u0001\u001b\u0005Aq!D\u0001\t\u0010a\u001by!B\u0018\u0005\u0003E1A\u0001\u0001\u0005\u0001+\r)\u0011\u0001\u0003\u0002\u0019\u0005U\u0019Q!\u0001\u0005\t1!A\n\"(\u0005\u0005\u0001!IQ\u0002B\u0003\u0003\t\u0003A\u0001\u0001\b\u0001Q\u0007\u0003iz\u0001\u0002\u0001\t\u000b5\u0019Q!\u0001E\u00061\u0017\u00016!A\u0011\u0004\u000b\u0005Ai\u0001'\u0004R\u0007%!\t\"C\u0001\u0005\u00015\t\u0001\u0012C\u0007\u0002\u0011%i\u0011\u0001c\u0004Y\u0007\u001f\u0001"})
public final class IndexUtilsKt {
    public static final <TDeclaration extends JetCallableDeclaration> void indexTopLevelExtension(@NotNull KotlinCallableStubBase<TDeclaration> stub, @NotNull IndexSink sink) {
        Intrinsics.checkParameterIsNotNull(stub, (String)"stub");
        Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
        if (stub.isExtension()) {
            Unit unit;
            JetCallableDeclaration declaration = (JetCallableDeclaration)stub.getPsi();
            JetTypeReference jetTypeReference = declaration.getReceiverTypeReference();
            if (jetTypeReference == null) {
                Intrinsics.throwNpe();
            }
            JetTypeElement jetTypeElement = jetTypeReference.getTypeElement();
            if (jetTypeElement != null) {
                IndexUtilsKt.index(jetTypeElement, declaration, sink);
                unit = Unit.INSTANCE$;
            } else {
                unit = null;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final <TDeclaration extends JetCallableDeclaration> void index(JetTypeElement $receiver, @NotNull TDeclaration declaration, @NotNull IndexSink sink) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
        Function1<String, Unit> occurrence$ = new Function1<String, Unit>(declaration, sink){
            final /* synthetic */ JetCallableDeclaration $declaration;
            final /* synthetic */ IndexSink $sink;

            public final void invoke(@NotNull String typeName) {
                Intrinsics.checkParameterIsNotNull((Object)typeName, (String)"typeName");
                String string = this.$declaration.getName();
                if (string == null) {
                    return;
                }
                String name2 = string;
                StubIndexKey<String, JetCallableDeclaration> stubIndexKey = JetTopLevelExtensionsByReceiverTypeIndex.Companion.getINSTANCE().getKey();
                String string2 = name2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name");
                this.$sink.occurrence(stubIndexKey, (Object)JetTopLevelExtensionsByReceiverTypeIndex.Companion.buildKey(typeName, string2));
            }
            {
                this.$declaration = jetCallableDeclaration;
                this.$sink = indexSink;
                super(1);
            }
        };
        JetTypeElement jetTypeElement = $receiver;
        if (jetTypeElement instanceof JetUserType) {
            Object bound;
            Object v1;
            Object referenceName;
            Object it;
            void $receiver2;
            block18: {
                Ref.ObjectRef objectRef = new Ref.ObjectRef();
                String string = ((JetUserType)$receiver).getReferencedName();
                if (string == null) {
                    return;
                }
                objectRef.element = string;
                Iterable iterable = declaration.getTypeParameters();
                for (Object element2 : $receiver2) {
                    it = (JetTypeParameter)element2;
                    if (!Intrinsics.areEqual((Object)((JetTypeParameter)it).getName(), (Object)((String)referenceName.element))) continue;
                    v1 = element2;
                    break block18;
                }
                v1 = null;
            }
            JetTypeParameter typeParameter = v1;
            if (typeParameter != null) {
                bound = typeParameter.getExtendsBound();
                if (bound != null) {
                    Unit unit;
                    JetTypeElement jetTypeElement2 = ((JetTypeReference)bound).getTypeElement();
                    if (jetTypeElement2 != null) {
                        IndexUtilsKt.index(jetTypeElement2, declaration, sink);
                        unit = Unit.INSTANCE$;
                    } else {
                        unit = null;
                    }
                } else {
                    occurrence$.invoke("Any");
                }
                return;
            }
            String string = (String)referenceName.element;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"referenceName");
            occurrence$.invoke(string);
            bound = TypeIndexUtilKt.aliasImportMap((JetUserType)$receiver).get((Object)((String)referenceName.element));
            for (Object element2 : $receiver2) {
                Object object = it = (String)element2;
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it");
                occurrence$.invoke((String)object);
            }
            referenceName = null;
        } else if (jetTypeElement instanceof JetNullableType) {
            Unit unit;
            JetTypeElement jetTypeElement3 = ((JetNullableType)$receiver).getInnerType();
            if (jetTypeElement3 != null) {
                IndexUtilsKt.index(jetTypeElement3, declaration, sink);
                unit = Unit.INSTANCE$;
            } else {
                unit = null;
            }
        } else if (jetTypeElement instanceof JetFunctionType) {
            int arity = ((JetFunctionType)$receiver).getParameters().size() + (((JetFunctionType)$receiver).getReceiverTypeReference() != null ? 1 : 0);
            occurrence$.invoke("Function" + arity);
        } else if (jetTypeElement instanceof JetDynamicType) {
            occurrence$.invoke("Any");
        } else {
            KotlinPackage.error((Object)("Unsupported type: " + $receiver));
        }
    }
}

