/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.idea.codeInsight.CodeInsightUtils;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.debugger.DebuggerPackage;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.stubindex.PackageIndexUtil;
import org.jetbrains.kotlin.idea.stubindex.StaticFacadeIndexUtil;
import org.jetbrains.kotlin.load.kotlin.PackageClassUtils;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetForExpression;
import org.jetbrains.kotlin.psi.JetMultiDeclaration;
import org.jetbrains.kotlin.psi.JetMultiDeclarationEntry;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetTreeVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.CompositeBindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedSimpleFunctionDescriptor;

public class DebuggerUtils {
    private static final Set<String> KOTLIN_EXTENSIONS = Sets.newHashSet((Object[])new String[]{"kt", "kts"});

    private DebuggerUtils() {
    }

    @Nullable
    public static JetFile findSourceFileForClass(@NotNull Project project, @NotNull GlobalSearchScope searchScope2, final @NotNull JvmClassName className, final @NotNull String fileName, final int lineNumber) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/util/DebuggerUtils", "findSourceFileForClass"));
        }
        if (searchScope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "org/jetbrains/kotlin/idea/util/DebuggerUtils", "findSourceFileForClass"));
        }
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/kotlin/idea/util/DebuggerUtils", "findSourceFileForClass"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "org/jetbrains/kotlin/idea/util/DebuggerUtils", "findSourceFileForClass"));
        }
        String extension = FileUtilRt.getExtension((String)fileName);
        if (!KOTLIN_EXTENSIONS.contains(extension)) {
            return null;
        }
        if (DumbService.getInstance((Project)project).isDumb()) {
            return null;
        }
        Collection<JetFile> filesInPackage = PackageIndexUtil.findFilesWithExactPackage(className.getPackageFqName(), searchScope2, project);
        Collection filesWithExactName = Collections2.filter(filesInPackage, (Predicate)new Predicate<JetFile>(){

            public boolean apply(@Nullable JetFile file) {
                return file != null && file.getName().equals(fileName);
            }
        });
        if (filesWithExactName.isEmpty()) {
            return null;
        }
        if (filesWithExactName.size() == 1) {
            return (JetFile)filesWithExactName.iterator().next();
        }
        FqName partFqName = className.getFqNameForClassNameWithoutDollars();
        Collection<JetFile> filesForPart = StaticFacadeIndexUtil.findFilesForFilePart(partFqName, searchScope2, project);
        if (!filesForPart.isEmpty()) {
            for (JetFile file : filesForPart) {
                if (!file.getName().equals(fileName)) continue;
                return file;
            }
            return null;
        }
        if (DebuggerUtils.isPackageClassName(className)) {
            for (JetFile file : filesWithExactName) {
                boolean hasTopLevelMembers = KotlinPackage.any(file.getDeclarations(), (Function1)new Function1<JetDeclaration, Boolean>(){

                    public Boolean invoke(JetDeclaration declaration) {
                        return !(declaration instanceof JetClassOrObject);
                    }
                });
                if (!hasTopLevelMembers) continue;
                return file;
            }
        }
        if (DebuggerUtils.isPackagePartClassName(className)) {
            JetFile file = DebuggerUtils.getFileForPackagePartPrefixedName(filesWithExactName, className.getInternalName());
            if (file != null) {
                return file;
            }
            boolean isInLibrary = KotlinPackage.all((Iterable)filesWithExactName, (Function1)new Function1<JetFile, Boolean>(){

                public Boolean invoke(JetFile file) {
                    return LibraryUtil.findLibraryEntry((VirtualFile)file.getVirtualFile(), (Project)file.getProject()) != null;
                }
            });
            if (isInLibrary) {
                return (JetFile)KotlinPackage.singleOrNull((List)KotlinPackage.filter((Iterable)filesWithExactName, (Function1)new Function1<JetFile, Boolean>(){

                    public Boolean invoke(JetFile file) {
                        Integer startLineOffset = CodeInsightUtils.getStartLineOffset((PsiFile)file, lineNumber);
                        assert (startLineOffset != null) : "Cannot find start line offset for file " + file.getName() + ", line " + lineNumber;
                        JetDeclaration elementAt = (JetDeclaration)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(startLineOffset), JetDeclaration.class);
                        return elementAt != null && className.getInternalName().equals(DebuggerPackage.findPackagePartInternalNameForLibraryFile(elementAt));
                    }
                }));
            }
            return null;
        }
        return (JetFile)filesWithExactName.iterator().next();
    }

    private static boolean isPackagePartClassName(JvmClassName className) {
        String packageName = PackageClassUtils.getPackageClassInternalName(className.getPackageFqName());
        String internalName = className.getInternalName();
        return !internalName.equals(packageName) && internalName.startsWith(packageName);
    }

    private static boolean isPackageClassName(JvmClassName className) {
        String packageName = PackageClassUtils.getPackageClassInternalName(className.getPackageFqName());
        return packageName.equals(className.getInternalName());
    }

    @Nullable
    private static JetFile getFileForPackagePartPrefixedName(@NotNull Collection<JetFile> allPackageFiles, @NotNull String classInternalName) {
        if (allPackageFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allPackageFiles", "org/jetbrains/kotlin/idea/util/DebuggerUtils", "getFileForPackagePartPrefixedName"));
        }
        if (classInternalName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classInternalName", "org/jetbrains/kotlin/idea/util/DebuggerUtils", "getFileForPackagePartPrefixedName"));
        }
        for (JetFile file : allPackageFiles) {
            String packagePartInternalName = PackagePartClassUtils.getPackagePartInternalName(file);
            if (!classInternalName.startsWith(packagePartInternalName)) continue;
            return file;
        }
        return null;
    }

    @NotNull
    public static Pair<BindingContext, List<JetFile>> analyzeInlinedFunctions(@NotNull ResolutionFacade resolutionFacadeForFile, @NotNull BindingContext bindingContextForFile, @NotNull JetFile file, boolean analyzeOnlyReifiedInlineFunctions) {
        if (resolutionFacadeForFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolutionFacadeForFile", "org/jetbrains/kotlin/idea/util/DebuggerUtils", "analyzeInlinedFunctions"));
        }
        if (bindingContextForFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContextForFile", "org/jetbrains/kotlin/idea/util/DebuggerUtils", "analyzeInlinedFunctions"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/util/DebuggerUtils", "analyzeInlinedFunctions"));
        }
        HashSet<JetElement> analyzedElements = new HashSet<JetElement>();
        BindingContext context = DebuggerUtils.analyzeElementWithInline(resolutionFacadeForFile, bindingContextForFile, file, 1, analyzedElements, !analyzeOnlyReifiedInlineFunctions);
        LinkedHashSet<JetFile> toProcess = new LinkedHashSet<JetFile>();
        toProcess.add(file);
        for (JetElement collectedElement : analyzedElements) {
            JetFile containingFile = collectedElement.getContainingJetFile();
            toProcess.add(containingFile);
        }
        Pair pair2 = new Pair((Object)context, new ArrayList(toProcess));
        if (pair2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/util/DebuggerUtils", "analyzeInlinedFunctions"));
        }
        return pair2;
    }

    @NotNull
    public static Collection<JetElement> analyzeElementWithInline(@NotNull ResolutionFacade resolutionFacade, @NotNull BindingContext bindingContext2, @NotNull JetNamedFunction function2, boolean analyzeInlineFunctions) {
        if (resolutionFacade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolutionFacade", "org/jetbrains/kotlin/idea/util/DebuggerUtils", "analyzeElementWithInline"));
        }
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/idea/util/DebuggerUtils", "analyzeElementWithInline"));
        }
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/idea/util/DebuggerUtils", "analyzeElementWithInline"));
        }
        HashSet<JetElement> analyzedElements = new HashSet<JetElement>();
        DebuggerUtils.analyzeElementWithInline(resolutionFacade, bindingContext2, function2, 1, analyzedElements, !analyzeInlineFunctions);
        HashSet<JetElement> hashSet = analyzedElements;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/util/DebuggerUtils", "analyzeElementWithInline"));
        }
        return hashSet;
    }

    @NotNull
    private static BindingContext analyzeElementWithInline(@NotNull ResolutionFacade resolutionFacade, final @NotNull BindingContext bindingContext2, @NotNull JetElement element2, int deep, final @NotNull Set<JetElement> analyzedElements, final boolean analyzeInlineFunctions) {
        if (resolutionFacade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolutionFacade", "org/jetbrains/kotlin/idea/util/DebuggerUtils", "analyzeElementWithInline"));
        }
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/idea/util/DebuggerUtils", "analyzeElementWithInline"));
        }
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/util/DebuggerUtils", "analyzeElementWithInline"));
        }
        if (analyzedElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "analyzedElements", "org/jetbrains/kotlin/idea/util/DebuggerUtils", "analyzeElementWithInline"));
        }
        final Project project = element2.getProject();
        final HashSet collectedElements = new HashSet();
        element2.accept(new JetTreeVisitorVoid(){

            @Override
            public void visitExpression(@NotNull JetExpression expression2) {
                if (expression2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/util/DebuggerUtils$5", "visitExpression"));
                }
                super.visitExpression(expression2);
                Call call = bindingContext2.get(BindingContext.CALL, expression2);
                if (call == null) {
                    return;
                }
                ResolvedCall<?> resolvedCall = bindingContext2.get(BindingContext.RESOLVED_CALL, call);
                this.checkResolveCall(resolvedCall);
            }

            @Override
            public void visitMultiDeclaration(@NotNull JetMultiDeclaration multiDeclaration) {
                if (multiDeclaration == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "multiDeclaration", "org/jetbrains/kotlin/idea/util/DebuggerUtils$5", "visitMultiDeclaration"));
                }
                super.visitMultiDeclaration(multiDeclaration);
                for (JetMultiDeclarationEntry entry : multiDeclaration.getEntries()) {
                    ResolvedCall<FunctionDescriptor> resolvedCall = bindingContext2.get(BindingContext.COMPONENT_RESOLVED_CALL, entry);
                    this.checkResolveCall(resolvedCall);
                }
            }

            @Override
            public void visitForExpression(@NotNull JetForExpression expression2) {
                if (expression2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/util/DebuggerUtils$5", "visitForExpression"));
                }
                super.visitForExpression(expression2);
                this.checkResolveCall(bindingContext2.get(BindingContext.LOOP_RANGE_ITERATOR_RESOLVED_CALL, expression2.getLoopRange()));
                this.checkResolveCall(bindingContext2.get(BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL, expression2.getLoopRange()));
                this.checkResolveCall(bindingContext2.get(BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL, expression2.getLoopRange()));
            }

            private void checkResolveCall(ResolvedCall<?> resolvedCall) {
                PsiElement declaration;
                if (resolvedCall == null) {
                    return;
                }
                Object descriptor2 = resolvedCall.getResultingDescriptor();
                if (descriptor2 instanceof DeserializedSimpleFunctionDescriptor) {
                    return;
                }
                if (InlineUtil.isInline(descriptor2) && (analyzeInlineFunctions || DebuggerUtils.hasReifiedTypeParameters(descriptor2)) && (declaration = DescriptorToSourceUtilsIde.INSTANCE$.getAnyDeclaration(project, (DeclarationDescriptor)descriptor2)) != null && declaration instanceof JetNamedFunction && !analyzedElements.contains(declaration)) {
                    collectedElements.add((JetNamedFunction)declaration);
                }
            }
        });
        analyzedElements.add(element2);
        if (!collectedElements.isEmpty() && deep < 10) {
            ArrayList<BindingContext> innerContexts = new ArrayList<BindingContext>();
            for (JetNamedFunction inlineFunctions : collectedElements) {
                JetExpression body2 = inlineFunctions.getBodyExpression();
                if (body2 == null) continue;
                BindingContext bindingContextForFunction = resolutionFacade.analyze(body2, BodyResolveMode.FULL);
                innerContexts.add(DebuggerUtils.analyzeElementWithInline(resolutionFacade, bindingContextForFunction, inlineFunctions, deep + 1, analyzedElements, analyzeInlineFunctions));
            }
            innerContexts.add(bindingContext2);
            analyzedElements.addAll(collectedElements);
            BindingContext bindingContext3 = CompositeBindingContext.Companion.create(innerContexts);
            if (bindingContext3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/util/DebuggerUtils", "analyzeElementWithInline"));
            }
            return bindingContext3;
        }
        BindingContext bindingContext4 = bindingContext2;
        if (bindingContext4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/util/DebuggerUtils", "analyzeElementWithInline"));
        }
        return bindingContext4;
    }

    private static boolean hasReifiedTypeParameters(CallableDescriptor descriptor2) {
        return Iterables.any(descriptor2.getTypeParameters(), (Predicate)new Predicate<TypeParameterDescriptor>(){

            public boolean apply(TypeParameterDescriptor input) {
                return input.isReified();
            }
        });
    }
}

