/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import java.util.Map;
import kotlin.IndexedValue;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.parsing.JetExpressionParsing;
import org.jetbrains.kotlin.psi.JetAnnotatedExpression;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetLabeledExpression;
import org.jetbrains.kotlin.psi.JetOperationExpression;
import org.jetbrains.kotlin.psi.JetPostfixExpression;
import org.jetbrains.kotlin.psi.JetPrefixExpression;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"^\b)\t\"*\u001a;Qg&\u0004&/Z2fI\u0016t7-Z:\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*11n\u001c;mS:TA!\u001b3fC*!Q\u000f^5m\u0015\r\te.\u001f\u0006\u0004\u0019>;%B\u0002'pO\u001e,'OC\u0002d_6T\u0001\"\u001b8uK2d\u0017N\u001b\u0006\b_B,g.\u00199j\u0015)!\u0017.Y4o_N$\u0018n\u0019\u0006\b\u001d>$h*\u001e7m\u0015-\tgN\\8uCRLwN\\:\u000b?A\u0013ViQ#E\u000b:\u001bUiX(G?\u0006#v*T%D?\u0016C\u0006KU#T'&{eJC\u0002J]RT!eZ3u!J+5)\u0012#F\u001d\u000e+ul\u0014$`\u0003R{U*S\"`\u000bb\u0003&+R*T\u0013>s%\u0002\t)S\u000b\u000e+E)\u0012(D\u000b~{ei\u0018)P'R3\u0015\nW0F1B\u0013ViU*J\u001f:S1eZ3u!J+5)\u0012#F\u001d\u000e+ul\u0014$`!>\u001bFKR%Y?\u0016C\u0006KU#T'&{eJC\u0010Q%\u0016\u001bU\tR#O\u0007\u0016{vJR0Q%\u00163\u0015\nW0F1B\u0013ViU*J\u001f:S!eZ3u!J+5)\u0012#F\u001d\u000e+ul\u0014$`!J+e)\u0013-`\u000bb\u0003&+R*T\u0013>s%B\u00039sK\u000e,G-\u001a8dK*\u0019Q*\u00199\u000b\u0019%+E.Z7f]R$\u0016\u0010]3\u000b\u0007A\u001c\u0018N\u0003\u0003ue\u0016,'\u0002\u00026bm\u0006TQbZ3u!J,7-\u001a3f]\u000e,'BC3yaJ,7o]5p]*i!*\u001a;FqB\u0014Xm]:j_:T\u0011\"[:US\u001eDG/\u001a:\u000b\u000fM,(M[3di*YA/[4ii\u0016\u0014H\u000b[1o\u0015\u001d\u0011un\u001c7fC:\u0014\u001cA\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\t!\u0011\u0001\u0003\u0002\u0006\u0005\u0011\r\u0001RA\u0003\u0004\t\tA\u0001\u0001\u0004\u0001\u0006\u0003!\rQa\u0001\u0003\u0004\u0011\ra\u0001!B\u0001\t\n\u0015\u0011A\u0001\u0002\u0005\u0006\u000b\t!I\u0001c\u0003\u0006\u0005\u0011)\u0001BB\u0003\u0004\t\u0017AA\u0001\u0004\u0001\u0006\u0005\u0011\u0005\u0001bB\u0003\u0004\t\u001bAi\u0001\u0004\u0001\u0006\u0005\u0011-\u0001\u0002B\u0003\u0004\t\rA\u0001\u0002\u0004\u0001\u0006\u0007\u0011\u0019\u0001r\u0003\u0007\u0001\u000b\t!I\u0001#\u0007\u0006\u0005\u0011I\u0001\"D\u0003\u0004\t'AA\u0002\u0004\u0001\u0006\u0003!mQA\u0001C\u000b\u0011\u000b)!\u0001B\u0006\t\u0018\u0015\u0011A!\u0001E\r\u000b\r!A\u0002C\b\r\u0001\u0015\u0011A\u0001\u0004\u0005\u0010\u000b\r!1\u0001C\t\r\u0001\u0011\u0019\u0017\u0001$\u0002\u001a\u0007\u0015\t\u0001r\u0001M\u0004[;!\u0011\r\u0002M\u0004C\u0017)\u0011\u0001\u0003\u0004\u0019\rE\u001b\u0011\u0001B\u0004V\u0007\u0011)1\u0001b\u0002\n\u0003!=Q\u0006\u0005\u0003d)a=\u0011eA\u0003\u0002\u0011!A\u0002\"V\u0002\t\u000b\r!y!C\u0001\u0005\u00065\u0019A\u0011C\u0005\u0002\t\u000bi\u0003\u0003B2\u00051%\t3!B\u0001\t\u0011aAQk\u0001\u0005\u0006\u0007\u0011I\u0011\"\u0001C\u0003\u001b\r!\u0019\"C\u0001\u0005\u00065\u0002Ba\u0019\u0003\u0019\u0015\u0005\u001aQ!\u0001\u0005\t1!)6\u0001C\u0003\u0004\t)I\u0011\u0001\"\u0002\u000e\u0007\u0011U\u0011\"\u0001C\u0003[Y!\u0011\r\u0002\r\fC5)\u0011\u0001#\u0005\n\t%\u0019Q!\u0001\u0005\u000b1)IA!C\u0002\u0006\u0003!A\u0001\u0004\u0003M\t+\u000e!Qa\u0001\u0003\f\u0013\u0005A9\"L\u000b\u0005\u0007aqQt\u0002\u0003\u0001\u0011;i1!B\u0001\t\u001aae\u0001k\u0001\u0001\"\u0007\u0015\t\u0001\u0002\u0003\r\t#\u000e)AAD\u0005\u0002\t\u000bi\u0011\u0001C\u0007.@\u0011\u0019\u0001tDO\b\t\u0001A\u0001#D\u0002\u0006\u0003!A\u0001\u0004\u0003)\u0004\u0001u=A\u0001\u0001E\u0011\u001b\r)\u0011\u0001\u0003\u0005\u0019\u0011A\u001b\t!I\u0002\u0006\u0003!m\u00014D)\u0004\u000f\u0011}\u0011\"\u0001C\u0001\u001b\u0005!)!D\u0001\u0005\u0006U\u0002\u0001"})
public final class JetPsiPrecedences {
    public static final /* synthetic */ KClass $kotlinClass;
    private static final Logger LOG;
    private static final Map<IElementType, ? extends Integer> precedence;
    public static final int PRECEDENCE_OF_ATOMIC_EXPRESSION = -1;
    public static final int PRECEDENCE_OF_PREFIX_EXPRESSION;
    public static final int PRECEDENCE_OF_POSTFIX_EXPRESSION;
    public static final JetPsiPrecedences INSTANCE$;

    static {
        $kotlinClass = Reflection.createKotlinClass(JetPsiPrecedences.class);
        new JetPsiPrecedences();
    }

    public final int getPRECEDENCE_OF_ATOMIC_EXPRESSION() {
        return PRECEDENCE_OF_ATOMIC_EXPRESSION;
    }

    public final int getPRECEDENCE_OF_PREFIX_EXPRESSION() {
        return PRECEDENCE_OF_PREFIX_EXPRESSION;
    }

    public final int getPRECEDENCE_OF_POSTFIX_EXPRESSION() {
        return PRECEDENCE_OF_POSTFIX_EXPRESSION;
    }

    public final int getPrecedence(@NotNull JetExpression expression2) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        JetExpression jetExpression = expression2;
        if (jetExpression instanceof JetAnnotatedExpression || jetExpression instanceof JetLabeledExpression || jetExpression instanceof JetPrefixExpression) {
            n = PRECEDENCE_OF_PREFIX_EXPRESSION;
        } else if (jetExpression instanceof JetPostfixExpression) {
            n = PRECEDENCE_OF_POSTFIX_EXPRESSION;
        } else if (jetExpression instanceof JetOperationExpression) {
            IElementType operation = ((JetOperationExpression)expression2).getOperationReference().getReferencedNameElementType();
            Integer precedenceNumber = precedence.get(operation);
            if (precedenceNumber == null) {
                LOG.error("No precedence for operation: " + operation);
                n = precedence.size();
            } else {
                n = ((Number)precedenceNumber).intValue();
            }
        } else {
            n = PRECEDENCE_OF_ATOMIC_EXPRESSION;
        }
        return n;
    }

    public final boolean isTighter(int subject, int tighterThan) {
        return subject < tighterThan;
    }

    JetPsiPrecedences() {
        INSTANCE$ = this;
        LOG = Logger.getInstance(JetPsiPrecedences.class);
        HashMap builder = new HashMap();
        for (IndexedValue indexedValue : KotlinPackage.withIndex((Object[])((Object[])JetExpressionParsing.Precedence.values()))) {
            int i = indexedValue.component1();
            JetExpressionParsing.Precedence record2 = (JetExpressionParsing.Precedence)((Object)indexedValue.component2());
            IElementType[] iElementTypeArray = record2.getOperations().getTypes();
            for (int j = 0; j < iElementTypeArray.length; ++j) {
                IElementType elementType = iElementTypeArray[j];
                Map map2 = builder;
                IElementType iElementType = elementType;
                Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"elementType");
                KotlinPackage.set((Map)map2, (Object)iElementType, (Object)i);
            }
        }
        precedence = builder;
        PRECEDENCE_OF_ATOMIC_EXPRESSION = -1;
        PRECEDENCE_OF_PREFIX_EXPRESSION = JetExpressionParsing.Precedence.PREFIX.ordinal();
        PRECEDENCE_OF_POSTFIX_EXPRESSION = JetExpressionParsing.Precedence.POSTFIX.ordinal();
    }
}

