/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k.ast;

import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.j2k.CodeBuilder;
import org.jetbrains.kotlin.j2k.ast.Annotations;
import org.jetbrains.kotlin.j2k.ast.Block;
import org.jetbrains.kotlin.j2k.ast.DeferredElement;
import org.jetbrains.kotlin.j2k.ast.Function;
import org.jetbrains.kotlin.j2k.ast.FunctionLike;
import org.jetbrains.kotlin.j2k.ast.Identifier;
import org.jetbrains.kotlin.j2k.ast.Modifier;
import org.jetbrains.kotlin.j2k.ast.ModifierKt;
import org.jetbrains.kotlin.j2k.ast.Modifiers;
import org.jetbrains.kotlin.j2k.ast.ParameterList;
import org.jetbrains.kotlin.j2k.ast.Type;
import org.jetbrains.kotlin.j2k.ast.TypeParameterList;
import org.jetbrains.kotlin.j2k.ast.TypesKt;
import org.jetbrains.kotlin.j2k.ast.UtilKt;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"\u0012\b)Aa)\u001e8di&|gNC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\rQ'g\u001b\u0006\u0004CN$(\u0002\u0004$v]\u000e$\u0018n\u001c8MS.,'B\u0002\u001fj]&$hH\u0003\u0003oC6,'BC%eK:$\u0018NZ5fe*Y\u0011M\u001c8pi\u0006$\u0018n\u001c8t\u0015-\teN\\8uCRLwN\\:\u000b\u00135|G-\u001b4jKJ\u001c(\"C'pI&4\u0017.\u001a:t\u0015)\u0011X\r^;s]RK\b/\u001a\u0006\u0005)f\u0004XMC\tusB,\u0007+\u0019:b[\u0016$XM\u001d'jgRT\u0011\u0003V=qKB\u000b'/Y7fi\u0016\u0014H*[:u\u00155\u0001\u0018M]1nKR,'\u000fT5ti*i\u0001+\u0019:b[\u0016$XM\u001d'jgRTAAY8es*yA)\u001a4feJ,G-\u00127f[\u0016tGOC\u0003CY>\u001c7NC\u0007jg&s\u0017J\u001c;fe\u001a\f7-\u001a\u0006\b\u0005>|G.Z1o\u0015A9W\r^%t\u0013:Le\u000e^3sM\u0006\u001cWMC\u0004hKRt\u0015-\\3\u000b\u001b\u001d,GOU3ukJtG+\u001f9f\u0015Q9W\r\u001e+za\u0016\u0004\u0016M]1nKR,'\u000fT5ti*aq-\u001a8fe\u0006$XmQ8eK*9!-^5mI\u0016\u0014(bC\"pI\u0016\u0014U/\u001b7eKJTA!\u00168ji*)\u0002O]3tK:$\u0018\r^5p]6{G-\u001b4jKJ\u001c\b8\u0001\u0006\u0003!\u0005QA\u0001\u0003\u0001\u0011\u0005)!\u0001\"\u0001\t\u0004\u0015\u0011A!\u0001\u0005\u0003\u000b\t!\u0019\u0001#\u0002\u0006\u0007\u0011\u0011\u0001\u0002\u0001\u0007\u0001\u000b\r!!\u0001C\u0002\r\u0001\u0015\u0019AA\u0001E\u0005\u0019\u0001)1\u0001\u0002\u0002\t\f1\u0001Qa\u0001\u0003\u0003\u0011\u001ba\u0001!B\u0002\u0005\u0005!=A\u0002A\u0003\u0004\t\tA\t\u0002\u0004\u0001\u0006\u0007\u0011\u0011\u00012\u0003\u0007\u0001\u000b\r!!\u0001#\u0006\r\u0001\u0015\u0019AA\u0001\u0005\f\u0019\u0001)\u0011\u0001c\u0001\u0006\u0007\u0011=\u0001\u0002\u0004\u0007\u0001\u000b\t!!\u0001#\u0003\u0006\u0005\u0011\u0011\u00012B\u0003\u0003\t\tAi!\u0002\u0002\u0005\u0005!=QA\u0001\u0003\u0003\u0011#)!\u0001\u0002\u0002\t\u0014\u0015\u0011AA\u0001E\u000b\u000b\r!\u0019\u0001c\b\r\u0001\u0015\u0019Aq\u0002\u0005\u0011\u0019\u0001)!\u0001b\u0001\t \u0011\u0019ARA\r\u0004\u000b\u0005A1\u0001G\u0002.!\u0011\u0019G\u0001g\u0006\"\u0007\u0015\t\u0001\u0002\u0003\r\t+\u000eAQa\u0001C\f\u0013\u0005!\t!D\u0002\u0005\u001a%\tA\u0011A\u0017\u0011\t\r$\u0001\u0004B\u0011\u0004\u000b\u0005A9\u0001g\u0002V\u0007!)1\u0001\u0002\u0003\n\u0003!EQb\u0001\u0003\u000e\u0013\u0005A\t\"\f\t\u0005G\u0012Ar!I\u0002\u0006\u0003!)\u0001$B+\u0004\u0011\u0015\u0019AaB\u0005\u0002\u0011)i1\u0001b\u0007\n\u0003!QQ\u0006\u0005\u0003d\taA\u0011eA\u0003\u0002\u0011\u0017AZ!V\u0002\t\u000b\r!\u0001\"C\u0001\t\u00165\u0019AAD\u0005\u0002\u0011+iS\u0003B\u0006\u0019\u001eu=A\u0001\u0001\u0005\u0010\u001b\r)\u0011\u0001\u0003\u0007\u0019\u0019A\u001b\u0001!I\u0002\u0006\u0003!e\u0001\u0014D)\u0004\u000b\u0011u\u0011\"\u0001\u0003\u0001\u001b\u0005AQ\",\u0006\u0005\u0003a\u0005\u0012eA\u0003\u0002\u0011\u0013AJ!U\u0002\u0004\tCI\u0011\u0001c\u00056N\u0004)Q\u001d\u0001\u0003d\u0002a\u001dQt\u0002\u0003\u0001\u0011\u0011i1!B\u0001\t\ba\u001d\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001\"B\u0007\u0004\u000b\u0005AA\u0001\u0007\u0003Q\u0007\u0003iz\u0001\u0002\u0001\t\r5\u0019Q!\u0001E\u00051\u0013\u00016!AO\b\t\u0001Aq!D\u0002\u0006\u0003!)\u0001$\u0002)\u0004\u0004u=A\u0001\u0001\u0005\t\u001b\r)\u0011\u0001c\u0003\u0019\fA\u001b!!h\u0004\u0005\u0001!IQbA\u0003\u0002\u0011\u0019Ab\u0001UB\u0003;7!\u0001\u0001\u0003\u0006\u000e\u0013\u0015\t\u0001RB\u0005\u0005\u0013\r)\u0011\u0001C\u0004\u0019\u000f1\u0005\u0001T\u0002)\u0004\u0007u=A\u0001\u0001E\f\u001b\r)\u0011\u0001\u0003\u0005\u0019\u0011A\u001b9!I\u0002\u0006\u0003!\u0015\u0001TA)\u0004'\u0011\u001d\u0011\"\u0001\u0003\u0001\u001b\u0005A\t\"D\u0001\t\u00135\t\u00012C\u0007\u0002\u0011)i\u0011\u0001#\u0006\u000e\u0003!YQ\"\u0001E\f\u001b\u0005!\t\u0001"})
public final class Function
extends FunctionLike {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    private final Identifier name;
    @NotNull
    private final Type returnType;
    @NotNull
    private final TypeParameterList typeParameterList;
    private final boolean isInInterface;

    static {
        $kotlinClass = Reflection.createKotlinClass(Function.class);
    }

    private final Modifiers presentationModifiers() {
        Modifiers modifiers = this.getModifiers();
        if (this.isInInterface) {
            modifiers = modifiers.without(Modifier.ABSTRACT);
        }
        if (modifiers.contains(Modifier.OVERRIDE)) {
            modifiers = ModifierKt.filter(modifiers, (Function1<? super Modifier, ? extends Boolean>)((Function1)presentationModifiers.1.INSTANCE$));
        }
        return modifiers;
    }

    @Override
    public void generateCode(@NotNull CodeBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        UtilKt.appendWithSuffix(ModifierKt.appendWithSpaceAfter(builder.append(this.getAnnotations()), this.presentationModifiers()).append("fun "), this.typeParameterList, " ").append(this.name).append("(").append(this.getParameterList()).append(")");
        if (!TypesKt.isUnit(this.returnType)) {
            builder.append(":").append(this.returnType);
        }
        this.typeParameterList.appendWhere(builder);
        if (this.getBody() != null) {
            builder.append(" ").append(this.getBody());
        }
    }

    @NotNull
    public final Identifier getName() {
        return this.name;
    }

    @NotNull
    public final Type getReturnType() {
        return this.returnType;
    }

    @NotNull
    public final TypeParameterList getTypeParameterList() {
        return this.typeParameterList;
    }

    public final boolean getIsInInterface() {
        return this.isInInterface;
    }

    public Function(@NotNull Identifier name2, @NotNull Annotations annotations2, @NotNull Modifiers modifiers, @NotNull Type returnType2, @NotNull TypeParameterList typeParameterList, @NotNull ParameterList parameterList2, @Nullable DeferredElement<Block> body2, boolean isInInterface) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)annotations2, (String)"annotations");
        Intrinsics.checkParameterIsNotNull((Object)modifiers, (String)"modifiers");
        Intrinsics.checkParameterIsNotNull((Object)returnType2, (String)"returnType");
        Intrinsics.checkParameterIsNotNull((Object)typeParameterList, (String)"typeParameterList");
        Intrinsics.checkParameterIsNotNull((Object)parameterList2, (String)"parameterList");
        super(annotations2, modifiers, parameterList2, body2);
        this.name = name2;
        this.returnType = returnType2;
        this.typeParameterList = typeParameterList;
        this.isInInterface = isInInterface;
    }
}

