/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k.ast;

import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.j2k.CodeBuilder;
import org.jetbrains.kotlin.j2k.ast.ArrayAccessExpression;
import org.jetbrains.kotlin.j2k.ast.AssignmentExpression;
import org.jetbrains.kotlin.j2k.ast.BangBangExpression;
import org.jetbrains.kotlin.j2k.ast.BinaryExpression;
import org.jetbrains.kotlin.j2k.ast.DownToExpression;
import org.jetbrains.kotlin.j2k.ast.Element;
import org.jetbrains.kotlin.j2k.ast.Expression;
import org.jetbrains.kotlin.j2k.ast.IfStatement;
import org.jetbrains.kotlin.j2k.ast.IsOperator;
import org.jetbrains.kotlin.j2k.ast.MethodCallExpression;
import org.jetbrains.kotlin.j2k.ast.PostfixExpression;
import org.jetbrains.kotlin.j2k.ast.PrefixExpression;
import org.jetbrains.kotlin.j2k.ast.QualifiedExpression;
import org.jetbrains.kotlin.j2k.ast.RangeExpression;
import org.jetbrains.kotlin.j2k.ast.StarExpression;
import org.jetbrains.kotlin.j2k.ast.TypeCastExpression;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"\u001b\u0006)Y1i\u001c3f\u0005VLG\u000eZ3s\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'b\u000163W*i\u0011\r\u001d9f]\u0012|\u0005/\u001a:b]\u0012T!\"\u001a=qe\u0016\u001c8/[8o\u0015))\u0005\u0010\u001d:fgNLwN\u001c\u0006\u0004CN$(bB8qKJ\fg\u000e\u001a\u0006\u001da\u0006\u0014XM\u001c;iKNL7OR8s'\u0006lW\r\u0015:fG\u0016$WM\\2f\u0015\u001d\u0011un\u001c7fC:Ta!\u0016;jY.#(\u0002E1qa\u0016tGmV5uQB\u0013XMZ5y\u0015\u001d)G.Z7f]RTq!\u00127f[\u0016tGO\u0003\u0004qe\u00164\u0017\u000e\u001f\u0006\u0007'R\u0014\u0018N\\4\u000b\t)\fg/\u0019\u0006\u0005Y\u0006twM\u0003\tbaB,g\u000eZ,ji\"\u001cVO\u001a4jq*11/\u001e4gSbT!\u0002\u001d:fG\u0016$WM\\2f\u0015\rIe\u000e\u001e\u0006\b\u0013:$XmZ3s\u0015)9\u0018\u000e\u001e5Qe\u00164\u0017\u000e\u001f\u0006\u000bo&$\bnU;gM&D\bP\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\t!\u0011\u0001\u0003\u0002\u0006\u0007\u0011\r\u0001\u0002\u0001\u0007\u0001\u000b\t!\u0019\u0001\u0003\u0003\u0006\u0007\u0011\u0015\u0001r\u0001\u0007\u0001\u000b\u0005A\u0019!B\u0002\u0005\b!-A\u0002A\u0003\u0003\t\u0007A\u0001!\u0002\u0002\u0005\u0006!\u001dQa\u0001C\u0003\u0011\u001fa\u0001!B\u0002\u0005\b!EA\u0002A\u0003\u0003\t\u000bAy!B\u0001\t\u0013\u0015\u0011Aa\u0002E\n\u000b\t!y\u0001#\u0005\u0006\u0007\u0011\u001d\u0001r\u0003\u0007\u0001\u000b\t!y\u0001\u0003\u0007\u0006d\u0011\u0019QcA\u0003\u0002\u0011\tA\"\u0001'\u0002\u001e\u0010\u0011\u0001\u0001bA\u0007\u0004\u000b\u0005A1\u0001G\u0002Q\u0007\u0003iz\u0001\u0002\u0001\t\n5\u0019Q!\u0001\u0005\u00041\r\u00016!AO\b\t\u0005AQ!D\u0002\u0006\u0003!!\u0001\u0004\u0002)\u0004\u0004\u0005\u001aQ!\u0001\u0005\u00031\t\t6a\u0003C\u0003\u0013\u0005AI!D\u0001\t\n5\t\u0001\"B\u0007\u0002\u0011\u0015i\u0011\u0001\"\u0001Y\u0007\u0019)q\u0005B\u0002\u0016\u0007\u0015\t\u0001B\u0001\r\u00031\u001biz\u0001\u0002\u0001\t\u000f5\u0019Q!\u0001E\u00061\u0017\u00016\u0011AO\b\t\u0001A\u0001\"D\u0002\u0006\u0003!1\u0001D\u0002)\u0004\u0003\u0005\u001aQ!\u0001\u0005\u00031\t\t6!\u0003C\u0007\u0013\u0005AI!D\u0001\t\n5\t\u0001RB\u0007\u0002\u0011!A6AB\u0003(\t\r)2!B\u0001\t\u0005a\u0011\u0001DCO\b\t\u0001Aq!D\u0002\u0006\u0003!-\u00014\u0002)\u0004\u0002u=A\u0001\u0001E\u000b\u001b\r)\u0011\u0001\u0003\u0004\u0019\rA\u001b\u0011!I\u0002\u0006\u0003!\u0011\u0001DA)\u0004\u0013\u0011Q\u0011\"\u0001E\u0005\u001b\u0005AI!D\u0001\t\u000e5\t\u0001\u0002\u0003-\u0004\r\u0015\u0019B!A\u000b\u0004\u000b\u0005A1\u0001G\u0002\u0019\u0017\u0005\"Q!\u0001E\t\u0019\u0003A\n\"U\u0002\u0006\t-I\u0011\u0001C\u0005\u000e\u0003!)\u0001l\u0001\u0004\u0006:\u0011\u0019QcA\u0003\u0002\u0011\u0019Ab\u0001'\u0007\u001e\u0010\u0011\u0001\u0001\u0002C\u0007\u0004\u000b\u0005Aa\u0001\u0007\u0004Q\u0007\u0003\t3!B\u0001\t\ra1\u0011kA\u0004\u0005\u001a%\t\u0001\u0002C\u0007\u0002\u0011!i\u0011\u0001\u0003\u0005Y\u0007\u0019)I\u0004B\u0002\u0016\u0007\u0015\t\u0001B\u0002\r\u000715iz\u0001\u0002\u0001\t\u00165\u0019Q!\u0001\u0005\u00071\u0019\u00016\u0011A\u0011\u0004\u000b\u0005Aa\u0001\u0007\u0004R\u0007\u001d!Q\"C\u0001\t\u00115\t\u0001\u0002C\u0007\u0002\u0011!A6A\u0002"})
public final class UtilKt {
    @NotNull
    public static final String withSuffix(String $receiver, @NotNull String suffix) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)suffix, (String)"suffix");
        return KotlinPackage.isEmpty((String)$receiver) ? "" : $receiver + suffix;
    }

    @NotNull
    public static final String withPrefix(String $receiver, @NotNull String prefix) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        return KotlinPackage.isEmpty((String)$receiver) ? "" : prefix + $receiver;
    }

    @NotNull
    public static final CodeBuilder appendWithPrefix(CodeBuilder $receiver, @NotNull Element element2, @NotNull String prefix) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        return !element2.getIsEmpty() ? $receiver.append(prefix).append(element2) : $receiver;
    }

    @NotNull
    public static final CodeBuilder appendWithSuffix(CodeBuilder $receiver, @NotNull Element element2, @NotNull String suffix) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)suffix, (String)"suffix");
        return !element2.getIsEmpty() ? $receiver.append(element2).append(suffix) : $receiver;
    }

    @NotNull
    public static final CodeBuilder appendOperand(CodeBuilder $receiver, @NotNull Expression expression2, @NotNull Expression operand, boolean parenthesisForSamePrecedence) {
        boolean needParenthesis;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)operand, (String)"operand");
        Integer n = UtilKt.precedence(expression2);
        if (n == null) {
            throw (Throwable)new IllegalArgumentException("Unknown precendence for " + expression2);
        }
        int parentPrecedence = ((Number)n).intValue();
        Integer operandPrecedence = UtilKt.precedence(operand);
        boolean bl = needParenthesis = operandPrecedence != null && (Intrinsics.compare((int)parentPrecedence, (int)((Number)operandPrecedence).intValue()) < 0 || Intrinsics.areEqual((Object)parentPrecedence, (Object)operandPrecedence) && parenthesisForSamePrecedence);
        if (needParenthesis) {
            $receiver.append("(");
        }
        $receiver.append(operand);
        if (needParenthesis) {
            $receiver.append(")");
        }
        return $receiver;
    }

    @NotNull
    public static /* synthetic */ CodeBuilder appendOperand$default(CodeBuilder codeBuilder, Expression expression2, Expression expression3, boolean bl, int n) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return UtilKt.appendOperand(codeBuilder, expression2, expression3, bl);
    }

    @Nullable
    public static final Integer precedence(Expression $receiver) {
        Integer n;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Expression expression2 = $receiver;
        if (expression2 instanceof QualifiedExpression || expression2 instanceof MethodCallExpression || expression2 instanceof ArrayAccessExpression || expression2 instanceof PostfixExpression || expression2 instanceof BangBangExpression || expression2 instanceof StarExpression) {
            n = 0;
        } else if (expression2 instanceof PrefixExpression) {
            n = 1;
        } else if (expression2 instanceof TypeCastExpression) {
            n = 2;
        } else if (expression2 instanceof BinaryExpression) {
            int n2;
            switch (((BinaryExpression)$receiver).getOp()) {
                case "%": 
                case "*": 
                case "/": {
                    n2 = 3;
                    break;
                }
                case "+": 
                case "-": {
                    n2 = 4;
                    break;
                }
                case "?:": {
                    n2 = 7;
                    break;
                }
                case ">=": 
                case "<=": 
                case ">": 
                case "<": {
                    n2 = 9;
                    break;
                }
                case "===": 
                case "==": 
                case "!=": 
                case "!===": {
                    n2 = 10;
                    break;
                }
                case "&&": {
                    n2 = 11;
                    break;
                }
                case "||": {
                    n2 = 12;
                    break;
                }
                default: {
                    n2 = 6;
                }
            }
            n = n2;
        } else {
            n = expression2 instanceof RangeExpression || expression2 instanceof DownToExpression ? Integer.valueOf(5) : (expression2 instanceof IsOperator ? Integer.valueOf(8) : (expression2 instanceof IfStatement ? Integer.valueOf(13) : (expression2 instanceof AssignmentExpression ? Integer.valueOf(14) : (Integer)null)));
        }
        return n;
    }
}

