/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.js.PredefinedAnnotation;
import org.jetbrains.kotlin.js.resolve.AbstractNativeIndexerChecker;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"x\u0004)\u0019b*\u0019;jm\u0016\u001cV\r\u001e;fe\u000eCWmY6fe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgN\u0003\u0002kg*9!/Z:pYZ,'\u0002H!cgR\u0014\u0018m\u0019;OCRLg/Z%oI\u0016DXM]\"iK\u000e\\WM\u001d\u0006\u0007y%t\u0017\u000e\u001e \u000b\u001f\u0005$G-\u001b;j_:\fGn\u00115fG.T1\u0002Z3dY\u0006\u0014\u0018\r^5p]*\u0001\"*\u001a;OC6,GMR;oGRLwN\u001c\u0006\u0004aNL'B\u00033fg\u000e\u0014\u0018\u000e\u001d;pe*\u0011b)\u001e8di&|g\u000eR3tGJL\u0007\u000f^8s\u0015-!Wm]2sSB$xN]:\u000b!\u0011L\u0017m\u001a8pgRL7\rS8mI\u0016\u0014(B\u0004#jC\u001etwn\u001d;jGNKgn\u001b\u0006\fI&\fwM\\8ti&\u001c7O\u0003\u0003V]&$HO\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\t!\u0011\u0001\u0003\u0002\u0006\u0005\u0011\r\u0001RA\u0003\u0004\t\tA\u0001\u0001\u0004\u0001\u0006\u0007\u0011\u0011\u0001b\u0001\u0007\u0001\u000b\t!\u0011\u0001c\u0003\u0006\u0007\u0011\u001d\u0001\"\u0002\u0007\u0001\u000b\t!\u0011\u0001C\u0004\u0006\u0007\u0011%\u0001R\u0002\u0007\u0001\u000b\t!\u0011\u0001#\u0005\u0006\u0007\u0011-\u0001\u0002\u0003\u0007\u0001\u000b\u0005A\u0019!B\u0002\u0005\u000e!IA\u0002A\u0003\u0003\t\u000fAQ!\u0002\u0002\u0005\n!5QA\u0001C\u0006\u0011!!1\u0001$\u0002\u001a\u0007\u0015\t\u0001b\u0001\r\u0004[)\"1\u0002\u0007\u0003\u001e\u0010\u0011\u0001\u0001\u0012B\u0007\u0004\u000b\u0005AA\u0001\u0007\u0003Q\u0007\u0001iz\u0001\u0002\u0001\t\r5\u0019Q!\u0001\u0005\u00061\u0015\u00016\u0011AO\b\t\u0001Ay!D\u0002\u0006\u0003!1\u0001D\u0002)\u0004\u0003\u0005\u001aQ!\u0001\u0005\b1\u001d\t6!\u0003\u0003\u0005\u0013\u0005!\u0001!D\u0001\t\u00105\t\u0001\u0002C\u0007\u0002\u0011#)D\"B\u0006\u0005G\u0004A:!I\u0002\u0006\u0003!\u0015\u0001TA)\u0004\u0007\u0011\u001d\u0011\"\u0001\u0003\u0001"})
public final class NativeSetterChecker
extends AbstractNativeIndexerChecker {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(NativeSetterChecker.class);
    }

    @Override
    public void additionalCheck(@NotNull JetNamedFunction declaration, @NotNull FunctionDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)diagnosticHolder, (String)"diagnosticHolder");
        super.additionalCheck(declaration, descriptor2, diagnosticHolder);
        JetType returnType2 = descriptor2.getReturnType();
        if (returnType2 == null || KotlinBuiltIns.isUnit(returnType2)) {
            return;
        }
        List<ValueParameterDescriptor> parameters2 = descriptor2.getValueParameters();
        if (parameters2.size() < 2) {
            return;
        }
        JetType secondParameterType = parameters2.get(1).getType();
        if (TypeUtilsKt.isSubtypeOf(secondParameterType, returnType2)) {
            return;
        }
        diagnosticHolder.report(ErrorsJs.NATIVE_SETTER_WRONG_RETURN_TYPE.on((JetDeclaration)((PsiElement)declaration)));
    }

    public NativeSetterChecker() {
        super(PredefinedAnnotation.NATIVE_SETTER, "setter", 2);
    }
}

