/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.components;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.java.components.ExternalAnnotationResolver;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotation;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotationOwner;
import org.jetbrains.kotlin.load.java.structure.impl.JavaAnnotationImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaElementCollectionFromPsiArrayUtil;
import org.jetbrains.kotlin.load.java.structure.impl.JavaModifierListOwnerImpl;
import org.jetbrains.kotlin.name.FqName;

public class PsiBasedExternalAnnotationResolver
implements ExternalAnnotationResolver {
    @Override
    @Nullable
    public JavaAnnotation findExternalAnnotation(@NotNull JavaAnnotationOwner owner, @NotNull FqName fqName2) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/load/java/components/PsiBasedExternalAnnotationResolver", "findExternalAnnotation"));
        }
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/load/java/components/PsiBasedExternalAnnotationResolver", "findExternalAnnotation"));
        }
        if (owner instanceof JavaModifierListOwnerImpl) {
            JavaModifierListOwnerImpl modifierListOwner = (JavaModifierListOwnerImpl)((Object)owner);
            PsiAnnotation psiAnnotation = PsiBasedExternalAnnotationResolver.findExternalAnnotation(modifierListOwner.getPsi(), fqName2);
            return psiAnnotation == null ? null : new JavaAnnotationImpl(psiAnnotation);
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<JavaAnnotation> findExternalAnnotations(@NotNull JavaAnnotationOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/load/java/components/PsiBasedExternalAnnotationResolver", "findExternalAnnotations"));
        }
        if (owner instanceof JavaModifierListOwnerImpl) {
            PsiModifierListOwner psiOwner = ((JavaModifierListOwnerImpl)((Object)owner)).getPsi();
            PsiAnnotation[] annotations2 = ExternalAnnotationsManager.getInstance((Project)psiOwner.getProject()).findExternalAnnotations(psiOwner);
            Collection<Object> collection = annotations2 == null ? Collections.emptyList() : JavaElementCollectionFromPsiArrayUtil.annotations(annotations2);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/components/PsiBasedExternalAnnotationResolver", "findExternalAnnotations"));
            }
            return collection;
        }
        List<JavaAnnotation> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/components/PsiBasedExternalAnnotationResolver", "findExternalAnnotations"));
        }
        return list;
    }

    @Nullable
    public static PsiAnnotation findExternalAnnotation(@NotNull PsiModifierListOwner owner, @NotNull FqName fqName2) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/load/java/components/PsiBasedExternalAnnotationResolver", "findExternalAnnotation"));
        }
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/load/java/components/PsiBasedExternalAnnotationResolver", "findExternalAnnotation"));
        }
        return ExternalAnnotationsManager.getInstance((Project)owner.getProject()).findExternalAnnotation(owner, fqName2.asString());
    }
}

