/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.sam;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.load.java.components.DescriptorResolverUtils;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaConstructorDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaMethodDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.SamAdapterDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.SamConstructorDescriptor;
import org.jetbrains.kotlin.load.java.lazy.types.LazyJavaTypeResolver;
import org.jetbrains.kotlin.load.java.sam.SamAdapterConstructorDescriptor;
import org.jetbrains.kotlin.load.java.sam.SamAdapterFunctionDescriptor;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaClassifier;
import org.jetbrains.kotlin.load.java.structure.JavaClassifierType;
import org.jetbrains.kotlin.load.java.structure.JavaMethod;
import org.jetbrains.kotlin.load.java.structure.JavaType;
import org.jetbrains.kotlin.load.java.structure.JavaTypeSubstitutor;
import org.jetbrains.kotlin.load.java.structure.JavaValueParameter;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilPackage;
import org.jetbrains.kotlin.resolve.jvm.JavaResolverUtils;
import org.jetbrains.kotlin.resolve.jvm.JvmPackage;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.JetTypeImpl;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.TypesPackage;
import org.jetbrains.kotlin.types.Variance;

public class SingleAbstractMethodUtils {
    private SingleAbstractMethodUtils() {
    }

    @NotNull
    public static List<CallableMemberDescriptor> getAbstractMembers(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "getAbstractMembers"));
        }
        ArrayList<CallableMemberDescriptor> abstractMembers = new ArrayList<CallableMemberDescriptor>();
        for (DeclarationDescriptor member : type2.getMemberScope().getAllDescriptors()) {
            if (!(member instanceof CallableMemberDescriptor) || ((CallableMemberDescriptor)member).getModality() != Modality.ABSTRACT) continue;
            abstractMembers.add((CallableMemberDescriptor)member);
        }
        ArrayList<CallableMemberDescriptor> arrayList = abstractMembers;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "getAbstractMembers"));
        }
        return arrayList;
    }

    private static JetType fixProjections(@NotNull JetType functionType) {
        if (functionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionType", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "fixProjections"));
        }
        List<TypeParameterDescriptor> typeParameters = functionType.getConstructor().getParameters();
        ArrayList<TypeProjection> arguments2 = new ArrayList<TypeProjection>(typeParameters.size());
        for (TypeParameterDescriptor typeParameter : typeParameters) {
            Variance variance = typeParameter.getVariance();
            TypeProjection argument = functionType.getArguments().get(typeParameter.getIndex());
            Variance kind2 = argument.getProjectionKind();
            if (kind2 != Variance.INVARIANT && variance != Variance.INVARIANT) {
                if (kind2 == variance) {
                    arguments2.add(new TypeProjectionImpl(argument.getType()));
                    continue;
                }
                return null;
            }
            arguments2.add(argument);
        }
        ClassifierDescriptor classifier2 = functionType.getConstructor().getDeclarationDescriptor();
        assert (classifier2 instanceof ClassDescriptor) : "Not class: " + classifier2;
        return JetTypeImpl.create(functionType.getAnnotations(), functionType.getConstructor(), functionType.isMarkedNullable(), arguments2, ((ClassDescriptor)classifier2).getMemberScope(arguments2));
    }

    @Nullable
    public static JetType getFunctionTypeForSamType(@NotNull JetType samType) {
        JetType functionTypeDefault;
        if (samType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "samType", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "getFunctionTypeForSamType"));
        }
        ClassifierDescriptor classifier2 = samType.getConstructor().getDeclarationDescriptor();
        if (classifier2 instanceof JavaClassDescriptor && (functionTypeDefault = ((JavaClassDescriptor)classifier2).getFunctionTypeForSamInterface()) != null) {
            JetType substitute = TypeSubstitutor.create(samType).substitute(functionTypeDefault, Variance.INVARIANT);
            if (substitute == null) {
                return null;
            }
            JetType type2 = SingleAbstractMethodUtils.fixProjections(substitute);
            if (type2 == null) {
                return null;
            }
            if (JvmPackage.getPLATFORM_TYPES() && TypesPackage.isNullabilityFlexible(samType)) {
                return LazyJavaTypeResolver.FlexibleJavaClassifierTypeCapabilities.create(type2, TypeUtils.makeNullable(type2));
            }
            return TypeUtils.makeNullableAsSpecified(type2, samType.isMarkedNullable());
        }
        return null;
    }

    @NotNull
    public static JetType getFunctionTypeForAbstractMethod(@NotNull FunctionDescriptor function2) {
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "getFunctionTypeForAbstractMethod"));
        }
        JetType returnType2 = function2.getReturnType();
        assert (returnType2 != null) : "function is not initialized: " + function2;
        List<ValueParameterDescriptor> valueParameters = function2.getValueParameters();
        ArrayList<JetType> parameterTypes = new ArrayList<JetType>(valueParameters.size());
        for (ValueParameterDescriptor parameter : valueParameters) {
            parameterTypes.add(parameter.getType());
        }
        JetType jetType = DescriptorUtilPackage.getBuiltIns(function2).getFunctionType(Annotations.EMPTY, null, parameterTypes, returnType2);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "getFunctionTypeForAbstractMethod"));
        }
        return jetType;
    }

    private static boolean isSamInterface(@NotNull ClassDescriptor klass) {
        CallableMemberDescriptor member;
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "isSamInterface"));
        }
        if (klass.getKind() != ClassKind.INTERFACE) {
            return false;
        }
        List<CallableMemberDescriptor> abstractMembers = SingleAbstractMethodUtils.getAbstractMembers(klass.getDefaultType());
        if (abstractMembers.size() == 1 && (member = abstractMembers.get(0)) instanceof SimpleFunctionDescriptor) {
            return member.getTypeParameters().isEmpty();
        }
        return false;
    }

    @NotNull
    public static SamConstructorDescriptor createSamConstructorFunction(@NotNull DeclarationDescriptor owner, @NotNull JavaClassDescriptor samInterface) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "createSamConstructorFunction"));
        }
        if (samInterface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "samInterface", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "createSamConstructorFunction"));
        }
        assert (SingleAbstractMethodUtils.isSamInterface(samInterface)) : samInterface;
        SamConstructorDescriptor result2 = new SamConstructorDescriptor(owner, samInterface);
        TypeParameters typeParameters = SingleAbstractMethodUtils.recreateAndInitializeTypeParameters(samInterface.getTypeConstructor().getParameters(), result2);
        JetType parameterTypeUnsubstituted = SingleAbstractMethodUtils.getFunctionTypeForSamType(samInterface.getDefaultType());
        assert (parameterTypeUnsubstituted != null) : "couldn't get function type for SAM type " + samInterface.getDefaultType();
        JetType parameterType = typeParameters.substitutor.substitute(parameterTypeUnsubstituted, Variance.IN_VARIANCE);
        assert (parameterType != null) : "couldn't substitute type: " + parameterTypeUnsubstituted + ", substitutor = " + typeParameters.substitutor;
        ValueParameterDescriptorImpl parameter = new ValueParameterDescriptorImpl(result2, null, 0, Annotations.EMPTY, Name.identifier("function"), parameterType, false, null, SourceElement.NO_SOURCE);
        JetType returnType2 = typeParameters.substitutor.substitute(samInterface.getDefaultType(), Variance.OUT_VARIANCE);
        assert (returnType2 != null) : "couldn't substitute type: " + samInterface.getDefaultType() + ", substitutor = " + typeParameters.substitutor;
        result2.initialize((JetType)null, (ReceiverParameterDescriptor)null, typeParameters.descriptors, (List)Arrays.asList(parameter), returnType2, Modality.FINAL, samInterface.getVisibility());
        SamConstructorDescriptor samConstructorDescriptor = result2;
        if (samConstructorDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "createSamConstructorFunction"));
        }
        return samConstructorDescriptor;
    }

    public static boolean isSamType(@NotNull JetType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "isSamType"));
        }
        return SingleAbstractMethodUtils.getFunctionTypeForSamType(type2) != null;
    }

    public static boolean isSamAdapterNecessary(@NotNull FunctionDescriptor fun2) {
        if (fun2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "isSamAdapterNecessary"));
        }
        for (ValueParameterDescriptor param : fun2.getValueParameters()) {
            if (!SingleAbstractMethodUtils.isSamType(param.getType())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static SamAdapterDescriptor<JavaMethodDescriptor> createSamAdapterFunction(final @NotNull JavaMethodDescriptor original) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "createSamAdapterFunction"));
        }
        final SamAdapterFunctionDescriptor result2 = new SamAdapterFunctionDescriptor(original);
        SamAdapterDescriptor<JavaMethodDescriptor> samAdapterDescriptor = SingleAbstractMethodUtils.initSamAdapter(original, result2, new FunctionInitializer(){

            @Override
            public void initialize(@NotNull List<TypeParameterDescriptor> typeParameters, @NotNull List<ValueParameterDescriptor> valueParameters, @NotNull JetType returnType2) {
                if (typeParameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils$1", "initialize"));
                }
                if (valueParameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameters", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils$1", "initialize"));
                }
                if (returnType2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils$1", "initialize"));
                }
                result2.initialize((JetType)null, original.getDispatchReceiverParameter(), typeParameters, (List)valueParameters, returnType2, Modality.FINAL, original.getVisibility());
            }
        });
        if (samAdapterDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "createSamAdapterFunction"));
        }
        return samAdapterDescriptor;
    }

    @NotNull
    public static SamAdapterDescriptor<JavaConstructorDescriptor> createSamAdapterConstructor(final @NotNull JavaConstructorDescriptor original) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "createSamAdapterConstructor"));
        }
        final SamAdapterConstructorDescriptor result2 = new SamAdapterConstructorDescriptor(original);
        SamAdapterDescriptor<JavaConstructorDescriptor> samAdapterDescriptor = SingleAbstractMethodUtils.initSamAdapter(original, result2, new FunctionInitializer(){

            @Override
            public void initialize(@NotNull List<TypeParameterDescriptor> typeParameters, @NotNull List<ValueParameterDescriptor> valueParameters, @NotNull JetType returnType2) {
                if (typeParameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils$2", "initialize"));
                }
                if (valueParameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameters", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils$2", "initialize"));
                }
                if (returnType2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils$2", "initialize"));
                }
                result2.initialize(typeParameters, valueParameters, original.getVisibility());
                result2.setReturnType(returnType2);
            }
        });
        if (samAdapterDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "createSamAdapterConstructor"));
        }
        return samAdapterDescriptor;
    }

    @NotNull
    private static <F extends FunctionDescriptor> SamAdapterDescriptor<F> initSamAdapter(@NotNull F original, @NotNull SamAdapterDescriptor<F> adapter, @NotNull FunctionInitializer initializer) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "initSamAdapter"));
        }
        if (adapter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "adapter", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "initSamAdapter"));
        }
        if (initializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "initSamAdapter"));
        }
        TypeParameters typeParameters = SingleAbstractMethodUtils.recreateAndInitializeTypeParameters(original.getTypeParameters(), adapter);
        JetType returnTypeUnsubstituted = original.getReturnType();
        assert (returnTypeUnsubstituted != null) : "Creating SAM adapter for not initialized original: " + original;
        TypeSubstitutor substitutor3 = typeParameters.substitutor;
        JetType returnType2 = substitutor3.substitute(returnTypeUnsubstituted, Variance.INVARIANT);
        assert (returnType2 != null) : "couldn't substitute type: " + returnTypeUnsubstituted + ", substitutor = " + substitutor3;
        List<ValueParameterDescriptor> valueParameters = SingleAbstractMethodUtils.createValueParametersForSamAdapter(original, adapter, substitutor3);
        initializer.initialize(typeParameters.descriptors, valueParameters, returnType2);
        SamAdapterDescriptor<F> samAdapterDescriptor = adapter;
        if (samAdapterDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "initSamAdapter"));
        }
        return samAdapterDescriptor;
    }

    public static List<ValueParameterDescriptor> createValueParametersForSamAdapter(@NotNull FunctionDescriptor original, @NotNull FunctionDescriptor samAdapter, @NotNull TypeSubstitutor substitutor3) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "createValueParametersForSamAdapter"));
        }
        if (samAdapter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "samAdapter", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "createValueParametersForSamAdapter"));
        }
        if (substitutor3 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "createValueParametersForSamAdapter"));
        }
        List<ValueParameterDescriptor> originalValueParameters = original.getValueParameters();
        ArrayList<ValueParameterDescriptor> valueParameters = new ArrayList<ValueParameterDescriptor>(originalValueParameters.size());
        for (ValueParameterDescriptor originalParam : originalValueParameters) {
            JetType originalType = originalParam.getType();
            JetType functionType = SingleAbstractMethodUtils.getFunctionTypeForSamType(originalType);
            JetType newTypeUnsubstituted = functionType != null ? functionType : originalType;
            JetType newType = substitutor3.substitute(newTypeUnsubstituted, Variance.IN_VARIANCE);
            assert (newType != null) : "couldn't substitute type: " + newTypeUnsubstituted + ", substitutor = " + substitutor3;
            ValueParameterDescriptorImpl newParam = new ValueParameterDescriptorImpl(samAdapter, null, originalParam.getIndex(), originalParam.getAnnotations(), originalParam.getName(), newType, false, null, SourceElement.NO_SOURCE);
            valueParameters.add(newParam);
        }
        return valueParameters;
    }

    @NotNull
    private static TypeParameters recreateAndInitializeTypeParameters(@NotNull List<TypeParameterDescriptor> originalParameters, @Nullable DeclarationDescriptor newOwner) {
        if (originalParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalParameters", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "recreateAndInitializeTypeParameters"));
        }
        Map<TypeParameterDescriptor, TypeParameterDescriptorImpl> traitToFunTypeParameters = JavaResolverUtils.recreateTypeParametersAndReturnMapping(originalParameters, newOwner);
        TypeSubstitutor typeParametersSubstitutor = JavaResolverUtils.createSubstitutorForTypeParameters(traitToFunTypeParameters);
        for (Map.Entry<TypeParameterDescriptor, TypeParameterDescriptorImpl> mapEntry : traitToFunTypeParameters.entrySet()) {
            TypeParameterDescriptor traitTypeParameter = mapEntry.getKey();
            TypeParameterDescriptorImpl funTypeParameter = mapEntry.getValue();
            for (JetType upperBound : traitTypeParameter.getUpperBounds()) {
                JetType upperBoundSubstituted = typeParametersSubstitutor.substitute(upperBound, Variance.INVARIANT);
                assert (upperBoundSubstituted != null) : "couldn't substitute type: " + upperBound + ", substitutor = " + typeParametersSubstitutor;
                funTypeParameter.addUpperBound(upperBoundSubstituted);
            }
            funTypeParameter.setInitialized();
        }
        ArrayList<TypeParameterDescriptorImpl> typeParameters = new ArrayList<TypeParameterDescriptorImpl>(traitToFunTypeParameters.values());
        TypeParameters typeParameters2 = new TypeParameters(typeParameters, typeParametersSubstitutor);
        if (typeParameters2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "recreateAndInitializeTypeParameters"));
        }
        return typeParameters2;
    }

    @Nullable
    public static JavaMethod getSamInterfaceMethod(@NotNull JavaClass javaClass) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "getSamInterfaceMethod"));
        }
        FqName fqName2 = javaClass.getFqName();
        if (fqName2 == null || fqName2.firstSegmentIs(KotlinBuiltIns.BUILT_INS_PACKAGE_NAME)) {
            return null;
        }
        if (!javaClass.isInterface() || javaClass.isAnnotationType()) {
            return null;
        }
        return SingleAbstractMethodUtils.findOnlyAbstractMethod(javaClass);
    }

    @Nullable
    private static JavaMethod findOnlyAbstractMethod(@NotNull JavaClass javaClass) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils", "findOnlyAbstractMethod"));
        }
        OnlyAbstractMethodFinder finder = new OnlyAbstractMethodFinder();
        if (finder.find(javaClass.getDefaultType())) {
            return finder.getFoundMethod();
        }
        return null;
    }

    private static class OnlyAbstractMethodFinder {
        private static final FqName OBJECT_FQ_NAME = new FqName("java.lang.Object");
        private JavaMethod foundMethod;
        private JavaTypeSubstitutor foundClassSubstitutor;

        private OnlyAbstractMethodFinder() {
        }

        private boolean find(@NotNull JavaClassifierType classifierType) {
            if (classifierType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classifierType", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils$OnlyAbstractMethodFinder", "find"));
            }
            JavaTypeSubstitutor classSubstitutor = classifierType.getSubstitutor();
            JavaClassifier classifier2 = classifierType.getClassifier();
            if (classifier2 == null) {
                return false;
            }
            assert (classifier2 instanceof JavaClass) : "Classifier should be a class here: " + classifier2;
            JavaClass javaClass = (JavaClass)classifier2;
            if (OBJECT_FQ_NAME.equals(javaClass.getFqName())) {
                return true;
            }
            for (JavaMethod method : javaClass.getMethods()) {
                if (!method.isAbstract() || DescriptorResolverUtils.isObjectMethod(method)) continue;
                if (!method.getTypeParameters().isEmpty()) {
                    return false;
                }
                if (this.foundMethod == null) {
                    this.foundMethod = method;
                    this.foundClassSubstitutor = classSubstitutor;
                    continue;
                }
                if (OnlyAbstractMethodFinder.areSignaturesErasureEqual(method, classSubstitutor, this.foundMethod, this.foundClassSubstitutor)) continue;
                return false;
            }
            for (JavaClassifierType t : classifierType.getSupertypes()) {
                if (this.find(t)) continue;
                return false;
            }
            return true;
        }

        private static boolean areSignaturesErasureEqual(@NotNull JavaMethod method1, @NotNull JavaTypeSubstitutor substitutor1, @NotNull JavaMethod method2, @NotNull JavaTypeSubstitutor substitutor22) {
            if (method1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method1", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils$OnlyAbstractMethodFinder", "areSignaturesErasureEqual"));
            }
            if (substitutor1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor1", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils$OnlyAbstractMethodFinder", "areSignaturesErasureEqual"));
            }
            if (method2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method2", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils$OnlyAbstractMethodFinder", "areSignaturesErasureEqual"));
            }
            if (substitutor22 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor2", "org/jetbrains/kotlin/load/java/sam/SingleAbstractMethodUtils$OnlyAbstractMethodFinder", "areSignaturesErasureEqual"));
            }
            if (!method1.getName().equals(method2.getName())) {
                return false;
            }
            List<JavaValueParameter> parameters1 = method1.getValueParameters();
            List<JavaValueParameter> parameters2 = method2.getValueParameters();
            if (parameters1.size() != parameters2.size()) {
                return false;
            }
            Iterator it1 = parameters1.iterator();
            Iterator it2 = parameters2.iterator();
            while (it1.hasNext()) {
                JavaValueParameter param1 = (JavaValueParameter)it1.next();
                JavaValueParameter param2 = (JavaValueParameter)it2.next();
                if (param1.isVararg() != param2.isVararg()) {
                    return false;
                }
                JavaType type1 = JavaResolverUtils.erasure(substitutor1.substitute(param1.getType()), substitutor1);
                JavaType type2 = JavaResolverUtils.erasure(substitutor22.substitute(param2.getType()), substitutor22);
                if (type1 != null ? type1.equals(type2) : type2 == null) continue;
                return false;
            }
            return true;
        }

        @Nullable
        private JavaMethod getFoundMethod() {
            return this.foundMethod;
        }
    }

    private static abstract class FunctionInitializer {
        private FunctionInitializer() {
        }

        public abstract void initialize(@NotNull List<TypeParameterDescriptor> var1, @NotNull List<ValueParameterDescriptor> var2, @NotNull JetType var3);
    }

    private static class TypeParameters {
        public final List<TypeParameterDescriptor> descriptors;
        public final TypeSubstitutor substitutor;

        private TypeParameters(List<TypeParameterDescriptor> descriptors, TypeSubstitutor substitutor3) {
            this.descriptors = descriptors;
            this.substitutor = substitutor3;
        }
    }
}

