/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin.nativeDeclarations;

import com.intellij.psi.PsiElement;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.load.kotlin.nativeDeclarations.NativeKt;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetDeclarationWithBody;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DeclarationChecker;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"\u0018\u0006)\u0001b*\u0019;jm\u00164UO\\\"iK\u000e\\WM\u001d\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0019Yw\u000e\u001e7j]*!An\\1e\u0015Iq\u0017\r^5wK\u0012+7\r\\1sCRLwN\\:\u000b%\u0011+7\r\\1sCRLwN\\\"iK\u000e\\WM\u001d\u0006\be\u0016\u001cx\u000e\u001c<f\u0015\u0019a\u0014N\\5u}))1\r[3dW*YA-Z2mCJ\fG/[8o\u00159QU\r\u001e#fG2\f'/\u0019;j_:T1\u0001]:j\u0015)!Wm]2sSB$xN\u001d\u0006\u0016\t\u0016\u001cG.\u0019:bi&|g\u000eR3tGJL\u0007\u000f^8s\u0015-!Wm]2sSB$xN]:\u000b!\u0011L\u0017m\u001a8pgRL7\rS8mI\u0016\u0014(B\u0004#jC\u001etwn\u001d;jGNKgn\u001b\u0006\fI&\fwM\\8ti&\u001c7O\u0003\bcS:$\u0017N\\4D_:$X\r\u001f;\u000b\u001d\tKg\u000eZ5oO\u000e{g\u000e^3yi*!QK\\5u\u001d\u0007Q!\u0001E\u0001\u000b\t!\u0001\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0003\t\u0005A!!\u0002\u0002\u0005\u0004!\rQA\u0001\u0003\u0003\u0011\u000b)1\u0001\"\u0002\t\u00011\u0001QA\u0001\u0003\u0002\u0011\u000f)1\u0001b\u0002\t\u00071\u0001QA\u0001\u0003\u0002\u0011\u0019)1\u0001\"\u0003\t\f1\u0001QA\u0001\u0003\u0002\u0011\u001f)1\u0001b\u0003\t\u000f1\u0001QA\u0001\u0003\u0002\u0011%)1\u0001\"\u0004\t\u00121\u0001Qa\u0001C\u0004\u0011)a\u0001!B\u0001\t\u0004\u0015\u0019A\u0001\u0003E\u000b\u0019\u0001)!\u0001\"\u0003\t\f\u0015\u0011A1\u0002\u0005\b\u000b\t!i\u0001#\u0005\u0006\u0005\u0011\u001d\u0001B\u0003\u0003\u0004\u0019\rI2!B\u0001\t\ta!Q\u0016\u000e\u0003\f1\u0013iz\u0001\u0002\u0001\t\u000b5\u0019Q!\u0001\u0005\u00061\u0015\u00016\u0001AO\b\t\u0001Ai!D\u0002\u0006\u0003!1\u0001D\u0002)\u0004\u0002u=A\u0001\u0001\u0005\t\u001b\r)\u0011\u0001C\u0004\u0019\u000fA\u001b\u0011!h\u0004\u0005\u0001!MQbA\u0003\u0002\u0011\u001fAz\u0001UB\u0002C\r)\u0011\u0001#\u0005\u0019\u0012E\u001b1\u0002\"\u0003\n\u0003\u0011\u0001Q\"\u0001\u0005\n\u001b\u0005A\u0019\"D\u0001\t\u00155\t\u0001RC\u001b\r\u000b-!1\u001d\u0001\r\u0005C\r)\u0011\u0001C\u0002\u0019\u0007E\u001b1\u0001\u0002\u0003\n\u0003\u0011\u0001\u0001"})
public final class NativeFunChecker
implements DeclarationChecker {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(NativeFunChecker.class);
    }

    @Override
    public void check(@NotNull JetDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)diagnosticHolder, (String)"diagnosticHolder");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        if (!NativeKt.hasNativeAnnotation(descriptor2)) {
            return;
        }
        if (DescriptorUtils.isTrait(descriptor2.getContainingDeclaration())) {
            diagnosticHolder.report(ErrorsJvm.EXTERNAL_DECLARATION_IN_TRAIT.on((JetDeclaration)((PsiElement)declaration)));
        } else if (descriptor2 instanceof CallableMemberDescriptor && Intrinsics.areEqual((Object)((Object)((CallableMemberDescriptor)descriptor2).getModality()), (Object)((Object)Modality.ABSTRACT))) {
            diagnosticHolder.report(ErrorsJvm.EXTERNAL_DECLARATION_CANNOT_BE_ABSTRACT.on((JetDeclaration)((PsiElement)declaration)));
        }
        if (!(descriptor2 instanceof ConstructorDescriptor) && declaration instanceof JetDeclarationWithBody && ((JetDeclarationWithBody)declaration).hasBody()) {
            diagnosticHolder.report(ErrorsJvm.EXTERNAL_DECLARATION_CANNOT_HAVE_BODY.on((JetDeclaration)((PsiElement)declaration)));
        }
        if (AnnotationUtilKt.hasInlineAnnotation(descriptor2)) {
            diagnosticHolder.report(ErrorsJvm.EXTERNAL_DECLARATION_CANNOT_BE_INLINED.on((JetDeclaration)((PsiElement)declaration)));
        }
    }
}

