/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.Stack;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.JetKeywordToken;
import org.jetbrains.kotlin.lexer.JetToken;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.parsing.AbstractTokenStreamPredicate;
import org.jetbrains.kotlin.parsing.JetParsing;
import org.jetbrains.kotlin.parsing.LastBefore;
import org.jetbrains.kotlin.parsing.PrecedingCommentsBinder;
import org.jetbrains.kotlin.parsing.PrecedingDocCommentsBinder;
import org.jetbrains.kotlin.parsing.SemanticWhitespaceAwarePsiBuilder;
import org.jetbrains.kotlin.parsing.TokenStreamPattern;
import org.jetbrains.kotlin.parsing.TrailingCommentsBinder;
import org.jetbrains.kotlin.parsing.TruncatedSemanticWhitespaceAwarePsiBuilder;
import org.jetbrains.kotlin.utils.strings.StringsPackage;

abstract class AbstractJetParsing {
    private static final Map<String, JetKeywordToken> SOFT_KEYWORD_TEXTS = new HashMap<String, JetKeywordToken>();
    protected final SemanticWhitespaceAwarePsiBuilder myBuilder;

    public AbstractJetParsing(SemanticWhitespaceAwarePsiBuilder builder) {
        this.myBuilder = builder;
    }

    protected IElementType getLastToken() {
        int i;
        int currentOffset = this.myBuilder.getCurrentOffset();
        for (i = 1; i <= currentOffset && JetTokens.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(this.myBuilder.rawLookup(-i)); ++i) {
        }
        return this.myBuilder.rawLookup(-i);
    }

    protected boolean expect(JetToken expectation, String message) {
        return this.expect(expectation, message, null);
    }

    protected PsiBuilder.Marker mark() {
        return this.myBuilder.mark();
    }

    protected void error(String message) {
        this.myBuilder.error(message);
    }

    protected boolean expect(JetToken expectation, String message, TokenSet recoverySet) {
        if (this.at(expectation)) {
            this.advance();
            return true;
        }
        this.errorWithRecovery(message, recoverySet);
        return false;
    }

    protected boolean expectNoAdvance(JetToken expectation, String message) {
        if (this.at(expectation)) {
            this.advance();
            return true;
        }
        this.error(message);
        return false;
    }

    protected void errorWithRecovery(String message, TokenSet recoverySet) {
        IElementType tt = this.tt();
        if (recoverySet == null || recoverySet.contains(tt) || tt == JetTokens.LBRACE || tt == JetTokens.RBRACE || recoverySet.contains((IElementType)JetTokens.EOL_OR_SEMICOLON) && (this.eof() || tt == JetTokens.SEMICOLON || this.myBuilder.newlineBeforeCurrentToken())) {
            this.error(message);
        } else {
            this.errorAndAdvance(message);
        }
    }

    protected boolean errorAndAdvance(String message) {
        return this.errorAndAdvance(message, 1);
    }

    protected boolean errorAndAdvance(String message, int advanceTokenCount) {
        PsiBuilder.Marker err = this.mark();
        this.advance(advanceTokenCount);
        err.error(message);
        return false;
    }

    protected boolean eof() {
        return this.myBuilder.eof();
    }

    protected void advance() {
        this.myBuilder.advanceLexer();
    }

    protected void advance(int advanceTokenCount) {
        for (int i = 0; i < advanceTokenCount; ++i) {
            this.advance();
        }
    }

    protected void advanceAt(IElementType current) {
        assert (this._at(current));
        this.myBuilder.advanceLexer();
    }

    protected void advanceAtSet(IElementType ... tokens2) {
        assert (this._atSet(tokens2));
        this.myBuilder.advanceLexer();
    }

    protected void advanceAtSet(TokenSet set) {
        assert (this._atSet(set));
        this.myBuilder.advanceLexer();
    }

    protected IElementType tt() {
        return this.myBuilder.getTokenType();
    }

    protected boolean _at(IElementType expectation) {
        IElementType token = this.tt();
        return this.tokenMatches(token, expectation);
    }

    private boolean tokenMatches(IElementType token, IElementType expectation) {
        if (token == expectation) {
            return true;
        }
        if (expectation == JetTokens.EOL_OR_SEMICOLON) {
            if (this.eof()) {
                return true;
            }
            if (token == JetTokens.SEMICOLON) {
                return true;
            }
            if (this.myBuilder.newlineBeforeCurrentToken()) {
                return true;
            }
        }
        return false;
    }

    protected boolean at(IElementType expectation) {
        JetKeywordToken keywordToken;
        JetKeywordToken expectedKeyword;
        if (this._at(expectation)) {
            return true;
        }
        IElementType token = this.tt();
        if (token == JetTokens.IDENTIFIER && expectation instanceof JetKeywordToken && (expectedKeyword = (JetKeywordToken)expectation).isSoft() && expectedKeyword.getValue().equals(this.myBuilder.getTokenText())) {
            this.myBuilder.remapCurrentToken(expectation);
            return true;
        }
        if (expectation == JetTokens.IDENTIFIER && token instanceof JetKeywordToken && (keywordToken = (JetKeywordToken)token).isSoft()) {
            this.myBuilder.remapCurrentToken(JetTokens.IDENTIFIER);
            return true;
        }
        return false;
    }

    protected boolean _atSet(IElementType ... tokens2) {
        return this._atSet(TokenSet.create((IElementType[])tokens2));
    }

    protected boolean _atSet(TokenSet set) {
        IElementType token = this.tt();
        if (set.contains(token)) {
            return true;
        }
        if (set.contains((IElementType)JetTokens.EOL_OR_SEMICOLON)) {
            if (this.eof()) {
                return true;
            }
            if (token == JetTokens.SEMICOLON) {
                return true;
            }
            if (this.myBuilder.newlineBeforeCurrentToken()) {
                return true;
            }
        }
        return false;
    }

    protected boolean atSet(IElementType ... tokens2) {
        return this.atSet(TokenSet.create((IElementType[])tokens2));
    }

    protected boolean atSet(TokenSet set) {
        if (this._atSet(set)) {
            return true;
        }
        IElementType token = this.tt();
        if (token == JetTokens.IDENTIFIER) {
            JetKeywordToken keywordToken = SOFT_KEYWORD_TEXTS.get(this.myBuilder.getTokenText());
            if (keywordToken != null && set.contains((IElementType)keywordToken)) {
                this.myBuilder.remapCurrentToken(keywordToken);
                return true;
            }
        } else if (set.contains((IElementType)JetTokens.IDENTIFIER) && token instanceof JetKeywordToken && ((JetKeywordToken)token).isSoft()) {
            this.myBuilder.remapCurrentToken(JetTokens.IDENTIFIER);
            return true;
        }
        return false;
    }

    protected IElementType lookahead(int k) {
        return this.myBuilder.lookAhead(k);
    }

    protected void consumeIf(JetToken token) {
        if (this.at(token)) {
            this.advance();
        }
    }

    protected void skipUntil(TokenSet tokenSet) {
        boolean stopAtEolOrSemi = tokenSet.contains((IElementType)JetTokens.EOL_OR_SEMICOLON);
        while (!(this.eof() || tokenSet.contains(this.tt()) || stopAtEolOrSemi && this.at(JetTokens.EOL_OR_SEMICOLON))) {
            this.advance();
        }
    }

    protected void errorUntil(String message, TokenSet tokenSet) {
        assert (tokenSet.contains((IElementType)JetTokens.LBRACE)) : "Cannot include LBRACE into error element!";
        assert (tokenSet.contains((IElementType)JetTokens.RBRACE)) : "Cannot include RBRACE into error element!";
        PsiBuilder.Marker error = this.mark();
        this.skipUntil(tokenSet);
        error.error(message);
    }

    protected void errorUntilOffset(String mesage, int offset2) {
        PsiBuilder.Marker error = this.mark();
        while (!this.eof() && this.myBuilder.getCurrentOffset() < offset2) {
            this.advance();
        }
        error.error(mesage);
    }

    protected static void errorIf(PsiBuilder.Marker marker, boolean condition2, String message) {
        if (condition2) {
            marker.error(message);
        } else {
            marker.drop();
        }
    }

    protected int matchTokenStreamPredicate(TokenStreamPattern pattern2) {
        PsiBuilder.Marker currentPosition = this.mark();
        Stack opens = new Stack();
        int openAngleBrackets = 0;
        int openBraces = 0;
        int openParentheses = 0;
        int openBrackets = 0;
        while (!this.eof() && !pattern2.processToken(this.myBuilder.getCurrentOffset(), pattern2.isTopLevel(openAngleBrackets, openBrackets, openBraces, openParentheses))) {
            if (this.at(JetTokens.LPAR)) {
                ++openParentheses;
                opens.push((Object)JetTokens.LPAR);
            } else if (this.at(JetTokens.LT)) {
                ++openAngleBrackets;
                opens.push((Object)JetTokens.LT);
            } else if (this.at(JetTokens.LBRACE)) {
                ++openBraces;
                opens.push((Object)JetTokens.LBRACE);
            } else if (this.at(JetTokens.LBRACKET)) {
                ++openBrackets;
                opens.push((Object)JetTokens.LBRACKET);
            } else if (this.at(JetTokens.RPAR)) {
                --openParentheses;
                if ((opens.isEmpty() || opens.pop() != JetTokens.LPAR) && pattern2.handleUnmatchedClosing(JetTokens.RPAR)) {
                    break;
                }
            } else if (this.at(JetTokens.GT)) {
                --openAngleBrackets;
            } else if (this.at(JetTokens.RBRACE)) {
                --openBraces;
            } else if (this.at(JetTokens.RBRACKET)) {
                --openBrackets;
            }
            this.advance();
        }
        currentPosition.rollbackTo();
        return pattern2.result();
    }

    protected int findLastBefore(TokenSet lookFor, TokenSet stopAt, boolean dontStopRightAfterOccurrence) {
        return this.matchTokenStreamPredicate(new LastBefore(new AtSet(lookFor), new AtSet(stopAt), dontStopRightAfterOccurrence));
    }

    protected int findLastBefore(IElementType lookFor, TokenSet stopAt, boolean dontStopRightAfterOccurrence) {
        return this.matchTokenStreamPredicate(new LastBefore(new At(lookFor), new AtSet(stopAt), dontStopRightAfterOccurrence));
    }

    protected boolean eol() {
        return this.myBuilder.newlineBeforeCurrentToken() || this.eof();
    }

    protected static void closeDeclarationWithCommentBinders(@NotNull PsiBuilder.Marker marker, @NotNull IElementType elementType, boolean precedingNonDocComments) {
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "org/jetbrains/kotlin/parsing/AbstractJetParsing", "closeDeclarationWithCommentBinders"));
        }
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "org/jetbrains/kotlin/parsing/AbstractJetParsing", "closeDeclarationWithCommentBinders"));
        }
        marker.done(elementType);
        marker.setCustomEdgeTokenBinders((WhitespacesAndCommentsBinder)(precedingNonDocComments ? PrecedingCommentsBinder.INSTANCE$ : PrecedingDocCommentsBinder.INSTANCE$), (WhitespacesAndCommentsBinder)TrailingCommentsBinder.INSTANCE$);
    }

    protected abstract JetParsing create(SemanticWhitespaceAwarePsiBuilder var1);

    protected JetParsing createTruncatedBuilder(int eofPosition) {
        return this.create(new TruncatedSemanticWhitespaceAwarePsiBuilder(this.myBuilder, eofPosition));
    }

    public String currentContext() {
        return StringsPackage.substringWithContext(this.myBuilder.getOriginalText(), this.myBuilder.getCurrentOffset(), this.myBuilder.getCurrentOffset(), 20);
    }

    static {
        for (IElementType type2 : JetTokens.SOFT_KEYWORDS.getTypes()) {
            JetKeywordToken keywordToken = (JetKeywordToken)type2;
            assert (keywordToken.isSoft());
            SOFT_KEYWORD_TEXTS.put(keywordToken.getValue(), keywordToken);
        }
        for (IElementType token : JetTokens.KEYWORDS.getTypes()) {
            assert (token instanceof JetKeywordToken) : "Must be JetKeywordToken: " + token;
            assert (!((JetKeywordToken)token).isSoft()) : "Must not be soft: " + token;
        }
    }

    protected class AtFirstTokenOfTokens
    extends AbstractTokenStreamPredicate {
        private final IElementType[] tokens;

        public AtFirstTokenOfTokens(IElementType ... tokens2) {
            assert (tokens2.length > 0);
            this.tokens = tokens2;
        }

        @Override
        public boolean matching(boolean topLevel) {
            int length = this.tokens.length;
            if (!AbstractJetParsing.this.at(this.tokens[0])) {
                return false;
            }
            for (int i = 1; i < length; ++i) {
                IElementType lookAhead = AbstractJetParsing.this.myBuilder.lookAhead(i);
                if (lookAhead != null && AbstractJetParsing.this.tokenMatches(lookAhead, this.tokens[i])) continue;
                return false;
            }
            return true;
        }
    }

    protected class AtSet
    extends AbstractTokenStreamPredicate {
        private final TokenSet lookFor;
        private final TokenSet topLevelOnly;

        public AtSet(TokenSet lookFor, TokenSet topLevelOnly) {
            this.lookFor = lookFor;
            this.topLevelOnly = topLevelOnly;
        }

        public AtSet(TokenSet lookFor) {
            this(lookFor, lookFor);
        }

        public AtSet(IElementType ... lookFor) {
            this(TokenSet.create((IElementType[])lookFor), TokenSet.create((IElementType[])lookFor));
        }

        @Override
        public boolean matching(boolean topLevel) {
            return (topLevel || !AbstractJetParsing.this.atSet(this.topLevelOnly)) && AbstractJetParsing.this.atSet(this.lookFor);
        }
    }

    protected class At
    extends AbstractTokenStreamPredicate {
        private final IElementType lookFor;
        private final boolean topLevelOnly;

        public At(IElementType lookFor, boolean topLevelOnly) {
            this.lookFor = lookFor;
            this.topLevelOnly = topLevelOnly;
        }

        public At(IElementType lookFor) {
            this(lookFor, true);
        }

        @Override
        public boolean matching(boolean topLevel) {
            return (topLevel || !this.topLevelOnly) && AbstractJetParsing.this.at(this.lookFor);
        }
    }

    protected class AtOffset
    extends AbstractTokenStreamPredicate {
        private final int offset;

        public AtOffset(int offset2) {
            this.offset = offset2;
        }

        @Override
        public boolean matching(boolean topLevel) {
            return AbstractJetParsing.this.myBuilder.getCurrentOffset() == this.offset;
        }
    }

    protected class OptionalMarker {
        private final PsiBuilder.Marker marker;
        private final int offset;

        public OptionalMarker(boolean actuallyMark) {
            this.marker = actuallyMark ? AbstractJetParsing.this.mark() : null;
            this.offset = AbstractJetParsing.this.myBuilder.getCurrentOffset();
        }

        public void done(IElementType elementType) {
            if (this.marker == null) {
                return;
            }
            this.marker.done(elementType);
        }

        public void error(String message) {
            if (this.marker == null) {
                return;
            }
            if (this.offset == AbstractJetParsing.this.myBuilder.getCurrentOffset()) {
                this.marker.drop();
            } else {
                this.marker.error(message);
            }
        }

        public void drop() {
            if (this.marker == null) {
                return;
            }
            this.marker.drop();
        }
    }
}

