/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.parsing;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.parsing.JetParsing;
import org.jetbrains.kotlin.parsing.JetScriptDefinitionProvider;
import org.jetbrains.kotlin.parsing.SemanticWhitespaceAwarePsiBuilderImpl;

public class JetParser
implements PsiParser {
    private final JetScriptDefinitionProvider scriptDefinitionProvider;

    public JetParser(Project project) {
        this.scriptDefinitionProvider = JetScriptDefinitionProvider.getInstance(project);
    }

    @NotNull
    public ASTNode parse(IElementType iElementType, PsiBuilder psiBuilder) {
        throw new IllegalStateException("use another parse");
    }

    @NotNull
    public ASTNode parse(IElementType iElementType, PsiBuilder psiBuilder, PsiFile psiFile) {
        JetParsing jetParsing = JetParsing.createForTopLevel(new SemanticWhitespaceAwarePsiBuilderImpl(psiBuilder));
        if (this.scriptDefinitionProvider != null && this.scriptDefinitionProvider.isScript(psiFile) || psiFile.getName().endsWith(".kts")) {
            jetParsing.parseScript();
        } else {
            jetParsing.parseFile();
        }
        ASTNode aSTNode = psiBuilder.getTreeBuilt();
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/parsing/JetParser", "parse"));
        }
        return aSTNode;
    }

    @NotNull
    public static ASTNode parseTypeCodeFragment(PsiBuilder psiBuilder) {
        JetParsing jetParsing = JetParsing.createForTopLevel(new SemanticWhitespaceAwarePsiBuilderImpl(psiBuilder));
        jetParsing.parseTypeCodeFragment();
        ASTNode aSTNode = psiBuilder.getTreeBuilt();
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/parsing/JetParser", "parseTypeCodeFragment"));
        }
        return aSTNode;
    }

    @NotNull
    public static ASTNode parseExpressionCodeFragment(PsiBuilder psiBuilder) {
        JetParsing jetParsing = JetParsing.createForTopLevel(new SemanticWhitespaceAwarePsiBuilderImpl(psiBuilder));
        jetParsing.parseExpressionCodeFragment();
        ASTNode aSTNode = psiBuilder.getTreeBuilt();
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/parsing/JetParser", "parseExpressionCodeFragment"));
        }
        return aSTNode;
    }

    @NotNull
    public static ASTNode parseBlockCodeFragment(PsiBuilder psiBuilder) {
        JetParsing jetParsing = JetParsing.createForTopLevel(new SemanticWhitespaceAwarePsiBuilderImpl(psiBuilder));
        jetParsing.parseBlockCodeFragment();
        ASTNode aSTNode = psiBuilder.getTreeBuilt();
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/parsing/JetParser", "parseBlockCodeFragment"));
        }
        return aSTNode;
    }
}

