/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.parsing;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.parsing.JetScriptDefinition;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.resolve.AnalyzerScriptParameter;

public class JetScriptDefinitionProvider {
    private final Map<String, JetScriptDefinition> scripts = new HashMap<String, JetScriptDefinition>();
    private final Set<PsiFile> scriptsFiles = new HashSet<PsiFile>();
    private static final JetScriptDefinition standardScript = new JetScriptDefinition(".kts", Collections.<AnalyzerScriptParameter>emptyList());

    public static JetScriptDefinitionProvider getInstance(Project project) {
        return (JetScriptDefinitionProvider)ServiceManager.getService((Project)project, JetScriptDefinitionProvider.class);
    }

    public JetScriptDefinitionProvider() {
        this.addScriptDefinition(standardScript);
    }

    public void markFileAsScript(JetFile file) {
        this.scriptsFiles.add((PsiFile)file);
    }

    public JetScriptDefinition findScriptDefinition(PsiFile psiFile) {
        boolean force = this.scriptsFiles.contains(psiFile);
        String name2 = psiFile.getName();
        for (Map.Entry<String, JetScriptDefinition> e : this.scripts.entrySet()) {
            if (!name2.endsWith(e.getKey())) continue;
            return e.getValue();
        }
        if (force) {
            return standardScript;
        }
        return null;
    }

    public boolean isScript(PsiFile psiFile) {
        return this.findScriptDefinition(psiFile) != null;
    }

    public void addScriptDefinition(@NotNull JetScriptDefinition scriptDefinition) {
        if (scriptDefinition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptDefinition", "org/jetbrains/kotlin/parsing/JetScriptDefinitionProvider", "addScriptDefinition"));
        }
        this.scripts.put(scriptDefinition.getExtension(), scriptDefinition);
    }

    public void addScriptDefinitions(List<JetScriptDefinition> definitions) {
        for (JetScriptDefinition definition : definitions) {
            this.addScriptDefinition(definition);
        }
    }
}

