/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.JetNodeTypes;
import org.jetbrains.kotlin.psi.JetCallElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetExpressionImpl;
import org.jetbrains.kotlin.psi.JetFunctionLiteralArgument;
import org.jetbrains.kotlin.psi.JetReferenceExpression;
import org.jetbrains.kotlin.psi.JetTypeArgumentList;
import org.jetbrains.kotlin.psi.JetTypeProjection;
import org.jetbrains.kotlin.psi.JetValueArgument;
import org.jetbrains.kotlin.psi.JetValueArgumentList;
import org.jetbrains.kotlin.psi.JetVisitor;

public class JetCallExpression
extends JetExpressionImpl
implements JetCallElement,
JetReferenceExpression {
    public JetCallExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/JetCallExpression", "<init>"));
        }
        super(node);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor2, D data2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/JetCallExpression", "accept"));
        }
        return visitor2.visitCallExpression(this, data2);
    }

    @Override
    @Nullable
    public JetExpression getCalleeExpression() {
        return (JetExpression)this.findChildByClass(JetExpression.class);
    }

    @Override
    @Nullable
    public JetValueArgumentList getValueArgumentList() {
        return (JetValueArgumentList)this.findChildByType(JetNodeTypes.VALUE_ARGUMENT_LIST);
    }

    @Override
    @Nullable
    public JetTypeArgumentList getTypeArgumentList() {
        return (JetTypeArgumentList)this.findChildByType(JetNodeTypes.TYPE_ARGUMENT_LIST);
    }

    @Override
    @NotNull
    public List<JetFunctionLiteralArgument> getFunctionLiteralArguments() {
        List list = this.findChildrenByType(JetNodeTypes.FUNCTION_LITERAL_ARGUMENT);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetCallExpression", "getFunctionLiteralArguments"));
        }
        return list;
    }

    @NotNull
    public List<JetValueArgument> getValueArguments() {
        JetValueArgumentList list = this.getValueArgumentList();
        List<JetValueArgument> valueArgumentsInParentheses = list != null ? list.getArguments() : Collections.emptyList();
        List<JetFunctionLiteralArgument> functionLiteralArguments = this.getFunctionLiteralArguments();
        if (functionLiteralArguments.isEmpty()) {
            List<JetValueArgument> list2 = valueArgumentsInParentheses;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetCallExpression", "getValueArguments"));
            }
            return list2;
        }
        ArrayList allValueArguments2 = Lists.newArrayList();
        allValueArguments2.addAll(valueArgumentsInParentheses);
        allValueArguments2.addAll(functionLiteralArguments);
        ArrayList arrayList = allValueArguments2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetCallExpression", "getValueArguments"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<JetTypeProjection> getTypeArguments() {
        JetTypeArgumentList list = this.getTypeArgumentList();
        List<JetTypeProjection> list2 = list != null ? list.getArguments() : Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetCallExpression", "getTypeArguments"));
        }
        return list2;
    }
}

