/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetClassBody;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.psi.JetParameterList;
import org.jetbrains.kotlin.psi.JetPrimaryConstructor;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPsiFactory;
import org.jetbrains.kotlin.psi.JetVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinClassOrObjectStub;
import org.jetbrains.kotlin.psi.stubs.KotlinClassStub;
import org.jetbrains.kotlin.psi.stubs.elements.JetStubElementTypes;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={",\n)A!*\u001a;DY\u0006\u001c8OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\r\u00018/\u001b\u0006\u0011\u0015\u0016$8\t\\1tg>\u0013xJ\u00196fGRTa\u0001P5oSRt$\u0002\u00028pI\u0016Tq!Q*U\u001d>$WMC\u0002d_6T\u0001\"\u001b8uK2d\u0017N\u001b\u0006\u0005Y\u0006twM\u0003\u0003tiV\u0014'bD&pi2Lgn\u00117bgN\u001cF/\u001e2\u000b\u000bM$XOY:\u000b\u0003IS1!\u00118z\u0015\u0005!%BB1dG\u0016\u0004HOC\u0004wSNLGo\u001c:\u000b\u0015)+GOV5tSR|'O\u0003\u0003eCR\f'\u0002\u00026bm\u0006Taa\u00142kK\u000e$(\u0002I2sK\u0006$X\r\u0015:j[\u0006\u0014\u0018pQ8ogR\u0014Xo\u0019;pe&3\u0017IY:f]RTQCS3u!JLW.\u0019:z\u0007>t7\u000f\u001e:vGR|'OC\u0017de\u0016\fG/\u001a)sS6\f'/_\"p]N$(/^2u_J\u0004\u0016M]1nKR,'\u000fT5ti&3\u0017IY:f]RT\u0001CS3u!\u0006\u0014\u0018-\\3uKJd\u0015n\u001d;\u000b5\u001d,Go\u00117bgN|%/\u00138uKJ4\u0017mY3LKf<xN\u001d3\u000b\u0015A\u001b\u0018.\u00127f[\u0016tGO\u0003\u0005hKR\u001cu\u000e\\8o\u0015M9W\r^\"p[B\fg.[8o\u001f\nTWm\u0019;t\u0015\u0011a\u0015n\u001d;\u000b))+Go\u00142kK\u000e$H)Z2mCJ\fG/[8o\u0015\u0011)H/\u001b7\u000b\u001b\u001d,G\u000f\u0015:pa\u0016\u0014H/[3t\u0015-QU\r\u001e)s_B,'\u000f^=\u000b!\u001d,G/U;bY&4\u0017.\u001a3OC6,'BB*ue&twMC\u0004hKR\u001cF/\u001e2\u000b\r%\u001cXI\\;n\u0015\u001d\u0011un\u001c7fC:Ta\"[:FcVLg/\u00197f]R$vNC\u0004b]>$\b.\u001a:\u000b\u000f%\u001c\u0018J\u001c8fe*Y\u0011n]%oi\u0016\u0014h-Y2f\u0015!I7oU3bY\u0016$G>\u0001\u0006\u0003!\u0005QA\u0001\u0003\u0001\u0011\u0005)!\u0001\"\u0001\t\u0004\u0015\u0011A!\u0001\u0005\u0003\u000b\r!\u0019\u0001\u0003\u0001\r\u0001\u0015\u0019A1\u0001E\u0003\u0019\u0001)\u0011\u0001#\u0003\u0006\u0005\u0011\u0019\u0001\"B\u0003\u0003\t\u000fAY!B\u0002\u0005\t!!A\u0002A\u0003\u0003\t\u0011AA!\u0002\u0002\u0005\u0004!9Qa\u0001C\u0006\u0011\u001ba\u0001!\u0002\u0002\u0005\f!5Q!\u0001E\u0002\u000b\r!q\u0001\u0003\u0005\r\u0001\u0015\u0019A1\u0001\u0005\u000b\u0019\u0001)\u0011\u0001C\u0006\u0006\u0005\u0011E\u00012B\u0003\u0003\t%A9\"\u0002\u0002\u0005\u0004!QQa\u0001C\u0002\u00113a\u0001!\u0002\u0002\u0005\u0004!eQa\u0001C\u0002\u00117a\u0001!\u0002\u0002\u0005\u0004!mQA\u0001C\u0004\u0011\t)1\u0001\"\u0007\t\u001e1\u0001QA\u0001C\r\u0011;)1\u0001B\u0004\t!1\u0001Qa\u0001C\u0002\u0011Ca\u0001!\u0002\u0002\u0005\u0012!\tRA\u0001\u0003\u0010\u0011A)1\u0001b\u0001\t%1\u0001Qa\u0001\u0003\b\u0011Ma\u0001!\u0002\u0002\u0005\u0013!\u0019Ra\u0001\u0003\b\u0011Sa\u0001\u0001B\u0006\r\u0005e\u0019Q!\u0001E\u00031\u000bi[\bB\u0006\u0012\u000f\u0011\u0001\u0001rB\u000b\u0005\u000b\u0005Ay\u0001$\u0001\u0019\u0010E9A\u0011\u0001E\t+\u0011)\u0011\u0001c\u0004\r\u0002a=\u0001$CO\u0014\t\u0001A\u0019\"D\b\u0006\u0003!A\u0011\"B\u0005\u0005\u000b\t!\t\u0001\u0003\u0001\u001d\u0001%)\u0011\u0002B\u0003\u0003\t\u0003A\t\u0001(\u0001\u0019\u0011A\u001b\u0001!(\u0005\u0005\u0001!UQ\u0002B\u0003\u0003\t\u0003A\t\u0001(\u0001Q\u0007\u0003\tC!\u0002\u0002\u0005\u0002!\u0001A\u0004A)\u0004\u000f\u0011I\u0011\"\u0001E\n\u001b\u0005A!\"D\u0001\t\u00145VAa\u0001\r\rC\r)\u0011\u0001#\u0006\u0019\u0016E\u001b1\u0001\u0002\u0007\n\u0003!YQV\u0003\u0003\u000415\t3!B\u0001\t\u0018a]\u0011kA\u0002\u0005\u001b%\t\u0001\u0002DW\f\t\rAb\"\t\u0003\u0006\u0003!iA\u0012\u0001\r\u000e#\u000e\u0019AAD\u0005\u0002\u00117i;\u0002B\u0002\u0019\u001f\u0005\"Q!\u0001\u0005\u000e\u0019\u0003AR\"U\u0002\u0004\t=I\u0011\u0001c\u0007. \u0011\u0019\u0001tD\u0011\t\u000b\u0005Aa\"\u0003\u0003\n\u0007\u0015\t\u0001R\u0004M\u000f19\t6a\u0001C\u0010\u0013\u0005Ay\"l\b\u0005\u0007a\r\u0012\u0005C\u0003\u0002\u00119IA!C\u0002\u0006\u0003!\u0001\u0002\u0004\u0005\r\u000f#\u000e\u0019A1E\u0005\u0002\u0011?i;\u0002\u0002\u0002\u0019&\u0005\"Q!\u0001E\u0011\u0019\u0003A\n#U\u0002\u0004\tKI\u0011\u0001C\t.\u0018\u0011Y\u0001tE\u0011\u0005\u000b\u0005Aa\u0001$\u0001\u0019\rE\u001b1\u0001b\n\n\u0003!5QV\u0003\u0003\u00041Q\t3!B\u0001\t$a\r\u0012kA\u0002\u0005)%\tA\u0011A\u0017\u0017\t-AR#(\u0005\u0005\u0001!-R\u0002B\u0003\u0002\u00115a\t\u0001G\u0007Q\u0007\u0001\t3!B\u0001\t$a\r\u0012kA\u0003\u0005+%\tA\u0011A\u0007\u0002\u00117i+\u0002B\u0002\u0019-\u0005\u001aQ!\u0001E\u00121G\t6a\u0001\u0003\u0017\u0013\u0005!\t!,\u0006\u0005\u0007a5\u0012eA\u0003\u0002\u0011GA\u001a#U\u0002\u0004\t[I\u0011\u0001\"\u0001.\u0016\u0011\u0019\u0001dF\u0011\u0004\u000b\u0005A\u0019\u0003g\tR\u0007\r!q#C\u0001\u0005\u0002e.Ba9\u0001\u0019\u0007u=A\u0001\u0001E\u0004\u001b\r)\u0011\u0001#\u0003\u0019\nA\u001b\u0001!I\u0002\u0006\u0003!\u0011\u0001DA)\u0004\u000b\u0011\u0019\u0011\"\u0001\u0003\u0001\u001b\u0005AQ!o\u000b\u0005G\u0004A2!h\u0004\u0005\u0001!1QbA\u0003\u0002\u0011\u0019Ab\u0001U\u0002\u0001C\r)\u0011\u0001\u0003\u0002\u0019\u0005E\u001bQ\u0001B\u0002\n\u0003\u0011\u0001Q\"\u0001E\u0007"})
public class JetClass
extends JetClassOrObject {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(JetClass.class);
    }

    @Nullable
    public KotlinClassStub getStub() {
        StubElement stubElement = super.getStub();
        if (!(stubElement instanceof KotlinClassStub)) {
            stubElement = null;
        }
        return (KotlinClassStub)stubElement;
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor2, D data2) {
        Intrinsics.checkParameterIsNotNull(visitor2, (String)"visitor");
        return visitor2.visitClass(this, data2);
    }

    @NotNull
    public final JetPrimaryConstructor createPrimaryConstructorIfAbsent() {
        JetPrimaryConstructor constructor = this.getPrimaryConstructor();
        if (constructor != null) {
            return constructor;
        }
        PsiElement anchor2 = (PsiElement)this.getTypeParameterList();
        if (anchor2 == null) {
            anchor2 = this.getNameIdentifier();
        }
        if (anchor2 == null) {
            anchor2 = this.getLastChild();
        }
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"getProject()");
        PsiElement psiElement2 = this.addAfter(new JetPsiFactory(project).createPrimaryConstructor(), anchor2);
        if (psiElement2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.JetPrimaryConstructor");
        }
        return (JetPrimaryConstructor)psiElement2;
    }

    @NotNull
    public final JetParameterList createPrimaryConstructorParameterListIfAbsent() {
        JetPrimaryConstructor constructor = this.createPrimaryConstructorIfAbsent();
        JetParameterList parameterList2 = constructor.getValueParameterList();
        if (parameterList2 != null) {
            return parameterList2;
        }
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"getProject()");
        PsiElement psiElement2 = constructor.add((PsiElement)new JetPsiFactory(project).createParameterList("()"));
        if (psiElement2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.JetParameterList");
        }
        return (JetParameterList)psiElement2;
    }

    @Nullable
    public final PsiElement getColon() {
        return this.findChildByType(JetTokens.COLON);
    }

    @NotNull
    public final List<JetProperty> getProperties() {
        JetClassBody jetClassBody = this.getBody();
        return KotlinPackage.orEmpty(jetClassBody != null ? jetClassBody.getProperties() : null);
    }

    public final boolean isInterface() {
        KotlinClassStub kotlinClassStub = this.getStub();
        return kotlinClassStub != null ? kotlinClassStub.isInterface() : this.findChildByType(JetTokens.TRAIT_KEYWORD) != null || this.findChildByType(JetTokens.INTERFACE_KEYWORD) != null;
    }

    public final boolean isEnum() {
        return this.hasModifier(JetTokens.ENUM_KEYWORD);
    }

    public final boolean isSealed() {
        return this.hasModifier(JetTokens.SEALED_KEYWORD);
    }

    public final boolean isInner() {
        return this.hasModifier(JetTokens.INNER_KEYWORD);
    }

    public boolean isEquivalentTo(@Nullable PsiElement another) {
        if (super.isEquivalentTo(another)) {
            return true;
        }
        if (another instanceof JetClass) {
            String fq1 = this.getQualifiedName();
            String fq2 = ((JetClass)another).getQualifiedName();
            return fq1 != null && fq2 != null && Intrinsics.areEqual((Object)fq1, (Object)fq2);
        }
        return false;
    }

    @Nullable
    protected final String getQualifiedName() {
        KotlinClassStub stub = this.getStub();
        if (stub != null) {
            FqName fqName2;
            FqName fqName3 = fqName2 = stub.getFqName();
            return fqName3 != null ? fqName3.asString() : null;
        }
        ArrayList<String> parts = new ArrayList<String>();
        JetClassOrObject current = this;
        while (current != null) {
            String string = current.getName();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            parts.add(string);
            current = (JetClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)current, JetClassOrObject.class);
        }
        PsiFile file = this.getContainingFile();
        if (!(file instanceof JetFile)) {
            return null;
        }
        String fileQualifiedName = ((JetFile)file).getPackageFqName().asString();
        if (!KotlinPackage.isEmpty((String)fileQualifiedName)) {
            parts.add(fileQualifiedName);
        }
        Collections.reverse((List)parts);
        return StringUtil.join((Collection)parts, (String)".");
    }

    @NotNull
    public final List<JetObjectDeclaration> getCompanionObjects() {
        JetClassBody jetClassBody = this.getBody();
        return KotlinPackage.orEmpty(jetClassBody != null ? jetClassBody.getAllCompanionObjects() : null);
    }

    @Nullable
    public final PsiElement getClassOrInterfaceKeyword() {
        return this.findChildByType(TokenSet.create((IElementType[])new IElementType[]{JetTokens.CLASS_KEYWORD, JetTokens.INTERFACE_KEYWORD}));
    }

    public JetClass(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        super(node);
    }

    public JetClass(@NotNull KotlinClassStub stub) {
        Intrinsics.checkParameterIsNotNull((Object)stub, (String)"stub");
        KotlinClassOrObjectStub kotlinClassOrObjectStub = stub;
        IStubElementType iStubElementType = JetStubElementTypes.CLASS;
        Intrinsics.checkExpressionValueIsNotNull((Object)iStubElementType, (String)"JetStubElementTypes.CLASS");
        super(kotlinClassOrObjectStub, iStubElementType);
    }
}

