/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.kdoc.psi.api.KDoc;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetModifierListOwnerStub;
import org.jetbrains.kotlin.psi.KotlinDeclarationNavigationPolicy;
import org.jetbrains.kotlin.psi.findDocComment.FindDocCommentPackage;
import org.jetbrains.kotlin.psi.stubs.KotlinClassOrObjectStub;

abstract class JetDeclarationStub<T extends StubElement<?>>
extends JetModifierListOwnerStub<T>
implements JetDeclaration {
    private long modificationStamp;

    public JetDeclarationStub(@NotNull T stub, @NotNull IStubElementType nodeType) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/JetDeclarationStub", "<init>"));
        }
        if (nodeType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeType", "org/jetbrains/kotlin/psi/JetDeclarationStub", "<init>"));
        }
        super(stub, nodeType);
        this.modificationStamp = 0L;
    }

    public JetDeclarationStub(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/JetDeclarationStub", "<init>"));
        }
        super(node);
        this.modificationStamp = 0L;
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        ++this.modificationStamp;
    }

    public long getModificationStamp() {
        return this.modificationStamp;
    }

    @Override
    @Nullable
    public KDoc getDocComment() {
        return FindDocCommentPackage.findDocComment(this);
    }

    public PsiElement getParent() {
        StubElement stub = this.getStub();
        if (!(stub == null || stub instanceof KotlinClassOrObjectStub && ((KotlinClassOrObjectStub)stub).isLocal())) {
            return stub.getParentStub().getPsi();
        }
        return super.getParent();
    }

    public PsiElement getOriginalElement() {
        KotlinDeclarationNavigationPolicy navigationPolicy = (KotlinDeclarationNavigationPolicy)ServiceManager.getService(KotlinDeclarationNavigationPolicy.class);
        return navigationPolicy != null ? navigationPolicy.getOriginalElement(this) : this;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        KotlinDeclarationNavigationPolicy navigationPolicy = (KotlinDeclarationNavigationPolicy)ServiceManager.getService(KotlinDeclarationNavigationPolicy.class);
        JetElement jetElement = navigationPolicy != null ? navigationPolicy.getNavigationElement(this) : this;
        if (jetElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetDeclarationStub", "getNavigationElement"));
        }
        return jetElement;
    }
}

