/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.JetModifierKeywordToken;
import org.jetbrains.kotlin.psi.JetAnnotation;
import org.jetbrains.kotlin.psi.JetAnnotationEntry;
import org.jetbrains.kotlin.psi.JetAnnotationsContainer;
import org.jetbrains.kotlin.psi.JetElementImplStub;
import org.jetbrains.kotlin.psi.JetVisitor;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilPackage;
import org.jetbrains.kotlin.psi.stubs.KotlinModifierListStub;
import org.jetbrains.kotlin.psi.stubs.elements.JetStubElementTypes;

public abstract class JetModifierList
extends JetElementImplStub<KotlinModifierListStub>
implements JetAnnotationsContainer {
    public JetModifierList(@NotNull KotlinModifierListStub stub, @NotNull IStubElementType nodeType) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/JetModifierList", "<init>"));
        }
        if (nodeType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeType", "org/jetbrains/kotlin/psi/JetModifierList", "<init>"));
        }
        super(stub, nodeType);
    }

    public JetModifierList(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/JetModifierList", "<init>"));
        }
        super(node);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor2, D data2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/JetModifierList", "accept"));
        }
        return visitor2.visitModifierList(this, data2);
    }

    @NotNull
    public List<JetAnnotation> getAnnotations() {
        List<JetAnnotation> list = this.getStubOrPsiChildrenAsList(JetStubElementTypes.ANNOTATION);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetModifierList", "getAnnotations"));
        }
        return list;
    }

    @NotNull
    public List<JetAnnotationEntry> getAnnotationEntries() {
        List<JetAnnotationEntry> list = PsiUtilPackage.collectAnnotationEntriesFromStubOrPsi(this);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetModifierList", "getAnnotationEntries"));
        }
        return list;
    }

    public boolean hasModifier(@NotNull JetModifierKeywordToken tokenType) {
        if (tokenType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokenType", "org/jetbrains/kotlin/psi/JetModifierList", "hasModifier"));
        }
        KotlinModifierListStub stub = (KotlinModifierListStub)this.getStub();
        if (stub != null) {
            return stub.hasModifier(tokenType);
        }
        return this.getModifier(tokenType) != null;
    }

    @Nullable
    public PsiElement getModifier(@NotNull JetModifierKeywordToken tokenType) {
        if (tokenType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokenType", "org/jetbrains/kotlin/psi/JetModifierList", "getModifier"));
        }
        return this.findChildByType(tokenType);
    }

    public PsiElement getOwner() {
        return this.getParentByStub();
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/kotlin/psi/JetModifierList", "deleteChildInternal"));
        }
        super.deleteChildInternal(child);
        if (this.getFirstChild() == null) {
            this.delete();
        }
    }
}

