/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetObjectDeclarationName;
import org.jetbrains.kotlin.psi.JetObjectLiteralExpression;
import org.jetbrains.kotlin.psi.JetPsiFactory;
import org.jetbrains.kotlin.psi.JetVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinClassOrObjectStub;
import org.jetbrains.kotlin.psi.stubs.KotlinObjectStub;
import org.jetbrains.kotlin.psi.stubs.elements.JetStubElementTypes;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"b\u0006)!\"*\u001a;PE*,7\r\u001e#fG2\f'/\u0019;j_:T1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\u0004aNL'\u0002\u0005&fi\u000ec\u0017m]:Pe>\u0013'.Z2u\u0015\u0019a\u0014N\\5u})!an\u001c3f\u0015\u001d\t5\u000b\u0016(pI\u0016T1aY8n\u0015!Ig\u000e^3mY&T'\u0002\u00027b]\u001eTAa\u001d;vE*\u00012j\u001c;mS:|%M[3diN#XO\u0019\u0006\u0006gR,(m\u001d\u0006\u0002%*\u0019\u0011I\\=\u000b\u0003\u0011Sa!Y2dKB$(b\u0002<jg&$xN\u001d\u0006\u000b\u0015\u0016$h+[:ji>\u0014(\u0002\u00023bi\u0006TAA[1wC*1qJ\u00196fGRTqaZ3u\u001d\u0006lWM\u0003\u0004TiJLgn\u001a\u0006\u0012O\u0016$h*Y7f\u0013\u0012,g\u000e^5gS\u0016\u0014(B\u0003)tS\u0016cW-\\3oi*\u0001r-\u001a;PE*,7\r^&fs^|'\u000f\u001a\u0006\bO\u0016$8\u000b^;c\u001559W\r\u001e+fqR|eMZ:fi*\u0019\u0011J\u001c;\u000b\u0017%\u001c8i\\7qC:LwN\u001c\u0006\b\u0005>|G.Z1o\u0015=I7o\u00142kK\u000e$H*\u001b;fe\u0006d'bB:fi:\u000bW.\u001a\u0006\u0005]\u0006lW\rn\u0001\u000b\u0005A\t!\u0002\u0002\u0005\u0001!\tQA\u0001C\u0001\u0011\u0007)!\u0001B\u0001\t\u0005\u0015\u0019A1\u0001\u0005\u0001\u0019\u0001)1\u0001b\u0001\t\u00061\u0001Q!\u0001E\u0005\u000b\t!1\u0001C\u0003\u0006\u0005\u0011\u001d\u00012B\u0003\u0004\t\u0011AA\u0001\u0004\u0001\u0006\u0005\u0011!\u0001\u0002B\u0003\u0003\t\u0007Aq!B\u0002\u0005\f!5A\u0002A\u0003\u0003\t\u0017Ai!B\u0001\t\u0004\u0015\u0019Aa\u0002\u0005\t\u0019\u0001)1\u0001b\u0001\t\u00151\u0001Q!\u0001\u0005\f\u000b\t!\t\u0002c\u0003\u0006\u0005\u0011I\u0001rC\u0003\u0003\t\u0007A!\"B\u0002\u0005\u000f!eA\u0002A\u0003\u0003\t%AI\"\u0002\u0002\u0005\b!\u0011Qa\u0001C\f\u00117a\u0001!\u0002\u0002\u0005\u0018!mQa\u0001\u0003\b\u0011?a\u0001!B\u0002\u0005\u000f!\u0005B\u0002\u0001\u0003\u0004\u0019\tI2!B\u0001\t\u0006a\u0015Q6\u0010\u0003\f#\u001d!\u0001\u0001c\u0004\u0016\t\u0015\t\u0001r\u0002G\u00011\u001f\tr\u0001\"\u0001\t\u0012U!Q!\u0001E\b\u0019\u0003Az\u0001G\u0005\u001e(\u0011\u0001\u00012C\u0007\u0010\u000b\u0005A\u0001\"C\u0003\n\t\u0015\u0011A\u0011\u0001\u0005\u00019\u0001IQ!\u0003\u0003\u0006\u0005\u0011\u0005\u0001\u0012\u0001O\u00011!\u00016\u0001AO\t\t\u0001A)\"\u0004\u0003\u0006\u0005\u0011\u0005\u0001\u0012\u0001O\u0001!\u000e\u0005\u0011\u0005B\u0003\u0003\t\u0003A\u0001\u0001\b\u0001R\u0007\u001d!\u0011\"C\u0001\t\u00145\t\u0001BC\u0007\u0002\u0011'i;\u0002B\u0006\u0019\u0019\u0005\"Q!\u0001E\u000b\u0019\u0003A*\"U\u0002\u0004\t1I\u0011\u0001C\u0006.\u0018\u0011Y\u0001$D\u0011\u0005\u000b\u0005AA\u0002$\u0001\u0019\u0019E\u001b1\u0001B\u0007\n\u0003!eQV\u0003\u0003\u000419\t3!B\u0001\t\u0019aa\u0011kA\u0002\u0005\u001d%\t\u0001\u0012DW\f\t-Aj\"\t\u0003\u0006\u0003!1A\u0012\u0001\r\u0007#\u000e\u0019AQD\u0005\u0002\u0011\u001bi+\u0002B\u0006\u0019\u001f\u0005\u001aQ!\u0001\u0005\u000e15\t6a\u0001\u0003\u0010\u0013\u0005!)!,\u0006\u0005\u0007a\u0001\u0012eA\u0003\u0002\u00117AZ\"U\u0002\u0004\tAI\u0011\u0001\"\u0001.\u0016\u0011\u0019\u0001$E\u0011\u0004\u000b\u0005AY\u0002g\u0007R\u0007\r!\u0011#C\u0001\u0005\u00025*Ba\u0003M\u0012;\u001f!\t\u0001\u0003\n\u000e\u0007\u0015\t\u0001R\u0003M\u000b!\u000e\u0001\u0011eA\u0003\u0002\u00111AB\"U\u0002\u0006\tGI\u0011\u0001#\u0007\u000e\u0003!Y\u00118\u0006\u0003d\u0002a\u0019Qt\u0002\u0003\u0001\u0011\u000fi1!B\u0001\t\na%\u0001k\u0001\u0001\"\u0007\u0015\t\u0001B\u0001\r\u0003#\u000e)AaA\u0005\u0002\t\u0001i\u0011\u0001C\u0003:,\u0011\u0019\u000f\u0001G\u0002\u001e\u0010\u0011\u0001\u0001BB\u0007\u0004\u000b\u0005Aa\u0001\u0007\u0004Q\u0007\u0001\t3!B\u0001\t\u0005a\u0011\u0011kA\u0003\u0005\u0007%\tA\u0001A\u0007\u0002\u0011\u001b\u0001"})
public final class JetObjectDeclaration
extends JetClassOrObject {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(JetObjectDeclaration.class);
    }

    @Nullable
    public KotlinObjectStub getStub() {
        StubElement stubElement = super.getStub();
        if (!(stubElement instanceof KotlinObjectStub)) {
            stubElement = null;
        }
        return (KotlinObjectStub)stubElement;
    }

    @Override
    @Nullable
    public String getName() {
        KotlinObjectStub stub = this.getStub();
        if (stub != null) {
            return stub.getName();
        }
        JetObjectDeclarationName nameAsDeclaration = this.getNameAsDeclaration();
        if (nameAsDeclaration == null && this.isCompanion()) {
            return SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT.toString();
        }
        JetObjectDeclarationName jetObjectDeclarationName = nameAsDeclaration;
        return jetObjectDeclarationName != null ? jetObjectDeclarationName.getName() : null;
    }

    @Override
    @Nullable
    public PsiElement getNameIdentifier() {
        JetObjectDeclarationName jetObjectDeclarationName = this.getNameAsDeclaration();
        return jetObjectDeclarationName != null ? jetObjectDeclarationName.getNameIdentifier() : null;
    }

    @Override
    @NotNull
    public PsiElement setName(@NonNls @NotNull String name2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        JetObjectDeclarationName declarationName = this.getNameAsDeclaration();
        if (declarationName == null) {
            Project project = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"getProject()");
            JetPsiFactory psiFactory = new JetPsiFactory(project);
            PsiElement result2 = this.addAfter((PsiElement)psiFactory.createObjectDeclarationName(name2), this.getObjectKeyword());
            this.addAfter(psiFactory.createWhiteSpace(), this.getObjectKeyword());
            PsiElement psiElement2 = result2;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"result");
            return psiElement2;
        }
        PsiElement psiElement3 = declarationName.setName(name2);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"declarationName.setName(name)");
        return psiElement3;
    }

    public final boolean isCompanion() {
        KotlinObjectStub kotlinObjectStub = this.getStub();
        return kotlinObjectStub != null ? kotlinObjectStub.isCompanion() : this.hasModifier(JetTokens.COMPANION_KEYWORD);
    }

    @Override
    public int getTextOffset() {
        PsiElement psiElement2 = this.getNameIdentifier();
        return psiElement2 != null && (psiElement2 = psiElement2.getTextRange()) != null ? psiElement2.getStartOffset() : this.getObjectKeyword().getTextRange().getStartOffset();
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor2, D data2) {
        Intrinsics.checkParameterIsNotNull(visitor2, (String)"visitor");
        return visitor2.visitObjectDeclaration(this, data2);
    }

    public final boolean isObjectLiteral() {
        KotlinObjectStub kotlinObjectStub = this.getStub();
        return kotlinObjectStub != null ? kotlinObjectStub.isObjectLiteral() : this.getParent() instanceof JetObjectLiteralExpression;
    }

    @NotNull
    public final PsiElement getObjectKeyword() {
        PsiElement psiElement2 = this.findChildByType(JetTokens.OBJECT_KEYWORD);
        if (psiElement2 == null) {
            Intrinsics.throwNpe();
        }
        return psiElement2;
    }

    public JetObjectDeclaration(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        super(node);
    }

    public JetObjectDeclaration(@NotNull KotlinObjectStub stub) {
        Intrinsics.checkParameterIsNotNull((Object)stub, (String)"stub");
        KotlinClassOrObjectStub kotlinClassOrObjectStub = stub;
        IStubElementType iStubElementType = JetStubElementTypes.OBJECT_DECLARATION;
        Intrinsics.checkExpressionValueIsNotNull((Object)iStubElementType, (String)"JetStubElementTypes.OBJECT_DECLARATION");
        super(kotlinClassOrObjectStub, iStubElementType);
    }
}

