/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.codeInsight.CommentUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.JetNodeTypes;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.kdoc.psi.api.KDocElement;
import org.jetbrains.kotlin.lexer.JetToken;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.parsing.JetExpressionParsing;
import org.jetbrains.kotlin.psi.JetAnnotatedExpression;
import org.jetbrains.kotlin.psi.JetAnnotationEntry;
import org.jetbrains.kotlin.psi.JetArrayAccessExpression;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.psi.JetBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetCallExpression;
import org.jetbrains.kotlin.psi.JetCallableDeclaration;
import org.jetbrains.kotlin.psi.JetCatchClause;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassBody;
import org.jetbrains.kotlin.psi.JetClassInitializer;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetConstantExpression;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetDeclarationWithBody;
import org.jetbrains.kotlin.psi.JetDotQualifiedExpression;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetForExpression;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetFunctionLiteral;
import org.jetbrains.kotlin.psi.JetFunctionLiteralExpression;
import org.jetbrains.kotlin.psi.JetIfExpression;
import org.jetbrains.kotlin.psi.JetImportDirective;
import org.jetbrains.kotlin.psi.JetLabelReferenceExpression;
import org.jetbrains.kotlin.psi.JetLabeledExpression;
import org.jetbrains.kotlin.psi.JetModifierList;
import org.jetbrains.kotlin.psi.JetModifierListOwner;
import org.jetbrains.kotlin.psi.JetMultiDeclaration;
import org.jetbrains.kotlin.psi.JetMultiDeclarationEntry;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.psi.JetObjectLiteralExpression;
import org.jetbrains.kotlin.psi.JetOperationExpression;
import org.jetbrains.kotlin.psi.JetPackageDirective;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetParameterList;
import org.jetbrains.kotlin.psi.JetParenthesizedExpression;
import org.jetbrains.kotlin.psi.JetPostfixExpression;
import org.jetbrains.kotlin.psi.JetPrefixExpression;
import org.jetbrains.kotlin.psi.JetPrimaryConstructor;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPropertyAccessor;
import org.jetbrains.kotlin.psi.JetQualifiedExpression;
import org.jetbrains.kotlin.psi.JetReturnExpression;
import org.jetbrains.kotlin.psi.JetScript;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetStatementExpression;
import org.jetbrains.kotlin.psi.JetStringTemplateExpression;
import org.jetbrains.kotlin.psi.JetSuperExpression;
import org.jetbrains.kotlin.psi.JetThisExpression;
import org.jetbrains.kotlin.psi.JetTryExpression;
import org.jetbrains.kotlin.psi.JetTypeElement;
import org.jetbrains.kotlin.psi.JetTypeParameter;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetUnaryExpression;
import org.jetbrains.kotlin.psi.JetUserType;
import org.jetbrains.kotlin.psi.JetValueArgument;
import org.jetbrains.kotlin.psi.JetValueArgumentList;
import org.jetbrains.kotlin.psi.JetVariableDeclaration;
import org.jetbrains.kotlin.psi.JetVisitor;
import org.jetbrains.kotlin.psi.JetVisitorVoid;
import org.jetbrains.kotlin.psi.JetWhenEntry;
import org.jetbrains.kotlin.psi.JetWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilPackage;
import org.jetbrains.kotlin.resolve.ResolvePackage;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

public class JetPsiUtil {
    public static final Predicate<JetElement> ANY_JET_ELEMENT = new Predicate<JetElement>(){

        public boolean apply(@Nullable JetElement input) {
            return true;
        }
    };

    private JetPsiUtil() {
    }

    public static <D> void visitChildren(@NotNull JetElement element2, @NotNull JetVisitor<Void, D> visitor2, D data2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/psi/JetPsiUtil", "visitChildren"));
        }
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/JetPsiUtil", "visitChildren"));
        }
        for (PsiElement child = element2.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof JetElement)) continue;
            ((JetElement)child).accept(visitor2, data2);
        }
    }

    @NotNull
    public static JetExpression safeDeparenthesize(@NotNull JetExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/psi/JetPsiUtil", "safeDeparenthesize"));
        }
        JetExpression jetExpression = JetPsiUtil.safeDeparenthesize(expression2, true);
        if (jetExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetPsiUtil", "safeDeparenthesize"));
        }
        return jetExpression;
    }

    @NotNull
    public static JetExpression safeDeparenthesize(@NotNull JetExpression expression2, boolean deparenthesizeBinaryExpressionWithTypeRHS) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/psi/JetPsiUtil", "safeDeparenthesize"));
        }
        JetExpression deparenthesized = JetPsiUtil.deparenthesize(expression2, deparenthesizeBinaryExpressionWithTypeRHS);
        JetExpression jetExpression = deparenthesized != null ? deparenthesized : expression2;
        if (jetExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetPsiUtil", "safeDeparenthesize"));
        }
        return jetExpression;
    }

    @Nullable
    public static JetExpression deparenthesize(@Nullable JetExpression expression2) {
        return JetPsiUtil.deparenthesize(expression2, true);
    }

    @Nullable
    public static JetExpression deparenthesize(@Nullable JetExpression expression2, boolean deparenthesizeBinaryExpressionWithTypeRHS) {
        return JetPsiUtil.deparenthesizeWithResolutionStrategy(expression2, deparenthesizeBinaryExpressionWithTypeRHS, null);
    }

    @Nullable
    public static JetExpression deparenthesizeOnce(@Nullable JetExpression expression2, boolean deparenthesizeBinaryExpressionWithTypeRHS) {
        return JetPsiUtil.deparenthesizeOnce(expression2, deparenthesizeBinaryExpressionWithTypeRHS, null);
    }

    @Nullable
    public static JetExpression deparenthesizeWithResolutionStrategy(@Nullable JetExpression expression2, @Nullable Function<JetTypeReference, Void> typeResolutionStrategy) {
        return JetPsiUtil.deparenthesizeWithResolutionStrategy(expression2, true, typeResolutionStrategy);
    }

    @Nullable
    private static JetExpression deparenthesizeWithResolutionStrategy(@Nullable JetExpression expression2, boolean deparenthesizeBinaryExpressionWithTypeRHS, @Nullable Function<JetTypeReference, Void> typeResolutionStrategy) {
        JetExpression baseExpression;
        while ((baseExpression = JetPsiUtil.deparenthesizeOnce(expression2, deparenthesizeBinaryExpressionWithTypeRHS, typeResolutionStrategy)) != expression2) {
            expression2 = baseExpression;
        }
        return baseExpression;
    }

    @Nullable
    private static JetExpression deparenthesizeOnce(@Nullable JetExpression expression2, boolean deparenthesizeBinaryExpressionWithTypeRHS, @Nullable Function<JetTypeReference, Void> typeResolutionStrategy) {
        if (deparenthesizeBinaryExpressionWithTypeRHS && expression2 instanceof JetBinaryExpressionWithTypeRHS) {
            JetBinaryExpressionWithTypeRHS binaryExpression = (JetBinaryExpressionWithTypeRHS)expression2;
            JetSimpleNameExpression operationSign = binaryExpression.getOperationReference();
            if (((Object)((Object)JetTokens.COLON)).equals(operationSign.getReferencedNameElementType())) {
                JetTypeReference typeReference = binaryExpression.getRight();
                if (typeResolutionStrategy != null && typeReference != null) {
                    typeResolutionStrategy.apply((Object)typeReference);
                }
                return binaryExpression.getLeft();
            }
            return expression2;
        }
        if (expression2 instanceof JetAnnotatedExpression) {
            return ((JetAnnotatedExpression)expression2).getBaseExpression();
        }
        if (expression2 instanceof JetLabeledExpression) {
            return ((JetLabeledExpression)expression2).getBaseExpression();
        }
        if (expression2 instanceof JetExpressionWrapper) {
            return ((JetExpressionWrapper)((Object)expression2)).getBaseExpression();
        }
        if (expression2 instanceof JetParenthesizedExpression) {
            return ((JetParenthesizedExpression)expression2).getExpression();
        }
        return expression2;
    }

    @NotNull
    public static Name safeName(@Nullable String name2) {
        Name name3 = name2 == null ? SpecialNames.NO_NAME_PROVIDED : Name.identifier(name2);
        if (name3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetPsiUtil", "safeName"));
        }
        return name3;
    }

    @NotNull
    public static Set<JetElement> findRootExpressions(@NotNull Collection<JetElement> unreachableElements) {
        if (unreachableElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unreachableElements", "org/jetbrains/kotlin/psi/JetPsiUtil", "findRootExpressions"));
        }
        HashSet<JetElement> rootElements = new HashSet<JetElement>();
        final HashSet shadowedElements = new HashSet();
        JetVisitorVoid shadowAllChildren = new JetVisitorVoid(){

            @Override
            public void visitJetElement(@NotNull JetElement element2) {
                if (element2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/psi/JetPsiUtil$1", "visitJetElement"));
                }
                if (shadowedElements.add(element2)) {
                    element2.acceptChildren(this);
                }
            }
        };
        for (JetElement element2 : unreachableElements) {
            if (shadowedElements.contains(element2)) continue;
            element2.acceptChildren(shadowAllChildren);
            rootElements.removeAll(shadowedElements);
            rootElements.add(element2);
        }
        HashSet<JetElement> hashSet = rootElements;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetPsiUtil", "findRootExpressions"));
        }
        return hashSet;
    }

    @NotNull
    public static String unquoteIdentifier(@NotNull String quoted) {
        if (quoted == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quoted", "org/jetbrains/kotlin/psi/JetPsiUtil", "unquoteIdentifier"));
        }
        if (quoted.indexOf(96) < 0) {
            String string = quoted;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetPsiUtil", "unquoteIdentifier"));
            }
            return string;
        }
        if (quoted.startsWith("`") && quoted.endsWith("`") && quoted.length() >= 2) {
            String string = quoted.substring(1, quoted.length() - 1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetPsiUtil", "unquoteIdentifier"));
            }
            return string;
        }
        String string = quoted;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetPsiUtil", "unquoteIdentifier"));
        }
        return string;
    }

    @NotNull
    public static String unquoteIdentifierOrFieldReference(@NotNull String quoted) {
        if (quoted == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quoted", "org/jetbrains/kotlin/psi/JetPsiUtil", "unquoteIdentifierOrFieldReference"));
        }
        if (quoted.indexOf(96) < 0) {
            String string = quoted;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetPsiUtil", "unquoteIdentifierOrFieldReference"));
            }
            return string;
        }
        if (quoted.startsWith("$")) {
            String string = "$" + JetPsiUtil.unquoteIdentifier(quoted.substring(1));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetPsiUtil", "unquoteIdentifierOrFieldReference"));
            }
            return string;
        }
        String string = JetPsiUtil.unquoteIdentifier(quoted);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetPsiUtil", "unquoteIdentifierOrFieldReference"));
        }
        return string;
    }

    @Nullable
    public static FqName toQualifiedName(@NotNull JetUserType userType) {
        if (userType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userType", "org/jetbrains/kotlin/psi/JetPsiUtil", "toQualifiedName"));
        }
        ArrayList reversedNames = Lists.newArrayList();
        for (JetUserType current = userType; current != null; current = current.getQualifier()) {
            String name2 = current.getReferencedName();
            if (name2 == null) {
                return null;
            }
            reversedNames.add(name2);
        }
        return FqName.fromSegments(ContainerUtil.reverse((List)reversedNames));
    }

    @Nullable
    public static Name getShortName(@NotNull JetAnnotationEntry annotation2) {
        JetUserType userType;
        String shortName;
        if (annotation2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/kotlin/psi/JetPsiUtil", "getShortName"));
        }
        JetTypeReference typeReference = annotation2.getTypeReference();
        assert (typeReference != null) : "Annotation entry hasn't typeReference " + annotation2.getText();
        JetTypeElement typeElement = typeReference.getTypeElement();
        if (typeElement instanceof JetUserType && (shortName = (userType = (JetUserType)typeElement).getReferencedName()) != null) {
            return Name.identifier(shortName);
        }
        return null;
    }

    public static boolean isDeprecated(@NotNull JetModifierListOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/psi/JetPsiUtil", "isDeprecated"));
        }
        JetModifierList modifierList = owner.getModifierList();
        if (modifierList != null) {
            List<JetAnnotationEntry> annotationEntries = modifierList.getAnnotationEntries();
            for (JetAnnotationEntry annotation2 : annotationEntries) {
                Name shortName = JetPsiUtil.getShortName(annotation2);
                if (!KotlinBuiltIns.FQ_NAMES.deprecated.shortName().equals(shortName)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static <T extends PsiElement> T getDirectParentOfTypeForBlock(@NotNull JetBlockExpression block, @NotNull Class<T> aClass) {
        JetFunctionLiteral functionLiteral;
        JetIfExpression ifExpression2;
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/kotlin/psi/JetPsiUtil", "getDirectParentOfTypeForBlock"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/psi/JetPsiUtil", "getDirectParentOfTypeForBlock"));
        }
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)block, aClass);
        if (parent instanceof JetIfExpression && ((ifExpression2 = (JetIfExpression)parent).getElse() == block || ifExpression2.getThen() == block)) {
            return (T)parent;
        }
        if (parent instanceof JetWhenExpression) {
            JetWhenExpression whenExpression2 = (JetWhenExpression)parent;
            for (JetWhenEntry whenEntry : whenExpression2.getEntries()) {
                if (whenEntry.getExpression() != block) continue;
                return (T)parent;
            }
        }
        if (parent instanceof JetFunctionLiteral && (functionLiteral = (JetFunctionLiteral)parent).getBodyExpression() == block) {
            return (T)parent;
        }
        if (parent instanceof JetTryExpression) {
            JetTryExpression tryExpression = (JetTryExpression)parent;
            if (tryExpression.getTryBlock() == block) {
                return (T)parent;
            }
            for (JetCatchClause clause : tryExpression.getCatchClauses()) {
                if (clause.getCatchBody() != block) continue;
                return (T)parent;
            }
        }
        return null;
    }

    @Nullable
    public static Name getAliasName(@NotNull JetImportDirective importDirective) {
        if (importDirective == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importDirective", "org/jetbrains/kotlin/psi/JetPsiUtil", "getAliasName"));
        }
        String aliasName = importDirective.getAliasName();
        JetExpression importedReference = importDirective.getImportedReference();
        if (importedReference == null) {
            return null;
        }
        JetSimpleNameExpression referenceExpression = JetPsiUtil.getLastReference(importedReference);
        if (aliasName == null) {
            aliasName = referenceExpression != null ? referenceExpression.getReferencedName() : null;
        }
        return aliasName != null && !aliasName.isEmpty() ? Name.identifier(aliasName) : null;
    }

    @Nullable
    public static JetSimpleNameExpression getLastReference(@NotNull JetExpression importedReference) {
        if (importedReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importedReference", "org/jetbrains/kotlin/psi/JetPsiUtil", "getLastReference"));
        }
        JetElement selector = PsiUtilPackage.getQualifiedElementSelector(importedReference);
        return selector instanceof JetSimpleNameExpression ? (JetSimpleNameExpression)selector : null;
    }

    public static boolean isSelectorInQualified(@NotNull JetSimpleNameExpression nameExpression) {
        if (nameExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameExpression", "org/jetbrains/kotlin/psi/JetPsiUtil", "isSelectorInQualified"));
        }
        JetElement qualifiedElement = PsiUtilPackage.getQualifiedElement(nameExpression);
        return qualifiedElement instanceof JetQualifiedExpression || qualifiedElement instanceof JetUserType && ((JetUserType)qualifiedElement).getQualifier() != null;
    }

    public static boolean isLHSOfDot(@NotNull JetExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/psi/JetPsiUtil", "isLHSOfDot"));
        }
        PsiElement parent = expression2.getParent();
        if (!(parent instanceof JetQualifiedExpression)) {
            return false;
        }
        JetQualifiedExpression qualifiedParent = (JetQualifiedExpression)parent;
        return qualifiedParent.getReceiverExpression() == expression2 || JetPsiUtil.isLHSOfDot(qualifiedParent);
    }

    public static boolean isScriptDeclaration(@NotNull JetDeclaration namedDeclaration) {
        if (namedDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedDeclaration", "org/jetbrains/kotlin/psi/JetPsiUtil", "isScriptDeclaration"));
        }
        return JetPsiUtil.getScript(namedDeclaration) != null;
    }

    @Nullable
    public static JetScript getScript(@NotNull JetDeclaration namedDeclaration) {
        if (namedDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedDeclaration", "org/jetbrains/kotlin/psi/JetPsiUtil", "getScript"));
        }
        PsiElement parent = namedDeclaration.getParent();
        if (parent != null && parent.getParent() instanceof JetScript) {
            return (JetScript)parent.getParent();
        }
        return null;
    }

    public static boolean isVariableNotParameterDeclaration(@NotNull JetDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/psi/JetPsiUtil", "isVariableNotParameterDeclaration"));
        }
        if (!(declaration instanceof JetVariableDeclaration)) {
            return false;
        }
        if (declaration instanceof JetProperty) {
            return true;
        }
        assert (declaration instanceof JetMultiDeclarationEntry);
        JetMultiDeclarationEntry multiDeclarationEntry = (JetMultiDeclarationEntry)declaration;
        return !(multiDeclarationEntry.getParent().getParent() instanceof JetForExpression);
    }

    @Nullable
    public static Name getConventionName(@NotNull JetSimpleNameExpression simpleNameExpression) {
        IElementType elementType;
        if (simpleNameExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "simpleNameExpression", "org/jetbrains/kotlin/psi/JetPsiUtil", "getConventionName"));
        }
        if (simpleNameExpression.getIdentifier() != null) {
            return simpleNameExpression.getReferencedNameAsName();
        }
        PsiElement firstChild = simpleNameExpression.getFirstChild();
        if (firstChild != null && (elementType = firstChild.getNode().getElementType()) instanceof JetToken) {
            JetToken jetToken = (JetToken)elementType;
            return OperatorConventions.getNameForOperationSymbol(jetToken);
        }
        return null;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    public static PsiElement getTopmostParentOfTypes(@Nullable PsiElement element2, Class<? extends PsiElement> ... parentTypes) {
        PsiElement next2;
        if (parentTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentTypes", "org/jetbrains/kotlin/psi/JetPsiUtil", "getTopmostParentOfTypes"));
        }
        if (element2 instanceof PsiFile) {
            return null;
        }
        PsiElement answer = PsiTreeUtil.getParentOfType((PsiElement)element2, (Class[])parentTypes);
        if (answer instanceof PsiFile) {
            return answer;
        }
        while ((next2 = PsiTreeUtil.getParentOfType((PsiElement)answer, (Class[])parentTypes)) != null) {
            answer = next2;
        }
        return answer;
    }

    public static boolean isNullConstant(@NotNull JetExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/psi/JetPsiUtil", "isNullConstant"));
        }
        JetExpression deparenthesized = JetPsiUtil.deparenthesize(expression2);
        return deparenthesized instanceof JetConstantExpression && deparenthesized.getNode().getElementType() == JetNodeTypes.NULL;
    }

    public static boolean isTrueConstant(@Nullable JetExpression condition2) {
        return condition2 != null && condition2.getNode().getElementType() == JetNodeTypes.BOOLEAN_CONSTANT && condition2.getNode().findChildByType((IElementType)JetTokens.TRUE_KEYWORD) != null;
    }

    public static boolean isAbstract(@NotNull JetDeclarationWithBody declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/psi/JetPsiUtil", "isAbstract"));
        }
        return declaration.getBodyExpression() == null;
    }

    public static boolean isBackingFieldReference(@NotNull JetSimpleNameExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/psi/JetPsiUtil", "isBackingFieldReference"));
        }
        return expression2.getReferencedNameElementType() == JetTokens.FIELD_IDENTIFIER;
    }

    public static boolean isBackingFieldReference(@Nullable JetElement element2) {
        return element2 instanceof JetSimpleNameExpression && JetPsiUtil.isBackingFieldReference((JetSimpleNameExpression)element2);
    }

    @Nullable
    public static JetExpression getExpressionOrLastStatementInBlock(@Nullable JetExpression expression2) {
        if (expression2 instanceof JetBlockExpression) {
            return JetPsiUtil.getLastStatementInABlock((JetBlockExpression)expression2);
        }
        return expression2;
    }

    @Nullable
    public static JetExpression getLastStatementInABlock(@Nullable JetBlockExpression blockExpression) {
        if (blockExpression == null) {
            return null;
        }
        List<JetExpression> statements = blockExpression.getStatements();
        return statements.isEmpty() ? null : statements.get(statements.size() - 1);
    }

    public static boolean isTrait(@NotNull JetClassOrObject classOrObject) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/psi/JetPsiUtil", "isTrait"));
        }
        return classOrObject instanceof JetClass && ((JetClass)classOrObject).isInterface();
    }

    @Nullable
    public static JetClassOrObject getOutermostClassOrObject(@NotNull JetClassOrObject classOrObject) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/psi/JetPsiUtil", "getOutermostClassOrObject"));
        }
        JetClassOrObject current = classOrObject;
        while (true) {
            PsiElement parent = current.getParent();
            assert (classOrObject.getParent() != null) : "Class with no parent: " + classOrObject.getText();
            if (parent instanceof PsiFile) {
                return current;
            }
            if (!(parent instanceof JetClassBody)) {
                return current;
            }
            current = (JetClassOrObject)parent.getParent();
        }
    }

    @Nullable
    public static JetClassOrObject getClassIfParameterIsProperty(@NotNull JetParameter jetParameter) {
        PsiElement grandParent;
        if (jetParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetParameter", "org/jetbrains/kotlin/psi/JetPsiUtil", "getClassIfParameterIsProperty"));
        }
        if (jetParameter.hasValOrVar() && (grandParent = jetParameter.getParent().getParent()) instanceof JetPrimaryConstructor) {
            return ((JetPrimaryConstructor)grandParent).getContainingClassOrObject();
        }
        return null;
    }

    @Nullable
    private static IElementType getOperation(@NotNull JetExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/psi/JetPsiUtil", "getOperation"));
        }
        if (expression2 instanceof JetQualifiedExpression) {
            return ((JetQualifiedExpression)expression2).getOperationSign();
        }
        if (expression2 instanceof JetOperationExpression) {
            return ((JetOperationExpression)expression2).getOperationReference().getReferencedNameElementType();
        }
        return null;
    }

    private static int getPriority(@NotNull JetExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/psi/JetPsiUtil", "getPriority"));
        }
        int maxPriority = JetExpressionParsing.Precedence.values().length + 1;
        if (expression2 instanceof JetPostfixExpression || expression2 instanceof JetQualifiedExpression || expression2 instanceof JetCallExpression || expression2 instanceof JetArrayAccessExpression) {
            return maxPriority - 1;
        }
        if (expression2 instanceof JetPrefixExpression || expression2 instanceof JetLabeledExpression) {
            return maxPriority - 2;
        }
        if (expression2 instanceof JetIfExpression) {
            return JetExpressionParsing.Precedence.ASSIGNMENT.ordinal();
        }
        if (expression2 instanceof JetSuperExpression) {
            return maxPriority;
        }
        if (expression2 instanceof JetDeclaration || expression2 instanceof JetStatementExpression) {
            return 0;
        }
        IElementType operation = JetPsiUtil.getOperation(expression2);
        for (JetExpressionParsing.Precedence precedence : JetExpressionParsing.Precedence.values()) {
            if (precedence == JetExpressionParsing.Precedence.PREFIX || precedence == JetExpressionParsing.Precedence.POSTFIX || !precedence.getOperations().contains(operation)) continue;
            return maxPriority - precedence.ordinal() - 1;
        }
        return maxPriority;
    }

    public static boolean areParenthesesUseless(@NotNull JetParenthesizedExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/psi/JetPsiUtil", "areParenthesesUseless"));
        }
        JetExpression innerExpression = expression2.getExpression();
        if (innerExpression == null) {
            return true;
        }
        PsiElement parent = expression2.getParent();
        if (!(parent instanceof JetExpression)) {
            return true;
        }
        return !JetPsiUtil.areParenthesesNecessary(innerExpression, expression2, (JetExpression)parent);
    }

    public static boolean areParenthesesNecessary(@NotNull JetExpression innerExpression, @NotNull JetExpression currentInner, @NotNull JetExpression parentExpression) {
        int parentPriority;
        if (innerExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerExpression", "org/jetbrains/kotlin/psi/JetPsiUtil", "areParenthesesNecessary"));
        }
        if (currentInner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentInner", "org/jetbrains/kotlin/psi/JetPsiUtil", "areParenthesesNecessary"));
        }
        if (parentExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentExpression", "org/jetbrains/kotlin/psi/JetPsiUtil", "areParenthesesNecessary"));
        }
        if (parentExpression instanceof JetParenthesizedExpression || innerExpression instanceof JetParenthesizedExpression) {
            return false;
        }
        if (parentExpression instanceof JetPackageDirective) {
            return false;
        }
        if (parentExpression instanceof JetWhenExpression || innerExpression instanceof JetWhenExpression) {
            return false;
        }
        if (innerExpression instanceof JetIfExpression) {
            JetExpression current = parentExpression;
            while (!(current instanceof JetBlockExpression || current instanceof JetDeclaration || current instanceof JetStatementExpression)) {
                if (current.getTextRange().getEndOffset() != currentInner.getTextRange().getEndOffset()) {
                    return current.getText().charAt(current.getTextLength() - 1) != ')';
                }
                current = current.getParent();
            }
        }
        if (parentExpression instanceof JetCallExpression && currentInner == ((JetCallExpression)parentExpression).getCalleeExpression()) {
            if (innerExpression instanceof JetSimpleNameExpression) {
                return false;
            }
            if (PsiUtilPackage.getQualifiedExpressionForSelector(parentExpression) != null) {
                return true;
            }
            return !(innerExpression instanceof JetThisExpression) && !(innerExpression instanceof JetArrayAccessExpression) && !(innerExpression instanceof JetConstantExpression) && !(innerExpression instanceof JetStringTemplateExpression) && !(innerExpression instanceof JetCallExpression);
        }
        IElementType innerOperation = JetPsiUtil.getOperation(innerExpression);
        IElementType parentOperation = JetPsiUtil.getOperation(parentExpression);
        if (parentExpression instanceof JetReturnExpression && (innerExpression instanceof JetLabeledExpression || innerExpression instanceof JetAnnotatedExpression)) {
            return true;
        }
        if (innerExpression instanceof JetBinaryExpressionWithTypeRHS && parentOperation == JetTokens.LT) {
            return true;
        }
        if (parentExpression instanceof JetLabeledExpression) {
            return false;
        }
        if (parentExpression instanceof JetBinaryExpression && parentOperation == JetTokens.ELVIS && currentInner == ((JetBinaryExpression)parentExpression).getRight()) {
            return false;
        }
        int innerPriority = JetPsiUtil.getPriority(innerExpression);
        if (innerPriority == (parentPriority = JetPsiUtil.getPriority(parentExpression))) {
            if (parentExpression instanceof JetBinaryExpression) {
                if (innerOperation == JetTokens.ANDAND || innerOperation == JetTokens.OROR) {
                    return false;
                }
                return ((JetBinaryExpression)parentExpression).getRight() == currentInner;
            }
            if (parentExpression instanceof JetPrefixExpression && innerExpression instanceof JetPrefixExpression) {
                return innerOperation == parentOperation && (innerOperation == JetTokens.PLUS || innerOperation == JetTokens.MINUS);
            }
            return false;
        }
        return innerPriority < parentPriority;
    }

    public static boolean isAssignment(@NotNull PsiElement element2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/psi/JetPsiUtil", "isAssignment"));
        }
        return element2 instanceof JetBinaryExpression && JetTokens.ALL_ASSIGNMENTS.contains(((JetBinaryExpression)element2).getOperationToken());
    }

    public static boolean isOrdinaryAssignment(@NotNull PsiElement element2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/psi/JetPsiUtil", "isOrdinaryAssignment"));
        }
        return element2 instanceof JetBinaryExpression && ((JetBinaryExpression)element2).getOperationToken().equals((Object)JetTokens.EQ);
    }

    public static boolean checkVariableDeclarationInBlock(@NotNull JetBlockExpression block, @NotNull String varName) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/kotlin/psi/JetPsiUtil", "checkVariableDeclarationInBlock"));
        }
        if (varName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "varName", "org/jetbrains/kotlin/psi/JetPsiUtil", "checkVariableDeclarationInBlock"));
        }
        for (JetExpression element2 : block.getStatements()) {
            if (!(element2 instanceof JetVariableDeclaration) || !((JetVariableDeclaration)element2).getNameAsSafeName().asString().equals(varName)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkWhenExpressionHasSingleElse(@NotNull JetWhenExpression whenExpression2) {
        if (whenExpression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whenExpression", "org/jetbrains/kotlin/psi/JetPsiUtil", "checkWhenExpressionHasSingleElse"));
        }
        int elseCount = 0;
        for (JetWhenEntry entry : whenExpression2.getEntries()) {
            if (!entry.isElse()) continue;
            ++elseCount;
        }
        return elseCount == 1;
    }

    @Nullable
    public static PsiElement skipTrailingWhitespacesAndComments(@Nullable PsiElement element2) {
        return PsiTreeUtil.skipSiblingsForward((PsiElement)element2, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class});
    }

    @NotNull
    public static String getText(@Nullable PsiElement element2) {
        String string = element2 != null ? element2.getText() : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetPsiUtil", "getText"));
        }
        return string;
    }

    @Nullable
    public static String getNullableText(@Nullable PsiElement element2) {
        return element2 != null ? element2.getText() : null;
    }

    public static boolean isInComment(PsiElement element2) {
        return CommentUtilCore.isComment((PsiElement)element2) || element2 instanceof KDocElement;
    }

    @Nullable
    public static PsiElement getOutermostParent(@NotNull PsiElement element2, @NotNull PsiElement upperBound, boolean strict) {
        PsiElement parent;
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/psi/JetPsiUtil", "getOutermostParent"));
        }
        if (upperBound == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "upperBound", "org/jetbrains/kotlin/psi/JetPsiUtil", "getOutermostParent"));
        }
        PsiElement psiElement2 = parent = strict ? element2.getParent() : element2;
        while (parent != null && parent.getParent() != upperBound) {
            parent = parent.getParent();
        }
        return parent;
    }

    public static <T extends PsiElement> T getLastChildByType(@NotNull PsiElement root, Class<? extends T> ... elementTypes) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/psi/JetPsiUtil", "getLastChildByType"));
        }
        if (elementTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementTypes", "org/jetbrains/kotlin/psi/JetPsiUtil", "getLastChildByType"));
        }
        PsiElement[] children2 = root.getChildren();
        for (int i = children2.length - 1; i >= 0; --i) {
            if (!PsiTreeUtil.instanceOf((Object)children2[i], (Class[])elementTypes)) continue;
            return (T)children2[i];
        }
        return null;
    }

    @Nullable
    public static JetElement getOutermostDescendantElement(@Nullable PsiElement root, boolean first, final @NotNull Predicate<JetElement> predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predicate", "org/jetbrains/kotlin/psi/JetPsiUtil", "getOutermostDescendantElement"));
        }
        if (!(root instanceof JetElement)) {
            return null;
        }
        final ArrayList results2 = Lists.newArrayList();
        root.accept((PsiElementVisitor)new JetVisitorVoid(){

            @Override
            public void visitJetElement(@NotNull JetElement element2) {
                if (element2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/psi/JetPsiUtil$3", "visitJetElement"));
                }
                if (predicate.apply((Object)element2)) {
                    results2.add(element2);
                } else {
                    element2.acceptChildren(this);
                }
            }
        });
        if (results2.isEmpty()) {
            return null;
        }
        return first ? (JetElement)results2.get(0) : (JetElement)results2.get(results2.size() - 1);
    }

    @Nullable
    public static PsiElement findChildByType(@NotNull PsiElement element2, @NotNull IElementType type2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/psi/JetPsiUtil", "findChildByType"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/psi/JetPsiUtil", "findChildByType"));
        }
        ASTNode node = element2.getNode().findChildByType(type2);
        return node == null ? null : node.getPsi();
    }

    @Nullable
    public static PsiElement skipSiblingsBackwardByPredicate(@Nullable PsiElement element2, Predicate<PsiElement> elementsToSkip) {
        if (element2 == null) {
            return null;
        }
        for (PsiElement e = element2.getPrevSibling(); e != null; e = e.getPrevSibling()) {
            if (elementsToSkip.apply((Object)e)) continue;
            return e;
        }
        return null;
    }

    public static PsiElement ascendIfPropertyAccessor(PsiElement element2) {
        if (element2 instanceof JetPropertyAccessor) {
            return element2.getParent();
        }
        return element2;
    }

    @Nullable
    public static JetModifierList replaceModifierList(@NotNull JetModifierListOwner owner, @Nullable JetModifierList modifierList) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/kotlin/psi/JetPsiUtil", "replaceModifierList"));
        }
        JetModifierList oldModifierList = owner.getModifierList();
        if (modifierList == null) {
            if (oldModifierList != null) {
                oldModifierList.delete();
            }
            return null;
        }
        if (oldModifierList == null) {
            PsiElement firstChild = owner.getFirstChild();
            return (JetModifierList)owner.addBefore((PsiElement)modifierList, firstChild);
        }
        return (JetModifierList)oldModifierList.replace((PsiElement)modifierList);
    }

    @Nullable
    public static String getPackageName(@NotNull JetElement element2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/psi/JetPsiUtil", "getPackageName"));
        }
        JetFile file = element2.getContainingJetFile();
        JetPackageDirective header = (JetPackageDirective)PsiTreeUtil.findChildOfType((PsiElement)file, JetPackageDirective.class);
        return header != null ? header.getQualifiedName() : null;
    }

    @Nullable
    public static JetElement getEnclosingElementForLocalDeclaration(@NotNull JetDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/psi/JetPsiUtil", "getEnclosingElementForLocalDeclaration"));
        }
        return JetPsiUtil.getEnclosingElementForLocalDeclaration(declaration, true);
    }

    private static boolean isMemberOfObjectExpression(@NotNull JetCallableDeclaration propertyOrFunction) {
        if (propertyOrFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyOrFunction", "org/jetbrains/kotlin/psi/JetPsiUtil", "isMemberOfObjectExpression"));
        }
        PsiElement parent = PsiTreeUtil.getStubOrPsiParent((PsiElement)propertyOrFunction);
        if (!(parent instanceof JetClassBody)) {
            return false;
        }
        PsiElement grandparent = PsiTreeUtil.getStubOrPsiParent((PsiElement)parent);
        if (!(grandparent instanceof JetObjectDeclaration)) {
            return false;
        }
        return PsiTreeUtil.getStubOrPsiParent((PsiElement)grandparent) instanceof JetObjectLiteralExpression;
    }

    @Nullable
    public static JetElement getEnclosingElementForLocalDeclaration(@NotNull JetDeclaration declaration, boolean skipParameters) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/psi/JetPsiUtil", "getEnclosingElementForLocalDeclaration"));
        }
        if (declaration instanceof JetTypeParameter && skipParameters) {
            declaration = (JetDeclaration)PsiTreeUtil.getParentOfType((PsiElement)declaration, JetNamedDeclaration.class);
        } else if (declaration instanceof JetParameter) {
            PsiElement parent = declaration.getParent();
            if (((JetParameter)declaration).hasValOrVar() && parent != null && parent.getParent() instanceof JetPrimaryConstructor) {
                return JetPsiUtil.getEnclosingElementForLocalDeclaration(((JetPrimaryConstructor)parent.getParent()).getContainingClassOrObject(), skipParameters);
            }
            if (skipParameters && parent != null && parent.getParent() instanceof JetNamedFunction) {
                declaration = (JetNamedFunction)parent.getParent();
            }
        }
        if (declaration instanceof PsiFile) {
            return declaration;
        }
        PsiElement current = PsiTreeUtil.getStubOrPsiParent((PsiElement)declaration);
        while (current != null) {
            PsiElement parent = PsiTreeUtil.getStubOrPsiParent((PsiElement)current);
            if (parent instanceof JetScript) {
                return null;
            }
            if (current instanceof JetClassInitializer) {
                return ((JetClassInitializer)current).getBody();
            }
            if (current instanceof JetProperty || current instanceof JetFunction) {
                if (parent instanceof JetFile) {
                    return (JetElement)current;
                }
                if (parent instanceof JetClassBody && !JetPsiUtil.isMemberOfObjectExpression((JetCallableDeclaration)current)) {
                    return (JetElement)parent;
                }
            }
            if (current instanceof JetBlockExpression || current instanceof JetParameter) {
                return (JetElement)current;
            }
            current = parent;
        }
        return null;
    }

    public static boolean isLocal(@NotNull JetDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/psi/JetPsiUtil", "isLocal"));
        }
        return JetPsiUtil.getEnclosingElementForLocalDeclaration(declaration) != null;
    }

    @Nullable
    public static JetToken getOperationToken(@NotNull JetOperationExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/psi/JetPsiUtil", "getOperationToken"));
        }
        JetSimpleNameExpression operationExpression = expression2.getOperationReference();
        IElementType elementType = operationExpression.getReferencedNameElementType();
        assert (elementType == null || elementType instanceof JetToken) : "JetOperationExpression should have operation token of type JetToken: " + expression2;
        return (JetToken)elementType;
    }

    public static boolean isLabelIdentifierExpression(PsiElement element2) {
        return element2 instanceof JetLabelReferenceExpression;
    }

    @Nullable
    public static JetExpression getParentCallIfPresent(@NotNull JetExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/psi/JetPsiUtil", "getParentCallIfPresent"));
        }
        PsiElement parent = expression2.getParent();
        while (parent != null) {
            if (parent instanceof JetBinaryExpression || parent instanceof JetUnaryExpression || parent instanceof JetLabeledExpression || parent instanceof JetDotQualifiedExpression || parent instanceof JetCallExpression || parent instanceof JetArrayAccessExpression || parent instanceof JetMultiDeclaration) {
                if (parent instanceof JetLabeledExpression) {
                    parent = parent.getParent();
                    continue;
                }
                return (JetExpression)parent;
            }
            if (parent instanceof JetParenthesizedExpression || parent instanceof JetBinaryExpressionWithTypeRHS) {
                parent = parent.getParent();
                continue;
            }
            if (parent instanceof JetValueArgument || parent instanceof JetValueArgumentList) {
                parent = parent.getParent();
                continue;
            }
            if (parent instanceof JetFunctionLiteralExpression) {
                parent = parent.getParent();
                continue;
            }
            return null;
        }
        return null;
    }

    public static boolean isDeprecatedLambdaSyntax(@NotNull JetFunctionLiteralExpression functionLiteralExpression) {
        if (functionLiteralExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionLiteralExpression", "org/jetbrains/kotlin/psi/JetPsiUtil", "isDeprecatedLambdaSyntax"));
        }
        JetFunctionLiteral functionLiteral = functionLiteralExpression.getFunctionLiteral();
        if (functionLiteral.hasDeclaredReturnType() || functionLiteral.getReceiverTypeReference() != null) {
            return true;
        }
        JetParameterList valueParameterList = functionLiteral.getValueParameterList();
        return valueParameterList != null && valueParameterList.isParenthesized();
    }

    @Nullable
    public static JetExpression getLastElementDeparenthesized(@Nullable JetExpression expression2, @NotNull StatementFilter statementFilter) {
        JetBlockExpression blockExpression;
        JetExpression lastStatementInABlock;
        if (statementFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statementFilter", "org/jetbrains/kotlin/psi/JetPsiUtil", "getLastElementDeparenthesized"));
        }
        JetExpression deparenthesizedExpression = JetPsiUtil.deparenthesize(expression2, false);
        if (deparenthesizedExpression instanceof JetBlockExpression && (lastStatementInABlock = ResolvePackage.getLastStatementInABlock(statementFilter, blockExpression = (JetBlockExpression)deparenthesizedExpression)) != null) {
            return JetPsiUtil.getLastElementDeparenthesized(lastStatementInABlock, statementFilter);
        }
        return deparenthesizedExpression;
    }

    public static interface JetExpressionWrapper {
        public JetExpression getBaseExpression();
    }
}

