/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.cfg.JetFlowInformationProvider;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclarationContainer;
import org.jetbrains.kotlin.psi.JetDeclarationWithBody;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPropertyAccessor;
import org.jetbrains.kotlin.psi.JetSecondaryConstructor;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodiesResolveContext;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeUtils;

public class ControlFlowAnalyzer {
    @NotNull
    private final BindingTrace trace;
    @NotNull
    private final KotlinBuiltIns builtIns;

    public ControlFlowAnalyzer(@NotNull BindingTrace trace, @NotNull KotlinBuiltIns builtIns) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/ControlFlowAnalyzer", "<init>"));
        }
        if (builtIns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builtIns", "org/jetbrains/kotlin/resolve/ControlFlowAnalyzer", "<init>"));
        }
        this.trace = trace;
        this.builtIns = builtIns;
    }

    public void process(@NotNull BodiesResolveContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/ControlFlowAnalyzer", "process"));
        }
        for (JetFile jetFile : c.getFiles()) {
            this.checkDeclarationContainer(c, jetFile);
        }
        for (JetClassOrObject jetClassOrObject : c.getDeclaredClasses().keySet()) {
            this.checkDeclarationContainer(c, jetClassOrObject);
        }
        for (JetSecondaryConstructor jetSecondaryConstructor : c.getSecondaryConstructors().keySet()) {
            this.checkSecondaryConstructor(jetSecondaryConstructor);
        }
        for (Map.Entry entry : c.getFunctions().entrySet()) {
            JetNamedFunction function2 = (JetNamedFunction)entry.getKey();
            SimpleFunctionDescriptor functionDescriptor = (SimpleFunctionDescriptor)entry.getValue();
            JetType expectedReturnType = !function2.hasBlockBody() && !function2.hasDeclaredReturnType() ? TypeUtils.NO_EXPECTED_TYPE : functionDescriptor.getReturnType();
            this.checkFunction(c, function2, expectedReturnType);
        }
        for (Map.Entry entry : c.getProperties().entrySet()) {
            JetProperty property = (JetProperty)entry.getKey();
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)entry.getValue();
            this.checkProperty(c, property, propertyDescriptor);
        }
    }

    private void checkSecondaryConstructor(@NotNull JetSecondaryConstructor constructor) {
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/kotlin/resolve/ControlFlowAnalyzer", "checkSecondaryConstructor"));
        }
        JetFlowInformationProvider flowInformationProvider = new JetFlowInformationProvider(constructor, this.trace);
        flowInformationProvider.checkDeclaration();
        flowInformationProvider.checkFunction(this.builtIns.getUnitType());
    }

    private void checkDeclarationContainer(@NotNull BodiesResolveContext c, JetDeclarationContainer declarationContainer) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/ControlFlowAnalyzer", "checkDeclarationContainer"));
        }
        JetFlowInformationProvider flowInformationProvider = new JetFlowInformationProvider((JetElement)((Object)declarationContainer), this.trace);
        if (c.getTopDownAnalysisMode().getIsLocalDeclarations()) {
            flowInformationProvider.checkForLocalClassOrObjectMode();
            return;
        }
        flowInformationProvider.checkDeclaration();
    }

    private void checkProperty(@NotNull BodiesResolveContext c, JetProperty property, PropertyDescriptor propertyDescriptor) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/ControlFlowAnalyzer", "checkProperty"));
        }
        for (JetPropertyAccessor accessor : property.getAccessors()) {
            PropertyAccessorDescriptor accessorDescriptor;
            PropertyAccessorDescriptor propertyAccessorDescriptor = accessorDescriptor = accessor.isGetter() ? propertyDescriptor.getGetter() : propertyDescriptor.getSetter();
            assert (accessorDescriptor != null) : "no property accessor descriptor " + accessor.getText();
            JetType returnType2 = accessorDescriptor.getReturnType();
            this.checkFunction(c, accessor, returnType2);
        }
    }

    private void checkFunction(@NotNull BodiesResolveContext c, @NotNull JetDeclarationWithBody function2, @Nullable JetType expectedReturnType) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/ControlFlowAnalyzer", "checkFunction"));
        }
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/resolve/ControlFlowAnalyzer", "checkFunction"));
        }
        if (!function2.hasBody()) {
            return;
        }
        JetFlowInformationProvider flowInformationProvider = new JetFlowInformationProvider(function2, this.trace);
        if (c.getTopDownAnalysisMode().getIsLocalDeclarations()) {
            flowInformationProvider.checkForLocalClassOrObjectMode();
            return;
        }
        flowInformationProvider.checkDeclaration();
        flowInformationProvider.checkFunction(expectedReturnType);
    }
}

