/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.platform.PlatformToKotlinClassMap;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetImportDirective;
import org.jetbrains.kotlin.resolve.BindingTrace;

public class PlatformTypesMappedToKotlinChecker {
    public static void checkPlatformTypesMappedToKotlin(@NotNull ModuleDescriptor module, @NotNull BindingTrace trace, @NotNull JetImportDirective importDirective, @NotNull Collection<? extends DeclarationDescriptor> descriptors) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/resolve/PlatformTypesMappedToKotlinChecker", "checkPlatformTypesMappedToKotlin"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/PlatformTypesMappedToKotlinChecker", "checkPlatformTypesMappedToKotlin"));
        }
        if (importDirective == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importDirective", "org/jetbrains/kotlin/resolve/PlatformTypesMappedToKotlinChecker", "checkPlatformTypesMappedToKotlin"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/kotlin/resolve/PlatformTypesMappedToKotlinChecker", "checkPlatformTypesMappedToKotlin"));
        }
        JetExpression importedReference = importDirective.getImportedReference();
        if (importedReference != null) {
            for (DeclarationDescriptor declarationDescriptor : descriptors) {
                PlatformTypesMappedToKotlinChecker.reportPlatformClassMappedToKotlin(module, trace, importedReference, declarationDescriptor);
            }
        }
    }

    public static void reportPlatformClassMappedToKotlin(@NotNull ModuleDescriptor module, @NotNull BindingTrace trace, @NotNull JetElement element2, @NotNull DeclarationDescriptor descriptor2) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/resolve/PlatformTypesMappedToKotlinChecker", "reportPlatformClassMappedToKotlin"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/PlatformTypesMappedToKotlinChecker", "reportPlatformClassMappedToKotlin"));
        }
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/resolve/PlatformTypesMappedToKotlinChecker", "reportPlatformClassMappedToKotlin"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/PlatformTypesMappedToKotlinChecker", "reportPlatformClassMappedToKotlin"));
        }
        if (!(descriptor2 instanceof ClassDescriptor)) {
            return;
        }
        PlatformToKotlinClassMap platformToKotlinMap = module.getPlatformToKotlinClassMap();
        Collection<ClassDescriptor> kotlinAnalogsForClass = platformToKotlinMap.mapPlatformClass((ClassDescriptor)descriptor2);
        if (!kotlinAnalogsForClass.isEmpty()) {
            trace.report(Errors.PLATFORM_CLASS_MAPPED_TO_KOTLIN.on(element2, kotlinAnalogsForClass));
        }
    }
}

