/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Mutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetImportDirective;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetUserType;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ImportDirectiveProcessor;
import org.jetbrains.kotlin.resolve.scopes.AbstractScopeAdapter;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.validation.SymbolUsageValidator;

public class QualifiedExpressionResolver {
    @NotNull
    private final SymbolUsageValidator symbolUsageValidator;
    @NotNull
    private final ImportDirectiveProcessor importDirectiveProcessor;
    private static final Predicate<DeclarationDescriptor> CLASSIFIERS_AND_PACKAGE_VIEWS = new Predicate<DeclarationDescriptor>(){

        public boolean apply(@Nullable DeclarationDescriptor descriptor2) {
            return descriptor2 instanceof ClassifierDescriptor || descriptor2 instanceof PackageViewDescriptor;
        }
    };

    public QualifiedExpressionResolver(@NotNull SymbolUsageValidator symbolUsageValidator) {
        if (symbolUsageValidator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbolUsageValidator", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "<init>"));
        }
        this.importDirectiveProcessor = new ImportDirectiveProcessor(this);
        this.symbolUsageValidator = symbolUsageValidator;
    }

    @NotNull
    public JetScope processImportReference(@NotNull JetImportDirective importDirective, @NotNull ModuleDescriptor moduleDescriptor, @NotNull BindingTrace trace, @NotNull LookupMode lookupMode) {
        if (importDirective == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importDirective", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "processImportReference"));
        }
        if (moduleDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleDescriptor", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "processImportReference"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "processImportReference"));
        }
        if (lookupMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupMode", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "processImportReference"));
        }
        JetScope jetScope = this.importDirectiveProcessor.processImportReference(importDirective, moduleDescriptor, trace, lookupMode);
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "processImportReference"));
        }
        return jetScope;
    }

    @NotNull
    public Collection<DeclarationDescriptor> lookupDescriptorsForUserType(@NotNull JetUserType userType, @NotNull JetScope outerScope, @NotNull BindingTrace trace, boolean onlyClassifiers) {
        if (userType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userType", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "lookupDescriptorsForUserType"));
        }
        if (outerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerScope", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "lookupDescriptorsForUserType"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "lookupDescriptorsForUserType"));
        }
        if (userType.isAbsoluteInRootPackage()) {
            trace.report(Errors.UNSUPPORTED.on((PsiElement)userType, "package"));
            List<DeclarationDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "lookupDescriptorsForUserType"));
            }
            return list;
        }
        JetSimpleNameExpression referenceExpression = userType.getReferenceExpression();
        JetUserType qualifier = userType.getQualifier();
        JetScope filteredScope = QualifiedExpressionResolver.filterOutPackagesIfNeeded(outerScope, onlyClassifiers);
        DeclarationDescriptor shouldBeVisibleFrom = outerScope.getContainingDeclaration();
        if (qualifier == null) {
            if (referenceExpression == null) {
                List<DeclarationDescriptor> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "lookupDescriptorsForUserType"));
                }
                return list;
            }
            Collection<DeclarationDescriptor> collection = this.lookupDescriptorsForSimpleNameReference(referenceExpression, filteredScope, shouldBeVisibleFrom, trace, LookupMode.ONLY_CLASSES_AND_PACKAGES, false, true);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "lookupDescriptorsForUserType"));
            }
            return collection;
        }
        Collection<DeclarationDescriptor> declarationDescriptors = this.lookupDescriptorsForUserType(qualifier, outerScope, trace, false);
        if (referenceExpression == null) {
            List<DeclarationDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "lookupDescriptorsForUserType"));
            }
            return list;
        }
        Collection<DeclarationDescriptor> collection = this.lookupSelectorDescriptors(referenceExpression, declarationDescriptors, trace, shouldBeVisibleFrom, LookupMode.ONLY_CLASSES_AND_PACKAGES, true);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "lookupDescriptorsForUserType"));
        }
        return collection;
    }

    private static JetScope filterOutPackagesIfNeeded(final JetScope outerScope, boolean noPackages) {
        return !noPackages ? outerScope : new AbstractScopeAdapter(){

            @Override
            @NotNull
            protected JetScope getWorkerScope() {
                JetScope jetScope = outerScope;
                if (jetScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver$2", "getWorkerScope"));
                }
                return jetScope;
            }

            @Override
            @Nullable
            public PackageViewDescriptor getPackage(@NotNull Name name2) {
                if (name2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver$2", "getPackage"));
                }
                return null;
            }
        };
    }

    @NotNull
    public Collection<DeclarationDescriptor> lookupSelectorDescriptors(@NotNull JetSimpleNameExpression selector, @NotNull Collection<DeclarationDescriptor> declarationDescriptors, @NotNull BindingTrace trace, @NotNull DeclarationDescriptor shouldBeVisibleFrom, @NotNull LookupMode lookupMode, boolean storeResult) {
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "lookupSelectorDescriptors"));
        }
        if (declarationDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationDescriptors", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "lookupSelectorDescriptors"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "lookupSelectorDescriptors"));
        }
        if (shouldBeVisibleFrom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shouldBeVisibleFrom", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "lookupSelectorDescriptors"));
        }
        if (lookupMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupMode", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "lookupSelectorDescriptors"));
        }
        LinkedHashSet results2 = Sets.newLinkedHashSet();
        for (DeclarationDescriptor declarationDescriptor : declarationDescriptors) {
            if (declarationDescriptor instanceof PackageViewDescriptor) {
                results2.add(QualifiedExpressionResolver.lookupSimpleNameReference(selector, ((PackageViewDescriptor)declarationDescriptor).getMemberScope(), lookupMode, true));
            }
            if (!(declarationDescriptor instanceof ClassDescriptor)) continue;
            QualifiedExpressionResolver.addResultsForClass(results2, selector, lookupMode, (ClassDescriptor)declarationDescriptor);
        }
        Collection<DeclarationDescriptor> collection = this.filterAndStoreResolutionResult(results2, selector, trace, shouldBeVisibleFrom, lookupMode, storeResult);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "lookupSelectorDescriptors"));
        }
        return collection;
    }

    private static void addResultsForClass(@NotNull @Mutable Set<LookupResult> results2, @NotNull JetSimpleNameExpression selector, @NotNull LookupMode lookupMode, @NotNull ClassDescriptor descriptor2) {
        if (results2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "addResultsForClass"));
        }
        if (selector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "addResultsForClass"));
        }
        if (lookupMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupMode", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "addResultsForClass"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "addResultsForClass"));
        }
        JetScope scope2 = lookupMode == LookupMode.ONLY_CLASSES_AND_PACKAGES ? descriptor2.getUnsubstitutedInnerClassesScope() : descriptor2.getDefaultType().getMemberScope();
        results2.add(QualifiedExpressionResolver.lookupSimpleNameReference(selector, scope2, lookupMode, false));
        results2.add(QualifiedExpressionResolver.lookupSimpleNameReference(selector, descriptor2.getStaticScope(), lookupMode, true));
    }

    @NotNull
    public Collection<DeclarationDescriptor> lookupDescriptorsForSimpleNameReference(@NotNull JetSimpleNameExpression referenceExpression, @NotNull JetScope outerScope, @NotNull DeclarationDescriptor shouldBeVisibleFrom, @NotNull BindingTrace trace, @NotNull LookupMode lookupMode, boolean packageLevel, boolean storeResult) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "lookupDescriptorsForSimpleNameReference"));
        }
        if (outerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerScope", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "lookupDescriptorsForSimpleNameReference"));
        }
        if (shouldBeVisibleFrom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shouldBeVisibleFrom", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "lookupDescriptorsForSimpleNameReference"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "lookupDescriptorsForSimpleNameReference"));
        }
        if (lookupMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupMode", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "lookupDescriptorsForSimpleNameReference"));
        }
        LookupResult lookupResult = QualifiedExpressionResolver.lookupSimpleNameReference(referenceExpression, outerScope, lookupMode, packageLevel);
        Collection<DeclarationDescriptor> collection = this.filterAndStoreResolutionResult(Collections.singletonList(lookupResult), referenceExpression, trace, shouldBeVisibleFrom, lookupMode, storeResult);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "lookupDescriptorsForSimpleNameReference"));
        }
        return collection;
    }

    @NotNull
    private static LookupResult lookupSimpleNameReference(@NotNull JetSimpleNameExpression referenceExpression, @NotNull JetScope outerScope, @NotNull LookupMode lookupMode, boolean packageLevel) {
        KotlinLookupLocation location2;
        ClassifierDescriptor classifierDescriptor;
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "lookupSimpleNameReference"));
        }
        if (outerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerScope", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "lookupSimpleNameReference"));
        }
        if (lookupMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupMode", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "lookupSimpleNameReference"));
        }
        Name referencedName = referenceExpression.getReferencedNameAsName();
        LinkedHashSet descriptors = Sets.newLinkedHashSet();
        PackageViewDescriptor packageDescriptor = outerScope.getPackage(referencedName);
        if (packageDescriptor != null) {
            descriptors.add(packageDescriptor);
        }
        if ((classifierDescriptor = outerScope.getClassifier(referencedName, location2 = new KotlinLookupLocation(referenceExpression))) != null) {
            descriptors.add(classifierDescriptor);
        }
        if (lookupMode == LookupMode.EVERYTHING) {
            descriptors.addAll(outerScope.getFunctions(referencedName, location2));
            descriptors.addAll(outerScope.getProperties(referencedName, location2));
            VariableDescriptor localVariable = outerScope.getLocalVariable(referencedName);
            if (localVariable != null) {
                descriptors.add(localVariable);
            }
        }
        LookupResult lookupResult = new LookupResult(descriptors, outerScope, packageLevel);
        if (lookupResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "lookupSimpleNameReference"));
        }
        return lookupResult;
    }

    @NotNull
    private Collection<DeclarationDescriptor> filterAndStoreResolutionResult(@NotNull Collection<LookupResult> lookupResults, @NotNull JetSimpleNameExpression referenceExpression, @NotNull BindingTrace trace, @NotNull DeclarationDescriptor shouldBeVisibleFrom, @NotNull LookupMode lookupMode, boolean storeResult) {
        Collection<DeclarationDescriptor> filteredDescriptors;
        if (lookupResults == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupResults", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "filterAndStoreResolutionResult"));
        }
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "filterAndStoreResolutionResult"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "filterAndStoreResolutionResult"));
        }
        if (shouldBeVisibleFrom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shouldBeVisibleFrom", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "filterAndStoreResolutionResult"));
        }
        if (lookupMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupMode", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "filterAndStoreResolutionResult"));
        }
        if (lookupResults.isEmpty()) {
            List<DeclarationDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "filterAndStoreResolutionResult"));
            }
            return list;
        }
        LinkedHashSet descriptors = Sets.newLinkedHashSet();
        for (LookupResult lookupResult : lookupResults) {
            descriptors.addAll(lookupResult.descriptors);
        }
        if (lookupMode == LookupMode.ONLY_CLASSES_AND_PACKAGES) {
            filteredDescriptors = Collections2.filter((Collection)descriptors, CLASSIFIERS_AND_PACKAGE_VIEWS);
        } else {
            filteredDescriptors = Sets.newLinkedHashSet();
            for (LookupResult lookupResult : lookupResults) {
                if (lookupResult.packageLevel) {
                    filteredDescriptors.addAll(lookupResult.descriptors);
                    continue;
                }
                filteredDescriptors.addAll(Collections2.filter((Collection)lookupResult.descriptors, CLASSIFIERS_AND_PACKAGE_VIEWS));
            }
        }
        if (storeResult) {
            ArrayList possibleResolutionScopes = Lists.newArrayList();
            for (LookupResult lookupResult : lookupResults) {
                if (lookupResult.descriptors.isEmpty()) continue;
                possibleResolutionScopes.add(lookupResult.resolutionScope);
            }
            if (possibleResolutionScopes.isEmpty()) {
                for (LookupResult lookupResult : lookupResults) {
                    possibleResolutionScopes.add(lookupResult.resolutionScope);
                }
            }
            this.storeResolutionResult(descriptors, filteredDescriptors, referenceExpression, possibleResolutionScopes, trace, shouldBeVisibleFrom);
        }
        Collection<DeclarationDescriptor> collection = filteredDescriptors;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "filterAndStoreResolutionResult"));
        }
        return collection;
    }

    private void storeResolutionResult(@NotNull Collection<DeclarationDescriptor> descriptors, @NotNull Collection<DeclarationDescriptor> canBeImportedDescriptors, @NotNull JetSimpleNameExpression referenceExpression, @NotNull Collection<JetScope> possibleResolutionScopes, @NotNull BindingTrace trace, @NotNull DeclarationDescriptor shouldBeVisibleFrom) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "storeResolutionResult"));
        }
        if (canBeImportedDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "canBeImportedDescriptors", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "storeResolutionResult"));
        }
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "storeResolutionResult"));
        }
        if (possibleResolutionScopes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "possibleResolutionScopes", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "storeResolutionResult"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "storeResolutionResult"));
        }
        if (shouldBeVisibleFrom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shouldBeVisibleFrom", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "storeResolutionResult"));
        }
        assert (canBeImportedDescriptors.size() <= descriptors.size());
        assert (!possibleResolutionScopes.isEmpty());
        JetScope resolutionScope = possibleResolutionScopes.iterator().next();
        if (QualifiedExpressionResolver.resolveClassPackageAmbiguity(canBeImportedDescriptors, referenceExpression, resolutionScope, trace, shouldBeVisibleFrom)) {
            return;
        }
        if (descriptors.isEmpty()) {
            trace.record(BindingContext.RESOLUTION_SCOPE, referenceExpression, resolutionScope);
            trace.report(Errors.UNRESOLVED_REFERENCE.on(referenceExpression, referenceExpression));
            return;
        }
        DeclarationDescriptor descriptor2 = null;
        if (descriptors.size() == 1) {
            descriptor2 = descriptors.iterator().next();
            assert (canBeImportedDescriptors.size() <= 1);
        } else if (canBeImportedDescriptors.size() == 1) {
            descriptor2 = canBeImportedDescriptors.iterator().next();
        }
        if (descriptor2 != null) {
            trace.record(BindingContext.REFERENCE_TARGET, referenceExpression, descriptors.iterator().next());
            trace.record(BindingContext.RESOLUTION_SCOPE, referenceExpression, resolutionScope);
            if (descriptor2 instanceof ClassifierDescriptor) {
                this.symbolUsageValidator.validateTypeUsage((ClassifierDescriptor)descriptor2, trace, (PsiElement)referenceExpression);
            }
            if (descriptor2 instanceof DeclarationDescriptorWithVisibility) {
                QualifiedExpressionResolver.checkVisibility((DeclarationDescriptorWithVisibility)descriptor2, trace, referenceExpression, shouldBeVisibleFrom);
            }
        }
        if (canBeImportedDescriptors.isEmpty()) {
            assert (descriptors.size() >= 1);
            trace.report(Errors.CANNOT_BE_IMPORTED.on(referenceExpression, descriptors.iterator().next()));
            return;
        }
        if (canBeImportedDescriptors.size() > 1) {
            trace.record(BindingContext.AMBIGUOUS_REFERENCE_TARGET, referenceExpression, descriptors);
        }
    }

    private static boolean resolveClassPackageAmbiguity(@NotNull Collection<DeclarationDescriptor> filteredDescriptors, @NotNull JetSimpleNameExpression referenceExpression, @NotNull JetScope resolutionScope, @NotNull BindingTrace trace, @NotNull DeclarationDescriptor shouldBeVisibleFrom) {
        if (filteredDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filteredDescriptors", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "resolveClassPackageAmbiguity"));
        }
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "resolveClassPackageAmbiguity"));
        }
        if (resolutionScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolutionScope", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "resolveClassPackageAmbiguity"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "resolveClassPackageAmbiguity"));
        }
        if (shouldBeVisibleFrom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shouldBeVisibleFrom", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "resolveClassPackageAmbiguity"));
        }
        if (filteredDescriptors.size() == 2) {
            PackageViewDescriptor packageView = null;
            ClassDescriptor classDescriptor = null;
            for (DeclarationDescriptor filteredDescriptor : filteredDescriptors) {
                if (filteredDescriptor instanceof PackageViewDescriptor) {
                    packageView = (PackageViewDescriptor)filteredDescriptor;
                    continue;
                }
                if (!(filteredDescriptor instanceof ClassDescriptor)) continue;
                classDescriptor = (ClassDescriptor)filteredDescriptor;
            }
            if (packageView != null && classDescriptor != null && packageView.getFqName().equalsTo(DescriptorUtils.getFqName(classDescriptor))) {
                trace.record(BindingContext.REFERENCE_TARGET, referenceExpression, classDescriptor);
                trace.record(BindingContext.RESOLUTION_SCOPE, referenceExpression, resolutionScope);
                QualifiedExpressionResolver.checkVisibility(classDescriptor, trace, referenceExpression, shouldBeVisibleFrom);
                return true;
            }
        }
        return false;
    }

    private static void checkVisibility(@NotNull DeclarationDescriptorWithVisibility descriptor2, @NotNull BindingTrace trace, @NotNull JetSimpleNameExpression referenceExpression, @NotNull DeclarationDescriptor shouldBeVisibleFrom) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "checkVisibility"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "checkVisibility"));
        }
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "checkVisibility"));
        }
        if (shouldBeVisibleFrom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shouldBeVisibleFrom", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver", "checkVisibility"));
        }
        if (!Visibilities.isVisible(ReceiverValue.IRRELEVANT_RECEIVER, descriptor2, shouldBeVisibleFrom)) {
            Visibility visibility = descriptor2.getVisibility();
            if (PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, JetImportDirective.class) != null && !visibility.mustCheckInImports()) {
                return;
            }
            trace.report(Errors.INVISIBLE_REFERENCE.on(referenceExpression, descriptor2, visibility, descriptor2.getContainingDeclaration()));
        }
    }

    private static class LookupResult {
        private final Collection<DeclarationDescriptor> descriptors;
        private final JetScope resolutionScope;
        private final boolean packageLevel;

        public LookupResult(@NotNull Collection<DeclarationDescriptor> descriptors, @NotNull JetScope resolutionScope, boolean packageLevel) {
            if (descriptors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver$LookupResult", "<init>"));
            }
            if (resolutionScope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolutionScope", "org/jetbrains/kotlin/resolve/QualifiedExpressionResolver$LookupResult", "<init>"));
            }
            this.descriptors = descriptors;
            this.resolutionScope = resolutionScope;
            this.packageLevel = packageLevel;
        }
    }

    public static enum LookupMode {
        ONLY_CLASSES_AND_PACKAGES,
        EVERYTHING;

    }
}

