/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.callableReferences;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.KotlinPackage;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.JetCallableReferenceExpression;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.FunctionDescriptorUtil;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.callableReferences.CallableReferencesResolutionUtilsKt$WhenMappings;
import org.jetbrains.kotlin.resolve.calls.CallResolver;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.ResolveArgumentsMode;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.TemporaryTraceAndCache;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsUtil;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.utils.ThrowingList;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"7\u0014))\"-\u001b8e\rVt7\r^5p]J+g-\u001a:f]\u000e,'BC3yaJ,7o]5p]*q\"*\u001a;DC2d\u0017M\u00197f%\u00164WM]3oG\u0016,\u0005\u0010\u001d:fgNLwN\u001c\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0019Yw\u000e\u001e7j]*\u0019\u0001o]5\u000b\u001bI,g-\u001a:f]\u000e,G+\u001f9f\u0015\u001dQU\r\u001e+za\u0016TQ\u0001^=qKNTqaY8oi\u0016DHOC\tSKN|G.\u001e;j_:\u001cuN\u001c;fqRTqA]3t_24XMC\u0003dC2d7O\u0003\u0003V]&$(bI\"bY2\f'\r\\3SK\u001a,'/\u001a8dKN\u0014Vm]8mkRLwN\\+uS2\u001c8\n\u001e\u0006\u0016E&tG\r\u0015:pa\u0016\u0014H/\u001f*fM\u0016\u0014XM\\2f\u0015%\u001a'/Z1uKJ+g\r\\3di&|g\u000eV=qK\u001a{'oQ1mY\u0006\u0014G.\u001a#fg\u000e\u0014\u0018\u000e\u001d;pe*QA-Z:de&\u0004Ho\u001c:\u000b%\r\u000bG\u000e\\1cY\u0016$Um]2sSB$xN\u001d\u0006\fI\u0016\u001c8M]5qi>\u00148OC\bsK\u001adWm\u0019;j_:$\u0016\u0010]3t\u0015=\u0011VM\u001a7fGRLwN\u001c+za\u0016\u001c(\u0002\u00032vS2$\u0018N\\:\u000b\u0011I,\u0007o\u001c:u\u001f:TQBS3u\u000bb\u0004(/Z:tS>t'bH2sK\u0006$XMU3gY\u0016\u001cG/[8o)f\u0004XMR8s\rVt7\r^5p]*\u0011b)\u001e8di&|g\u000eR3tGJL\u0007\u000f^8s\u00151\u0011XmY3jm\u0016\u0014H+\u001f9f\u0015}\u0019'/Z1uKJ+g\r\\3di&|g\u000eV=qK\u001a{'\u000f\u0015:pa\u0016\u0014H/\u001f\u0006\u0013!J|\u0007/\u001a:us\u0012+7o\u0019:jaR|'O\u0003\u0019de\u0016\fG/\u001a*fM2,7\r^5p]RK\b/\u001a$peJ+7o\u001c7wK\u0012\u001c\u0015\r\u001c7bE2,'+\u001a4fe\u0016t7-\u001a\u0006\ne\u00164WM]3oG\u0016TqeZ3u%\u00164G.Z2uS>tG+\u001f9f\r>\u00148)\u00198eS\u0012\fG/\u001a#fg\u000e\u0014\u0018\u000e\u001d;pe*)s-\u001a;SKN|GN^3e\u0007\u0006dG.\u00192mKJ+g-\u001a:f]\u000e,7\u000b[1qKRK\b/\u001a\u0006\u001a_Z,'\u000f\\8bIJ+7o\u001c7vi&|gNU3tk2$8OC\rPm\u0016\u0014Hn\\1e%\u0016\u001cx\u000e\\;uS>t'+Z:vYR\u001c(b\u0002:fgVdGo\u001d\u0006\u0014Kb\u0004Xm\u0019;fIRK\b/Z+oW:|wO\u001c\u0006\b\u0005>|G.Z1o\u0015!\u0011W/\u001b7u\u0013:\u001c(BD&pi2LgNQ;jYRLen\u001d\u0006%e\u0016\u001cx\u000e\u001c<f\u0007\u0006dG.\u00192mKJ+g-\u001a:f]\u000e,'+Z2fSZ,'\u000fV=qK*Y2-\u00197mC\ndWMU3gKJ,gnY3FqB\u0014Xm]:j_:TA\u0002^=qKJ+7o\u001c7wKJTA\u0002V=qKJ+7o\u001c7wKJTaD]3t_24XmQ1mY\u0006\u0014G.\u001a*fM\u0016\u0014XM\\2f)\u0006\u0014x-\u001a;\u000b\u000f1D7\u000fV=qK*\u0019\"/Z:pYZ,G\rV8T_6,G\u000f[5oO*a!i\\8mK\u0006t\u0017I\u001d:bs*a1-\u00197m%\u0016\u001cx\u000e\u001c<fe*a1)\u00197m%\u0016\u001cx\u000e\u001c<fe*I#/Z:pYZ,\u0007k\\:tS\nd\u00170Q7cS\u001e,x.^:DC2d\u0017M\u00197f%\u00164WM]3oG\u0016TaB]3t_2,H/[8o\u001b>$WM\u0003\u000bSKN|GN^3Be\u001e,X.\u001a8ug6{G-\u001a\u0006\u0011G\u0006dGNU3t_24XM]+uS2TqCS3u'&l\u0007\u000f\\3OC6,W\t\u001f9sKN\u001c\u0018n\u001c8\u000b\u0011I,7-Z5wKJTQBU3dK&4XM\u001d,bYV,'BB:d_B,7OC\u0005sK\u000e,\u0017N^3sg*\tAI\u0003\tbG\u000e,\u0007\u000f\u001e*fg>dW\u000f^5p]*)AO]1dK*1B+Z7q_J\f'/\u001f+sC\u000e,\u0017I\u001c3DC\u000eDWMC\u0006jgN{W.\u001a;iS:<gZ\u0001\u0006\u0003!\rQA\u0001\u0003\u0001\u0011\t)!\u0001\"\u0001\t\u0006\u0015\u0011A!\u0001\u0005\u0004\u000b\r!\u0019\u0001C\u0001\r\u0001\u0015\u0011A!\u0001E\u0005\u000b\r!)\u0001\u0003\u0003\r\u0001\u0015\u0011A!\u0001\u0005\u0007\u000b\t!9\u0001#\u0004\u0006\u0005\u0011!\u0001\"B\u0003\u0004\t\u0013AY\u0001\u0004\u0001\u0006\u0003!\u0015Qa\u0001C\u0006\u0011\u001da\u0001!\u0002\u0002\u0005\u0004!\tQA\u0001C\u0003\u0011\u0011)!\u0001\"\u0003\t\f\u0015\u0011A!\u0001\u0005\u000b\u000b\r!\u0001\u0002c\u0005\r\u0001\u0015\u0011A!\u0001E\f\u000b\r!\u0011\u0002C\u0006\r\u0001\u0015\u0019A1\u0001E\r\u0019\u0001)!\u0001\u0002\u0005\t\u0014\u0015\u0011A!\u0003\u0005\f\u000b\t!\u0019\u0001#\u0007\u0006\u0007\u0011A\u00012\u0004\u0007\u0001\u000b\t!\u0001\u0002c\u0007\u0006\u0007\u0011A\u0001b\u0004\u0007\u0001\u000b\t!\u0001\u0002C\b\u0006\u0005\u0011!\u0001RE\u0003\u0004\t9A!\u0003\u0004\u0001\u0006\u0007\u0011-\u0001r\u0005\u0007\u0001\u000b\r!\u0011\u0002#\u000b\r\u0001\u0015\u0011AA\u0004\u0005\u0013\u000b\t!\u0011\u0002#\u000b\u0006\u0007\u0011\u001d\u0001R\u0006\u0007\u0001\u000b\t!9\u0001#\f\u0006\u0007\u0011-\u0001\u0012\u0007\u0007\u0001\u000b\r!A\u0001c\r\r\u0001\u0015\u0011A\u0001\u0002E\u001a\u000b\t!A\u0001c\u000e\u0006\u0007\u0011\u001d\u0002b\u0007\u0007\u0001\u000b\t!9\u0003C\u000e\u0006\u0007\u0011\r\u0001\u0002\b\u0007\u0001\u000b\t!9\u0001c\u000f\u0006\u0005\u0011-\u0002BH\u0003\u0004\tYAQ\u0004\u0004\u0001\u0006\u0005\u0011\r\u0001\u0002H\u0003\u0003\tYAQ$B\u0002\u0005\n!\u0001C\u0002A\u0003\u0003\t\u0013A\u0001%b\u0017\u0005\u0003a\u0001Qt\u0002\u0003\u0001\u0011\u0003i1!B\u0001\t\u0005a\u0011\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001rA\u0007\u0004\u000b\u0005A1\u0001G\u0002Q\u0007\u0003i\u001a\u0002\u0002\u0001\t\u000b5)Q!\u0001\u0005\u0006\u0013\u0005!\u0019\u0001G\u0003Q\u0007\u0005\t3!B\u0001\t\ra1\u0011kA\u0005\u0005\u0001%\tA\u0001A\u0007\u0002\u0011\u001bi\u0011\u0001C\u0004\u000e\u0003!=\u0001la\u0004\u0006\\\u0011\t\u0001\u0004CO\b\t\u0001A\t!D\u0002\u0006\u0003!\u0011\u0001D\u0001)\u0004\u0001u=A\u0001\u0001E\u0004\u001b\r)\u0011\u0001C\u0002\u0019\u0007A\u001b\t!h\u0005\u0005\u0001!)Q\"B\u0003\u0002\u0011\u0015I\u0011\u0001b\u0001\u0019\u000bA\u001b\u0011!I\u0002\u0006\u0003!1\u0001DB)\u0004\u0013\u0011A\u0011\"\u0001\u0003\u0001\u001b\u0005Ai!D\u0001\t\u000f5\t\u0001r\u0002-\u0004\u0010\u0015QD!\u0001M\t;\u001f!\u0001\u0001C\u0005\u000e\u0007\u0015\t\u0001\u0012\u0003M\t!\u000e\u0001Q4\u0003\u0003\u0001\u0011\u0015iQ!B\u0001\t\u000b%\tA1\u0001\r\u0006!\u000e\u0005Qt\u0002\u0003\u0001\u0011+i1!B\u0001\t\u0014aM\u0001kA\u0001\u001e\u0012\u0011\u0001\u0001\u0002D\u0007\u0005\u000b\u0005A!\u0002$\u0001\u0019\u0015A\u001b\u0019!\t\u0003\u0006\u0003!\u0019A\u0012\u0001\r\u0004#\u000eYA\u0011C\u0005\u0002\u0011\u001di\u0011\u0001#\u0006\u000e\u0003!=Q\"\u0001\u0005\f\u001b\u0005A9\u0002WB\b\u000b7\"\u0011\u0001G\u0007\u001e\u0010\u0011\u0001\u0001\"C\u0007\u0004\u000b\u0005AA\u0002\u0007\u0007Q\u0007\u0001i\n\u0002\u0002\u0001\t\u001d5!Q!\u0001\u0005\u0004\u0019\u0003A2\u0001UB\u0001;\u001f!\u0001\u0001#\u0006\u000e\u0007\u0015\t\u00012\u0003M\n!\u000e\t\u0011\u0005B\u0003\u0002\u0011\ra\t\u0001G\u0002R\u0007%!Q\"C\u0001\t\u000f5\t\u0001\u0012D\u0007\u0002\u0011\u001di\u0011\u0001C\u0006Y\u0007\u001f)I\u0006B\u0001\u0019\u001eu=A\u0001\u0001\u0005\n\u001b\r)\u0011\u0001C\u0007\u0019\u001bA\u001b\u0001!(\u0005\u0005\u0001!qQ\u0002B\u0003\u0002\u0011\ra\t\u0001G\u0002Q\u0007\u0003iz\u0001\u0002\u0001\t\u00165\u0019Q!\u0001E\n1'\u00016!A\u0011\u0004\u000b\u0005A1\u0001G\u0002R\u0007%!i\"C\u0001\t\u000f5\t\u00012D\u0007\u0002\u0011\u001di\u0011\u0001C\u0006Y\u0007\u001f)\u0011\bB\u0002\u0019 u=A\u0001\u0001\u0005\u0011\u001b\r)\u0011\u0001\u0003\u0002\u0019\u0005A\u001b\u0001!h\u0004\u0005\u0001!IQbA\u0003\u0002\u0011#A\n\u0002UB\u0001;'!\u0001\u0001C\u0003\u000e\u000b\u0015\t\u0001\"B\u0005\u0002\t\u0007AR\u0001U\u0002\u0002;\u001f!\u0001\u0001#\u0006\u000e\u0007\u0015\t\u00012\u0003M\n!\u000e\r\u0011\u0005B\u0003\u0002\u0011\ra\t\u0001G\u0002R\u0007-!y\"C\u0001\t\u000f5\t\u0001RB\u0007\u0002\u0011+i\u0011\u0001c\u0004\u000e\u0003!Y\u0001la\u0004\u0006^\u0011\u0019\u0001\u0014EO\b\t\u0001A\u0011\"D\u0002\u0006\u0003!E\u0001\u0014\u0003)\u0004\u0001uMA\u0001\u0001\u0005\u0006\u001b\u0015)\u0011\u0001C\u0003\n\u0003\u0011\r\u0001$\u0002)\u0004\u0002u=A\u0001\u0001E\u000b\u001b\r)\u0011\u0001c\u0005\u0019\u0014A\u001b\u0011!\t\u0003\u0006\u0003!\u0019A\u0012\u0001\r\u0004#\u000eIA\u0011E\u0005\u0002\u0011\u001di\u0011\u0001#\u0006\u000e\u0003!=Q\"\u0001\u0005\f1\u000e=Q\u00016\u0001\u0005\u0007a\tRt\u0002\u0003\u0001\u0011Ai1!B\u0001\t\u0005a\u0011\u0001k\u0001\u0001\u001e\u001c\u0011\u0001\u00012E\u0007\n\u000b\u0005Ai\"\u0003\u0003\n\u0007\u0015\t\u0001\u0012\u0003M\t\u0019\u0003Aj\u0002UB\u0001;'!\u0001\u0001C\u0003\u000e\u000b\u0015\t\u0001\"B\u0005\u0002\t\u0007AR\u0001U\u0002\u0002;\u001f!\u0001\u0001C\n\u000e\u0007\u0015\t\u0001b\u0004\r\u0010!\u000e\rQt\u0002\u0003\u0001\u0011+i1!B\u0001\t\u0014aM\u0001k\u0001\u0002\u001e\u0010\u0011\u0001\u0001\u0002F\u0007\u0004\u000b\u0005Ay\u0002g\bQ\u0007\u000b\tC!B\u0001\t\u00071\u0005\u0001dA)\u0004\u001f\u0011\t\u0012\"\u0001\u0005\b\u001b\u0005Ai!D\u0001\t!5\t\u0001rB\u0007\u0002\t\u0003i\u0011\u0001C\u0006\u000e\u0003!\u0005\u0002la\u0004\u0006^\u0011\u0019\u0001$FO\b\t\u0001AY#D\u0002\u0006\u0003!\u0011\u0001D\u0001)\u0004\u0001uMA\u0001\u0001\u0005\u0006\u001b\u0015)\u0011\u0001C\u0003\n\u0003\u0011\r\u0001$\u0002)\u0004\u0002u=A\u0001\u0001\u0005\u0017\u001b\r)\u0011\u0001C\t\u0019#A\u001b\u0011!\t\u0003\u0006\u0003!\u0019A\u0012\u0001\r\u0004#\u000eIA!F\u0005\u0002\u0011\u001di\u0011\u0001#\u0004\u000e\u0003!=Q\"\u0001E\u00121\u000e=Q12\u0001\u0005\u0007a9Rt\u0002\u0003\u0001\u0011Wi1!B\u0001\t\u0005a\u0011\u0001k\u0001\u0001\u001e\u0012\u0011\u0001\u0001rF\u0007\u0005\u000b\u0005A1\u0001$\u0001\u0019\u0007A\u001b\t!h\u0005\u0005\u0001!)Q\"B\u0003\u0002\u0011\u0015I\u0011\u0001b\u0001\u0019\u000bA\u001b\u0011!h\u0004\u0005\u0001!ARbA\u0003\u0002\u0011IA\"\u0003UB\u0002;\u001f!\u0001\u0001C\r\u000e\u0007\u0015\t\u0001R\u0005M\u0013!\u000e\u0011\u0011\u0005B\u0003\u0002\u0011#a\t\u0001'\u0005R\u00079!q#C\u0001\t\u00165\t\u0001RB\u0007\u0002\u0011\u001di\u0011\u0001c\u0004\u000e\u0005\u0011\u0005A\u0012A\u0007\u0002\u0011MA6qBCJ\u0002\u0011\u0019\u0001DGO\b\t\u0001AY#D\u0002\u0006\u0003!\u0011\u0001D\u0001)\u0004\u0001uEA\u0001\u0001E\u0018\u001b\u0011)\u0011\u0001C\u0002\r\u0002a\u0019\u0001k!\u0001\u001e\u0014\u0011\u0001\u0001\"B\u0007\u0006\u000b\u0005AQ!C\u0001\u0005\u0004a)\u0001kA\u0001\u001e\u0010\u0011\u0001\u0001RG\u0007\u0004\u000b\u0005AA\u0003\u0007\u000bQ\u0007\u0007iz\u0001\u0002\u0001\t35\u0019Q!\u0001E\u00131K\u00016AA\u0011\n\u000b\u0005Ai\"\u0003\u0003\n\u0007\u0015\t\u0001\u0012\u0003M\t\u0019\u0003Aj\"U\u0002\u000e\tiI\u0011\u0001\u0003\t\u000e\u0003!5Q\"\u0001\u0005\b\u001b\u0005Ay!D\u0001\t*5\t\u0001b\u0005-\u0004\u0010\u0015=\r\u0001B\u0001\u00195u=A\u0001\u0001\u0005\u0011\u001b\r)\u0011\u0001C\u000b\u0019+A\u001b\u0001!h\u0004\u0005\u0001!eRbA\u0003\u0002\u0011[Aj\u0003UB\u0001;'!\u0001\u0001C\u0003\u000e\u000b\u0015\t\u0001\"B\u0005\u0002\t\u0007AR\u0001U\u0002\u0002;\u001f!\u0001\u0001#\u000e\u000e\u0007\u0015\t\u0001\u0002\u0006\r\u0015!\u000e\rQt\u0002\u0003\u0001\u0011ei1!B\u0001\t&a\u0015\u0002k\u0001\u0002\"\u0011\u0015\t\u0001RD\u0005\u0005\u0013\r)\u0011\u0001#\u0005\u0019\u0012au\u0011kA\u0007\u00055%\t\u0001\u0002E\u0007\u0002\u0011]i\u0011\u0001c\f\u000e\u0003!=Q\"\u0001E\u0015\u001b\u0005A1\u0003WB\b\u000bQ\"\u0011!\u0005\u0004\u0005\u0001!uRcA\u0003\u0002\u0011#A\n\"F\u0002\u0006\u0003!!\u0002\u0004\u0006\r ;7!\u0001\u0001#\n\u000e\u0013\u0015\t\u0001RD\u0005\u0006\u0013\u0011)!\u0001\"\u0001\t\u0001q\u0001\u0001T\u0004)\u0004\u0002u=A\u0001\u0001E \u001b\r)\u0011\u0001\u0003\r\u00191A\u001b\u0011!I\u0002\u0006\u0003!1\u0001DB)\u0004\u0013\u0011y\u0012\"\u0001\u0003\u0001\u001b\u0005AI#D\u0001\t!5\t\u0001\u0012\u0007-\u0004\u0010\u0015!B!A\u000b\u0006\u000b\u0005Ai\"C\u0001\u0005\u0004au\u0001\u0014I\u0011\u0004\u000b\u0005Aq\u0002G\bR\u0007\u0015!\t%C\u0001\u0005\u00025\t\u0001\u0002\u0005-\u0004\u0010\u0001"})
public final class CallableReferencesResolutionUtilsKt {
    @Nullable
    public static final JetType resolveCallableReferenceReceiverType(@NotNull JetCallableReferenceExpression callableReferenceExpression, @NotNull ResolutionContext<?> context, @NotNull TypeResolver typeResolver) {
        JetType jetType;
        Intrinsics.checkParameterIsNotNull((Object)callableReferenceExpression, (String)"callableReferenceExpression");
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)typeResolver, (String)"typeResolver");
        JetTypeReference jetTypeReference = callableReferenceExpression.getTypeReference();
        if (jetTypeReference != null) {
            JetTypeReference $receiver = jetTypeReference;
            JetTypeReference it = $receiver;
            LexicalScope lexicalScope = context.scope;
            Intrinsics.checkExpressionValueIsNotNull((Object)lexicalScope, (String)"context.scope");
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"context.trace");
            jetType = typeResolver.resolveType(lexicalScope, it, bindingTrace, false);
        } else {
            jetType = null;
        }
        return jetType;
    }

    public static final <D extends CallableDescriptor> void acceptResolution(ResolveArgumentsMode $receiver, @NotNull OverloadResolutionResults<D> results2, @NotNull TemporaryTraceAndCache trace) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(results2, (String)"results");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        switch (CallableReferencesResolutionUtilsKt$WhenMappings.$EnumSwitchMapping$0[$receiver.ordinal()]) {
            case 1: {
                if (!results2.isSingleResult()) break;
                trace.commit();
                break;
            }
            case 2: {
                if (!CallableReferencesResolutionUtilsKt.isSomething(results2)) break;
                trace.commit();
            }
        }
    }

    @NotNull
    public static final OverloadResolutionResults<CallableDescriptor> resolvePossiblyAmbiguousCallableReference(@NotNull JetSimpleNameExpression reference, @NotNull ReceiverValue receiver, @NotNull ResolutionContext<?> context, @NotNull ResolveArgumentsMode resolutionMode, @NotNull CallResolver callResolver) {
        OverloadResolutionResults<CallableDescriptor> resolutionResults;
        Intrinsics.checkParameterIsNotNull((Object)reference, (String)"reference");
        Intrinsics.checkParameterIsNotNull((Object)receiver, (String)"receiver");
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)((Object)resolutionMode), (String)"resolutionMode");
        Intrinsics.checkParameterIsNotNull((Object)callResolver, (String)"callResolver");
        Call call = CallMaker.makeCall(reference, receiver, null, reference, ThrowingList.instance());
        TemporaryTraceAndCache temporaryTrace = TemporaryTraceAndCache.create(context, "trace to resolve ::" + reference.getReferencedName() + " as function", reference);
        Object newContext = Intrinsics.areEqual((Object)((Object)resolutionMode), (Object)((Object)ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS)) ? ((ResolutionContext)context.replaceTraceAndCache(temporaryTrace)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE) : context.replaceTraceAndCache(temporaryTrace);
        BasicCallResolutionContext callResolutionContext = BasicCallResolutionContext.create(newContext, call, CheckArgumentTypesMode.CHECK_CALLABLE_TYPE);
        OverloadResolutionResults<CallableDescriptor> overloadResolutionResults = resolutionResults = callResolver.resolveCallForMember(reference, callResolutionContext);
        Intrinsics.checkExpressionValueIsNotNull(overloadResolutionResults, (String)"resolutionResults");
        TemporaryTraceAndCache temporaryTraceAndCache = temporaryTrace;
        Intrinsics.checkExpressionValueIsNotNull((Object)temporaryTraceAndCache, (String)"temporaryTrace");
        CallableReferencesResolutionUtilsKt.acceptResolution(resolutionMode, overloadResolutionResults, temporaryTraceAndCache);
        OverloadResolutionResults<CallableDescriptor> overloadResolutionResults2 = resolutionResults;
        Intrinsics.checkExpressionValueIsNotNull(overloadResolutionResults2, (String)"resolutionResults");
        return overloadResolutionResults2;
    }

    public static final boolean isSomething(OverloadResolutionResults<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        return !$receiver.isNothing();
    }

    @Nullable
    public static final OverloadResolutionResults<CallableDescriptor> resolvePossiblyAmbiguousCallableReference(@NotNull JetCallableReferenceExpression callableReferenceExpression, @Nullable JetType lhsType, @NotNull ResolutionContext<?> context, @NotNull ResolveArgumentsMode resolutionMode, @NotNull CallResolver callResolver) {
        Intrinsics.checkParameterIsNotNull((Object)callableReferenceExpression, (String)"callableReferenceExpression");
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)((Object)resolutionMode), (String)"resolutionMode");
        Intrinsics.checkParameterIsNotNull((Object)callResolver, (String)"callResolver");
        JetSimpleNameExpression reference = callableReferenceExpression.getCallableReference();
        Function2<String, JetScope, OverloadResolutionResults<CallableDescriptor>> resolveInScope$ = new Function2<String, JetScope, OverloadResolutionResults<CallableDescriptor>>(context, reference, resolutionMode, callResolver){
            final /* synthetic */ ResolutionContext $context;
            final /* synthetic */ JetSimpleNameExpression $reference;
            final /* synthetic */ ResolveArgumentsMode $resolutionMode;
            final /* synthetic */ CallResolver $callResolver;

            @NotNull
            public final OverloadResolutionResults<CallableDescriptor> invoke(@NotNull String traceTitle, @NotNull JetScope staticScope) {
                Intrinsics.checkParameterIsNotNull((Object)traceTitle, (String)"traceTitle");
                Intrinsics.checkParameterIsNotNull((Object)staticScope, (String)"staticScope");
                TemporaryTraceAndCache temporaryTraceAndCache = TemporaryTraceAndCache.create(this.$context, traceTitle, this.$reference);
                Context newContext = ((ResolutionContext)this.$context.replaceTraceAndCache(temporaryTraceAndCache)).replaceScope(ScopeUtilsKt.memberScopeAsFileScope(staticScope));
                JetSimpleNameExpression jetSimpleNameExpression = this.$reference;
                Intrinsics.checkExpressionValueIsNotNull((Object)jetSimpleNameExpression, (String)"reference");
                ReceiverValue receiverValue = ReceiverValue.NO_RECEIVER;
                Intrinsics.checkExpressionValueIsNotNull((Object)receiverValue, (String)"ReceiverValue.NO_RECEIVER");
                Context Context2 = newContext;
                Intrinsics.checkExpressionValueIsNotNull(Context2, (String)"newContext");
                OverloadResolutionResults<CallableDescriptor> results2 = CallableReferencesResolutionUtilsKt.resolvePossiblyAmbiguousCallableReference(jetSimpleNameExpression, receiverValue, Context2, this.$resolutionMode, this.$callResolver);
                TemporaryTraceAndCache temporaryTraceAndCache2 = temporaryTraceAndCache;
                Intrinsics.checkExpressionValueIsNotNull((Object)temporaryTraceAndCache2, (String)"temporaryTraceAndCache");
                CallableReferencesResolutionUtilsKt.acceptResolution(this.$resolutionMode, results2, temporaryTraceAndCache2);
                return results2;
            }
            {
                this.$context = resolutionContext;
                this.$reference = jetSimpleNameExpression;
                this.$resolutionMode = resolveArgumentsMode;
                this.$callResolver = callResolver;
                super(2);
            }
        };
        Function2<String, ReceiverValue, OverloadResolutionResults<CallableDescriptor>> resolveWithReceiver$ = new Function2<String, ReceiverValue, OverloadResolutionResults<CallableDescriptor>>(context, reference, resolutionMode, callResolver){
            final /* synthetic */ ResolutionContext $context;
            final /* synthetic */ JetSimpleNameExpression $reference;
            final /* synthetic */ ResolveArgumentsMode $resolutionMode;
            final /* synthetic */ CallResolver $callResolver;

            @NotNull
            public final OverloadResolutionResults<CallableDescriptor> invoke(@NotNull String traceTitle, @NotNull ReceiverValue receiver) {
                Intrinsics.checkParameterIsNotNull((Object)traceTitle, (String)"traceTitle");
                Intrinsics.checkParameterIsNotNull((Object)receiver, (String)"receiver");
                TemporaryTraceAndCache temporaryTraceAndCache = TemporaryTraceAndCache.create(this.$context, traceTitle, this.$reference);
                Context newContext = this.$context.replaceTraceAndCache(temporaryTraceAndCache);
                JetSimpleNameExpression jetSimpleNameExpression = this.$reference;
                Intrinsics.checkExpressionValueIsNotNull((Object)jetSimpleNameExpression, (String)"reference");
                Context Context2 = newContext;
                Intrinsics.checkExpressionValueIsNotNull(Context2, (String)"newContext");
                OverloadResolutionResults<CallableDescriptor> results2 = CallableReferencesResolutionUtilsKt.resolvePossiblyAmbiguousCallableReference(jetSimpleNameExpression, receiver, Context2, this.$resolutionMode, this.$callResolver);
                TemporaryTraceAndCache temporaryTraceAndCache2 = temporaryTraceAndCache;
                Intrinsics.checkExpressionValueIsNotNull((Object)temporaryTraceAndCache2, (String)"temporaryTraceAndCache");
                CallableReferencesResolutionUtilsKt.acceptResolution(this.$resolutionMode, results2, temporaryTraceAndCache2);
                return results2;
            }
            {
                this.$context = resolutionContext;
                this.$reference = jetSimpleNameExpression;
                this.$resolutionMode = resolveArgumentsMode;
                this.$callResolver = callResolver;
                super(2);
            }
        };
        if (lhsType == null) {
            JetSimpleNameExpression jetSimpleNameExpression = reference;
            Intrinsics.checkExpressionValueIsNotNull((Object)jetSimpleNameExpression, (String)"reference");
            ReceiverValue receiverValue = ReceiverValue.NO_RECEIVER;
            Intrinsics.checkExpressionValueIsNotNull((Object)receiverValue, (String)"ReceiverValue.NO_RECEIVER");
            return CallableReferencesResolutionUtilsKt.resolvePossiblyAmbiguousCallableReference(jetSimpleNameExpression, receiverValue, context, resolutionMode, callResolver);
        }
        ClassifierDescriptor classifier2 = lhsType.getConstructor().getDeclarationDescriptor();
        if (!(classifier2 instanceof ClassDescriptor)) {
            context.trace.report(Errors.CALLABLE_REFERENCE_LHS_NOT_A_CLASS.on((JetExpression)((PsiElement)callableReferenceExpression)));
            return null;
        }
        String string = "trace to resolve ::" + reference.getReferencedName() + " in static scope";
        JetScope jetScope = ((ClassDescriptor)classifier2).getStaticScope();
        Intrinsics.checkExpressionValueIsNotNull((Object)jetScope, (String)"classifier.getStaticScope()");
        OverloadResolutionResults<CallableDescriptor> possibleStatic = resolveInScope$.invoke(string, jetScope);
        if (CallableReferencesResolutionUtilsKt.isSomething(possibleStatic)) {
            return possibleStatic;
        }
        String string2 = "trace to resolve ::" + reference.getReferencedName() + " in static nested classes scope";
        JetScope jetScope2 = DescriptorUtils.getStaticNestedClassesScope((ClassDescriptor)classifier2);
        Intrinsics.checkExpressionValueIsNotNull((Object)jetScope2, (String)"DescriptorUtils.getStati\u2026dClassesScope(classifier)");
        OverloadResolutionResults<CallableDescriptor> possibleNested = resolveInScope$.invoke(string2, jetScope2);
        if (CallableReferencesResolutionUtilsKt.isSomething(possibleNested)) {
            return possibleNested;
        }
        OverloadResolutionResults<CallableDescriptor> possibleWithReceiver = resolveWithReceiver$.invoke("trace to resolve ::" + reference.getReferencedName() + " with receiver", (ReceiverValue)new TransientReceiver(lhsType));
        if (CallableReferencesResolutionUtilsKt.isSomething(possibleWithReceiver)) {
            return possibleWithReceiver;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final CallableDescriptor resolveCallableReferenceTarget(@NotNull JetCallableReferenceExpression callableReferenceExpression, @Nullable JetType lhsType, @NotNull ResolutionContext<?> context, @NotNull boolean[] resolvedToSomething, @NotNull CallResolver callResolver) {
        CallableDescriptor callableDescriptor;
        OverloadResolutionResults<CallableDescriptor> resolutionResults;
        Intrinsics.checkParameterIsNotNull((Object)callableReferenceExpression, (String)"callableReferenceExpression");
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)resolvedToSomething, (String)"resolvedToSomething");
        Intrinsics.checkParameterIsNotNull((Object)callResolver, (String)"callResolver");
        OverloadResolutionResults<CallableDescriptor> overloadResolutionResults = resolutionResults = CallableReferencesResolutionUtilsKt.resolvePossiblyAmbiguousCallableReference(callableReferenceExpression, lhsType, context, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS, callResolver);
        if (overloadResolutionResults != null) {
            CallableDescriptor callableDescriptor2;
            void $receiver;
            OverloadResolutionResults<CallableDescriptor> overloadResolutionResults2 = overloadResolutionResults;
            OverloadResolutionResults results2 = (OverloadResolutionResults)$receiver;
            if (CallableReferencesResolutionUtilsKt.isSomething(results2)) {
                resolvedToSomething[0] = true;
                ResolvedCall resolvedCall = OverloadResolutionResultsUtil.getResultingCall(results2, context.contextDependency);
                if (resolvedCall != null) {
                    void $receiver2;
                    ResolvedCall resolvedCall2 = resolvedCall;
                    ResolvedCall call = (ResolvedCall)$receiver2;
                    callableDescriptor2 = (CallableDescriptor)call.getResultingDescriptor();
                } else {
                    callableDescriptor2 = null;
                }
            } else {
                callableDescriptor2 = null;
            }
            callableDescriptor = callableDescriptor2;
        } else {
            callableDescriptor = null;
        }
        return callableDescriptor;
    }

    @Nullable
    public static final JetType createReflectionTypeForFunction(@NotNull FunctionDescriptor descriptor2, @Nullable JetType receiverType, @NotNull ReflectionTypes reflectionTypes) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)reflectionTypes, (String)"reflectionTypes");
        JetType jetType = descriptor2.getReturnType();
        if (jetType == null) {
            return null;
        }
        JetType returnType2 = jetType;
        List<JetType> valueParametersTypes = ExpressionTypingUtils.getValueParametersTypes(descriptor2.getValueParameters());
        Annotations annotations2 = Annotations.Companion.getEMPTY();
        List<JetType> list = valueParametersTypes;
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"valueParametersTypes");
        JetType jetType2 = returnType2;
        Intrinsics.checkExpressionValueIsNotNull((Object)jetType2, (String)"returnType");
        return reflectionTypes.getKFunctionType(annotations2, receiverType, list, jetType2);
    }

    @NotNull
    public static final JetType createReflectionTypeForProperty(@NotNull PropertyDescriptor descriptor2, @Nullable JetType receiverType, @NotNull ReflectionTypes reflectionTypes) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)reflectionTypes, (String)"reflectionTypes");
        Annotations annotations2 = Annotations.Companion.getEMPTY();
        JetType jetType = descriptor2.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)jetType, (String)"descriptor.getType()");
        return reflectionTypes.getKPropertyType(annotations2, receiverType, jetType, descriptor2.isVar());
    }

    public static final void bindFunctionReference(@NotNull JetCallableReferenceExpression expression2, @NotNull JetType referenceType, @NotNull ResolutionContext<?> context) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)referenceType, (String)"referenceType");
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        AnonymousFunctionDescriptor functionDescriptor = new AnonymousFunctionDescriptor(context.scope.getOwnerDescriptor(), Annotations.Companion.getEMPTY(), CallableMemberDescriptor.Kind.DECLARATION, KotlinSourceElementKt.toSourceElement(expression2));
        FunctionDescriptorUtil.initializeFromFunctionType(functionDescriptor, referenceType, null, Modality.FINAL, Visibilities.PUBLIC);
        context.trace.record(BindingContext.FUNCTION, expression2, functionDescriptor);
    }

    public static final void bindPropertyReference(@NotNull JetCallableReferenceExpression expression2, @NotNull JetType referenceType, @NotNull ResolutionContext<?> context) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)referenceType, (String)"referenceType");
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        LocalVariableDescriptor localVariable = new LocalVariableDescriptor(context.scope.getOwnerDescriptor(), Annotations.Companion.getEMPTY(), Name.special("<anonymous>"), referenceType, false, KotlinSourceElementKt.toSourceElement(expression2));
        context.trace.record(BindingContext.VARIABLE, expression2, localVariable);
    }

    @Nullable
    public static final JetType createReflectionTypeForCallableDescriptor(@NotNull CallableDescriptor descriptor2, @NotNull ResolutionContext<?> context, @NotNull ReflectionTypes reflectionTypes, @Nullable JetExpression reportOn) {
        JetType jetType;
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)reflectionTypes, (String)"reflectionTypes");
        ReceiverParameterDescriptor extensionReceiver = descriptor2.getExtensionReceiverParameter();
        ReceiverParameterDescriptor dispatchReceiver = descriptor2.getDispatchReceiverParameter();
        if (extensionReceiver != null && dispatchReceiver != null && descriptor2 instanceof CallableMemberDescriptor) {
            if (reportOn != null) {
                context.trace.report(Errors.EXTENSION_IN_CLASS_REFERENCE_NOT_ALLOWED.on((JetExpression)((PsiElement)reportOn), (CallableMemberDescriptor)descriptor2));
            }
            return null;
        }
        Annotated annotated = extensionReceiver;
        if (annotated == null || (annotated = annotated.getType()) == null) {
            ReceiverParameterDescriptor receiverParameterDescriptor = dispatchReceiver;
            annotated = receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null;
        }
        Annotated receiverType = annotated;
        CallableDescriptor callableDescriptor = descriptor2;
        if (callableDescriptor instanceof FunctionDescriptor) {
            jetType = CallableReferencesResolutionUtilsKt.createReflectionTypeForFunction((FunctionDescriptor)descriptor2, (JetType)receiverType, reflectionTypes);
        } else if (callableDescriptor instanceof PropertyDescriptor) {
            jetType = CallableReferencesResolutionUtilsKt.createReflectionTypeForProperty((PropertyDescriptor)descriptor2, (JetType)receiverType, reflectionTypes);
        } else if (callableDescriptor instanceof VariableDescriptor) {
            if (reportOn != null) {
                context.trace.report(Errors.UNSUPPORTED.on((PsiElement)reportOn, "References to variables aren't supported yet"));
            }
            jetType = null;
        } else {
            throw (Throwable)new UnsupportedOperationException("Callable reference resolved to an unsupported descriptor: " + descriptor2);
        }
        return jetType;
    }

    @Nullable
    public static final JetType getReflectionTypeForCandidateDescriptor(@NotNull CallableDescriptor descriptor2, @NotNull ResolutionContext<?> context, @NotNull ReflectionTypes reflectionTypes) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)reflectionTypes, (String)"reflectionTypes");
        return CallableReferencesResolutionUtilsKt.createReflectionTypeForCallableDescriptor(descriptor2, context, reflectionTypes, null);
    }

    @Nullable
    public static final JetType createReflectionTypeForResolvedCallableReference(@NotNull JetCallableReferenceExpression reference, @NotNull CallableDescriptor descriptor2, @NotNull ResolutionContext<?> context, @NotNull ReflectionTypes reflectionTypes) {
        Intrinsics.checkParameterIsNotNull((Object)reference, (String)"reference");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)reflectionTypes, (String)"reflectionTypes");
        JetType jetType = CallableReferencesResolutionUtilsKt.createReflectionTypeForCallableDescriptor(descriptor2, context, reflectionTypes, reference.getCallableReference());
        if (jetType == null) {
            return null;
        }
        JetType type2 = jetType;
        CallableDescriptor callableDescriptor = descriptor2;
        if (callableDescriptor instanceof FunctionDescriptor) {
            CallableReferencesResolutionUtilsKt.bindFunctionReference(reference, type2, context);
        } else if (callableDescriptor instanceof PropertyDescriptor) {
            CallableReferencesResolutionUtilsKt.bindPropertyReference(reference, type2, context);
        }
        return type2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final JetType getResolvedCallableReferenceShapeType(@NotNull JetCallableReferenceExpression reference, @Nullable OverloadResolutionResults<CallableDescriptor> overloadResolutionResults, @NotNull ResolutionContext<?> context, boolean expectedTypeUnknown, @NotNull ReflectionTypes reflectionTypes, @NotNull KotlinBuiltIns builtIns) {
        JetType jetType;
        Intrinsics.checkParameterIsNotNull((Object)reference, (String)"reference");
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)reflectionTypes, (String)"reflectionTypes");
        Intrinsics.checkParameterIsNotNull((Object)builtIns, (String)"builtIns");
        if (overloadResolutionResults == null) {
            jetType = null;
        } else if (overloadResolutionResults.isSingleResult()) {
            ResolvedCall<CallableDescriptor> resolvedCall = OverloadResolutionResultsUtil.getResultingCall(overloadResolutionResults, context.contextDependency);
            if (resolvedCall != null) {
                void $receiver;
                ResolvedCall<CallableDescriptor> resolvedCall2 = resolvedCall;
                ResolvedCall call = (ResolvedCall)$receiver;
                Object d = call.getResultingDescriptor();
                Intrinsics.checkExpressionValueIsNotNull(d, (String)"call.getResultingDescriptor()");
                jetType = CallableReferencesResolutionUtilsKt.createReflectionTypeForCallableDescriptor(d, context, reflectionTypes, reference);
            } else {
                jetType = null;
            }
        } else {
            jetType = expectedTypeUnknown ? ErrorUtils.createFunctionPlaceholderType(KotlinPackage.emptyList(), false) : builtIns.getFunctionType(Annotations.Companion.getEMPTY(), null, KotlinPackage.emptyList(), TypeUtils.DONT_CARE);
        }
        return jetType;
    }
}

