/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.results;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.resolve.OverrideResolver;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallImpl;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.results.OverloadingConflictResolver;
import org.jetbrains.kotlin.resolve.calls.results.ResolutionStatus;
import org.jetbrains.kotlin.resolve.calls.tasks.ResolutionTask;

public class ResolutionResultsHandler {
    private final OverloadingConflictResolver overloadingConflictResolver;

    public ResolutionResultsHandler(@NotNull OverloadingConflictResolver overloadingConflictResolver) {
        if (overloadingConflictResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overloadingConflictResolver", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "<init>"));
        }
        this.overloadingConflictResolver = overloadingConflictResolver;
    }

    @NotNull
    public <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> computeResultAndReportErrors(@NotNull ResolutionTask task, @NotNull Collection<MutableResolvedCall<D>> candidates) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeResultAndReportErrors"));
        }
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeResultAndReportErrors"));
        }
        LinkedHashSet successfulCandidates = Sets.newLinkedHashSet();
        LinkedHashSet failedCandidates = Sets.newLinkedHashSet();
        LinkedHashSet incompleteCandidates = Sets.newLinkedHashSet();
        LinkedHashSet candidatesWithWrongReceiver = Sets.newLinkedHashSet();
        for (MutableResolvedCall<D> candidateCall : candidates) {
            ResolutionStatus status = candidateCall.getStatus();
            assert (status != ResolutionStatus.UNKNOWN_STATUS) : "No resolution for " + candidateCall.getCandidateDescriptor();
            if (status.isSuccess()) {
                successfulCandidates.add(candidateCall);
                continue;
            }
            if (status == ResolutionStatus.INCOMPLETE_TYPE_INFERENCE) {
                incompleteCandidates.add(candidateCall);
                continue;
            }
            if (candidateCall.getStatus() == ResolutionStatus.RECEIVER_TYPE_ERROR) {
                candidatesWithWrongReceiver.add(candidateCall);
                continue;
            }
            if (candidateCall.getStatus() == ResolutionStatus.RECEIVER_PRESENCE_ERROR) continue;
            failedCandidates.add(candidateCall);
        }
        if (!successfulCandidates.isEmpty() || !incompleteCandidates.isEmpty()) {
            OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = this.computeSuccessfulResult(task, successfulCandidates, incompleteCandidates);
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeResultAndReportErrors"));
            }
            return overloadResolutionResultsImpl;
        }
        if (!failedCandidates.isEmpty()) {
            OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = this.computeFailedResult(task, failedCandidates);
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeResultAndReportErrors"));
            }
            return overloadResolutionResultsImpl;
        }
        if (!candidatesWithWrongReceiver.isEmpty()) {
            task.tracing.unresolvedReferenceWrongReceiver(task.trace, candidatesWithWrongReceiver);
            OverloadResolutionResultsImpl overloadResolutionResultsImpl = OverloadResolutionResultsImpl.candidatesWithWrongReceiver(candidatesWithWrongReceiver);
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeResultAndReportErrors"));
            }
            return overloadResolutionResultsImpl;
        }
        task.tracing.unresolvedReference(task.trace);
        OverloadResolutionResultsImpl overloadResolutionResultsImpl = OverloadResolutionResultsImpl.nameNotFound();
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeResultAndReportErrors"));
        }
        return overloadResolutionResultsImpl;
    }

    @NotNull
    private <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> computeSuccessfulResult(@NotNull ResolutionTask task, @NotNull Set<MutableResolvedCall<D>> successfulCandidates, @NotNull Set<MutableResolvedCall<D>> incompleteCandidates) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeSuccessfulResult"));
        }
        if (successfulCandidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "successfulCandidates", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeSuccessfulResult"));
        }
        if (incompleteCandidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "incompleteCandidates", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeSuccessfulResult"));
        }
        LinkedHashSet successfulAndIncomplete = Sets.newLinkedHashSet();
        successfulAndIncomplete.addAll(successfulCandidates);
        successfulAndIncomplete.addAll(incompleteCandidates);
        OverloadResolutionResultsImpl<D> results2 = this.chooseAndReportMaximallySpecific(successfulAndIncomplete, true);
        if (results2.isSingleResult()) {
            ResolvedCall resultingCall = results2.getResultingCall();
            resultingCall.getTrace().moveAllMyDataTo(task.trace);
            if (resultingCall.getStatus() == ResolutionStatus.INCOMPLETE_TYPE_INFERENCE) {
                OverloadResolutionResultsImpl overloadResolutionResultsImpl = OverloadResolutionResultsImpl.incompleteTypeInference(resultingCall);
                if (overloadResolutionResultsImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeSuccessfulResult"));
                }
                return overloadResolutionResultsImpl;
            }
        }
        if (results2.isAmbiguity()) {
            task.tracing.recordAmbiguity(task.trace, results2.getResultingCalls());
            boolean allCandidatesIncomplete = ResolutionResultsHandler.allIncomplete(results2.getResultingCalls());
            if (task.checkArguments != CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS || !CallUtilPackage.hasUnresolvedArguments(task.call, task)) {
                if (allCandidatesIncomplete) {
                    task.tracing.cannotCompleteResolve(task.trace, results2.getResultingCalls());
                } else {
                    task.tracing.ambiguity(task.trace, results2.getResultingCalls());
                }
            }
            if (allCandidatesIncomplete) {
                OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = OverloadResolutionResultsImpl.incompleteTypeInference(results2.getResultingCalls());
                if (overloadResolutionResultsImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeSuccessfulResult"));
                }
                return overloadResolutionResultsImpl;
            }
        }
        OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = results2;
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeSuccessfulResult"));
        }
        return overloadResolutionResultsImpl;
    }

    @NotNull
    private <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> computeFailedResult(@NotNull ResolutionTask task, @NotNull Set<MutableResolvedCall<D>> failedCandidates) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeFailedResult"));
        }
        if (failedCandidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "failedCandidates", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeFailedResult"));
        }
        if (failedCandidates.size() != 1) {
            for (EnumSet<ResolutionStatus> severityLevel : ResolutionStatus.SEVERITY_LEVELS) {
                LinkedHashSet thisLevel = Sets.newLinkedHashSet();
                for (MutableResolvedCall<D> candidate : failedCandidates) {
                    if (!severityLevel.contains((Object)candidate.getStatus())) continue;
                    thisLevel.add(candidate);
                }
                if (thisLevel.isEmpty()) continue;
                if (severityLevel.contains((Object)ResolutionStatus.ARGUMENTS_MAPPING_ERROR)) {
                    OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = ResolutionResultsHandler.recordFailedInfo(task, thisLevel);
                    if (overloadResolutionResultsImpl == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeFailedResult"));
                    }
                    return overloadResolutionResultsImpl;
                }
                OverloadResolutionResultsImpl<D> results2 = this.chooseAndReportMaximallySpecific(thisLevel, false);
                OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = ResolutionResultsHandler.recordFailedInfo(task, results2.getResultingCalls());
                if (overloadResolutionResultsImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeFailedResult"));
                }
                return overloadResolutionResultsImpl;
            }
            assert (false) : "Should not be reachable, cause every status must belong to some level";
            Set<MutableResolvedCall<D>> noOverrides = OverrideResolver.filterOutOverridden(failedCandidates, ResolvedCallImpl.MAP_TO_CANDIDATE);
            OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = ResolutionResultsHandler.recordFailedInfo(task, noOverrides);
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeFailedResult"));
            }
            return overloadResolutionResultsImpl;
        }
        OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = ResolutionResultsHandler.recordFailedInfo(task, failedCandidates);
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "computeFailedResult"));
        }
        return overloadResolutionResultsImpl;
    }

    @NotNull
    private static <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> recordFailedInfo(@NotNull ResolutionTask task, @NotNull Collection<MutableResolvedCall<D>> candidates) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "recordFailedInfo"));
        }
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "recordFailedInfo"));
        }
        if (candidates.size() == 1) {
            MutableResolvedCall<D> failed = candidates.iterator().next();
            failed.getTrace().moveAllMyDataTo(task.trace);
            OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = OverloadResolutionResultsImpl.singleFailedCandidate(failed);
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "recordFailedInfo"));
            }
            return overloadResolutionResultsImpl;
        }
        task.tracing.noneApplicable(task.trace, candidates);
        task.tracing.recordAmbiguity(task.trace, candidates);
        OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = OverloadResolutionResultsImpl.manyFailedCandidates(candidates);
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "recordFailedInfo"));
        }
        return overloadResolutionResultsImpl;
    }

    private static <D extends CallableDescriptor> boolean allIncomplete(@NotNull Collection<MutableResolvedCall<D>> results2) {
        if (results2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "allIncomplete"));
        }
        for (MutableResolvedCall<D> result2 : results2) {
            if (result2.getStatus() == ResolutionStatus.INCOMPLETE_TYPE_INFERENCE) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> chooseAndReportMaximallySpecific(@NotNull Set<MutableResolvedCall<D>> candidates, boolean discriminateGenerics) {
        MutableResolvedCall maximallySpecificGenericsDiscriminated;
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "chooseAndReportMaximallySpecific"));
        }
        if (candidates.size() == 1) {
            OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = OverloadResolutionResultsImpl.success(candidates.iterator().next());
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "chooseAndReportMaximallySpecific"));
            }
            return overloadResolutionResultsImpl;
        }
        Set noOverrides = OverrideResolver.filterOutOverridden(candidates, ResolvedCallImpl.MAP_TO_RESULT);
        if (noOverrides.size() == 1) {
            OverloadResolutionResultsImpl<?> overloadResolutionResultsImpl = OverloadResolutionResultsImpl.success(noOverrides.iterator().next());
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "chooseAndReportMaximallySpecific"));
            }
            return overloadResolutionResultsImpl;
        }
        MutableResolvedCall maximallySpecific = this.overloadingConflictResolver.findMaximallySpecific(noOverrides, false);
        if (maximallySpecific != null) {
            OverloadResolutionResultsImpl overloadResolutionResultsImpl = OverloadResolutionResultsImpl.success(maximallySpecific);
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "chooseAndReportMaximallySpecific"));
            }
            return overloadResolutionResultsImpl;
        }
        if (discriminateGenerics && (maximallySpecificGenericsDiscriminated = this.overloadingConflictResolver.findMaximallySpecific(noOverrides, true)) != null) {
            OverloadResolutionResultsImpl overloadResolutionResultsImpl = OverloadResolutionResultsImpl.success(maximallySpecificGenericsDiscriminated);
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "chooseAndReportMaximallySpecific"));
            }
            return overloadResolutionResultsImpl;
        }
        OverloadResolutionResultsImpl overloadResolutionResultsImpl = OverloadResolutionResultsImpl.ambiguity(noOverrides);
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/results/ResolutionResultsHandler", "chooseAndReportMaximallySpecific"));
        }
        return overloadResolutionResultsImpl;
    }
}

