/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.smartcasts;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.Nullability;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeUtils;

class DelegatingDataFlowInfo
implements DataFlowInfo {
    private static final ImmutableMap<DataFlowValue, Nullability> EMPTY_NULLABILITY_INFO = ImmutableMap.of();
    private static final SetMultimap<DataFlowValue, JetType> EMPTY_TYPE_INFO = DelegatingDataFlowInfo.newTypeInfo();
    @Nullable
    private final DataFlowInfo parent;
    @NotNull
    private final ImmutableMap<DataFlowValue, Nullability> nullabilityInfo;
    @NotNull
    private final SetMultimap<DataFlowValue, JetType> typeInfo;
    @Nullable
    private final DataFlowValue valueWithGivenTypeInfo;

    DelegatingDataFlowInfo(@Nullable DataFlowInfo parent, @NotNull ImmutableMap<DataFlowValue, Nullability> nullabilityInfo, @NotNull SetMultimap<DataFlowValue, JetType> typeInfo) {
        if (nullabilityInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nullabilityInfo", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "<init>"));
        }
        if (typeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeInfo", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "<init>"));
        }
        this(parent, nullabilityInfo, typeInfo, null);
    }

    DelegatingDataFlowInfo(@Nullable DataFlowInfo parent, @NotNull ImmutableMap<DataFlowValue, Nullability> nullabilityInfo, @NotNull SetMultimap<DataFlowValue, JetType> typeInfo, @Nullable DataFlowValue valueWithGivenTypeInfo) {
        if (nullabilityInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nullabilityInfo", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "<init>"));
        }
        if (typeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeInfo", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "<init>"));
        }
        this.parent = parent;
        this.nullabilityInfo = nullabilityInfo;
        this.typeInfo = typeInfo;
        this.valueWithGivenTypeInfo = valueWithGivenTypeInfo;
    }

    @Override
    @NotNull
    public Map<DataFlowValue, Nullability> getCompleteNullabilityInfo() {
        HashMap result2 = Maps.newHashMap();
        DelegatingDataFlowInfo info = this;
        while (info != null) {
            for (Map.Entry entry : info.nullabilityInfo.entrySet()) {
                DataFlowValue key = (DataFlowValue)entry.getKey();
                Nullability value2 = (Nullability)((Object)entry.getValue());
                if (result2.containsKey(key)) continue;
                result2.put(key, value2);
            }
            info = (DelegatingDataFlowInfo)info.parent;
        }
        HashMap hashMap = result2;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "getCompleteNullabilityInfo"));
        }
        return hashMap;
    }

    @Override
    @NotNull
    public SetMultimap<DataFlowValue, JetType> getCompleteTypeInfo() {
        SetMultimap<DataFlowValue, JetType> result2 = DelegatingDataFlowInfo.newTypeInfo();
        HashSet<DataFlowValue> withGivenTypeInfo = new HashSet<DataFlowValue>();
        DelegatingDataFlowInfo info = this;
        while (info != null) {
            for (DataFlowValue key : info.typeInfo.keySet()) {
                if (withGivenTypeInfo.contains(key)) continue;
                result2.putAll((Object)key, (Iterable)info.typeInfo.get((Object)key));
            }
            if (info.valueWithGivenTypeInfo != null) {
                withGivenTypeInfo.add(info.valueWithGivenTypeInfo);
            }
            info = (DelegatingDataFlowInfo)info.parent;
        }
        SetMultimap<DataFlowValue, JetType> setMultimap = result2;
        if (setMultimap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "getCompleteTypeInfo"));
        }
        return setMultimap;
    }

    @Override
    @NotNull
    public Nullability getNullability(@NotNull DataFlowValue key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "getNullability"));
        }
        if (!key.isPredictable()) {
            Nullability nullability = key.getImmanentNullability();
            if (nullability == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "getNullability"));
            }
            return nullability;
        }
        Nullability nullability = (Nullability)((Object)this.nullabilityInfo.get((Object)key));
        Nullability nullability2 = nullability != null ? nullability : (this.parent != null ? this.parent.getNullability(key) : key.getImmanentNullability());
        if (nullability2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "getNullability"));
        }
        return nullability2;
    }

    private boolean putNullability(@NotNull Map<DataFlowValue, Nullability> map2, @NotNull DataFlowValue value2, @NotNull Nullability nullability) {
        if (map2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "putNullability"));
        }
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "putNullability"));
        }
        if (nullability == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nullability", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "putNullability"));
        }
        if (!value2.isPredictable()) {
            return false;
        }
        map2.put(value2, nullability);
        return nullability != this.getNullability(value2);
    }

    @Override
    @NotNull
    public Set<JetType> getPossibleTypes(@NotNull DataFlowValue key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "getPossibleTypes"));
        }
        JetType originalType = key.getType();
        Set<JetType> types2 = this.collectTypesFromMeAndParents(key);
        if (this.getNullability(key).canBeNull()) {
            Set<JetType> set = types2;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "getPossibleTypes"));
            }
            return set;
        }
        HashSet enrichedTypes = Sets.newHashSetWithExpectedSize((int)(types2.size() + 1));
        if (originalType.isMarkedNullable()) {
            enrichedTypes.add(TypeUtils.makeNotNullable(originalType));
        }
        for (JetType type2 : types2) {
            enrichedTypes.add(TypeUtils.makeNotNullable(type2));
        }
        HashSet hashSet = enrichedTypes;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "getPossibleTypes"));
        }
        return hashSet;
    }

    @Override
    @NotNull
    public DataFlowInfo clearValueInfo(@NotNull DataFlowValue value2) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "clearValueInfo"));
        }
        HashMap builder = Maps.newHashMap();
        this.putNullability(builder, value2, Nullability.UNKNOWN);
        DelegatingDataFlowInfo delegatingDataFlowInfo = new DelegatingDataFlowInfo(this, (ImmutableMap<DataFlowValue, Nullability>)ImmutableMap.copyOf((Map)builder), EMPTY_TYPE_INFO, value2);
        if (delegatingDataFlowInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "clearValueInfo"));
        }
        return delegatingDataFlowInfo;
    }

    @Override
    @NotNull
    public DataFlowInfo assign(@NotNull DataFlowValue a, @NotNull DataFlowValue b) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "assign"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "assign"));
        }
        HashMap nullability = Maps.newHashMap();
        Nullability nullabilityOfB = this.getNullability(b);
        this.putNullability(nullability, a, nullabilityOfB);
        SetMultimap<DataFlowValue, JetType> newTypeInfo = DelegatingDataFlowInfo.newTypeInfo();
        Set<JetType> typesForB = this.collectTypesFromMeAndParents(b);
        if (nullabilityOfB.canBeNonNull() && !((Object)a.getType()).equals(b.getType())) {
            typesForB.add(b.getType());
        }
        newTypeInfo.putAll((Object)a, typesForB);
        DelegatingDataFlowInfo delegatingDataFlowInfo = new DelegatingDataFlowInfo(this, (ImmutableMap<DataFlowValue, Nullability>)ImmutableMap.copyOf((Map)nullability), newTypeInfo.isEmpty() ? EMPTY_TYPE_INFO : newTypeInfo, a);
        if (delegatingDataFlowInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "assign"));
        }
        return delegatingDataFlowInfo;
    }

    @Override
    @NotNull
    public DataFlowInfo equate(@NotNull DataFlowValue a, @NotNull DataFlowValue b) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "equate"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "equate"));
        }
        HashMap builder = Maps.newHashMap();
        Nullability nullabilityOfA = this.getNullability(a);
        Nullability nullabilityOfB = this.getNullability(b);
        boolean changed = false;
        changed |= this.putNullability(builder, a, nullabilityOfA.refine(nullabilityOfB));
        changed |= this.putNullability(builder, b, nullabilityOfB.refine(nullabilityOfA));
        SetMultimap<DataFlowValue, JetType> newTypeInfo = DelegatingDataFlowInfo.newTypeInfo();
        newTypeInfo.putAll((Object)a, this.collectTypesFromMeAndParents(b));
        newTypeInfo.putAll((Object)b, this.collectTypesFromMeAndParents(a));
        DelegatingDataFlowInfo delegatingDataFlowInfo = !(changed |= !newTypeInfo.isEmpty()) ? this : new DelegatingDataFlowInfo(this, (ImmutableMap<DataFlowValue, Nullability>)ImmutableMap.copyOf((Map)builder), newTypeInfo.isEmpty() ? EMPTY_TYPE_INFO : newTypeInfo);
        if (delegatingDataFlowInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "equate"));
        }
        return delegatingDataFlowInfo;
    }

    @NotNull
    private Set<JetType> collectTypesFromMeAndParents(@NotNull DataFlowValue value2) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "collectTypesFromMeAndParents"));
        }
        LinkedHashSet<JetType> types2 = new LinkedHashSet<JetType>();
        DataFlowInfo current = this;
        while (current != null) {
            if (current instanceof DelegatingDataFlowInfo) {
                DelegatingDataFlowInfo delegatingInfo = current;
                types2.addAll(delegatingInfo.typeInfo.get((Object)value2));
                if (value2.equals(delegatingInfo.valueWithGivenTypeInfo)) {
                    current = null;
                    continue;
                }
                current = delegatingInfo.parent;
                continue;
            }
            types2.addAll(current.getPossibleTypes(value2));
            break;
        }
        LinkedHashSet<JetType> linkedHashSet = types2;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "collectTypesFromMeAndParents"));
        }
        return linkedHashSet;
    }

    @Override
    @NotNull
    public DataFlowInfo disequate(@NotNull DataFlowValue a, @NotNull DataFlowValue b) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "disequate"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "disequate"));
        }
        HashMap builder = Maps.newHashMap();
        Nullability nullabilityOfA = this.getNullability(a);
        Nullability nullabilityOfB = this.getNullability(b);
        boolean changed = false;
        changed |= this.putNullability(builder, a, nullabilityOfA.refine(nullabilityOfB.invert()));
        DelegatingDataFlowInfo delegatingDataFlowInfo = (changed |= this.putNullability(builder, b, nullabilityOfB.refine(nullabilityOfA.invert()))) ? new DelegatingDataFlowInfo(this, (ImmutableMap<DataFlowValue, Nullability>)ImmutableMap.copyOf((Map)builder), EMPTY_TYPE_INFO) : this;
        if (delegatingDataFlowInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "disequate"));
        }
        return delegatingDataFlowInfo;
    }

    @Override
    @NotNull
    public DataFlowInfo establishSubtyping(@NotNull DataFlowValue value2, @NotNull JetType type2) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "establishSubtyping"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "establishSubtyping"));
        }
        if (((Object)value2.getType()).equals(type2)) {
            DelegatingDataFlowInfo delegatingDataFlowInfo = this;
            if (delegatingDataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "establishSubtyping"));
            }
            return delegatingDataFlowInfo;
        }
        if (this.getPossibleTypes(value2).contains(type2)) {
            DelegatingDataFlowInfo delegatingDataFlowInfo = this;
            if (delegatingDataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "establishSubtyping"));
            }
            return delegatingDataFlowInfo;
        }
        ImmutableMap newNullabilityInfo = type2.isMarkedNullable() ? EMPTY_NULLABILITY_INFO : ImmutableMap.of((Object)value2, (Object)((Object)Nullability.NOT_NULL));
        ImmutableSetMultimap newTypeInfo = ImmutableSetMultimap.of((Object)value2, (Object)type2);
        DelegatingDataFlowInfo delegatingDataFlowInfo = new DelegatingDataFlowInfo(this, (ImmutableMap<DataFlowValue, Nullability>)newNullabilityInfo, (SetMultimap<DataFlowValue, JetType>)newTypeInfo);
        if (delegatingDataFlowInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "establishSubtyping"));
        }
        return delegatingDataFlowInfo;
    }

    @Override
    @NotNull
    public DataFlowInfo and(@NotNull DataFlowInfo otherInfo) {
        if (otherInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherInfo", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "and"));
        }
        if (otherInfo == EMPTY) {
            DelegatingDataFlowInfo delegatingDataFlowInfo = this;
            if (delegatingDataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "and"));
            }
            return delegatingDataFlowInfo;
        }
        if (this == EMPTY) {
            DataFlowInfo dataFlowInfo = otherInfo;
            if (dataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "and"));
            }
            return dataFlowInfo;
        }
        if (this == otherInfo) {
            DelegatingDataFlowInfo delegatingDataFlowInfo = this;
            if (delegatingDataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "and"));
            }
            return delegatingDataFlowInfo;
        }
        assert (otherInfo instanceof DelegatingDataFlowInfo) : "Unknown DataFlowInfo type: " + otherInfo;
        DelegatingDataFlowInfo other = (DelegatingDataFlowInfo)otherInfo;
        HashMap nullabilityMapBuilder = Maps.newHashMap();
        for (Map.Entry<DataFlowValue, Nullability> entry : other.getCompleteNullabilityInfo().entrySet()) {
            DataFlowValue key = entry.getKey();
            Nullability otherFlags = entry.getValue();
            Nullability thisFlags = this.getNullability(key);
            Nullability flags = thisFlags.and(otherFlags);
            if (flags == thisFlags) continue;
            nullabilityMapBuilder.put(key, flags);
        }
        SetMultimap<DataFlowValue, JetType> myTypeInfo = this.getCompleteTypeInfo();
        SetMultimap<DataFlowValue, JetType> otherTypeInfo = other.getCompleteTypeInfo();
        if (nullabilityMapBuilder.isEmpty() && DelegatingDataFlowInfo.containsAll(myTypeInfo, otherTypeInfo)) {
            DelegatingDataFlowInfo delegatingDataFlowInfo = this;
            if (delegatingDataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "and"));
            }
            return delegatingDataFlowInfo;
        }
        DelegatingDataFlowInfo delegatingDataFlowInfo = new DelegatingDataFlowInfo(this, (ImmutableMap<DataFlowValue, Nullability>)ImmutableMap.copyOf((Map)nullabilityMapBuilder), otherTypeInfo);
        if (delegatingDataFlowInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "and"));
        }
        return delegatingDataFlowInfo;
    }

    private static boolean containsAll(SetMultimap<DataFlowValue, JetType> first, SetMultimap<DataFlowValue, JetType> second) {
        return first.entries().containsAll(second.entries());
    }

    @Override
    @NotNull
    public DataFlowInfo or(@NotNull DataFlowInfo otherInfo) {
        if (otherInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherInfo", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "or"));
        }
        if (otherInfo == EMPTY) {
            DataFlowInfo dataFlowInfo = EMPTY;
            if (dataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "or"));
            }
            return dataFlowInfo;
        }
        if (this == EMPTY) {
            DataFlowInfo dataFlowInfo = EMPTY;
            if (dataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "or"));
            }
            return dataFlowInfo;
        }
        if (this == otherInfo) {
            DelegatingDataFlowInfo delegatingDataFlowInfo = this;
            if (delegatingDataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "or"));
            }
            return delegatingDataFlowInfo;
        }
        assert (otherInfo instanceof DelegatingDataFlowInfo) : "Unknown DataFlowInfo type: " + otherInfo;
        DelegatingDataFlowInfo other = (DelegatingDataFlowInfo)otherInfo;
        HashMap nullabilityMapBuilder = Maps.newHashMap();
        for (Map.Entry<DataFlowValue, Nullability> entry : other.getCompleteNullabilityInfo().entrySet()) {
            DataFlowValue key = entry.getKey();
            Nullability otherFlags = entry.getValue();
            Nullability thisFlags = this.getNullability(key);
            nullabilityMapBuilder.put(key, thisFlags.or(otherFlags));
        }
        SetMultimap<DataFlowValue, JetType> myTypeInfo = this.getCompleteTypeInfo();
        SetMultimap<DataFlowValue, JetType> otherTypeInfo = other.getCompleteTypeInfo();
        SetMultimap<DataFlowValue, JetType> newTypeInfo = DelegatingDataFlowInfo.newTypeInfo();
        for (DataFlowValue key : Sets.intersection((Set)myTypeInfo.keySet(), (Set)otherTypeInfo.keySet())) {
            Set thisTypes = myTypeInfo.get((Object)key);
            Set otherTypes = otherTypeInfo.get((Object)key);
            newTypeInfo.putAll((Object)key, (Iterable)Sets.intersection((Set)thisTypes, (Set)otherTypes));
        }
        if (nullabilityMapBuilder.isEmpty() && newTypeInfo.isEmpty()) {
            DataFlowInfo dataFlowInfo = EMPTY;
            if (dataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "or"));
            }
            return dataFlowInfo;
        }
        DelegatingDataFlowInfo delegatingDataFlowInfo = new DelegatingDataFlowInfo(null, (ImmutableMap<DataFlowValue, Nullability>)ImmutableMap.copyOf((Map)nullabilityMapBuilder), newTypeInfo);
        if (delegatingDataFlowInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "or"));
        }
        return delegatingDataFlowInfo;
    }

    @NotNull
    static SetMultimap<DataFlowValue, JetType> newTypeInfo() {
        LinkedHashMultimap linkedHashMultimap = LinkedHashMultimap.create();
        if (linkedHashMultimap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/DelegatingDataFlowInfo", "newTypeInfo"));
        }
        return linkedHashMultimap;
    }

    public String toString() {
        if (this.typeInfo.isEmpty() && this.nullabilityInfo.isEmpty()) {
            return "EMPTY";
        }
        return "Non-trivial DataFlowInfo";
    }
}

