/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.platform;

import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DeclarationChecker;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatformConfiguratorKt;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"\"\u0006))#+Z5gS\u0016$G+\u001f9f!\u0006\u0014\u0018-\\3uKJ\feN\\8uCRLwN\\\"iK\u000e\\WM\u001d\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0019Yw\u000e\u001e7j]*9!/Z:pYZ,'b\u00016w[*A\u0001\u000f\\1uM>\u0014XN\u0003\nEK\u000ed\u0017M]1uS>t7\t[3dW\u0016\u0014(B\u0002\u001fj]&$hHC\u0003dQ\u0016\u001c7NC\u0006eK\u000ed\u0017M]1uS>t'B\u0004&fi\u0012+7\r\\1sCRLwN\u001c\u0006\u0004aNL'B\u00033fg\u000e\u0014\u0018\u000e\u001d;pe*)B)Z2mCJ\fG/[8o\t\u0016\u001c8M]5qi>\u0014(b\u00033fg\u000e\u0014\u0018\u000e\u001d;peNT\u0001\u0003Z5bO:|7\u000f^5d\u0011>dG-\u001a:\u000b\u001d\u0011K\u0017m\u001a8pgRL7mU5oW*YA-[1h]>\u001cH/[2t\u00159\u0011\u0017N\u001c3j]\u001e\u001cuN\u001c;fqRTaBQ5oI&twmQ8oi\u0016DHO\u0003\u0003V]&$\b2\u0001\u0006\u0003!\u0005QA\u0001\u0003\u0001\u0011\u0005)!\u0001\"\u0001\t\u0004\u0015\u0011A!\u0001\u0005\u0003\u000b\t!\u0019\u0001#\u0002\u0006\u0005\u0011\u0011\u0001bA\u0003\u0004\t\u000bA\u0001\u0001\u0004\u0001\u0006\u0007\u0011\r\u0001r\u0001\u0007\u0001\u000b\t!\u0011\u0001\u0003\u0004\u0006\u0007\u0011!\u00012\u0002\u0007\u0001\u000b\t!\u0011\u0001c\u0004\u0006\u0007\u0011)\u0001b\u0002\u0007\u0001\u000b\t!\u0011\u0001C\u0005\u0006\u0007\u00111\u0001\u0012\u0003\u0007\u0001\u000b\r!\u0019\u0001\u0003\u0006\r\u0001\u0015\t\u00012A\u0003\u0004\t\u001fA)\u0002\u0004\u0001\u0006\u0005\u0011!\u00012B\u0003\u0003\t\u0015Aq!\u0002\u0002\u0005\r!EQA\u0001C\u0002\u0011)!1\u0001D\u0002\u001a\u0007\u0015\t\u0001r\u0001M\u0004[S\"1\u0002'\u0003\u001e\u0010\u0011\u0001\u0001\"B\u0007\u0004\u000b\u0005AI\u0001'\u0003Q\u0007\u0001iz\u0001\u0002\u0001\t\u000e5\u0019Q!\u0001E\u00061\u0017\u00016\u0011AO\b\t\u0001A\u0001\"D\u0002\u0006\u0003!5\u0001T\u0002)\u0004\u0003u=A\u0001\u0001E\n\u001b\r)\u0011\u0001C\u0004\u0019\u000fA\u001b\u0019!I\u0002\u0006\u0003!A\u0001\u0004C)\u0004\u0017\u0011%\u0011\"\u0001\u0003\u0001\u001b\u0005A\t\"D\u0001\t\u00135\t\u00012C\u0007\u0002\u0011))D\"B\u0006\u0005G\u0004AB!I\u0002\u0006\u0003!\u0019\u0001dA)\u0004\u0007\u0011!\u0011\"\u0001\u0003\u0001"})
public final class ReifiedTypeParameterAnnotationChecker
implements DeclarationChecker {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(ReifiedTypeParameterAnnotationChecker.class);
    }

    @Override
    public void check(@NotNull JetDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)diagnosticHolder, (String)"diagnosticHolder");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        if (AnnotationUtilKt.hasIntrinsicAnnotation(descriptor2)) {
            return;
        }
        if (descriptor2 instanceof CallableDescriptor && !AnnotationUtilKt.hasInlineAnnotation(descriptor2)) {
            List<TypeParameterDescriptor> list = ((CallableDescriptor)descriptor2).getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"descriptor.getTypeParameters()");
            JvmPlatformConfiguratorKt.checkTypeParameterDescriptorsAreNotReified(list, diagnosticHolder);
        }
        if (descriptor2 instanceof ClassDescriptor) {
            List<TypeParameterDescriptor> list = ((ClassDescriptor)descriptor2).getTypeConstructor().getParameters();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"descriptor.getTypeConstructor().getParameters()");
            JvmPlatformConfiguratorKt.checkTypeParameterDescriptorsAreNotReified(list, diagnosticHolder);
        }
    }
}

