/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.context.GlobalContext;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetPrimaryConstructor;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetScript;
import org.jetbrains.kotlin.psi.JetSecondaryConstructor;
import org.jetbrains.kotlin.psi.JetStubbedPsiUtil;
import org.jetbrains.kotlin.psi.JetTypeParameter;
import org.jetbrains.kotlin.psi.JetTypeParameterListOwner;
import org.jetbrains.kotlin.psi.JetVisitor;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilPackage;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.lazy.DeclarationScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.DeclarationScopeProviderImpl;
import org.jetbrains.kotlin.resolve.lazy.NoDescriptorForDeclarationException;
import org.jetbrains.kotlin.resolve.lazy.TopLevelDescriptorProvider;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyPackageDescriptor;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.storage.LockBasedLazyResolveStorageManager;

public class LazyDeclarationResolver {
    @NotNull
    private final TopLevelDescriptorProvider topLevelDescriptorProvider;
    @NotNull
    private final BindingTrace trace;
    protected DeclarationScopeProvider scopeProvider;

    @Inject
    public void setDeclarationScopeProvider(@NotNull DeclarationScopeProviderImpl scopeProvider) {
        if (scopeProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeProvider", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver", "setDeclarationScopeProvider"));
        }
        this.scopeProvider = scopeProvider;
    }

    @Deprecated
    public LazyDeclarationResolver(@NotNull GlobalContext globalContext, @NotNull BindingTrace delegationTrace, @NotNull TopLevelDescriptorProvider topLevelDescriptorProvider) {
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver", "<init>"));
        }
        if (delegationTrace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegationTrace", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver", "<init>"));
        }
        if (topLevelDescriptorProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topLevelDescriptorProvider", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver", "<init>"));
        }
        this.topLevelDescriptorProvider = topLevelDescriptorProvider;
        LockBasedLazyResolveStorageManager lockBasedLazyResolveStorageManager = new LockBasedLazyResolveStorageManager(globalContext.getStorageManager());
        this.trace = lockBasedLazyResolveStorageManager.createSafeTrace(delegationTrace);
    }

    @NotNull
    public ClassDescriptor getClassDescriptor(@NotNull JetClassOrObject classOrObject, @NotNull LookupLocation location2) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver", "getClassDescriptor"));
        }
        if (location2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver", "getClassDescriptor"));
        }
        JetScope scope2 = this.getMemberScopeDeclaredIn(classOrObject, location2);
        ClassifierDescriptor scopeDescriptor = scope2.getClassifier(classOrObject.getNameAsSafeName(), location2);
        DeclarationDescriptor descriptor2 = this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, classOrObject);
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Could not find a classifier for %s.\nFound descriptor: %s (%s).\n", PsiUtilPackage.getElementTextWithContext(classOrObject), scopeDescriptor != null ? DescriptorRenderer.DEBUG_TEXT.render(scopeDescriptor) : "null", scopeDescriptor != null ? scopeDescriptor.getContainingDeclaration().getClass() : null));
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)descriptor2;
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver", "getClassDescriptor"));
        }
        return classDescriptor;
    }

    @NotNull
    private BindingContext getBindingContext() {
        BindingContext bindingContext2 = this.trace.getBindingContext();
        if (bindingContext2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver", "getBindingContext"));
        }
        return bindingContext2;
    }

    @NotNull
    public DeclarationDescriptor resolveToDescriptor(@NotNull JetDeclaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver", "resolveToDescriptor"));
        }
        DeclarationDescriptor declarationDescriptor = this.resolveToDescriptor(declaration, true);
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver", "resolveToDescriptor"));
        }
        return declarationDescriptor;
    }

    @NotNull
    private DeclarationDescriptor resolveToDescriptor(@NotNull JetDeclaration declaration, final boolean track) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver", "resolveToDescriptor"));
        }
        DeclarationDescriptor result2 = declaration.accept(new JetVisitor<DeclarationDescriptor, Void>(){

            @NotNull
            private LookupLocation lookupLocationFor(@NotNull JetDeclaration declaration, boolean isTopLevel) {
                if (declaration == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver$1", "lookupLocationFor"));
                }
                LookupLocation lookupLocation = isTopLevel && track ? new KotlinLookupLocation(declaration) : NoLookupLocation.WHEN_RESOLVE_DECLARATION;
                if (lookupLocation == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver$1", "lookupLocationFor"));
                }
                return lookupLocation;
            }

            @Override
            public DeclarationDescriptor visitClass(@NotNull JetClass klass, Void data2) {
                if (klass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver$1", "visitClass"));
                }
                return LazyDeclarationResolver.this.getClassDescriptor(klass, this.lookupLocationFor(klass, klass.isTopLevel()));
            }

            @Override
            public DeclarationDescriptor visitObjectDeclaration(@NotNull JetObjectDeclaration declaration, Void data2) {
                if (declaration == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver$1", "visitObjectDeclaration"));
                }
                return LazyDeclarationResolver.this.getClassDescriptor(declaration, this.lookupLocationFor(declaration, declaration.isTopLevel()));
            }

            @Override
            public DeclarationDescriptor visitTypeParameter(@NotNull JetTypeParameter parameter, Void data2) {
                List<TypeParameterDescriptor> typeParameters;
                if (parameter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver$1", "visitTypeParameter"));
                }
                JetTypeParameterListOwner ownerElement = (JetTypeParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)parameter, JetTypeParameterListOwner.class);
                assert (ownerElement != null) : "Owner not found for type parameter: " + parameter.getText();
                DeclarationDescriptor ownerDescriptor = LazyDeclarationResolver.this.resolveToDescriptor(ownerElement, false);
                if (ownerDescriptor instanceof CallableDescriptor) {
                    CallableDescriptor callableDescriptor = (CallableDescriptor)ownerDescriptor;
                    typeParameters = callableDescriptor.getTypeParameters();
                } else if (ownerDescriptor instanceof ClassDescriptor) {
                    ClassDescriptor classDescriptor = (ClassDescriptor)ownerDescriptor;
                    typeParameters = classDescriptor.getTypeConstructor().getParameters();
                } else {
                    throw new IllegalStateException("Unknown owner kind for a type parameter: " + ownerDescriptor);
                }
                Name name2 = parameter.getNameAsSafeName();
                for (TypeParameterDescriptor typeParameterDescriptor : typeParameters) {
                    if (!typeParameterDescriptor.getName().equals(name2)) continue;
                    return typeParameterDescriptor;
                }
                throw new IllegalStateException("Type parameter " + name2 + " not found for " + ownerDescriptor);
            }

            @Override
            public DeclarationDescriptor visitNamedFunction(@NotNull JetNamedFunction function2, Void data2) {
                if (function2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver$1", "visitNamedFunction"));
                }
                LookupLocation location2 = this.lookupLocationFor(function2, function2.isTopLevel());
                JetScope scopeForDeclaration = LazyDeclarationResolver.this.getMemberScopeDeclaredIn(function2, location2);
                scopeForDeclaration.getFunctions(function2.getNameAsSafeName(), location2);
                return LazyDeclarationResolver.this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, function2);
            }

            @Override
            public DeclarationDescriptor visitParameter(@NotNull JetParameter parameter, Void data2) {
                if (parameter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver$1", "visitParameter"));
                }
                PsiElement grandFather = parameter.getParent().getParent();
                if (grandFather instanceof JetPrimaryConstructor) {
                    JetClassOrObject jetClass = ((JetPrimaryConstructor)grandFather).getContainingClassOrObject();
                    ClassDescriptor classDescriptor = LazyDeclarationResolver.this.getClassDescriptor(jetClass, this.lookupLocationFor(jetClass, false));
                    if (parameter.hasValOrVar()) {
                        classDescriptor.getDefaultType().getMemberScope().getProperties(parameter.getNameAsSafeName(), this.lookupLocationFor(parameter, false));
                        return LazyDeclarationResolver.this.getBindingContext().get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter);
                    }
                    ConstructorDescriptor constructor = classDescriptor.getUnsubstitutedPrimaryConstructor();
                    assert (constructor != null) : "There are constructor parameters found, so a constructor should also exist";
                    constructor.getValueParameters();
                    return LazyDeclarationResolver.this.getBindingContext().get(BindingContext.VALUE_PARAMETER, parameter);
                }
                if (grandFather instanceof JetNamedFunction) {
                    FunctionDescriptor function2 = (FunctionDescriptor)this.visitNamedFunction((JetNamedFunction)grandFather, data2);
                    function2.getValueParameters();
                    return LazyDeclarationResolver.this.getBindingContext().get(BindingContext.VALUE_PARAMETER, parameter);
                }
                if (grandFather instanceof JetSecondaryConstructor) {
                    ConstructorDescriptor constructorDescriptor = (ConstructorDescriptor)this.visitSecondaryConstructor((JetSecondaryConstructor)grandFather, data2);
                    constructorDescriptor.getValueParameters();
                    return LazyDeclarationResolver.this.getBindingContext().get(BindingContext.VALUE_PARAMETER, parameter);
                }
                return (DeclarationDescriptor)super.visitParameter(parameter, data2);
            }

            @Override
            public DeclarationDescriptor visitSecondaryConstructor(@NotNull JetSecondaryConstructor constructor, Void data2) {
                if (constructor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver$1", "visitSecondaryConstructor"));
                }
                LazyDeclarationResolver.this.getClassDescriptor((JetClassOrObject)constructor.getParent().getParent(), this.lookupLocationFor(constructor, false)).getConstructors();
                return LazyDeclarationResolver.this.getBindingContext().get(BindingContext.CONSTRUCTOR, constructor);
            }

            @Override
            public DeclarationDescriptor visitPrimaryConstructor(@NotNull JetPrimaryConstructor constructor, Void data2) {
                if (constructor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver$1", "visitPrimaryConstructor"));
                }
                LazyDeclarationResolver.this.getClassDescriptor(constructor.getContainingClassOrObject(), this.lookupLocationFor(constructor, false)).getConstructors();
                return LazyDeclarationResolver.this.getBindingContext().get(BindingContext.CONSTRUCTOR, constructor);
            }

            @Override
            public DeclarationDescriptor visitProperty(@NotNull JetProperty property, Void data2) {
                if (property == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver$1", "visitProperty"));
                }
                LookupLocation location2 = this.lookupLocationFor(property, property.isTopLevel());
                JetScope scopeForDeclaration = LazyDeclarationResolver.this.getMemberScopeDeclaredIn(property, location2);
                scopeForDeclaration.getProperties(property.getNameAsSafeName(), location2);
                return LazyDeclarationResolver.this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, property);
            }

            @Override
            public DeclarationDescriptor visitScript(@NotNull JetScript script, Void data2) {
                if (script == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver$1", "visitScript"));
                }
                return LazyDeclarationResolver.this.topLevelDescriptorProvider.getScriptDescriptor(script);
            }

            @Override
            public DeclarationDescriptor visitJetElement(@NotNull JetElement element2, Void data2) {
                if (element2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver$1", "visitJetElement"));
                }
                throw new IllegalArgumentException("Unsupported declaration type: " + element2 + " " + PsiUtilPackage.getElementTextWithContext((PsiElement)element2));
            }
        }, null);
        if (result2 == null) {
            throw new NoDescriptorForDeclarationException(declaration);
        }
        DeclarationDescriptor declarationDescriptor = result2;
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver", "resolveToDescriptor"));
        }
        return declarationDescriptor;
    }

    @NotNull
    JetScope getMemberScopeDeclaredIn(@NotNull JetDeclaration declaration, @NotNull LookupLocation location2) {
        boolean isTopLevel;
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver", "getMemberScopeDeclaredIn"));
        }
        if (location2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver", "getMemberScopeDeclaredIn"));
        }
        JetDeclaration parentDeclaration = JetStubbedPsiUtil.getContainingDeclaration(declaration);
        boolean bl = isTopLevel = parentDeclaration == null;
        if (isTopLevel) {
            FqName fqName2 = ((JetFile)declaration.getContainingFile()).getPackageFqName();
            LazyPackageDescriptor packageDescriptor = this.topLevelDescriptorProvider.getPackageFragment(fqName2);
            assert (packageDescriptor != null);
            JetScope jetScope = packageDescriptor.getMemberScope();
            if (jetScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver", "getMemberScopeDeclaredIn"));
            }
            return jetScope;
        }
        if (parentDeclaration instanceof JetClassOrObject) {
            JetScope jetScope = this.getClassDescriptor((JetClassOrObject)parentDeclaration, location2).getUnsubstitutedMemberScope();
            if (jetScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/LazyDeclarationResolver", "getMemberScopeDeclaredIn"));
            }
            return jetScope;
        }
        throw new IllegalStateException("Don't call this method for local declarations: " + declaration + "\n" + PsiUtilPackage.getElementTextWithContext(declaration));
    }
}

