/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.psi.PsiElement;
import java.util.Collections;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.resolve.validation.SymbolUsageValidator;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.FakeCallResolver;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class ForLoopConventionsChecker {
    @NotNull
    private final KotlinBuiltIns builtIns;
    @NotNull
    private final SymbolUsageValidator symbolUsageValidator;
    @NotNull
    private final FakeCallResolver fakeCallResolver;

    public ForLoopConventionsChecker(@NotNull KotlinBuiltIns builtIns, @NotNull FakeCallResolver fakeCallResolver, @NotNull SymbolUsageValidator symbolUsageValidator) {
        if (builtIns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builtIns", "org/jetbrains/kotlin/types/expressions/ForLoopConventionsChecker", "<init>"));
        }
        if (fakeCallResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fakeCallResolver", "org/jetbrains/kotlin/types/expressions/ForLoopConventionsChecker", "<init>"));
        }
        if (symbolUsageValidator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbolUsageValidator", "org/jetbrains/kotlin/types/expressions/ForLoopConventionsChecker", "<init>"));
        }
        this.builtIns = builtIns;
        this.fakeCallResolver = fakeCallResolver;
        this.symbolUsageValidator = symbolUsageValidator;
    }

    @Nullable
    public JetType checkIterableConvention(@NotNull ExpressionReceiver loopRange, ExpressionTypingContext context) {
        if (loopRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopRange", "org/jetbrains/kotlin/types/expressions/ForLoopConventionsChecker", "checkIterableConvention"));
        }
        JetExpression loopRangeExpression = loopRange.getExpression();
        Name iterator2 = Name.identifier("iterator");
        Pair<Call, OverloadResolutionResults<FunctionDescriptor>> calls = this.fakeCallResolver.makeAndResolveFakeCall(loopRange, context, Collections.emptyList(), iterator2, loopRange.getExpression());
        OverloadResolutionResults iteratorResolutionResults = (OverloadResolutionResults)calls.getSecond();
        if (iteratorResolutionResults.isSuccess()) {
            ResolvedCall iteratorResolvedCall = iteratorResolutionResults.getResultingCall();
            context.trace.record(BindingContext.LOOP_RANGE_ITERATOR_RESOLVED_CALL, loopRangeExpression, iteratorResolvedCall);
            FunctionDescriptor iteratorFunction = (FunctionDescriptor)iteratorResolvedCall.getResultingDescriptor();
            this.symbolUsageValidator.validateCall(iteratorFunction, context.trace, (PsiElement)loopRangeExpression);
            JetType iteratorType = iteratorFunction.getReturnType();
            JetType hasNextType = this.checkConventionForIterator(context, loopRangeExpression, iteratorType, "hasNext", Errors.HAS_NEXT_FUNCTION_AMBIGUITY, Errors.HAS_NEXT_MISSING, Errors.HAS_NEXT_FUNCTION_NONE_APPLICABLE, BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL);
            if (hasNextType != null && !this.builtIns.isBooleanOrSubtype(hasNextType)) {
                context.trace.report(Errors.HAS_NEXT_FUNCTION_TYPE_MISMATCH.on(loopRangeExpression, hasNextType));
            }
            return this.checkConventionForIterator(context, loopRangeExpression, iteratorType, "next", Errors.NEXT_AMBIGUITY, Errors.NEXT_MISSING, Errors.NEXT_NONE_APPLICABLE, BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL);
        }
        if (iteratorResolutionResults.isAmbiguity()) {
            context.trace.report(Errors.ITERATOR_AMBIGUITY.on((PsiElement)loopRangeExpression, iteratorResolutionResults.getResultingCalls()));
        } else {
            context.trace.report(Errors.ITERATOR_MISSING.on(loopRangeExpression));
        }
        return null;
    }

    @Nullable
    private JetType checkConventionForIterator(@NotNull ExpressionTypingContext context, @NotNull JetExpression loopRangeExpression, @NotNull JetType iteratorType, @NotNull String name2, @NotNull DiagnosticFactory1<JetExpression, JetType> ambiguity, @NotNull DiagnosticFactory1<JetExpression, JetType> missing, @NotNull DiagnosticFactory1<JetExpression, JetType> noneApplicable, @NotNull WritableSlice<JetExpression, ResolvedCall<FunctionDescriptor>> resolvedCallKey) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/ForLoopConventionsChecker", "checkConventionForIterator"));
        }
        if (loopRangeExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopRangeExpression", "org/jetbrains/kotlin/types/expressions/ForLoopConventionsChecker", "checkConventionForIterator"));
        }
        if (iteratorType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iteratorType", "org/jetbrains/kotlin/types/expressions/ForLoopConventionsChecker", "checkConventionForIterator"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/types/expressions/ForLoopConventionsChecker", "checkConventionForIterator"));
        }
        if (ambiguity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ambiguity", "org/jetbrains/kotlin/types/expressions/ForLoopConventionsChecker", "checkConventionForIterator"));
        }
        if (missing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "missing", "org/jetbrains/kotlin/types/expressions/ForLoopConventionsChecker", "checkConventionForIterator"));
        }
        if (noneApplicable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "noneApplicable", "org/jetbrains/kotlin/types/expressions/ForLoopConventionsChecker", "checkConventionForIterator"));
        }
        if (resolvedCallKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCallKey", "org/jetbrains/kotlin/types/expressions/ForLoopConventionsChecker", "checkConventionForIterator"));
        }
        OverloadResolutionResults<FunctionDescriptor> nextResolutionResults = this.fakeCallResolver.resolveFakeCall(context, new TransientReceiver(iteratorType), Name.identifier(name2), loopRangeExpression);
        if (nextResolutionResults.isAmbiguity()) {
            context.trace.report(ambiguity.on(loopRangeExpression, iteratorType));
        } else if (nextResolutionResults.isNothing()) {
            context.trace.report(missing.on(loopRangeExpression, iteratorType));
        } else if (!nextResolutionResults.isSuccess()) {
            context.trace.report(noneApplicable.on(loopRangeExpression, iteratorType));
        } else {
            assert (nextResolutionResults.isSuccess());
            ResolvedCall<FunctionDescriptor> resolvedCall = nextResolutionResults.getResultingCall();
            context.trace.record(resolvedCallKey, loopRangeExpression, resolvedCall);
            FunctionDescriptor functionDescriptor = resolvedCall.getResultingDescriptor();
            this.symbolUsageValidator.validateCall(functionDescriptor, context.trace, (PsiElement)loopRangeExpression);
            return functionDescriptor.getReturnType();
        }
        return null;
    }
}

