/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"=\n)1b+\u00197vKB\u000b'/Y7fi\u0016\u0014(+Z:pYZ,'OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\u0015!\u0018\u0010]3t\u0015-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0007\u0005s\u0017P\u0003\u0004=S:LGO\u0010\u0006\u0019Kb\u0004(/Z:tS>tG+\u001f9j]\u001e\u001cVM\u001d<jG\u0016\u001c(\u0002G#yaJ,7o]5p]RK\b/\u001b8h'\u0016\u0014h/[2fg*Y2m\u001c8ti\u0006tG/\u0012=qe\u0016\u001c8/[8o\u000bZ\fG.^1u_JT1dQ8ogR\fg\u000e^#yaJ,7o]5p]\u00163\u0018\r\\;bi>\u0014(b\u0002:fg>dg/\u001a\u0006\nG>t7\u000f^1oiNT\u0001\"\u001a<bYV\fG/\u001a\u0006\u0014e\u0016\u001cx\u000e\u001c<f\t\u00164\u0017-\u001e7u-\u0006dW/\u001a\u0006\u0019m\u0006dW/\u001a)be\u0006lW\r^3s\t\u0016\u001c8M]5qi>\u0014(\u0002\u0007,bYV,\u0007+\u0019:b[\u0016$XM\u001d#fg\u000e\u0014\u0018\u000e\u001d;pe*YA-Z:de&\u0004Ho\u001c:t\u00151QW\r\u001e)be\u0006lW\r^3s\u00151QU\r\u001e)be\u0006lW\r^3s\u0015\r\u00018/\u001b\u0006\bG>tG/\u001a=u\u0015])\u0005\u0010\u001d:fgNLwN\u001c+za&twmQ8oi\u0016DHO\u0003\u0003V]&$(B\u0006:fg>dg/\u001a,bYV,\u0007+\u0019:b[\u0016$XM]:\u000b\u001fY\fG.^3QCJ\fW.\u001a;feNTA\u0001T5ti*Ib/\u00197vKB\u000b'/Y7fi\u0016\u0014H)Z:de&\u0004Ho\u001c:t\u00159!Wm\u00197be&twmU2pa\u0016TA\u0002T3yS\u000e\fGnU2pa\u0016Taa]2pa\u0016\u001c(\u0002\u00043bi\u00064En\\<J]\u001a|'\u0002\u0004#bi\u00064En\\<J]\u001a|'\"B2bY2\u001c(BC:nCJ$8-Y:ug*)AO]1dK*a!)\u001b8eS:<GK]1dK*!!.\u0019<b\u0015\u0011)H/\u001b7q\u0004)\u0011\u0001#\u0001\u0006\u0005\u0011\u0001\u0001\"A\u0003\u0003\t\u0003A\u0019!\u0002\u0002\u0005\u0003!\u0011QA\u0001C\u0002\u0011\u000b)1\u0001\u0002\u0002\t\u00011\u0001Q!\u0001E\u0002\u000b\r!1\u0001C\u0002\r\u0001\u0015\u0019AA\u0001E\u0005\u0019\u0001)!\u0001B\u0001\t\r\u0015\u0011A\u0011\u0002E\u0007\u000b\t!Q\u0001C\u0004\u0006\u0007\u0011-\u00012\u0002\u0007\u0001\u000b\t!!\u0001#\u0003\u0006\u0005\u0011-\u00012B\u0003\u0003\t\u0005A\u0011\"B\u0002\u0005\u0010!EA\u0002A\u0003\u0003\t\u0005A)\"B\u0002\u0005\u0012!QA\u0002A\u0003\u0004\t\tA9\u0002\u0004\u0001\u0006\u0007\u0011\u0019\u0001\u0002\u0004\u0007\u0001\u000b\t!y\u0001#\u0005\u0006\u0005\u0011E\u0001BC\u0003\u0003\t\tA9\"B\u0002\u0005\u0007!mA\u0002A\u0003\u0003\t\u0013Ay\"B\u0002\u0005\u001a!yA\u0002A\u0003\u0003\t\u0013A\u0011#\u0002\u0002\u0005\u001c!\rRa\u0001\u0003\u000f\u0011Ca\u0001!B\u0002\u0005\n!\u0015B\u0002A\u0003\u0002\u0011M)!\u0001b\b\t(\u0015\u0011A\u0001\u0005E\u000e\u000b\t!I\u0002C\b\u0006\u0005\u0011q\u0001\u0012E\u0003\u0003\t\u0013A)\u0003B\u0002\r\u0006e\u0019Q!\u0001E\u00041\u000fiC\u0002B1\u00051\u0015\t3!B\u0001\t\ra1Qk\u0001\u0003\u0006\u0007\u0011)\u0011\"\u0001\u0005\b[1!\u0011\r\u0002\r\u0005C\r)\u0011\u0001\u0003\u0003\u0019\tU\u001bA!B\u0002\u0005\t%\t\u0001RB\u0017+\t\u0005Az!h\u0004\u0005\u0001!AQbA\u0003\u0002\u0011!A\u0002\u0002U\u0002\u0001;\u001f!\u0001\u0001c\u0005\u000e\u0007\u0015\t\u0001\"\u0003\r\n!\u000e\u0005Qt\u0002\u0003\u0001\u0011-i1!B\u0001\t\u0014aM\u0001kA\u0001\"\u0007\u0015\t\u0001B\u0003\r\u000b#\u000eIAqB\u0005\u0002\t\u0001i\u0011\u0001#\u0006\u000e\u0003!YQ\"\u0001E\f[%\u0007Aa\u0001M\r;3!\u0001\u0001C\u0007\u000e\u0011\u0015\t\u0001\u0002D\u0005\u0005\u0013\r)\u0011\u0001C\u0005\u0019\u0013aa\u0001k\u0001\u0001\u001e\u001a\u0011\u0001\u0001BD\u0007\t\u000b\u0005AA\"\u0003\u0003\n\u0007\u0015\t\u0001\u0002\u0003\r\t11\u00016\u0011AO\b\t\u0001Ai\"D\u0002\u0006\u0003!i\u0001$\u0004)\u0004\u0003u=A\u0001\u0001\u0005\u0011\u001b\r)\u0011\u0001#\b\u0019\u001eA\u001b\u0019!h\u0004\u0005\u0001!\u0011RbA\u0003\u0002\u0011=Ar\u0002U\u0002\u0003C\r)\u0011\u0001\u0003\u0006\u0019\u0015E\u001bQ\u0002\"\u0007\n\u0003\u0011\u0001Q\"\u0001E\u0011\u001b\u0005A\t#D\u0001\t#5\t\u00012E\u0007\u0002\u0011IiC\u0007B\u0002\u0019\u001aueA\u0001\u0001\u0005\u000e\u001b!)\u0011\u0001\u0003\u0007\n\t%\u0019Q!\u0001\u0005\n1%AB\u0002U\u0002\u0001;3!\u0001\u0001\u0003\b\u000e\u0011\u0015\t\u0001\u0002D\u0005\u0005\u0013\r)\u0011\u0001\u0003\u0005\u0019\u0011aa\u0001k!\u0001\u001e\u0010\u0011\u0001\u0001bC\u0007\u0004\u000b\u0005A\u0019\u0002g\u0005Q\u0007\u0005\t3!B\u0001\t\u0015aQ\u0011kA\u0005\u0005\u001a%\tA\u0001A\u0007\u0002\u0011Ci\u0011\u0001#\t\u000e\u0003!]Q'I\u0003!\t\r\b\u0001tAO\b\t\u0001AA!D\u0002\u0006\u0003!!\u0001\u0004\u0002)\u0004\u0001u=A\u0001\u0001\u0005\u0006\u001b\r)\u0011\u0001\u0003\u0004\u0019\rA\u001b\t!I\u0002\u0006\u0003!\u0015\u0001TA)\u0004\u000f\u0011\u001d\u0011\"\u0001\u0003\u0001\u001b\u0005Ai!D\u0001\t\u000f\u0001"})
public final class ValueParameterResolver {
    public static final /* synthetic */ KClass $kotlinClass;
    private final ExpressionTypingServices expressionTypingServices;
    private final ConstantExpressionEvaluator constantExpressionEvaluator;

    static {
        $kotlinClass = Reflection.createKotlinClass(ValueParameterResolver.class);
    }

    public final void resolveValueParameters(@NotNull List<? extends JetParameter> valueParameters, @NotNull List<? extends ValueParameterDescriptor> valueParameterDescriptors, @NotNull LexicalScope declaringScope, @NotNull DataFlowInfo dataFlowInfo, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(valueParameters, (String)"valueParameters");
        Intrinsics.checkParameterIsNotNull(valueParameterDescriptors, (String)"valueParameterDescriptors");
        Intrinsics.checkParameterIsNotNull((Object)declaringScope, (String)"declaringScope");
        Intrinsics.checkParameterIsNotNull((Object)dataFlowInfo, (String)"dataFlowInfo");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        ExpressionTypingContext expressionTypingContext = ExpressionTypingContext.newContext(trace, declaringScope, dataFlowInfo, TypeUtils.NO_EXPECTED_TYPE);
        Intrinsics.checkExpressionValueIsNotNull((Object)expressionTypingContext, (String)"ExpressionTypingContext.\u2026peUtils.NO_EXPECTED_TYPE)");
        this.resolveValueParameters(valueParameters, valueParameterDescriptors, expressionTypingContext);
    }

    public final void resolveValueParameters(@NotNull List<? extends JetParameter> valueParameters, @NotNull List<? extends ValueParameterDescriptor> valueParameterDescriptors, @NotNull ExpressionTypingContext context) {
        Intrinsics.checkParameterIsNotNull(valueParameters, (String)"valueParameters");
        Intrinsics.checkParameterIsNotNull(valueParameterDescriptors, (String)"valueParameterDescriptors");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        for (Pair pair2 : KotlinPackage.zip((Iterable)valueParameterDescriptors, (Iterable)valueParameters)) {
            ValueParameterDescriptor descriptor2 = (ValueParameterDescriptor)pair2.component1();
            JetParameter parameter = (JetParameter)pair2.component2();
            ForceResolveUtil.forceResolveAllContents(descriptor2.getAnnotations());
            this.resolveDefaultValue(descriptor2, parameter, context);
        }
    }

    private final void resolveDefaultValue(ValueParameterDescriptor valueParameterDescriptor, JetParameter jetParameter, ExpressionTypingContext context) {
        if (!valueParameterDescriptor.declaresDefaultValue()) {
            return;
        }
        JetExpression jetExpression = jetParameter.getDefaultValue();
        if (jetExpression == null) {
            return;
        }
        JetExpression defaultValue = jetExpression;
        this.expressionTypingServices.getTypeInfo(defaultValue, (ResolutionContext)context.replaceExpectedType(valueParameterDescriptor.getType()));
        if (DescriptorUtils.isAnnotationClass(DescriptorResolver.getContainingClass(context.scope))) {
            JetExpression jetExpression2 = defaultValue;
            Intrinsics.checkExpressionValueIsNotNull((Object)jetExpression2, (String)"defaultValue");
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"context.trace");
            Unit unit = this.constantExpressionEvaluator.evaluateExpression(jetExpression2, bindingTrace, valueParameterDescriptor.getType());
            if (unit == null) {
                context.trace.report(Errors.ANNOTATION_PARAMETER_DEFAULT_VALUE_MUST_BE_CONSTANT.on((JetExpression)((PsiElement)defaultValue)));
                unit = Unit.INSTANCE$;
            }
        }
    }

    public ValueParameterResolver(@NotNull ExpressionTypingServices expressionTypingServices, @NotNull ConstantExpressionEvaluator constantExpressionEvaluator) {
        Intrinsics.checkParameterIsNotNull((Object)expressionTypingServices, (String)"expressionTypingServices");
        Intrinsics.checkParameterIsNotNull((Object)constantExpressionEvaluator, (String)"constantExpressionEvaluator");
        this.expressionTypingServices = expressionTypingServices;
        this.constantExpressionEvaluator = constantExpressionEvaluator;
    }
}

