/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.html;

import java.util.Map;
import kotlin.KotlinPackage;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.ast.visitors.RecursiveVisitor;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.html.GeneratingProvider;
import org.intellij.markdown.html.entities.EntityConverter;
import org.intellij.markdown.parser.LinkMap;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"E\u0006)i\u0001\n^7m\u000f\u0016tWM]1u_JT1a\u001c:h\u0015!Ig\u000e^3mY&T'\u0002C7be.$wn\u001e8\u000b\t!$X\u000e\u001c\u0006\u0004\u0003:L(BB6pi2LgN\u0003\u0004=S:LGO\u0010\u0006\r[\u0006\u00148\u000eZ8x]R+\u0007\u0010\u001e\u0006\u0007'R\u0014\u0018N\\4\u000b\tI|w\u000e\u001e\u0006\b\u0003N#fj\u001c3f\u0015\r\t7\u000f\u001e\u0006\bM2\fgo\\;s\u0015ei\u0015M]6e_^tg\t\\1w_V\u0014H)Z:de&\u0004Ho\u001c:\u000b\u0011\u0019d\u0017M^8veNTq\u0001\\5oW6\u000b\u0007OC\u0004MS:\\W*\u00199\u000b\rA\f'o]3s\u0015\u0011Q\u0017M^1\u000b\t1\fgn\u001a\u0006\u000bQRlGn\u0015;sS:<'\"D*ue&twMQ;jY\u0012,'OC\u0005qe>4\u0018\u000eZ3sg*\u0019Q*\u00199\u000b\u0019%+E.Z7f]R$\u0016\u0010]3\u000b%\u001d+g.\u001a:bi&tw\r\u0015:pm&$WM\u001d\u0006\u0005kRLGN\u0003\u0007hK:,'/\u0019;f\u0011RlGNC\u0005D_6\u0004\u0018M\\5p]*)\u0002\n^7m\u000f\u0016tWM]1uS:<g+[:ji>\u0014\b7\u0001\u0006\u0003!\u0005QA\u0001\u0003\u0001\u0011\u0005)!\u0001\"\u0001\t\u0004\u0015\u0011A!\u0001\u0005\u0003\u000b\r!\u0019\u0001\u0003\u0001\r\u0001\u0015\t\u0001bA\u0003\u0004\t\u000bA)\u0001\u0004\u0001\u0006\u0007\u0011\u0015\u0001\u0012\u0002\u0007\u0001\u000b\t!\u0011\u0001\u0003\u0004\u0006\u0007\u0011!\u00012\u0002\u0007\u0001\u000b\t!\u0011\u0001c\u0004\u0006\u0007\u0011)\u0001b\u0002\u0007\u0001\u000b\t!\u0011\u0001C\u0005\u0006\u0007\u00111\u0001\u0012\u0003\u0007\u0001\u000b\u0005A\u0019\"\u0002\u0002\u0005\u000f!QQA\u0001C\b\u0011\u0013)!\u0001\u0002\u0003\t\f\u0015\u0011A!\u0002\u0005\b\u000b\t!a\u0001#\u0005\u0006\u0007\u0011=\u0001b\u0003\u0007\u0001\u000b\t!y\u0001C\u0006\u0006\u0007\u0011\u0015\u0001\u0002\u0004\u0007\u0001\u000b\r!\u0011\u0001#\u0007\r\u0001\u0015\u0019A1\u0001\u0005\u000e\u0019\u0001)!\u0001B\u0004\t\u001c\u0015\u0011A\u0011\u0004\u0005\r\t\ra!\u0001%\b\u001a\u0007\u0015\t\u0001b\u0001\r\u0004;\u0005uq\"\f\u0007\u0005C\u0012A*\"I\u0002\u0006\u0003!Q\u0001DC+\u0004\t\u0015\u0019AQC\u0005\u0002\u0011+iC\u0002B1\u00051\u0011\t3!B\u0001\t\ba\u001dQk\u0001\u0003\u0006\u0007\u0011!\u0011\"\u0001\u0005\t[Y!\u0011\r\u0002M\fC5)\u0011\u0001C\u0006\n\t%\u0019Q!\u0001E\f1/IA!C\u0002\u0006\u0003!a\u0001\u0004\u0004\r\f+\u000e!Qa\u0001C\f\u0013\u0005AQ\"\f\u0007\u0005C\u0012AR!I\u0002\u0006\u0003!%\u0001\u0014B+\u0004\t\u0015\u0019A!B\u0005\u0002\u0011#i+\u0002B\u0002\u0019\u001d\u0005\u001aQ!\u0001E\u00041\u000f\t6a\u0001\u0003\u000f\u0013\u0005A\u0001\"\u000e\u001c\u0006k\u0011\u0019\u000f\u0001g\u0002\u001e\u0010\u0011\u0001\u0001\u0002B\u0007\u0004\u000b\u0005A9\u0001g\u0002Q\u0007\u0001iz\u0001\u0002\u0001\t\u000b5\u0019Q!\u0001E\u00051\u0013\u00016\u0011AO\b\t\u0001Ai!D\u0002\u0006\u0003!-\u00014\u0002)\u0004\u0003u=A!\u0001\u0005\t\u001b\r)\u0011\u0001#\u0004\u0019\u000eA\u001b\u0019!I\u0002\u0006\u0003!\u0011\u0001DA)\u0004\u0017\u0011\u001d\u0011\"\u0001\u0003\u0001\u001b\u0005A\u0001\"D\u0001\t\u00125\t\u0001\"C\u0007\u0002\u0011'\u0001"})
public final class HtmlGenerator {
    public static final /* synthetic */ KClass $kotlinClass;
    private final Map<IElementType, ? extends GeneratingProvider> providers;
    private final StringBuilder htmlString;
    private final String markdownText;
    private final ASTNode root;
    public static final Companion Companion;

    static {
        $kotlinClass = Reflection.createKotlinClass(HtmlGenerator.class);
        Companion companion = Companion = new Companion(null);
    }

    @NotNull
    public final String generateHtml() {
        new HtmlGeneratingVisitor().visitNode(this.root);
        String string = this.htmlString.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"htmlString.toString()");
        return string;
    }

    public HtmlGenerator(@NotNull String markdownText, @NotNull ASTNode root, @NotNull MarkdownFlavourDescriptor flavour, @NotNull LinkMap linkMap) {
        Intrinsics.checkParameterIsNotNull((Object)markdownText, (String)"markdownText");
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        Intrinsics.checkParameterIsNotNull((Object)flavour, (String)"flavour");
        Intrinsics.checkParameterIsNotNull((Object)linkMap, (String)"linkMap");
        this.markdownText = markdownText;
        this.root = root;
        this.providers = flavour.createHtmlGeneratingProviders(linkMap);
        this.htmlString = new StringBuilder();
    }

    public /* synthetic */ HtmlGenerator(String string, ASTNode aSTNode, MarkdownFlavourDescriptor markdownFlavourDescriptor, LinkMap linkMap, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            linkMap = LinkMap.Builder.buildLinkMap(aSTNode, string);
        }
        this(string, aSTNode, markdownFlavourDescriptor, linkMap);
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"I\u0004))\u0002\n^7m\u000f\u0016tWM]1uS:<g+[:ji>\u0014(\"\u0004%u[2<UM\\3sCR|'OC\u0002pe\u001eT\u0001\"\u001b8uK2d\u0017N\u001b\u0006\t[\u0006\u00148\u000eZ8x]*!\u0001\u000e^7m\u0015A\u0011VmY;sg&4XMV5tSR|'OC\u0002bgRT\u0001B^5tSR|'o\u001d\u0006\u0007y%t\u0017\u000e\u001e \u000b\u0017\r|gn];nK\"#X\u000e\u001c\u0006\r\u0007\"\f'oU3rk\u0016t7-\u001a\u0006\u0007W>$H.\u001b8\u000b\tUs\u0017\u000e\u001e\u0006\u0005U\u00064\u0018M\u0003\u0003mC:<'\"\u0003<jg&$H*Z1g\u0015\u0011qw\u000eZ3\u000b\u000f\u0005\u001bFKT8eK*Ia/[:ji:{G-\u001a:\u000b\u0005A\u0011!\u0002\u0002\u0005\u0001!\rQA\u0001C\u0001\u0011\t)!\u0001B\u0001\t\u0006\u0015\u0019A1\u0001E\u0001\u0019\u0001)1\u0001\u0002\u0002\t\u00011\u0001QA\u0001\u0003\u0002\u0011\u000f)!\u0001B\u0002\t\t\u0015\u0019Aq\u0001\u0005\u0004\u0019\u0001)!\u0001b\u0001\t\u0002\u0015\t\u0001BB\u0003\u0004\t\u0015AY\u0001\u0004\u0001\u0006\u0007\u0011)\u0001R\u0002\u0007\u0001\u000b\u0005Aq!\u0002\u0002\u0005\u000e!=QA\u0001\u0003\b\u0011\u0017)1\u0001B\u0002\t\u00131\u0001QA\u0001\u0003\u0004\u0011%!1I\u0001G\u00033\r)\u0011\u0001\u0003\u0003\u0019\t5*Ba\u0001\r\u0006;\u001f!\u0001\u0001#\u0002\u000e\u0007\u0015\t\u00012\u0002M\u0006!\u000e\u0001\u0011eA\u0003\u0002\u0011\u0019Ab!U\u0002\u0006\t\u0015I\u0011\u0001\u0002\u0001\u000e\u0003!=Q&\u0006\u0003\u00041!iz\u0001\u0002\u0001\t\u00125\u0019Q!\u0001\u0005\t1!\u00016\u0001A\u0011\u0004\u000b\u0005Aa\u0001\u0007\u0004R\u0007\u0015!\u0001\"C\u0001\u0005\u00015\t\u0001\u0012C\u0017\u0016\t-A\u001a\"h\u0004\u0005\u0001!EQbA\u0003\u0002\u0011!A\u0002\u0002U\u0002\u0001C\r)\u0011\u0001\u0003\u0004\u0019\rE\u001bQ\u0001b\u0005\n\u0003\u0011\u0001Q\"\u0001E\tk9)Q\u0002Br\u00011\u0013\t3!B\u0001\t\u0006a\u0015\u0011kA\u0003\u0005\n%\tA\u0001A\u0007\u0002\u0011\u0013\u0001"})
    public final class HtmlGeneratingVisitor
    extends RecursiveVisitor {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(HtmlGeneratingVisitor.class);
        }

        @Override
        public void visitNode(@NotNull ASTNode node) {
            block3: {
                GeneratingProvider generatingProvider;
                block2: {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    generatingProvider = HtmlGenerator.this.providers.get(node.getType());
                    if (generatingProvider == null) break block2;
                    generatingProvider.processNode(this, HtmlGenerator.this.markdownText, node);
                    generatingProvider = Unit.INSTANCE$;
                    if (generatingProvider != null) break block3;
                }
                node.acceptChildren(this);
                generatingProvider = Unit.INSTANCE$;
            }
        }

        public final void visitLeaf(@NotNull ASTNode node) {
            block3: {
                GeneratingProvider generatingProvider;
                block2: {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    generatingProvider = HtmlGenerator.this.providers.get(node.getType());
                    if (generatingProvider == null) break block2;
                    generatingProvider.processNode(this, HtmlGenerator.this.markdownText, node);
                    generatingProvider = Unit.INSTANCE$;
                    if (generatingProvider != null) break block3;
                }
                this.consumeHtml(org.intellij.markdown.html.HtmlGenerator$Companion.leafText$default(Companion, HtmlGenerator.this.markdownText, node, false, 4));
                generatingProvider = Unit.INSTANCE$;
            }
        }

        public final void consumeHtml(@NotNull CharSequence html) {
            Intrinsics.checkParameterIsNotNull((Object)html, (String)"html");
            HtmlGenerator.this.htmlString.append(html);
        }
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"K\u0004)I1i\\7qC:LwN\u001c\u0006\u000e\u0011RlGnR3oKJ\fGo\u001c:\u000b\u0007=\u0014xM\u0003\u0005j]R,G\u000e\\5k\u0015!i\u0017M]6e_^t'\u0002\u00025u[2T1!\u00118z\u0015\u0019Yw\u000e\u001e7j]*AA.Z1g)\u0016DHO\u0003\u0003uKb$(BB*ue&twM\u0003\u0003o_\u0012,'bB!T):{G-\u001a\u0006\u0004CN$(\"\u0007:fa2\f7-Z#tG\u0006\u0004Xm]!oI\u0016sG/\u001b;jKNTqAQ8pY\u0016\fgN\u0003\u0007DQ\u0006\u00148+Z9vK:\u001cWM\u0003\u0003kCZ\f'\u0002\u00027b]\u001eT1\u0002\u001e:j[&sG-\u001a8ug*1\u0011N\u001c3f]RT1!\u00138uy*\u0011\u0001C\u0001\u0006\u0005\u0011\u0001\u00012A\u0003\u0003\t\u0003A!!\u0002\u0002\u0005\u0003!\u0015Qa\u0001C\u0002\u0011\u0003a\u0001!B\u0002\u0005\u0005!\u0001A\u0002A\u0003\u0002\u0011\u000f)1\u0001B\u0002\t\u00071\u0001Qa\u0001\u0003\u0004\u0011\u0015a\u0001!\u0002\u0002\u0005\u0003!5Qa\u0001C\u0005\u0011\u0019a\u0001!B\u0002\u0005\u0007!=A\u0002A\u0003\u0004\t\rA\u0001\u0002\u0004\u0001\u0006\u0003!EQA\u0001C\u0007\u0011%)!\u0001B\u0004\t\u0011\u0015\u0011Aa\u0002\u0005\u0006\u000b\t!I\u0001\u0003\u0004\u0006\u0007\u0011\u0019\u0001R\u0003\u0007\u0001\t\r\u000fARA\r\u0004\u000b\u0005A9\u0001g\u0002.U\u0011\u0019\u0001\u0004BO\b\t\u0001AI!D\u0002\u0006\u0003!!\u0001\u0004\u0002)\u0004\u0001u=A\u0001\u0001E\u0006\u001b\r)\u0011\u0001C\u0003\u0019\u000bA\u001b\t!h\u0004\u0005\u0003!9QbA\u0003\u0002\u0011\u0017AZ\u0001U\u0002\u0002C\r)\u0011\u0001\u0003\u0004\u0019\rE\u001b\u0011\u0002\u0002\u0003\n\u0003!=Q\"\u0001\u0005\t\u001b\u0005A\t\"D\u0001\u0005\u00025~Ba\u0001M\n;\u001f!\u0001\u0001#\u0003\u000e\u0007\u0015\t\u0001B\u0002\r\u0007!\u000e\u0001Qt\u0002\u0003\u0001\u0011)i1!B\u0001\t\u0013aI\u0001k!\u0001\"\u0007\u0015\t\u0001B\u0002\r\u0007#\u000e9A1C\u0005\u0002\u0011\u001fi\u0011\u0001c\u0004\u000e\u0003\u0011\u0015Q\u0007\u0001"})
    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        @NotNull
        public final CharSequence leafText(@NotNull String text, @NotNull ASTNode node, boolean replaceEscapesAndEntities) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            if (Intrinsics.areEqual((Object)node.getType(), (Object)MarkdownTokenTypes.Companion.getBLOCK_QUOTE())) {
                return "";
            }
            return EntityConverter.INSTANCE$.replaceEntities(ASTUtilKt.getTextInNode(node, text), replaceEscapesAndEntities, replaceEscapesAndEntities);
        }

        @NotNull
        public static /* synthetic */ CharSequence leafText$default(Companion companion, String string, ASTNode aSTNode, boolean bl, int n) {
            if ((n & 4) != 0) {
                bl = true;
            }
            return companion.leafText(string, aSTNode, bl);
        }

        @NotNull
        public final CharSequence trimIndents(@NotNull CharSequence text, int indent) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            if (indent == 0) {
                return text;
            }
            StringBuilder buffer = new StringBuilder();
            int lastFlushed = 0;
            for (int offset = 0; offset < text.length(); ++offset) {
                if (offset != 0 && KotlinPackage.get((CharSequence)text, (int)(offset - 1)) != '\n') continue;
                buffer.append(text.subSequence(lastFlushed, offset));
                int indentEaten = 0;
                block5: while (indentEaten < indent && offset < text.length()) {
                    switch (KotlinPackage.get((CharSequence)text, (int)offset)) {
                        case ' ': {
                            ++indentEaten;
                            break;
                        }
                        case '\t': {
                            indentEaten += 4 - indentEaten % 4;
                            break;
                        }
                        default: {
                            break block5;
                        }
                    }
                    ++offset;
                }
                if (indentEaten > indent) {
                    buffer.append(KotlinPackage.repeat((String)" ", (int)(indentEaten - indent)));
                }
                lastFlushed = offset;
            }
            buffer.append(text.subSequence(lastFlushed, text.length()));
            return buffer;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

