/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.lexer;

import java.io.IOException;
import java.util.Set;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.lexer.GeneratedLexer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"\\\b)iQ*\u0019:lI><h\u000eT3yKJT1a\u001c:h\u0015!Ig\u000e^3mY&T'\u0002C7be.$wn\u001e8\u000b\u000b1,\u00070\u001a:\u000b\u0007\u0005s\u0017P\u0003\u0004l_Rd\u0017N\u001c\u0006\u0007y%t\u0017\u000e\u001e \u000b\u0013\t\f7/\u001a'fq\u0016\u0014(BD$f]\u0016\u0014\u0018\r^3e\u0019\u0016DXM\u001d\u0006\byM,G/L ?\u0015\rIe\u000e\u001e\u0006\nEV4g-\u001a:F]\u0012TAbZ3u\u0005V4g-\u001a:F]\u0012TAb]3u\u0005V4g-\u001a:F]\u0012T1BY;gM\u0016\u00148\u000b^1si*qq-\u001a;Ck\u001a4WM]*uCJ$(BD:fi\n+hMZ3s'R\f'\u000f\u001e\u0006\t]\u0016DH\u000fV=qK*a\u0011*\u00127f[\u0016tG\u000fV=qK*a1\t[1s'\u0016\fX/\u001a8dK*aqN]5hS:\fG\u000eV3yi*!!.\u0019<b\u0015\u0011a\u0017M\\4\u000b\u001f\u001d,Go\u0014:jO&t\u0017\r\u001c+fqRTqb]3u\u001fJLw-\u001b8bYR+\u0007\u0010\u001e\u0006\ti>\\WM\\#oI*Yq-\u001a;U_.,g.\u00128e\u0015-\u0019X\r\u001e+pW\u0016tWI\u001c3\u000b\u0015Q|7.\u001a8Ti\u0006\u0014HOC\u0007hKR$vn[3o'R\f'\u000f\u001e\u0006\u000eg\u0016$Hk\\6f]N#\u0018M\u001d;\u000b\tQL\b/\u001a\u0006\bO\u0016$H+\u001f9f\u0015\u001d\u0019X\r\u001e+za\u0016Tq!\u00193wC:\u001cWMC\u0004C_>dW-\u00198\u000b\u0017\u0005$g/\u00198dK\n\u000b7/\u001a\u0006\rG\u0006d7MT3yiRK\b/\u001a\u0006\u0005+:LGOC\u0006m_\u000e\fG/\u001a+pW\u0016t'\"B:uCJ$(\"C\"p[B\fg.[8om*\u0011\u0001#\u0001\u0006\u0005\u0011\u0001\u0001\"A\u0003\u0003\t\u0003A\u0019!\u0002\u0002\u0005\u0003!\u0011Qa\u0001C\u0002\u0011\u0001a\u0001!B\u0001\t\u0007\u0015\u0019AQ\u0001E\u0003\u0019\u0001)1\u0001b\u0001\t\n1\u0001QA\u0001C\u0002\u0011\u0013)1\u0001\"\u0002\t\f1\u0001Qa\u0001\u0003\u0002\u0011'a\u0001!\u0002\u0002\u0005\u0003!MQa\u0001C\u0003\u0011)a\u0001!B\u0001\t\u0017\u0015\u0011AQ\u0002E\f\u000b\t!q\u0001\u0003\u0006\u0006\u0007\u0011\u0015\u0001B\u0005\u0007\u0001\u000b\r!)\u0001c\n\r\u0001\u0011YAB\u0001\t\u00163\r)\u0011\u0001C\u0002\u0019\u0007u\u0005Q#\f\u0007\u0005C\u0012AB!I\u0002\u0006\u0003!\u001d\u0001tA+\u0004\t\u0015\u0019A\u0001B\u0005\u0002\u0011\u0011i{\u0004Bb\r1\u0019iz\u0001\u0002\u0001\t\u000b5\u0019Q!\u0001E\u00051\u0013\u00016\u0001A\u0011\u0004\u000b\u0005AI\u0001'\u0003)CU\u001ba\"B\u0002\u0005\r%\tAQA\u0007\u0004\t\u001bI\u0011\u0001\"\u0002\u0012\u000b\u00119\u0011\"\u0001\u0003\u0001\u001b\u0005!)!l\u0010\u0005\u00074Az!h\u0004\u0005\u0001!)QbA\u0003\u0002\u0011\u0013AJ\u0001U\u0002\u0001C\r)\u0011\u0001#\u0003\u0019\n!\nSk\u0001\b\u0006\u0007\u0011=\u0011\"\u0001C\u0003\u001b\r!\u0001\"C\u0001\u0005\u0006E)A\u0011C\u0005\u0002\t\u0001i\u0011\u0001\"\u0002.\u001b\u0011\tM\u0002G\u0005\"\t\u0015\t\u0001\"\u0002G\u00011\u0015)6\u0001B\u0003\u0004\t%I\u0011\u0001c\u0003.@\u0011\u0019M\u0002'\u0006\u001e\u0010\u0011\u0001\u0001\"B\u0007\u0004\u000b\u0005Aa\u0001\u0007\u0004Q\u0007\u0001\t3!B\u0001\t\ra1\u0001&I+\u0004\u001d\u0015\u0019AQC\u0005\u0002\u0011\u001fi1\u0001\u0002\u0007\n\u0003!=\u0011#\u0002C\r\u0013\u0005!\u0001!D\u0001\t\u00105~Ba1\u0007\u0019\u001bu=A\u0001\u0001\u0005\u0006\u001b\r)\u0011\u0001#\u0003\u0019\nA\u001b\u0001!I\u0002\u0006\u0003!%\u0001\u0014\u0002\u0015\"+\u000eqQa\u0001\u0003\u000e\u0013\u0005!)!D\u0002\u0005\u001c%\tAQA\t\u0006\t9I\u0011\u0001\u0002\u0001\u000e\u0003\u0011\u0015Qv\b\u0003D\u001aauQt\u0002\u0003\u0001\u0011\u0015i1!B\u0001\t\na%\u0001k\u0001\u0001\"\u0007\u0015\t\u0001\u0012\u0002M\u0005Q\u0005*6AD\u0003\u0004\t;I\u0011\u0001\"\u0002\u000e\u0007\u0011y\u0011\"\u0001C\u0003#\u0015!y\"C\u0001\u0005\u00015\tAQAW\"\t\rg\u0001\u0004EO\t\t\u0001AQ!\u0004\u0003\u0006\u0003!)A\u0012\u0001\r\u0006!\u000e\u0001\u0011\u0005B\u0003\u0002\u0011\u0015a\t\u0001G\u0003)CU\u001ba\"B\u0002\u0005!%\t\u00012B\u0007\u0004\tCI\u0011\u0001c\u0003\u0012\u000b\u0011\t\u0012\"\u0001\u0003\u0001\u001b\u0005AY!,\u0006\u0005\u0007a\r\u0012eA\u0003\u0002\u0011!A\u0002\"U\u0002\u0004\tGI\u0011\u0001\"\u0001.\u0018\u0011\t\u0001TE\u0011\u0005\u000b\u0005AQ\u0001$\u0001\u0019\u000bE\u001b1\u0001\"\n\n\u0003!-QV\u0003\u0003\u00021M\t3!B\u0001\t\u0012aE\u0011kA\u0002\u0005'%\tA\u0001AW\u000b\t\u0005AB#I\u0002\u0006\u0003!A\u0001\u0004C)\u0004\u0007\u0011!\u0012\"\u0001C\u0001[)\"1\u0001'\u000b\u001e\u0010\u0011\u0001\u0001RC\u0007\u0004\u000b\u0005Aa\u0001\u0007\u0004Q\u0007\u0001iz\u0001B\u0001\t\u00105\u0019Q!\u0001E\u00051\u0013\u00016\u0011AO\b\t\u0005Aa!D\u0002\u0006\u0003!%\u0001\u0014\u0002)\u0004\u0003\u0005\u001aQ!\u0001E\t1#\t6!\u0003C\u0015\u0013\u0005!\u0001!D\u0001\t\u00105\tAQA\u0007\u0002\t\u000b)l#b\u000b\u0005G\u0004A:!h\u0004\u0005\u0001!!QbA\u0003\u0002\u0011\u000fA:\u0001U\u0002\u0001C\r)\u0011\u0001\u0003\u0002\u0019\u0005E\u001bQ\u0001b\u0002\n\u0003\u0011\u0001Q\"\u0001\u0005\u0005"})
public class MarkdownLexer {
    public static final /* synthetic */ KClass $kotlinClass;
    private static final Set<? extends IElementType> TOKENS_TO_MERGE;
    @Nullable
    private IElementType type;
    private IElementType nextType;
    @NotNull
    private CharSequence originalText;
    private int bufferStart;
    private int bufferEnd;
    private int tokenStart;
    private int tokenEnd;
    private final GeneratedLexer baseLexer;
    public static final Companion Companion;

    static {
        $kotlinClass = Reflection.createKotlinClass(MarkdownLexer.class);
        Companion companion = Companion = new Companion(null);
        TOKENS_TO_MERGE = KotlinPackage.setOf((Object[])new IElementType[]{MarkdownTokenTypes.Companion.getTEXT(), MarkdownTokenTypes.Companion.getWHITE_SPACE(), MarkdownTokenTypes.Companion.getCODE(), MarkdownTokenTypes.Companion.getLINK_ID(), MarkdownTokenTypes.Companion.getLINK_TITLE(), MarkdownTokenTypes.Companion.getURL(), MarkdownTokenTypes.Companion.getAUTOLINK(), MarkdownTokenTypes.Companion.getEMAIL_AUTOLINK(), MarkdownTokenTypes.Companion.getBAD_CHARACTER()});
    }

    @Nullable
    public final IElementType getType() {
        return this.type;
    }

    private final void setType(IElementType iElementType) {
        this.type = iElementType;
    }

    @NotNull
    public final CharSequence getOriginalText() {
        return this.originalText;
    }

    private final void setOriginalText(CharSequence charSequence) {
        this.originalText = charSequence;
    }

    public final int getBufferStart() {
        return this.bufferStart;
    }

    private final void setBufferStart(int n) {
        this.bufferStart = n;
    }

    public final int getBufferEnd() {
        return this.bufferEnd;
    }

    private final void setBufferEnd(int n) {
        this.bufferEnd = n;
    }

    public final int getTokenStart() {
        return this.tokenStart;
    }

    private final void setTokenStart(int n) {
        this.tokenStart = n;
    }

    public final int getTokenEnd() {
        return this.tokenEnd;
    }

    private final void setTokenEnd(int n) {
        this.tokenEnd = n;
    }

    public final void start(@NotNull CharSequence originalText, int bufferStart, int bufferEnd) {
        Intrinsics.checkParameterIsNotNull((Object)originalText, (String)"originalText");
        this.originalText = originalText;
        this.bufferStart = bufferStart;
        this.bufferEnd = bufferEnd;
        this.baseLexer.reset(originalText, bufferStart, bufferEnd, 0);
        this.type = this.advanceBase();
        this.tokenStart = this.baseLexer.getTokenStart();
        this.calcNextType();
    }

    public static /* synthetic */ void start$default(MarkdownLexer markdownLexer, CharSequence charSequence, int n, int n2, int n3) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = charSequence.length();
        }
        markdownLexer.start(charSequence, n, n2);
    }

    public final boolean advance() {
        return this.locateToken();
    }

    private final boolean locateToken() {
        this.type = this.nextType;
        this.tokenStart = this.tokenEnd;
        if (this.type == null) {
            return false;
        }
        this.calcNextType();
        return true;
    }

    private final void calcNextType() {
        do {
            this.tokenEnd = this.baseLexer.getTokenEnd();
            this.nextType = this.advanceBase();
        } while (Intrinsics.areEqual((Object)this.nextType, (Object)this.type) && MarkdownLexer.Companion.getTOKENS_TO_MERGE().contains(this.type));
    }

    private final IElementType advanceBase() {
        try {
            return this.baseLexer.advance();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw (Throwable)((Object)new AssertionError((Object)"This could not be!"));
        }
    }

    public MarkdownLexer(@NotNull GeneratedLexer baseLexer) {
        Intrinsics.checkParameterIsNotNull((Object)baseLexer, (String)"baseLexer");
        this.baseLexer = baseLexer;
        this.originalText = "";
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"\f\u0004)I1i\\7qC:LwN\u001c\u0006\u000e\u001b\u0006\u00148\u000eZ8x]2+\u00070\u001a:\u000b\u0007=\u0014xM\u0003\u0005j]R,G\u000e\\5k\u0015!i\u0017M]6e_^t'\"\u00027fq\u0016\u0014(bA!os*11n\u001c;mS:Tq\u0002V(L\u000b:\u001bv\fV(`\u001b\u0016\u0013v)\u0012\u0006\u0004'\u0016$(\u0002D%FY\u0016lWM\u001c;UsB,'\u0002\u00026bm\u0006TA!\u001e;jY*\u0011r-\u001a;U\u001f.+ejU0U\u001f~kUIU$F%*\u0011\u0001C\u0001\u0006\u0005\u0011\u0001\u00012A\u0003\u0003\t\u0003A!!\u0002\u0002\u0005\u0003!\u0015Qa\u0001C\u0002\u0011\u0003a\u0001!B\u0002\u0005\u0005!\u0001A\u0002A\u0003\u0002\u0011\u000f)1\u0001B\u0002\t\u00071\u0001Qa\u0001\u0003\u0004\u0011\u0013a\u0001!B\u0002\u0005\u0003!)A\u0002A\u0003\u0002\u0011\u0017)!\u0001B\u0003\t\r\u0015\u0011A1\u0002E\u0005\t\r\u000fARA\r\u0004\u000b\u0005A9\u0001g\u0002.-\u0011\tG\u0001\u0007\u0003\"\u0011\u0015\t\u0001\u0002B\u0005\u0005\u0013\r)\u0011\u0001#\u0003\u0019\na!QkA\u0005\u0006\t\u0011!\u0011\"\u0001\u0005\u0007\u0019\u0003i1\u0001\"\u0004\n\u0003!1Q\u0007\u0001"})
    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        private final Set<IElementType> getTOKENS_TO_MERGE() {
            return TOKENS_TO_MERGE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

