/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.constraints;

import kotlin.KotlinPackage;
import kotlin.data;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.providers.HorizontalRuleProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"|\n)\u0019R*\u0019:lI><hnQ8ogR\u0014\u0018-\u001b8ug*\u0019qN]4\u000b\u0011%tG/\u001a7mS*T\u0001\"\\1sW\u0012|wO\u001c\u0006\u0007a\u0006\u00148/\u001a:\u000b\u0017\r|gn\u001d;sC&tGo\u001d\u0006\u0004\u0003:L(BB6pi2LgN\u0003\u0004=S:LGO\u0010\u0006\bS:$WM\u001c;t\u0015!Ie\u000e^!se\u0006L(\"\u0002;za\u0016\u001c(\"C\"iCJ\f%O]1z\u0015)I7/\u0012=qY&\u001c\u0017\u000e\u001e\u0006\r\u0005>|G.Z1o\u0003J\u0014\u0018-\u001f\u0006\u000bG\"\f'o]#bi\u0016t'bA%oi*!!-Y:f\u0015\u001d9W\r\u001e\"bg\u0016T1#\u00193e\u001b>$\u0017NZ5fe&3g*Z3eK\u0012T1\u0001]8t\u0015!\u0001vn]5uS>t'\"\u0004'p_.\f\u0007.Z1e)\u0016DHO\u0003\fM_>\\\u0017\r[3bIR+\u0007\u0010\u001e\u0013Q_NLG/[8o\u0015M\u0019wN\u001c;bS:\u001cH*[:u\u001b\u0006\u00148.\u001a:t\u0015\u001d\u0011un\u001c7fC:T\u0011\"\u001e9U_&sG-\u001a=\u000b)\r\u0014X-\u0019;f\u001d\u0016<8i\u001c8tiJ\f\u0017N\u001c;t\u0015M)\u0017\r^%ug\u0016dgM\u0012:p[N#(/\u001b8h\u0015\u0005\u0019(\u0002D\"iCJ\u001cV-];f]\u000e,'\u0002\u00026bm\u0006TA\u0001\\1oO*YQ\r\u001f;f]\u0012\u001cH*[:u\u0015\u0015yG\u000f[3s\u0015-)\u0007\u0010^3oIN\u0004&/\u001a<\u000b\u001f\u0019,Go\u00195MSN$X*\u0019:lKJTa\u0002T5ti6\u000b'o[3s\u0013:4wN\u0003\u0012NCJ\\Gm\\<o\u0007>t7\u000f\u001e:bS:$8\u000f\n'jgRl\u0015M]6fe&sgm\u001c\u0006\u000eO\u0016$8\t[1sg\u0016\u000bG/\u001a8\u000b\u0013\u001d,G/\u00138eK:$(bD4fi2\u000b7\u000f^#ya2L7-\u001b;\u000b\u0017\u001d,G\u000fT1tiRK\b/\u001a\u0006\u0005\u0007\"\f'OC\u0005DQ\u0006\u0014\u0018m\u0019;fe*Q1\u000f^1siN<\u0016\u000e\u001e5\u000b\u0011Q|7\u000b\u001e:j]\u001eTaa\u0015;sS:<'\u0002\u0005;ss\u0006#GM\u00117pG.\fVo\u001c;f\u00159!(/_!eI2K7\u000f^%uK6TA\"\u001e9tiJ,\u0017-\\,ji\"T\u0011bQ8na\u0006t\u0017n\u001c8=\u0004)\u0011\u0001#\u0001\u0006\u0005\u0011\u0001\u0001\"A\u0003\u0003\t\u0003A\u0019!\u0002\u0002\u0005\u0003!\u0011QA\u0001C\u0002\u0011\u000b)1\u0001\u0002\u0002\t\u00011\u0001Q!\u0001E\u0004\u000b\r!1\u0001C\u0002\r\u0001\u0015\u0019Aa\u0001\u0005\u0006\u0019\u0001)1\u0001B\u0002\t\r1\u0001Qa\u0001\u0003\u0004\u0011\u001da\u0001!B\u0002\u0005\u0007!AA\u0002A\u0003\u0003\t\tA\u0001!B\u0002\u0005\u0004!YA\u0002A\u0003\u0004\t\u001bA)\u0002\u0004\u0001\u0006\u0005\u0011\r\u0001rC\u0003\u0004\t\rAI\u0002\u0004\u0001\u0006\u0007\u0011\u0019\u0001b\u0004\u0007\u0001\u000b\u0005Ay\"\u0002\u0002\u0005\u0013!\u0001RA\u0001C\n\u0011=)1\u0001\"\u0002\t&1\u0001QA\u0001\u0003\u0003\u0011M)!\u0001b\u0005\t\u001a\u0015\u0019Aa\u0001E\u0016\u0019\u0001)!\u0001b\u0005\t-\u0015\u0019Aa\u0001E\u0018\u0019\u0001)!\u0001b\u0005\t0\u0011YAR\u0001I\u001a3\r)\u0011\u0001c\u0002\u0019\bu\t\u0019TE\u0017\u000e\t-$\u0001\u0014C\u0011\u0004\u000b\u0005A)\u0001'\u0002%WU\u001bA!D\u0002\u0005\u0013%\t\u0001BB\u0017\r\t\u0005$\u0001tB\u0011\u0004\u000b\u0005AY\u0001g\u0003V\u0007\u0011)1\u0001b\u0004\n\u0003\u0011\u0015Q&\u0004\u0003b\ta%\u0011eA\u0003\u0002\u0011\u0011AB!V\u0002\u0006\u000b\u0011!I!\u0003\u0002\u0005\u00061\u0005Q&\u0004\u0003b\ta5\u0011eA\u0003\u0002\u0011\u0015AR!V\u0002\u0006\u000b\u0011!i!\u0003\u0002\u0005\u00021\u0005Q&\u0004\u0003b\ta-\u0011eA\u0003\u0002\u0011\u0013AJ!V\u0002\u0006\u000b\u0011!Y!\u0003\u0002\u0005\u00031\u0005Qf\u0006\u0003\u00041'i\n\u0002\u0002\u0001\t\u00155!Q!\u0001\u0005\b\u0019\u0003Ar\u0001U\u0002\u0001C\u0011)\u0011\u0001#\u0002\r\u0002a\u0015\u0011kA\u0003\u0005\u0014%\t\u0001BB\u0007\u0002\u0011\u001fi+\u0002B\u0001\u0019\u0019\u0005\u001aQ!\u0001\u0005\t1!\t6a\u0001\u0003\r\u0013\u0005!\t!L\u000b\u0005\u0003aaQt\u0002\u0003\u0001\u00115i1!B\u0001\t\fa-\u0001k\u0001\u0001\"\u0007\u0015\t\u0001\u0002\u0003\r\t#\u000e)A\u0001D\u0005\u0002\t\u0003i\u0011\u0001\"\u0002.p\u0011Y\u00014DO\b\t\u0001AI!D\u0002\u0006\u0003!!\u0001\u0004\u0002)\u0004\u0001u=A\u0001\u0001E\u0006\u001b\r)\u0011\u0001#\u0003\u0019\nA\u001b\t!h\u0004\u0005\u0001!5QbA\u0003\u0002\u0011\u0015AR\u0001U\u0002\u0002;\u001f!\u0001\u0001c\u0004\u000e\u0007\u0015\t\u00012\u0002M\u0006!\u000e\r\u0011eA\u0003\u0002\u0011\u000bA*!U\u0002\u000f\t7I\u0011\u0001\u0003\u0004\u000e\u0005\u0011\u0015A\u0012A\u0007\u0003\t\u0005a\t!\u0004\u0002\u0005\u00021\u0005Q\"\u0001C\u0003[U!1\u0001\u0007\b\u001e\u0010\u0011\u0001\u0001RD\u0007\u0004\u000b\u0005A\t\u0002'\u0005Q\u0007\u0001\t3!B\u0001\t\u0012aE\u0011kA\u0003\u0005\u001d%\t\u0001BC\u0007\u0002\u0011)iS\u0003B\u0002\u0019\"u=A\u0001\u0001\u0005\u0012\u001b\r)\u0011\u0001#\u0002\u0019\u0006A\u001b\u0001!I\u0002\u0006\u0003!A\u0001\u0004C)\u0004\u000b\u0011\u0005\u0012\"\u0001C\u0001\u001b\u0005Aa!L\u000b\u0005\u0007a\rRt\u0002\u0003\u0001\u0011Ei1!B\u0001\t\u0006a\u0015\u0001k\u0001\u0001\"\u0007\u0015\t\u0001\u0002\u0003\r\t#\u000e)A1E\u0005\u0002\t\u0003i\u0011\u0001\u0003\u0004.-\u0011Q\u0001DEO\b\t\u0001A!\"D\u0002\u0006\u0003!9\u0001d\u0002)\u0004\u0001\u0005\"Q!\u0001E\u000b\u0019\u0003A*\"U\u0002\u0006\tII\u0011\u0001C\u0006\u000e\u0003!=Q&\u0006\u0003\u00041Oiz\u0001\u0002\u0001\t\u001e5\u0019Q!\u0001E\t1#\u00016\u0001A\u0011\u0004\u000b\u0005AY\u0001g\u0003R\u0007\u0015!9#C\u0001\u0005\u00065\t\u0001BCW\u000b\t\rAB#I\u0002\u0006\u0003!-\u00014B)\u0004\u0007\u0011!\u0012\"\u0001C\u0003[/!1\u0001'\u000b\"\t\u0015\t\u0001\u0002\u0003G\u00011!\t6a\u0001C\u0015\u0013\u0005A9\"l\u0006\u0005\u0017a)\u0012\u0005B\u0003\u0002\u00111a\t\u0001\u0007\u0007R\u0007\r!Q#C\u0001\t\u001a5*B!\u0001M\u0017;\u001f!\u0001\u0001C\t\u000e\u0007\u0015\t\u0001R\u0001M\u0003!\u000e\u0001\u0011eA\u0003\u0002\u0011!A\u0002\"U\u0002\u0006\t[I\u0011\u0001\"\u0001\u000e\u0003!1QV\u0003\u0003\f1]\t3!B\u0001\t\u001bai\u0011kA\u0002\u0005/%\t\u00012D\u0017\u0017\t\u0005A\u0002$h\u0004\u0005\u0001!QQbA\u0003\u0002\u0011\u001dAr\u0001U\u0002\u0001C\u0011)\u0011\u0001#\u0002\r\u0002a\u0015\u0011kA\u0003\u00051%\t\u0001BB\u0007\u0002\u0011\u001fic\u0003B\u0001\u00192u=A\u0001\u0001\u0005\u000b\u001b\r)\u0011\u0001C\u0004\u0019\u000fA\u001b\u0001!\t\u0003\u0006\u0003!\u0015A\u0012\u0001M\u0003#\u000e)A\u0011G\u0005\u0002\u0011\u0019i\u0011\u0001c\u0004.+\u0011\u0019\u0001$GO\b\t\u0001A\u0011#D\u0002\u0006\u0003!\u0015\u0001T\u0001)\u0004\u0001\u0005\u001aQ!\u0001\u0005\t1!\t6!\u0002\u0003\u001a\u0013\u0005!\t!D\u0001\t\rUJT\u0001\u000f\u0003c\u0002a!Qt\u0002\u0003\u0001\u0011\u0013i1!B\u0001\t\ta!\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u00012B\u0007\u0004\u000b\u0005AI\u0001'\u0003Q\u0007\u0003iz\u0001\u0002\u0001\t\u000e5\u0019Q!\u0001\u0005\u00061\u0015\u00016!AO\b\t\u0001Ay!D\u0002\u0006\u0003!-\u00014\u0002)\u0004\u0004\u0005\u001aQ!\u0001E\u00031\u000b\t6A\u0004\u0003\u0005\u0013\u0005!\u0001!\u0004\u0002\u0005\u00061\u0005QB\u0001\u0003\u0002\u0019\u0003i!\u0001\"\u0001\r\u00025\tAQ\u0001"})
public class MarkdownConstraints {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    public static final MarkdownConstraints BASE;
    public static final char BQ_CHAR = '>';
    private final int[] indents;
    private final char[] types;
    private final boolean[] isExplicit;
    private final int charsEaten;
    public static final Companion Companion;

    static {
        $kotlinClass = Reflection.createKotlinClass(MarkdownConstraints.class);
        Companion companion = Companion = new Companion(null);
        BASE = new MarkdownConstraints(new int[0], new char[0], new boolean[0], 0);
        BQ_CHAR = (char)62;
    }

    @NotNull
    public MarkdownConstraints getBase() {
        return Companion.getBASE();
    }

    @NotNull
    public MarkdownConstraints createNewConstraints(@NotNull int[] indents, @NotNull char[] types, @NotNull boolean[] isExplicit, int charsEaten) {
        Intrinsics.checkParameterIsNotNull((Object)indents, (String)"indents");
        Intrinsics.checkParameterIsNotNull((Object)types, (String)"types");
        Intrinsics.checkParameterIsNotNull((Object)isExplicit, (String)"isExplicit");
        return new MarkdownConstraints(indents, types, isExplicit, charsEaten);
    }

    @NotNull
    public final CharSequence eatItselfFromString(@NotNull CharSequence s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        if (s.length() < this.charsEaten) {
            return "";
        }
        return s.subSequence(this.charsEaten, s.length());
    }

    public final int getIndent() {
        if (this.indents.length == 0) {
            return 0;
        }
        return KotlinPackage.last((int[])this.indents);
    }

    public final int getCharsEaten(@NotNull CharSequence s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        return Math.min(this.charsEaten, s.length());
    }

    @Nullable
    public Character getLastType() {
        return KotlinPackage.lastOrNull((char[])this.types);
    }

    @Nullable
    public final Boolean getLastExplicit() {
        return KotlinPackage.lastOrNull((boolean[])this.isExplicit);
    }

    public final boolean upstreamWith(@NotNull MarkdownConstraints other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return other.startsWith(this) && !this.containsListMarkers();
    }

    public final boolean extendsPrev(@NotNull MarkdownConstraints other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return this.startsWith(other) && !this.containsListMarkers(other.types.length);
    }

    public final boolean extendsList(@NotNull MarkdownConstraints other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        if (other.types.length == 0) {
            throw (Throwable)new IllegalArgumentException("List constraints should contain at least one item");
        }
        return this.startsWith(other) && !this.containsListMarkers(other.types.length - 1);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean startsWith(MarkdownConstraints other) {
        int n = this.indents.length;
        int m = other.indents.length;
        if (n < m) {
            return false;
        }
        int n2 = 0;
        int n3 = m - 1;
        if (n2 <= n3) {
            while (true) {
                void i;
                if (this.types[i] != other.types[i]) {
                    return false;
                }
                if (i == n3) break;
                ++i;
            }
        }
        return true;
    }

    private final boolean containsListMarkers() {
        return this.containsListMarkers(this.types.length);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean containsListMarkers(int upToIndex) {
        int n = 0;
        int n2 = upToIndex - 1;
        if (n <= n2) {
            while (true) {
                void i;
                if (this.types[i] != Companion.getBQ_CHAR() && this.isExplicit[i]) {
                    return true;
                }
                if (i == n2) break;
                ++i;
            }
        }
        return false;
    }

    @Nullable
    public final MarkdownConstraints addModifierIfNeeded(@Nullable LookaheadText.Position pos) {
        if (pos == null || pos.getChar() == '\n') {
            return null;
        }
        if (HorizontalRuleProvider.Companion.isHorizontalRule(pos.getCurrentLine(), pos.getOffsetInCurrentLine())) {
            return null;
        }
        MarkdownConstraints markdownConstraints = this.tryAddListItem(pos);
        if (markdownConstraints == null) {
            markdownConstraints = this.tryAddBlockQuote(pos);
        }
        return markdownConstraints;
    }

    @Nullable
    protected ListMarkerInfo fetchListMarker(@NotNull LookaheadText.Position pos) {
        int offset;
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        if (pos.getChar() == '*' || pos.getChar() == '-' || pos.getChar() == '+') {
            return new ListMarkerInfo(String.valueOf(pos.getChar()), pos.getChar(), 1);
        }
        String line = pos.getCurrentLine();
        for (offset = pos.getOffsetInCurrentLine(); offset < line.length(); ++offset) {
            char c = line.charAt(offset);
            boolean bl = true;
            if (c < '0') {
                bl = false;
            }
            boolean bl2 = true;
            if (c > '9') {
                bl2 = false;
            }
            if (!(bl & bl2)) break;
        }
        if (offset > pos.getOffsetInCurrentLine() && offset - pos.getOffsetInCurrentLine() <= 9 && offset < line.length() && (line.charAt(offset) == '.' || line.charAt(offset) == ')')) {
            return new ListMarkerInfo(line.subSequence(pos.getOffsetInCurrentLine(), offset + 1), line.charAt(offset), offset + 1 - pos.getOffsetInCurrentLine());
        }
        return null;
    }

    private final MarkdownConstraints tryAddListItem(LookaheadText.Position pos) {
        int spacesBefore;
        String line = pos.getCurrentLine();
        int offset = pos.getOffsetInCurrentLine();
        for (spacesBefore = 0; offset < line.length() && line.charAt(offset) == ' ' && spacesBefore < 3; ++spacesBefore, ++offset) {
        }
        if (offset == line.length()) {
            return null;
        }
        LookaheadText.Position position = pos.nextPosition(spacesBefore);
        if (position == null) {
            Intrinsics.throwNpe();
        }
        ListMarkerInfo listMarkerInfo = this.fetchListMarker(position);
        if (listMarkerInfo == null) {
            return null;
        }
        ListMarkerInfo markerInfo = listMarkerInfo;
        int spacesAfter = 0;
        int markerEndOffset = offset += markerInfo.getMarkerText().length();
        block5: while (offset < line.length()) {
            switch (line.charAt(offset)) {
                case ' ': {
                    ++spacesAfter;
                    break;
                }
                case '\t': {
                    spacesAfter += 4 - spacesAfter % 4;
                    break;
                }
                default: {
                    break block5;
                }
            }
            ++offset;
        }
        if (spacesAfter > 0 && spacesAfter < 5 && offset < line.length()) {
            return MarkdownConstraints.Companion.MarkdownConstraints(this, spacesBefore + markerInfo.getMarkerIndent() + spacesAfter, markerInfo.getMarkerType(), true, offset);
        }
        if (spacesAfter >= 5 && offset < line.length() || offset == line.length()) {
            return MarkdownConstraints.Companion.MarkdownConstraints(this, spacesBefore + markerInfo.getMarkerIndent() + 1, markerInfo.getMarkerType(), true, Math.min(offset, markerEndOffset + 1));
        }
        return null;
    }

    private final MarkdownConstraints tryAddBlockQuote(LookaheadText.Position pos) {
        int spacesBefore;
        String line = pos.getCurrentLine();
        int offset = pos.getOffsetInCurrentLine();
        for (spacesBefore = 0; offset < line.length() && line.charAt(offset) == ' ' && spacesBefore < 3; ++spacesBefore, ++offset) {
        }
        if (offset == line.length() || line.charAt(offset) != Companion.getBQ_CHAR()) {
            return null;
        }
        int spacesAfter = 0;
        if (++offset >= line.length() || line.charAt(offset) == ' ' || line.charAt(offset) == '\t') {
            spacesAfter = 1;
            if (offset < line.length()) {
                ++offset;
            }
        }
        return MarkdownConstraints.Companion.MarkdownConstraints(this, spacesBefore + 1 + spacesAfter, MarkdownConstraints.Companion.getBQ_CHAR(), true, offset);
    }

    @NotNull
    public String toString() {
        return "MdConstraints: " + KotlinPackage.String((char[])this.types) + "(" + this.getIndent() + ")";
    }

    protected MarkdownConstraints(@NotNull int[] indents, @NotNull char[] types, @NotNull boolean[] isExplicit, int charsEaten) {
        Intrinsics.checkParameterIsNotNull((Object)indents, (String)"indents");
        Intrinsics.checkParameterIsNotNull((Object)types, (String)"types");
        Intrinsics.checkParameterIsNotNull((Object)isExplicit, (String)"isExplicit");
        this.indents = indents;
        this.types = types;
        this.isExplicit = isExplicit;
        this.charsEaten = charsEaten;
    }

    @data
    @KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"1\u0006)qA*[:u\u001b\u0006\u00148.\u001a:J]\u001a|'bE'be.$wn\u001e8D_:\u001cHO]1j]R\u001c(bA8sO*A\u0011N\u001c;fY2L'N\u0003\u0005nCJ\\Gm\\<o\u0015\u0019\u0001\u0018M]:fe*Y1m\u001c8tiJ\f\u0017N\u001c;t\u0015\r\te.\u001f\u0006\u0007W>$H.\u001b8\u000b\rqJg.\u001b;?\u0015)i\u0017M]6feR+\u0007\u0010\u001e\u0006\r\u0007\"\f'oU3rk\u0016t7-\u001a\u0006\u000b[\u0006\u00148.\u001a:UsB,'\u0002B\"iCJTA\"\\1sW\u0016\u0014\u0018J\u001c3f]RT1!\u00138u\u0015\u0011Q\u0017M^1\u000b\t1\fgn\u001a\u0006\u0010O\u0016$X*\u0019:lKJLe\u000eZ3oi*iq-\u001a;NCJ\\WM\u001d+fqRTQbZ3u\u001b\u0006\u00148.\u001a:UsB,'BC2p[B|g.\u001a8uc)Q1m\\7q_:,g\u000e\u001e\u001a\u000b\u0015\r|W\u000e]8oK:$8G\u0003\u0003d_BL(BI'be.$wn\u001e8D_:\u001cHO]1j]R\u001cH\u0005T5ti6\u000b'o[3s\u0013:4wN\u001a\u0006\u0003!\tQA\u0001\u0003\u0001\u0011\u0007)!\u0001\"\u0001\t\u0005\u0015\u0011A!\u0001E\u0003\u000b\t!\u0019\u0001C\u0002\u0006\u0007\u0011\u0011\u0001\u0012\u0001\u0007\u0001\u000b\r!)\u0001\u0003\u0001\r\u0001\u0015\t\u0001\u0002B\u0003\u0004\t\u000fA9\u0001\u0004\u0001\u0006\u0007\u0011\u001d\u00012\u0002\u0007\u0001\u000b\r!9\u0001#\u0004\r\u0001\u0015\u0019Aq\u0001E\b\u0019\u0001)\u0011\u0001\u0003\u0005\u0006\u0005\u00111\u0001\u0012C\u0003\u0003\t\u001bAY!\u0002\u0002\u0005\u0005!eAq\u0001\u0007\u00043\r)\u0011\u0001\u0003\u0003\u0019\t5\u0002Ba\u0019\u0003\u0019\u000f\u0005\u001aQ!\u0001E\u00061\u0017)6\u0001C\u0003\u0004\t\u001dI\u0011\u0001\"\u0002\u000e\u0007\u0011I\u0011\"\u0001C\u0003[A!1\r\u0002\r\u0006C\r)\u0011\u0001#\u0003\u0019\nU\u001b\u0001\"B\u0002\u0005\u000b%\t\u0001bB\u0007\u0004\t'I\u0011\u0001C\u0004.!\u0011\u0019G\u0001\u0007\u0004\"\u0007\u0015\t\u0001\"\u0002\r\u0006+\u000eAQa\u0001\u0003\u0007\u0013\u0005!\u0011!D\u0002\u0005\u0015%\tA!A\u0017\f\t\r\u001b\u0001TC\u0011\u0004\u000b\u0005AI\u0001'\u0003R\u0007\r!)\"C\u0001\t\u000f5ZAaQ\u0002\u0019\u0017\u0005\u001aQ!\u0001\u0005\u00061\u0015\t6a\u0001\u0003\f\u0013\u0005!\u0011!L\u0006\u0005\u0007\u000eA:\"I\u0002\u0006\u0003!-\u00014B)\u0004\u0007\u0011]\u0011\"\u0001C\u0003[+\"1i\u0001\r\r;\u001f!\u0011\u0001C\u0003\u000e\u0007\u0015\t\u0001\u0012\u0002M\u0005!\u000e\u0001Qt\u0002\u0003\u0002\u0011\u0019i1!B\u0001\t\u000ba)\u0001k!\u0001\u001e\u0010\u0011\t\u0001bB\u0007\u0004\u000b\u0005AY\u0001g\u0003Q\u0007\u0005\t3!B\u0001\t\u0007a\u0019\u0011kA\u0005\u0005\u0019%\t\u0001rB\u0007\u0002\u0011\u001di\u0011\u0001B\u0001\u000e\u0003\u0011\u0015QwKC+\t\r\b\u0001\u0014BO\b\t\u0001AQ!D\u0002\u0006\u0003!%\u0001\u0014\u0002)\u0004\u0001u=A\u0001\u0001\u0005\u0007\u001b\r)\u0011\u0001C\u0003\u0019\u000bA\u001b\t!h\u0004\u0005\u0001!9QbA\u0003\u0002\u0011\u0017AZ\u0001U\u0002\u0002C\r)\u0011\u0001C\u0002\u0019\u0007E\u001b\u0011\u0002\"\u0003\n\u0003\u0011\u0001Q\"\u0001\u0005\b\u001b\u0005!\u0011!D\u0001\u0005\u0006\u0001"})
    public static final class ListMarkerInfo {
        public static final /* synthetic */ KClass $kotlinClass;
        @NotNull
        private final CharSequence markerText;
        private final char markerType;
        private final int markerIndent;

        static {
            $kotlinClass = Reflection.createKotlinClass(ListMarkerInfo.class);
        }

        @NotNull
        public final CharSequence getMarkerText() {
            return this.markerText;
        }

        public final char getMarkerType() {
            return this.markerType;
        }

        public final int getMarkerIndent() {
            return this.markerIndent;
        }

        public ListMarkerInfo(@NotNull CharSequence markerText, char markerType, int markerIndent) {
            Intrinsics.checkParameterIsNotNull((Object)markerText, (String)"markerText");
            this.markerText = markerText;
            this.markerType = markerType;
            this.markerIndent = markerIndent;
        }

        @NotNull
        public final CharSequence component1() {
            return this.markerText;
        }

        public final char component2() {
            return this.markerType;
        }

        public final int component3() {
            return this.markerIndent;
        }

        @NotNull
        public final ListMarkerInfo copy(@NotNull CharSequence markerText, char markerType, int markerIndent) {
            Intrinsics.checkParameterIsNotNull((Object)markerText, (String)"markerText");
            return new ListMarkerInfo(markerText, markerType, markerIndent);
        }

        @NotNull
        public static /* synthetic */ ListMarkerInfo copy$default(ListMarkerInfo listMarkerInfo, CharSequence charSequence, char c, int n, int n2) {
            if ((n2 & 1) != 0) {
                charSequence = listMarkerInfo.markerText;
            }
            if ((n2 & 2) != 0) {
                c = listMarkerInfo.markerType;
            }
            if ((n2 & 4) != 0) {
                n = listMarkerInfo.markerIndent;
            }
            return listMarkerInfo.copy(charSequence, c, n);
        }

        public String toString() {
            return "ListMarkerInfo(markerText=" + this.markerText + ", markerType=" + this.markerType + ", markerIndent=" + this.markerIndent + ")";
        }

        public int hashCode() {
            CharSequence charSequence = this.markerText;
            return ((charSequence != null ? charSequence.hashCode() : 0) * 31 + this.markerType) * 31 + this.markerIndent;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ListMarkerInfo)) break block3;
                    ListMarkerInfo listMarkerInfo = (ListMarkerInfo)object;
                    if (!Intrinsics.areEqual((Object)this.markerText, (Object)listMarkerInfo.markerText) || !(this.markerType == listMarkerInfo.markerType) || !(this.markerIndent == listMarkerInfo.markerIndent)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"[\u0006)I1i\\7qC:LwN\u001c\u0006\u0014\u001b\u0006\u00148\u000eZ8x]\u000e{gn\u001d;sC&tGo\u001d\u0006\u0004_J<'\u0002C5oi\u0016dG.\u001b6\u000b\u00115\f'o\u001b3po:Ta\u0001]1sg\u0016\u0014(bC2p]N$(/Y5oiNT1!\u00118z\u0015\u0019Yw\u000e\u001e7j]*!!)Q*F\u0015\u001d9W\r\u001e\"B'\u0016SqAQ)`\u0007\"\u000b%K\u0003\u0003DQ\u0006\u0014(BC4fi\n\u000bvl\u0011%B%*1\u0001/\u0019:f]RTaB\\3x\u0013:$WM\u001c;EK2$\u0018MC\u0002J]RTqA\\3x)f\u0004XMC\u0006oK^,\u0005\u0010\u001d7jG&$(b\u0002\"p_2,\u0017M\u001c\u0006\n]\u0016<xJ\u001a4tKRT\u0001CZ5mY\u001a\u0013x.\u001c)sKZLw.^:\u000b\t1Lg.\u001a\u0006\u0007'R\u0014\u0018N\\4\u000b\u0017M$\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0006\u0014aJ,g\u000fT5oK\u000e{gn\u001d;sC&tGo\u001d\u0006\u0005U\u00064\u0018M\u0003\u0003mC:<'\u0002\u00034s_6\u0014\u0015m]3\u000b\u0007A|7O\u0003\u0005Q_NLG/[8o\u00155aun\\6bQ\u0016\fG\rV3yi*1Bj\\8lC\",\u0017\r\u001a+fqR$\u0003k\\:ji&|g\u000eb\u0001\u000b\u0005A\u0011!\u0002\u0002\u0005\u0001!\rQA\u0001C\u0001\u0011\t)!\u0001B\u0001\t\u0006\u0015\u0011A1\u0001\u0005\u0004\u000b\r!!\u0001#\u0001\r\u0001\u0015\u0019AQ\u0001\u0005\u0001\u0019\u0001)\u0011\u0001\u0003\u0003\u0006\u0007\u0011\u001d\u0001r\u0001\u0007\u0001\u000b\t!!\u0001#\u0001\u0006\u0007\u0011\u001d\u0001B\u0002\u0007\u0001\u000b\r!9\u0001\u0003\u0005\r\u0001\u0015\u0019Aq\u0001E\n\u0019\u0001)1\u0001b\u0002\t\u00181\u0001Q!\u0001\u0005\u000e\u000b\t!q\u0001c\u0007\u0006\u0005\u0011=\u0001rC\u0003\u0004\t\u0007Ay\u0002\u0004\u0001\u0006\u0007\u0011E\u0001b\u0004\u0007\u0001\u000b\t!\u0019\u0001\u0003\t\u0005\u0007\ba1!G\u0002\u0006\u0003!!\u0001\u0004B\u0017\u0012\t\r$\u0001\u0014B\u0011\u0004\u000b\u0005A)\u0001'\u0002V\u0007%)A\u0001\"\u0003\n\u0003!%A\u0012A\u0007\u0004\t\u0015I\u0011\u0001#\u0003.#\u0011\u0019G\u0003g\u0003\"\u0007\u0015\t\u0001\"\u0002\r\u0006+\u000eIQ\u0001\u0002C\u0006\u0013\u0005!\u0011\u0001$\u0001\u000e\u0007\u00115\u0011\"\u0001\u0003\u0002[}\"\u0011\u0001'\u0001\u001e\u0010\u0011\u0001\u0001bB\u0007\u0004\u000b\u0005A)\u0001'\u0002Q\u0007\u0001iz\u0001\u0002\u0001\t\u00105\u0019Q!\u0001E\u00061\u0017\u00016\u0011AO\b\t\u0001A\t\"D\u0002\u0006\u0003!)\u0001$\u0002)\u0004\u0003u=A\u0001\u0001\u0005\n\u001b\r)\u0011\u0001\u0003\u0004\u0019\rA\u001b\u0019!h\u0004\u0005\u0001!QQbA\u0003\u0002\u0011\u0017AZ\u0001U\u0002\u0003C\r)\u0011\u0001#\u0002\u0019\u0006E\u001bQ\u0002\"\u0001\n\u0003!%Q\"\u0001E\u0005\u001b\u0005!)!D\u0001\u0005\u00035\tA\u0011A\u0007\u0002\t\u000bi#\u0006B\u0002\u0019\u0016u=A\u0001\u0001\u0005\f\u001b\r)\u0011\u0001#\u0004\u0019\u000eA\u001b\u0001!h\u0004\u0005\u0001!aQbA\u0003\u0002\u0011\u0017AZ\u0001UB\u0001;\u001f!\u0001\u0001#\u0007\u000e\u0007\u0015\t\u0001R\u0001M\u0003!\u000e\t\u0011eA\u0003\u0002\u0011\u000bA*!U\u0002\n\t+I\u0011\u0001#\u0003\u000e\u0003!AQ\"\u0001C\u0003\u001b\u0005AI!l\u0010\u0005\u0007aqQt\u0002\u0003\u0001\u0011;i1!B\u0001\t\u0013aI\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001\u0012D\u0007\u0004\u000b\u0005A)\u0001'\u0002Q\u0007\u0003\t3!B\u0001\t\u0006a\u0015\u0011kA\u0004\u0005\u001d%\t\u0001\u0012B\u0007\u0002\u0011'i\u0011\u0001#\u00036\u0001\u0001"})
    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        @NotNull
        public final MarkdownConstraints getBASE() {
            return BASE;
        }

        public final char getBQ_CHAR() {
            return BQ_CHAR;
        }

        private final MarkdownConstraints MarkdownConstraints(MarkdownConstraints parent, int newIndentDelta, char newType, boolean newExplicit, int newOffset) {
            int n = parent.indents.length;
            int[] _indents = new int[n + 1];
            char[] _types = new char[n + 1];
            boolean[] _isExplicit = new boolean[n + 1];
            System.arraycopy(parent.indents, 0, _indents, 0, n);
            System.arraycopy(parent.types, 0, _types, 0, n);
            System.arraycopy(parent.isExplicit, 0, _isExplicit, 0, n);
            _indents[n] = parent.getIndent() + newIndentDelta;
            _types[n] = newType;
            _isExplicit[n] = newExplicit;
            return parent.createNewConstraints(_indents, _types, _isExplicit, newOffset);
        }

        @NotNull
        public final MarkdownConstraints fromBase(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints prevLineConstraints) {
            Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
            Intrinsics.checkParameterIsNotNull((Object)prevLineConstraints, (String)"prevLineConstraints");
            KotlinPackage.assert((pos.getChar() == '\n' ? 1 : 0) != 0);
            String line = pos.getCurrentLine();
            MarkdownConstraints result = this.fillFromPrevious(line, 0, prevLineConstraints);
            while (true) {
                int offset;
                if (result.addModifierIfNeeded(pos.nextPosition(1 + (offset = result.getCharsEaten(line)))) != null) continue;
                break;
            }
            return result;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final MarkdownConstraints fillFromPrevious(@NotNull String line, int startOffset, @NotNull MarkdownConstraints prevLineConstraints) {
            void indexPrev;
            Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
            Intrinsics.checkParameterIsNotNull((Object)prevLineConstraints, (String)"prevLineConstraints");
            int prevN = prevLineConstraints.indents.length;
            Ref.IntRef intRef = new Ref.IntRef();
            intRef.element = 0;
            Function1 getBlockQuoteIndent2 = (Function1)new Function1<Integer, Integer>(line){
                final /* synthetic */ String $line;

                @Nullable
                public final Integer invoke(int startOffset) {
                    int blockQuoteIndent;
                    int offset = startOffset;
                    for (blockQuoteIndent = 0; blockQuoteIndent < 3 && offset < this.$line.length() && this.$line.charAt(offset) == ' '; ++blockQuoteIndent, ++offset) {
                    }
                    return offset < this.$line.length() && this.$line.charAt(offset) == MarkdownConstraints.Companion.getBQ_CHAR() ? Integer.valueOf(blockQuoteIndent + 1) : (Integer)null;
                }
                {
                    this.$line = string;
                    super(1);
                }
            };
            Function1 fillMaybeBlockquoteAndListIndents2 = (Function1)new Function1<MarkdownConstraints, MarkdownConstraints>((Ref.IntRef)indexPrev, prevN, startOffset, line, prevLineConstraints, getBlockQuoteIndent2){
                final /* synthetic */ Ref.IntRef $indexPrev;
                final /* synthetic */ int $prevN;
                final /* synthetic */ int $startOffset;
                final /* synthetic */ String $line;
                final /* synthetic */ MarkdownConstraints $prevLineConstraints;
                final /* synthetic */ Function1 $getBlockQuoteIndent;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final MarkdownConstraints invoke(@NotNull MarkdownConstraints constraints) {
                    int n;
                    int bonusForTheBlockquote;
                    int deltaIndent;
                    Integer bqIndent;
                    void offset;
                    void spacesSeen;
                    Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
                    if (this.$indexPrev.element >= this.$prevN) {
                        return constraints;
                    }
                    Ref.IntRef intRef = new Ref.IntRef();
                    intRef.element = this.$startOffset + constraints.getCharsEaten(this.$line);
                    Ref.IntRef intRef2 = new Ref.IntRef();
                    intRef2.element = 0;
                    Function1 hasKMoreSpaces2 = (Function1)new Function1<Integer, Boolean>(this, (Ref.IntRef)spacesSeen, (Ref.IntRef)offset){
                        final /* synthetic */ fillFromPrevious.fillMaybeBlockquoteAndListIndents.1 this$0;
                        final /* synthetic */ Ref.IntRef $spacesSeen;
                        final /* synthetic */ Ref.IntRef $offset;

                        public final boolean invoke(int k) {
                            boolean bl;
                            int oldSpacesSeen = this.$spacesSeen.element;
                            int oldOffset = this.$offset.element;
                            block4: while (this.$spacesSeen.element < k && this.$offset.element < this.this$0.$line.length()) {
                                switch (this.this$0.$line.charAt(this.$offset.element)) {
                                    case ' ': {
                                        int n = this.$spacesSeen.element++;
                                        break;
                                    }
                                    case '\t': {
                                        this.$spacesSeen.element += 4 - this.$spacesSeen.element % 4;
                                        break;
                                    }
                                    default: {
                                        break block4;
                                    }
                                }
                                int n = this.$offset.element++;
                            }
                            if (this.$offset.element == this.this$0.$line.length()) {
                                this.$spacesSeen.element = Integer.MAX_VALUE;
                            }
                            if (k <= this.$spacesSeen.element) {
                                this.$spacesSeen.element -= k;
                                bl = true;
                            } else {
                                this.$offset.element = oldOffset;
                                this.$spacesSeen.element = oldSpacesSeen;
                                bl = false;
                            }
                            return bl;
                        }
                        {
                            this.this$0 = var1_1;
                            this.$spacesSeen = intRef;
                            this.$offset = intRef2;
                            super(1);
                        }
                    };
                    if (MarkdownConstraints.access$getTypes$1(this.$prevLineConstraints)[this.$indexPrev.element] == MarkdownConstraints.Companion.getBQ_CHAR()) {
                        Integer n2 = (Integer)this.$getBlockQuoteIndent.invoke((Object)offset.element);
                        if (n2 == null) {
                            return constraints;
                        }
                        bqIndent = ((Number)n2).intValue();
                        offset.element += ((Number)bqIndent).intValue();
                        int n3 = this.$indexPrev.element++;
                    } else {
                        bqIndent = null;
                    }
                    int oldIndexPrev = this.$indexPrev.element;
                    while (this.$indexPrev.element < this.$prevN && MarkdownConstraints.access$getTypes$1(this.$prevLineConstraints)[this.$indexPrev.element] != MarkdownConstraints.Companion.getBQ_CHAR() && ((Boolean)hasKMoreSpaces2.invoke((Object)(deltaIndent = MarkdownConstraints.access$getIndents$0(this.$prevLineConstraints)[this.$indexPrev.element] - (this.$indexPrev.element == 0 ? 0 : MarkdownConstraints.access$getIndents$0(this.$prevLineConstraints)[this.$indexPrev.element - 1])))).booleanValue()) {
                        int n4 = this.$indexPrev.element++;
                    }
                    MarkdownConstraints result = constraints;
                    if (bqIndent != null) {
                        bonusForTheBlockquote = (Boolean)hasKMoreSpaces2.invoke((Object)1) != false ? 1 : 0;
                        result = org.intellij.markdown.parser.constraints.MarkdownConstraints$Companion.access$MarkdownConstraints$0(MarkdownConstraints.Companion, result, ((Number)bqIndent).intValue() + bonusForTheBlockquote, MarkdownConstraints.Companion.getBQ_CHAR(), true, offset.element);
                    }
                    if ((bonusForTheBlockquote = oldIndexPrev) <= (n = this.$indexPrev.element - 1)) {
                        while (true) {
                            void index;
                            int deltaIndent2 = MarkdownConstraints.access$getIndents$0(this.$prevLineConstraints)[index] - (index == false ? 0 : MarkdownConstraints.access$getIndents$0(this.$prevLineConstraints)[index - true]);
                            result = org.intellij.markdown.parser.constraints.MarkdownConstraints$Companion.access$MarkdownConstraints$0(MarkdownConstraints.Companion, result, deltaIndent2, MarkdownConstraints.access$getTypes$1(this.$prevLineConstraints)[index], false, offset.element);
                            if (index == n) break;
                            ++index;
                        }
                    }
                    return result;
                }
                {
                    this.$indexPrev = intRef;
                    this.$prevN = n;
                    this.$startOffset = n2;
                    this.$line = string;
                    this.$prevLineConstraints = markdownConstraints;
                    this.$getBlockQuoteIndent = function1;
                    super(1);
                }
            };
            MarkdownConstraints result = prevLineConstraints.getBase();
            MarkdownConstraints nextConstraints;
            while (!Intrinsics.areEqual((Object)(nextConstraints = (MarkdownConstraints)fillMaybeBlockquoteAndListIndents2.invoke((Object)result)), (Object)result)) {
                result = nextConstraints;
            }
            return result;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

