/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks;

import kotlin.CharIterator;
import kotlin.KotlinPackage;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"d\u0006)\u0011R*\u0019:lI><h\u000eU1sg\u0016\u0014X\u000b^5m\u0015\ry'o\u001a\u0006\tS:$X\r\u001c7jU*AQ.\u0019:lI><hN\u0003\u0004qCJ\u001cXM\u001d\u0006\r[\u0006\u00148.\u001a:cY>\u001c7n\u001d\u0006\u0004\u0003:L(BB6pi2LgN\u0003\u000edC2\u001cg*^7cKJ|emQ8og\u0016\fX/\u001a8u\u000b>d7OC\u0002q_NT\u0001\u0002U8tSRLwN\u001c\u0006\u000e\u0019>|7.\u00195fC\u0012$V\r\u001f;\u000b\u0017\r|gn\u001d;sC&tGo\u001d\u0006\u0014\u001b\u0006\u00148\u000eZ8x]\u000e{gn\u001d;sC&tGo\u001d\u0006\u0004\u0013:$(B\u0006'p_.\f\u0007.Z1e)\u0016DH\u000f\n)pg&$\u0018n\u001c8\u000bG\u0019Lg\u000e\u001a(p]\u0016k\u0007\u000f^=MS:,w+\u001b;i'\u0006lWmQ8ogR\u0014\u0018-\u001b8ug*ar-\u001a;GSJ\u001cHOT8o/\"LG/Z:qC\u000e,G*\u001b8f!>\u001c(BC3pYN$vnU6ja*\u0011\u0002.Y:D_\u0012,'\t\\8dW&sG-\u001a8u\u0015\u001d\u0011un\u001c7fC:Tq\"[:F[B$\u0018p\u0014:Ta\u0006\u001cWm\u001d\u0006\u0002g*a1\t[1s'\u0016\fX/\u001a8dK*!!.\u0019<b\u0015\u0011a\u0017M\\4\u0003\u0004)\u0011\u0001#\u0001\u0006\u0005\u0011\u0001\u0001\"A\u0003\u0003\t\u0003A\u0019!\u0002\u0002\u0005\u0003!\u0011QA\u0001C\u0002\u0011\u000b)1\u0001\u0002\u0002\t\u00011\u0001Q!\u0001E\u0004\u000b\r!1\u0001C\u0002\r\u0001\u0015\u0019A1\u0001E\u0006\u0019\u0001)1\u0001\u0002\u0003\t\u000b1\u0001QA\u0001C\u0002\u0011\u0019)1\u0001B\u0003\t\u000e1\u0001Qa\u0001\u0003\u0004\u0011\u001da\u0001!\u0002\u0002\u0005\u0004!=QA\u0001\u0003\u0006\u0011\u001b)1\u0001B\u0002\t\u00151\u0001Qa\u0001\u0003\u0004\u0011/a\u0001!B\u0001\t\u0019\u0015\u0011A\u0011\u0003E\r\u000b\t!\u0011\u0002c\u0006\u0005G\u0006a)!G\u0002\u0006\u0003!\u001d\u0001tAW \t\rAB!h\u0004\u0005\u0001!%QbA\u0003\u0002\u0011\u0013AJ\u0001U\u0002\u0001;\u001f!\u0001\u0001\u0003\u0004\u000e\u0007\u0015\t\u00012\u0002M\u0006!\u000e\u0005\u0011eA\u0003\u0002\u0011\u0019Ab!U\u0002\b\t\u0011I\u0011\u0001\"\u0002\u000e\u0003!5Q\"\u0001\u0005\b[\u0003\"1\u0001\u0007\u0005\u001e\u0010\u0011\u0001\u0001BB\u0007\u0004\u000b\u0005AY\u0001g\u0003Q\u0007\u0001iz\u0001\u0002\u0001\t\n5\u0019Q!\u0001E\u00051\u0013\u00016\u0011A\u0011\u0005\u000b\u0005AI\u0001$\u0001\u0019\nE\u001bq\u0001\u0002\u0005\n\u0003!5Q\"\u0001\u0005\b\u001b\u0005Ai!,\u0011\u0005\u0007aEQt\u0002\u0003\u0001\u0011\u0013i1!B\u0001\t\na%\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001\"C\u0007\u0004\u000b\u0005Aa\u0001\u0007\u0004Q\u0007\u0003\tC!B\u0001\t\n1\u0005\u0001\u0014B)\u0004\u000f\u0011E\u0011\"\u0001E\u0007\u001b\u0005Ai!D\u0001\u0005\u00065~Ba\u0001M\n;\u001f!\u0001\u0001#\u0003\u000e\u0007\u0015\t\u0001\u0012\u0002M\u0005!\u000e\u0001Qt\u0002\u0003\u0001\u0011\u0019i1!B\u0001\t\fa-\u0001k!\u0001\"\u0007\u0015\t\u0001r\u0002M\b#\u000e9A1C\u0005\u0002\t\u0003i\u0011\u0001#\u0004\u000e\u0003!9Q&\u0006\u0003\u00041+iz\u0001\u0002\u0001\t\u00175\u0019Q!\u0001\u0005\t1!\u00016\u0001A\u0011\u0004\u000b\u0005Ay\u0001g\u0004R\u0007\u0015!)\"C\u0001\u0005\u00025\t\u00012C\u001b\u0001"})
public final class MarkdownParserUtil {
    public static final /* synthetic */ KClass $kotlinClass;
    public static final MarkdownParserUtil INSTANCE$;

    static {
        $kotlinClass = Reflection.createKotlinClass(MarkdownParserUtil.class);
        new MarkdownParserUtil();
    }

    public final int calcNumberOfConsequentEols(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        KotlinPackage.assert((pos.getChar() == '\n' ? 1 : 0) != 0);
        LookaheadText.Position currentPos = pos;
        int result = 1;
        Function1 isClearLine2 = (Function1)new Function1<LookaheadText.Position, Boolean>(constraints){
            final /* synthetic */ MarkdownConstraints $constraints;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean invoke(@NotNull LookaheadText.Position pos) {
                Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
                MarkdownConstraints currentConstraints = MarkdownConstraints.Companion.fillFromPrevious(pos.getCurrentLine(), 0, this.$constraints);
                int constraintsLength = currentConstraints.getCharsEaten(pos.getCurrentLine());
                if (!currentConstraints.upstreamWith(this.$constraints)) return false;
                if (constraintsLength >= pos.getCurrentLine().length()) return true;
                LookaheadText.Position position = pos.nextPosition(1 + constraintsLength);
                if (position == null) return true;
                Integer n = position.charsToNonWhitespace();
                if (n != null) return false;
                return true;
            }
            {
                this.$constraints = markdownConstraints;
                super(1);
            }
        };
        while (((Boolean)isClearLine2.invoke((Object)currentPos)).booleanValue()) {
            if (currentPos.nextLinePosition() == null) {
                break;
            }
            if (++result <= 4) continue;
            break;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final LookaheadText.Position getFirstNonWhitespaceLinePos(@NotNull LookaheadText.Position pos, int eolsToSkip) {
        void currentPos;
        void times;
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = pos;
        int n = eolsToSkip - 1;
        boolean bl = false;
        void var6_6 = times - true;
        if (bl <= var6_6) {
            void index;
            do {
                void it = ++index;
                if (pos.nextLinePosition() == null) {
                    Object cfr_ignored_0 = currentPos.element;
                    return null;
                }
                currentPos.element = currentPos.element;
            } while (index != var6_6);
        }
        while (((LookaheadText.Position)currentPos.element).charsToNonWhitespace() == null) {
            if (((LookaheadText.Position)currentPos.element).nextLinePosition() == null) {
                Object cfr_ignored_1 = currentPos.element;
                return null;
            }
            currentPos.element = currentPos.element;
        }
        return (LookaheadText.Position)currentPos.element;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean hasCodeBlockIndent(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        int constraintsLength = constraints.getCharsEaten(pos.getCurrentLine());
        if (pos.getOffsetInCurrentLine() >= constraintsLength + 4) {
            return true;
        }
        int n = constraintsLength;
        int n2 = pos.getOffsetInCurrentLine();
        if (n <= n2) {
            while (true) {
                void i;
                if (pos.getCurrentLine().charAt((int)i) == '\t') {
                    return true;
                }
                if (i == n2) break;
                ++i;
            }
        }
        return false;
    }

    public final boolean isEmptyOrSpaces(@NotNull CharSequence s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        CharIterator charIterator = KotlinPackage.iterator((CharSequence)s);
        while (charIterator.hasNext()) {
            char c = charIterator.nextChar();
            if (c == ' ' || c == '\t') continue;
            return false;
        }
        return true;
    }

    @Nullable
    public final LookaheadText.Position findNonEmptyLineWithSameConstraints(@NotNull MarkdownConstraints constraints, @NotNull LookaheadText.Position pos) {
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        LookaheadText.Position currentPos = pos;
        MarkdownConstraints nextLineConstraints;
        while ((nextLineConstraints = MarkdownConstraints.Companion.fromBase(currentPos, constraints)).upstreamWith(constraints) && nextLineConstraints.extendsPrev(constraints)) {
            CharSequence stringAfterConstraints = nextLineConstraints.eatItselfFromString(currentPos.getCurrentLine());
            if (!INSTANCE$.isEmptyOrSpaces(stringAfterConstraints)) {
                return currentPos;
            }
            if (currentPos.nextLinePosition() != null) continue;
            return null;
        }
        return null;
    }

    MarkdownParserUtil() {
        INSTANCE$ = this;
    }
}

