/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.providers;

import java.util.List;
import kotlin.IntRange;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.Range;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.CodeFenceMarkerBlock;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"_\b)\t2i\u001c3f\r\u0016t7-\u001a)s_ZLG-\u001a:\u000b\u0007=\u0014xM\u0003\u0005j]R,G\u000e\\5k\u0015!i\u0017M]6e_^t'B\u00029beN,'O\u0003\u0007nCJ\\WM\u001d2m_\u000e\\7OC\u0005qe>4\u0018\u000eZ3sg*\u0019R*\u0019:lKJ\u0014En\\2l!J|g/\u001b3fe*I1\u000b^1uK&sgm\u001c\u0006\u0010\u001b\u0006\u00148.\u001a:Qe>\u001cWm]:pe*1A(\u001b8jizR!c\u0019:fCR,W*\u0019:lKJ\u0014En\\2lg*\u0019\u0001o\\:\u000b\u0011A{7/\u001b;j_:TQ\u0002T8pW\u0006DW-\u00193UKb$(\u0002\u00059s_\u0012,8\r^5p]\"{G\u000eZ3s\u0015A\u0001&o\u001c3vGRLwN\u001c%pY\u0012,'OC\u0005ti\u0006$X-\u00138g_*!A*[:u\u0015\u0019Yw\u000e\u001e7j]*YQ*\u0019:lKJ\u0014En\\2l\u0015\u0011Q\u0017M^1\u000b\tU$\u0018\u000e\u001c\u0006\u0017\u0019>|7.\u00195fC\u0012$V\r\u001f;%!>\u001c\u0018\u000e^5p]*IR*\u0019:lKJ\u0004&o\\2fgN|'\u000fJ*uCR,\u0017J\u001c4p\u0015a\u0019'/Z1uK:{G-Z:G_J4UM\\2f'R\f'\u000f\u001e\u0006\rM\u0016t7-Z!oI&sgm\u001c\u0006\u0005!\u0006L'O\u0003\u0004TiJLgn\u001a\u0006\u0005+:LGO\u0003\u000bhKR4UM\\2f'R\f'\u000f^!oI&sgm\u001c\u0006\fG>t7\u000f\u001e:bS:$8OC\nNCJ\\Gm\\<o\u0007>t7\u000f\u001e:bS:$8OC\nj]R,'O];qiN\u0004\u0016M]1he\u0006\u0004\bNC\u0004C_>dW-\u00198\u000b\u0013\r{W\u000e]1oS>t':\u0001\u0006\u0003!\u0005QA\u0001\u0003\u0001\u0011\u0005)!\u0001\"\u0001\t\u0004\u0015\u0011A!\u0001\u0005\u0003\u000b\t!\u0019\u0001#\u0002\u0006\u0005\u0011\u0011\u0001bA\u0003\u0004\t\u000bA\u0001\u0001\u0004\u0001\u0006\u0007\u0011\u0011\u0001r\u0001\u0007\u0001\u000b\r!\u0019\u0001#\u0003\r\u0001\u0015\u0019A\u0001\u0002\u0005\u0005\u0019\u0001)1\u0001b\u0001\t\u000f1\u0001Qa\u0001\u0003\u0006\u0011\u001ba\u0001!B\u0002\u0005\u0004!AA\u0002A\u0003\u0002\u0011')1\u0001\"\u0004\t\u00131\u0001Qa\u0001\u0003\u0003\u0011)a\u0001!B\u0001\t\u0016\u0015\u0011A\u0001\u0003\u0005\f\u000b\t!\t\u0002C\u0005\u0006\u0005\u0011\r\u0001rC\u0003\u0003\t\u0007A\u0001\"\u0002\u0002\u0005\u0004!aQa\u0001C\u0007\u00117a\u0001!B\u0002\u0005\u000e!qA\u0002A\u0003\u0004\t\u001bAi\u0002\u0004\u0001\u0006\u0005\u00115\u00012D\u0003\u0003\t\u0007Ay\"B\u0002\u0005\u001b!\u0001B\u0002A\u0003\u0003\t5A\u0001#B\u0002\u0005\u000e!\tB\u0002\u0001\u0003\u0004\u0019\r\u0001\u001a#\u0007\u0005\u0006\u0003!\u001d\u0011\u0002B\u0005\u0004\u000b\u0005AI\u0001'\u0003\u0019\bu\u0005\u0019#L\u0018\u0005\u0017a-Qt\u0002\u0003\u0001\u0011\u0019i1!B\u0001\t\fa-\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001rB\u0007\u0004\u000b\u0005Aa\u0001\u0007\u0004Q\u0007\u0003iz\u0001\u0002\u0001\t\u00125\u0019Q!\u0001E\u00051\u0013\u00016!A\u0011\t\u000b\u0005Aq!\u0003\u0003\n\u0007\u0015\t\u0001r\u0002M\b1\u001d\t6!\u0003C\u0006\u0013\u0005A\u0011\"D\u0001\t\u00145\t\u0001BC\u0007\u0002\u0011+iC\u0007B\u0001\u0019\u001au=A\u0001\u0001\u0005\u0007\u001b\r)\u0011\u0001c\u0003\u0019\fA\u001b\u0001!h\t\u0005\u0001!iQ\"D\u0003\u0002\u0011-IA!C\u0002\u0006\u0003!]\u0001tC\u0005\u0005\u0013\r)\u0011\u0001c\u0006\u0019\u0018aY\u0001k!\u0001\u001e\u0010\u0011\u0001\u0001rB\u0007\u0004\u000b\u0005Aa\u0001\u0007\u0004Q\u0007\u0005\t3!B\u0001\t\u0019aa\u0011kA\u0005\u0005\u001a%\tA\u0001A\u0007\u0002\u0011'i\u0011\u0001#\u0007\u000e\u0003!QQV\u000b\u0003\u00021=iz\u0001\u0002\u0001\t\r5\u0019Q!\u0001E\u00061\u0017\u00016\u0001AO\b\t\u0001Ay\"D\u0002\u0006\u0003!m\u00014\u0004)\u0004\u0002\u0005rQ!\u0001\u0005\f\u0013\u0011I1!B\u0001\t\u0018a]\u0011\u0002B\u0005\u0004\u000b\u0005A9\u0002g\u0006\r\u0002aY\u0011kA\u0004\u0005\u001f%\t\u0001\u0012D\u0007\u0002\u0011'i\u0011\u0001\u0003\b.@\u0011Y\u0001\u0014EO\b\t\u0001Aa!D\u0002\u0006\u0003!-\u00014\u0002)\u0004\u0001u=A\u0001\u0001E\u0010\u001b\r)\u0011\u0001c\u0007\u0019\u001cA\u001b\t!I\u0002\u0006\u0003!u\u0001TD)\u0004\u000f\u0011\u0005\u0012\"\u0001C\u0001\u001b\u0005A\u0019\"D\u0001\t\u001dUbQa\u0003\u0003d\u0002a)\u0011eA\u0003\u0002\u0011\rA2!U\u0002\u0004\t\u0015I\u0011\u0001\u0002\u0001"})
public final class CodeFenceProvider
implements MarkerBlockProvider<MarkerProcessor.StateInfo> {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    public static final Regex REGEX;
    public static final Companion Companion;

    static {
        $kotlinClass = Reflection.createKotlinClass(CodeFenceProvider.class);
        Companion companion = Companion = new Companion(null);
        REGEX = new Regex("^ {0,3}(~~~+|```+)([^`]*)$");
    }

    @Override
    @NotNull
    public List<MarkerBlock> createMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder, @NotNull MarkerProcessor.StateInfo stateInfo) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkParameterIsNotNull((Object)stateInfo, (String)"stateInfo");
        Pair<String, String> fenceAndInfo = this.getFenceStartAndInfo(pos, stateInfo.getCurrentConstraints());
        if (fenceAndInfo != null) {
            this.createNodesForFenceStart(pos, fenceAndInfo, productionHolder);
            return KotlinPackage.listOf((Object)new CodeFenceMarkerBlock(stateInfo.getCurrentConstraints(), productionHolder, (String)fenceAndInfo.getFirst()));
        }
        return KotlinPackage.emptyList();
    }

    @Override
    public boolean interruptsParagraph(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        return this.getFenceStartAndInfo(pos, constraints) != null;
    }

    private final void createNodesForFenceStart(LookaheadText.Position pos, Pair<? extends String, ? extends String> fenceAndInfo, ProductionHolder productionHolder) {
        int infoStartPosition = pos.getNextLineOrEofOffset() - ((String)fenceAndInfo.getSecond()).length();
        productionHolder.addProduction(KotlinPackage.listOf((Object)new SequentialParser.Node((Range<Integer>)((Range)new IntRange(pos.getOffset(), infoStartPosition)), MarkdownTokenTypes.Companion.getCODE_FENCE_START())));
        if (((String)fenceAndInfo.getSecond()).length() > 0) {
            productionHolder.addProduction(KotlinPackage.listOf((Object)new SequentialParser.Node((Range<Integer>)((Range)new IntRange(infoStartPosition, pos.getNextLineOrEofOffset())), MarkdownTokenTypes.Companion.getFENCE_LANG())));
        }
    }

    private final Pair<String, String> getFenceStartAndInfo(LookaheadText.Position pos, MarkdownConstraints constraints) {
        if (!MarkerBlockProvider.Companion.isStartOfLineWithConstraints(pos, constraints)) {
            return null;
        }
        MatchResult matchResult = Regex.match$default((Regex)Companion.getREGEX(), (CharSequence)pos.getCurrentLineFromPosition(), (int)0, (int)2);
        if (matchResult == null) {
            return null;
        }
        MatchResult matchResult2 = matchResult;
        MatchGroup matchGroup = matchResult2.getGroups().get(1);
        String string = matchGroup != null ? matchGroup.getValue() : null;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        MatchGroup matchGroup2 = matchResult2.getGroups().get(2);
        String string2 = matchGroup2 != null ? matchGroup2.getValue() : null;
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        return new Pair((Object)string, (Object)string2);
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"\u0004\u0004)I1i\\7qC:LwN\u001c\u0006\u0012\u0007>$WMR3oG\u0016\u0004&o\u001c<jI\u0016\u0014(bA8sO*A\u0011N\u001c;fY2L'N\u0003\u0005nCJ\\Gm\\<o\u0015\u0019\u0001\u0018M]:fe*aQ.\u0019:lKJ\u0014Gn\\2lg*I\u0001O]8wS\u0012,'o\u001d\u0006\u0004\u0003:L(BB6pi2LgNC\u0003S\u000b\u001e+\u0005LC\u0003SK\u001e,\u0007P\u0003\u0003uKb$(\u0002C4fiJ+u)\u0012-S\u0015\t\u0001\"A\u0003\u0003\t\u0001A\u0019!\u0002\u0002\u0005\u0002!\u0011QA\u0001\u0003\u0002\u0011\u000b)!\u0001b\u0001\t\u0007\u0015\u0011AA\u0001E\u0004\u000b\r!)\u0001#\u0001\r\u0001\u0015\u0019Aa\u0001\u0005\u0001\u0019\u0001)\u0011\u0001#\u0003\u0006\u0007\u0011!\u0001\u0002\u0002\u0007\u0001\u000b\t!A\u0001\u0003\u0004\u0006\u0007\u0011)\u00012\u0002\u0007\u0001\u000b\t!Q\u0001c\u0003\u0005\u0007\ba9!G\u0002\u0006\u0003!%\u0001\u0014B\u0017\u0012\t\r$\u0001$B\u0011\u0004\u000b\u0005AY\u0001g\u0003V\u0007%)A\u0001B\u0003\n\u0003!1A\u0012A\u0007\u0004\t\u001bI\u0011\u0001\u0003\u00046\u0001\u0001"})
    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        @NotNull
        public final Regex getREGEX() {
            return REGEX;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

