/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="JavaProjectCodeInsightSettings", storages={@Storage(file="$PROJECT_FILE$"), @Storage(file="$PROJECT_CONFIG_DIR$/codeInsightSettings.xml", scheme=StorageScheme.DIRECTORY_BASED)})
public class JavaProjectCodeInsightSettings
implements PersistentStateComponent<JavaProjectCodeInsightSettings> {
    @Tag(value="excluded-names")
    @AbstractCollection(surroundWithTag=false, elementTag="name", elementValueAttribute="")
    public List<String> excludedNames = ContainerUtil.newArrayList();

    public static JavaProjectCodeInsightSettings getSettings(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/JavaProjectCodeInsightSettings", "getSettings"));
        }
        return (JavaProjectCodeInsightSettings)ServiceManager.getService((Project)project, JavaProjectCodeInsightSettings.class);
    }

    public boolean isExcluded(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/JavaProjectCodeInsightSettings", "isExcluded"));
        }
        for (String excluded : this.excludedNames) {
            if (!JavaProjectCodeInsightSettings.nameMatches(name, excluded)) continue;
            return true;
        }
        for (String excluded : CodeInsightSettings.getInstance().EXCLUDED_PACKAGES) {
            if (!JavaProjectCodeInsightSettings.nameMatches(name, excluded)) continue;
            return true;
        }
        return false;
    }

    private static boolean nameMatches(@NotNull String name, String excluded) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/JavaProjectCodeInsightSettings", "nameMatches"));
        }
        return name.equals(excluded) || name.startsWith(excluded + ".");
    }

    @Nullable
    public JavaProjectCodeInsightSettings getState() {
        return this;
    }

    public void loadState(JavaProjectCodeInsightSettings state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }
}

