/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CollectConversion;
import com.intellij.codeInsight.completion.CompletionBundle;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.ConstructorInsertHandler;
import com.intellij.codeInsight.completion.FunctionalExpressionCompletionProvider;
import com.intellij.codeInsight.completion.InheritorsHolder;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaClassNameCompletionContributor;
import com.intellij.codeInsight.completion.JavaClassNameInsertHandler;
import com.intellij.codeInsight.completion.JavaCompletionSorting;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaGenerateMemberCompletionContributor;
import com.intellij.codeInsight.completion.JavaInheritorsGetter;
import com.intellij.codeInsight.completion.JavaKeywordCompletion;
import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.JavaStaticMemberProcessor;
import com.intellij.codeInsight.completion.LabelReferenceCompletion;
import com.intellij.codeInsight.completion.LegacyCompletionContributor;
import com.intellij.codeInsight.completion.MethodReturnTypeProvider;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.SameSignatureCallParametersProvider;
import com.intellij.codeInsight.completion.SmartCastProvider;
import com.intellij.codeInsight.completion.SmartCompletionDecorator;
import com.intellij.codeInsight.completion.TypeArgumentCompletionProvider;
import com.intellij.codeInsight.completion.WordCompletionContributor;
import com.intellij.codeInsight.completion.scope.JavaCompletionProcessor;
import com.intellij.codeInsight.daemon.impl.quickfix.ImportClassFix;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.LookupItemUtil;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.LangBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiNameValuePairPattern;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ClassFilter;
import com.intellij.psi.filters.ElementExtractorFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.NotFilter;
import com.intellij.psi.filters.OrFilter;
import com.intellij.psi.filters.TrueFilter;
import com.intellij.psi.filters.classes.AnnotationTypeFilter;
import com.intellij.psi.filters.classes.AssignableFromContextFilter;
import com.intellij.psi.filters.element.ExcludeDeclaredFilter;
import com.intellij.psi.filters.element.ModifierFilter;
import com.intellij.psi.filters.getters.ExpectedTypesGetter;
import com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.source.PsiLabelReference;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.scope.ElementClassFilter;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Consumer;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCompletionContributor
extends CompletionContributor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.JavaCompletionContributor");
    public static final ElementPattern<PsiElement> ANNOTATION_NAME = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParents(new Class[]{PsiJavaCodeReferenceElement.class, PsiAnnotation.class})).afterLeaf(new String[]{"@"});
    private static final PsiJavaElementPattern.Capture<PsiElement> UNEXPECTED_REFERENCE_AFTER_DOT = (PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"."})).insideStarting((ElementPattern)PsiJavaPatterns.psiExpressionStatement());
    private static final PsiNameValuePairPattern NAME_VALUE_PAIR = (PsiNameValuePairPattern)PsiJavaPatterns.psiNameValuePair().withSuperParent(2, (ElementPattern)PsiJavaPatterns.psiElement(PsiAnnotation.class));
    private static final ElementPattern<PsiElement> ANNOTATION_ATTRIBUTE_NAME = PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement(PsiIdentifier.class).withParent((ElementPattern)NAME_VALUE_PAIR), ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"("})).withParent((ElementPattern)PsiJavaPatterns.psiReferenceExpression().withParent((ElementPattern)NAME_VALUE_PAIR))});
    private static final ElementPattern SWITCH_LABEL = PsiJavaPatterns.psiElement().withSuperParent(2, (ElementPattern)PsiJavaPatterns.psiElement(PsiSwitchLabelStatement.class).withSuperParent(2, (ElementPattern)PsiJavaPatterns.psiElement(PsiSwitchStatement.class).with((PatternCondition)new PatternCondition<PsiSwitchStatement>("enumExpressionType"){

        public boolean accepts(@NotNull PsiSwitchStatement psiSwitchStatement, ProcessingContext context) {
            if (psiSwitchStatement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiSwitchStatement", "com/intellij/codeInsight/completion/JavaCompletionContributor$1", "accepts"));
            }
            PsiExpression expression = psiSwitchStatement.getExpression();
            if (expression == null) {
                return false;
            }
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)expression.getType());
            return aClass != null && aClass.isEnum();
        }
    })));
    private static final ElementPattern<PsiElement> AFTER_NUMBER_LITERAL = PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)PsiJavaPatterns.psiElement().withElementType((ElementPattern)PsiJavaPatterns.elementType().oneOf((Object[])new IElementType[]{JavaTokenType.DOUBLE_LITERAL, JavaTokenType.LONG_LITERAL, JavaTokenType.FLOAT_LITERAL, JavaTokenType.INTEGER_LITERAL})));
    private static final ElementPattern<PsiElement> IMPORT_REFERENCE = PsiJavaPatterns.psiElement().withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiJavaCodeReferenceElement.class).withParent(PsiImportStatementBase.class));

    @Nullable
    public static ElementFilter getReferenceFilter(PsiElement position) {
        PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)position, PsiClass.class, (boolean)false, (Class[])new Class[]{PsiCodeBlock.class, PsiMethod.class, PsiExpressionList.class, PsiVariable.class, PsiAnnotation.class});
        if (containingClass != null && ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"extends", "implements", ",", "&"})).accepts((Object)position)) {
            return new AndFilter((ElementFilter)ElementClassFilter.CLASS, (ElementFilter)new NotFilter(new AssignableFromContextFilter()));
        }
        if (ANNOTATION_NAME.accepts((Object)position)) {
            return new AnnotationTypeFilter();
        }
        if (((ElementPattern)JavaKeywordCompletion.DECLARATION_START.getValue()).accepts((Object)position) || JavaKeywordCompletion.isInsideParameterList(position) || JavaCompletionContributor.isInsideAnnotationName(position)) {
            return new OrFilter(ElementClassFilter.CLASS, ElementClassFilter.PACKAGE_FILTER);
        }
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"instanceof"})).accepts((Object)position)) {
            return new ElementExtractorFilter(ElementClassFilter.CLASS);
        }
        if (JavaKeywordCompletion.VARIABLE_AFTER_FINAL.accepts((Object)position)) {
            return ElementClassFilter.CLASS;
        }
        if (JavaCompletionContributor.isCatchFinallyPosition(position) || JavaKeywordCompletion.START_SWITCH.accepts((Object)position) || JavaKeywordCompletion.isInstanceofPlace(position) || JavaKeywordCompletion.isAfterPrimitiveOrArrayType(position)) {
            return null;
        }
        if (JavaKeywordCompletion.START_FOR.accepts((Object)position)) {
            return new OrFilter(ElementClassFilter.CLASS, ElementClassFilter.VARIABLE);
        }
        if (JavaSmartCompletionContributor.AFTER_NEW.accepts((Object)position)) {
            return ElementClassFilter.CLASS;
        }
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside(PsiReferenceParameterList.class)).accepts((Object)position)) {
            return ElementClassFilter.CLASS;
        }
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside(PsiAnnotationParameterList.class)).accepts((Object)position)) {
            return JavaCompletionContributor.createAnnotationFilter(position);
        }
        PsiVariable var = (PsiVariable)PsiTreeUtil.getParentOfType((PsiElement)position, PsiVariable.class, (boolean)false, (Class[])new Class[]{PsiClass.class});
        if (var != null && PsiTreeUtil.isAncestor((PsiElement)var.getInitializer(), (PsiElement)position, (boolean)false)) {
            return new ExcludeDeclaredFilter(new ClassFilter(PsiVariable.class));
        }
        if (SWITCH_LABEL.accepts((Object)position)) {
            return new ClassFilter(PsiField.class){

                @Override
                public boolean isAcceptable(Object element, PsiElement context) {
                    return element instanceof PsiEnumConstant;
                }
            };
        }
        return TrueFilter.INSTANCE;
    }

    private static boolean isCatchFinallyPosition(PsiElement position) {
        PsiElement leaf = PsiTreeUtil.prevVisibleLeaf((PsiElement)position);
        return leaf != null && leaf.textMatches((CharSequence)"}") && leaf.getParent() instanceof PsiCodeBlock && leaf.getParent().getParent() instanceof PsiTryStatement && ((PsiTryStatement)leaf.getParent().getParent()).getResourceList() == null;
    }

    private static boolean isInsideAnnotationName(PsiElement position) {
        PsiAnnotation anno = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)position, PsiAnnotation.class, (boolean)true, (Class[])new Class[]{PsiMember.class});
        return anno != null && PsiTreeUtil.isAncestor((PsiElement)anno.getNameReferenceElement(), (PsiElement)position, (boolean)true);
    }

    private static ElementFilter createAnnotationFilter(PsiElement position) {
        OrFilter orFilter = new OrFilter(ElementClassFilter.CLASS, ElementClassFilter.PACKAGE_FILTER, new AndFilter((ElementFilter)new ClassFilter(PsiField.class), (ElementFilter)new ModifierFilter("static", "final")));
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().insideStarting((ElementPattern)PsiJavaPatterns.psiNameValuePair())).accepts((Object)position)) {
            orFilter.addFilter(new ClassFilter(PsiAnnotationMethod.class){

                @Override
                public boolean isAcceptable(Object element, PsiElement context) {
                    return element instanceof PsiAnnotationMethod && PsiUtil.isAnnotationMethod((PsiElement)((PsiElement)element));
                }
            });
        }
        return orFilter;
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet _result) {
        PsiReference reference;
        PsiElement parent;
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/JavaCompletionContributor", "fillCompletionVariants"));
        }
        if (_result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_result", "com/intellij/codeInsight/completion/JavaCompletionContributor", "fillCompletionVariants"));
        }
        if (parameters.getCompletionType() != CompletionType.BASIC) {
            return;
        }
        PsiElement position = parameters.getPosition();
        if (!JavaCompletionContributor.isInJavaContext(position)) {
            return;
        }
        if (AFTER_NUMBER_LITERAL.accepts((Object)position) || UNEXPECTED_REFERENCE_AFTER_DOT.accepts((Object)position)) {
            _result.stopHere();
            return;
        }
        final CompletionResultSet result = JavaCompletionSorting.addJavaSorting(parameters, _result);
        if (ANNOTATION_ATTRIBUTE_NAME.accepts((Object)position) && !JavaKeywordCompletion.isAfterPrimitiveOrArrayType(position)) {
            JavaKeywordCompletion.addExpectedTypeMembers(parameters, result);
            JavaCompletionContributor.completeAnnotationAttributeName(result, position, parameters);
            result.stopHere();
            return;
        }
        final InheritorsHolder inheritors = new InheritorsHolder(result);
        if (TypeArgumentCompletionProvider.IN_TYPE_ARGS.accepts((Object)position)) {
            new TypeArgumentCompletionProvider(false, inheritors).addCompletions(parameters, new ProcessingContext(), result);
        }
        result.addAllElements(FunctionalExpressionCompletionProvider.getLambdaVariants(parameters, true));
        PrefixMatcher matcher = result.getPrefixMatcher();
        if (JavaSmartCompletionContributor.AFTER_NEW.accepts((Object)position)) {
            new JavaInheritorsGetter(ConstructorInsertHandler.BASIC_INSTANCE).generateVariants(parameters, matcher, inheritors);
        }
        if (MethodReturnTypeProvider.IN_METHOD_RETURN_TYPE.accepts((Object)position)) {
            MethodReturnTypeProvider.addProbableReturnTypes(parameters, new Consumer<LookupElement>(){

                public void consume(LookupElement element) {
                    JavaCompletionContributor.registerClassFromTypeElement(element, inheritors);
                    result.addElement(element);
                }
            });
        }
        if (SmartCastProvider.shouldSuggestCast(parameters)) {
            SmartCastProvider.addCastVariants(parameters, new Consumer<LookupElement>(){

                public void consume(LookupElement element) {
                    JavaCompletionContributor.registerClassFromTypeElement(element, inheritors);
                    result.addElement(PrioritizedLookupElement.withPriority((LookupElement)element, (double)1.0));
                }
            });
        }
        if ((parent = position.getParent()) instanceof PsiReferenceExpression) {
            List<ExpectedTypeInfo> expected = Arrays.asList(ExpectedTypesProvider.getExpectedTypes((PsiExpression)parent, true));
            CollectConversion.addCollectConversion((PsiReferenceExpression)parent, expected, JavaSmartCompletionContributor.decorateWithoutTypeCheck(result, expected));
        }
        if (IMPORT_REFERENCE.accepts((Object)position)) {
            result.addElement((LookupElement)LookupElementBuilder.create((String)"*"));
        }
        JavaCompletionContributor.addKeywords(parameters, result);
        JavaCompletionContributor.addExpressionVariants(parameters, position, result);
        Set<String> usedWords = JavaCompletionContributor.addReferenceVariants(parameters, result, inheritors);
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside(PsiLiteralExpression.class)).accepts((Object)position) && ((reference = position.getContainingFile().findReferenceAt(parameters.getOffset())) == null || reference.isSoft())) {
            WordCompletionContributor.addWordCompletionVariants(result, parameters, usedWords);
        }
        JavaGenerateMemberCompletionContributor.fillCompletionVariants(parameters, result);
        JavaCompletionContributor.addAllClasses(parameters, result, inheritors);
        if (parent instanceof PsiReferenceExpression && !((PsiReferenceExpression)parent).isQualified() && parameters.isExtendedCompletion() && StringUtil.isNotEmpty((String)matcher.getPrefix())) {
            new JavaStaticMemberProcessor(parameters).processStaticMethodsGlobally(matcher, (Consumer<LookupElement>)result);
        }
        result.stopHere();
    }

    private static void registerClassFromTypeElement(LookupElement element, InheritorsHolder inheritors) {
        PsiClass aClass;
        PsiType type = ((PsiTypeLookupItem)ObjectUtils.assertNotNull((Object)element.as(PsiTypeLookupItem.CLASS_CONDITION_KEY))).getType();
        PsiClass psiClass = aClass = type instanceof PsiClassType && ((PsiClassType)type).getParameterCount() == 0 ? ((PsiClassType)type).resolve() : null;
        if (aClass != null) {
            inheritors.registerClass(aClass);
        }
    }

    private static void addExpressionVariants(@NotNull CompletionParameters parameters, PsiElement position, CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/JavaCompletionContributor", "addExpressionVariants"));
        }
        if (JavaSmartCompletionContributor.INSIDE_EXPRESSION.accepts((Object)position) && !JavaKeywordCompletion.AFTER_DOT.accepts((Object)position) && !SmartCastProvider.shouldSuggestCast(parameters)) {
            JavaKeywordCompletion.addExpectedTypeMembers(parameters, result);
            if (SameSignatureCallParametersProvider.IN_CALL_ARGUMENT.accepts((Object)position)) {
                new SameSignatureCallParametersProvider().addCompletions(parameters, new ProcessingContext(), result);
            }
        }
    }

    public static boolean isInJavaContext(PsiElement position) {
        return PsiUtilCore.findLanguageFromElement((PsiElement)position).isKindOf((Language)JavaLanguage.INSTANCE);
    }

    public static void addAllClasses(final CompletionParameters parameters, final CompletionResultSet result, final InheritorsHolder inheritors) {
        if (!JavaCompletionContributor.isClassNamePossible(parameters) || !JavaCompletionContributor.mayStartClassName(result)) {
            return;
        }
        if (parameters.getInvocationCount() >= 2) {
            JavaClassNameCompletionContributor.addAllClasses(parameters, parameters.getInvocationCount() <= 2, result.getPrefixMatcher(), new Consumer<LookupElement>(){

                public void consume(LookupElement element) {
                    if (!inheritors.alreadyProcessed(element)) {
                        result.addElement(JavaClassNameCompletionContributor.highlightIfNeeded((JavaPsiClassReferenceElement)element, parameters));
                    }
                }
            });
        } else {
            JavaCompletionContributor.advertiseSecondCompletion(parameters.getPosition().getProject(), result);
        }
    }

    public static void advertiseSecondCompletion(Project project, CompletionResultSet result) {
        if (FeatureUsageTracker.getInstance().isToBeAdvertisedInLookup("editing.completion.second.basic", project)) {
            result.addLookupAdvertisement("Press " + JavaCompletionContributor.getActionShortcut((String)"CodeCompletion") + " to see non-imported classes");
        }
    }

    private static Set<String> addReferenceVariants(final CompletionParameters parameters, CompletionResultSet result, final InheritorsHolder inheritors) {
        final HashSet<String> usedWords = new HashSet<String>();
        final PsiElement position = parameters.getPosition();
        final boolean first = parameters.getInvocationCount() <= 1;
        final boolean isSwitchLabel = SWITCH_LABEL.accepts((Object)position);
        final boolean isAfterNew = JavaClassNameCompletionContributor.AFTER_NEW.accepts((Object)position);
        final boolean pkgContext = JavaCompletionUtil.inSomePackage(position);
        final PsiType[] expectedTypes = ExpectedTypesGetter.getExpectedTypes(parameters.getPosition(), true);
        LegacyCompletionContributor.processReferences(parameters, result, new PairConsumer<PsiReference, CompletionResultSet>(){

            public void consume(PsiReference reference, CompletionResultSet result) {
                if (reference instanceof PsiJavaReference) {
                    ElementFilter filter = JavaCompletionContributor.getReferenceFilter(position);
                    if (filter != null) {
                        PsiFile originalFile = parameters.getOriginalFile();
                        JavaCompletionProcessor.Options options = JavaCompletionProcessor.Options.DEFAULT_OPTIONS.withCheckAccess(first).withFilterStaticAfterInstance(first).withShowInstanceInStaticContext(!first);
                        for (LookupElement element : JavaCompletionUtil.processJavaReference(position, (PsiJavaReference)reference, new ElementExtractorFilter(filter), options, result.getPrefixMatcher(), parameters)) {
                            JavaMethodCallElement call;
                            PsiMethod method;
                            if (inheritors.alreadyProcessed(element)) continue;
                            if (isSwitchLabel) {
                                result.addElement((LookupElement)new IndentingDecorator((LookupElement)TailTypeDecorator.withTail(element, TailType.createSimpleTailType((char)':'))));
                                continue;
                            }
                            LookupItem item = (LookupItem)element.as(LookupItem.CLASS_CONDITION_KEY);
                            if (originalFile instanceof PsiJavaCodeReferenceCodeFragment && !((PsiJavaCodeReferenceCodeFragment)originalFile).isClassesAccepted() && item != null) {
                                item.setTailType(TailType.NONE);
                            }
                            if (item instanceof JavaMethodCallElement && (method = (PsiMethod)(call = (JavaMethodCallElement)item).getObject()).getTypeParameters().length > 0) {
                                PsiType matchingExpectation;
                                final PsiType returned = TypeConversionUtil.erasure((PsiType)method.getReturnType());
                                PsiType psiType = matchingExpectation = returned == null ? null : (PsiType)ContainerUtil.find((Object[])expectedTypes, (Condition)new Condition<PsiType>(){

                                    public boolean value(PsiType type) {
                                        return type.isAssignableFrom(returned);
                                    }
                                });
                                if (matchingExpectation != null && SmartCompletionDecorator.hasUnboundTypeParams(method, matchingExpectation)) {
                                    call.setInferenceSubstitutor(SmartCompletionDecorator.calculateMethodReturnTypeSubstitutor(method, matchingExpectation), position);
                                }
                            }
                            result.addElement(element);
                        }
                    }
                    return;
                }
                if (reference instanceof PsiLabelReference) {
                    LabelReferenceCompletion.processLabelReference(result, (PsiLabelReference)reference);
                    return;
                }
                Object[] variants = reference.getVariants();
                if (variants == null) {
                    LOG.error("Reference=" + reference);
                }
                for (Object completion : variants) {
                    if (completion == null) {
                        LOG.error("Position=" + position + "\n;Reference=" + reference + "\n;variants=" + Arrays.toString(variants));
                    }
                    if (completion instanceof LookupElement && !inheritors.alreadyProcessed((LookupElement)completion)) {
                        usedWords.add(((LookupElement)completion).getLookupString());
                        result.addElement((LookupElement)completion);
                        continue;
                    }
                    if (completion instanceof PsiClass) {
                        for (JavaPsiClassReferenceElement item : JavaClassNameCompletionContributor.createClassLookupItems((PsiClass)completion, isAfterNew, JavaClassNameInsertHandler.JAVA_CLASS_INSERT_HANDLER, new Condition<PsiClass>(){

                            public boolean value(PsiClass psiClass) {
                                return !inheritors.alreadyProcessed(psiClass) && JavaCompletionUtil.isSourceLevelAccessible(position, psiClass, pkgContext);
                            }
                        })) {
                            usedWords.add(item.getLookupString());
                            result.addElement((LookupElement)item);
                        }
                        continue;
                    }
                    LookupElement element = LookupItemUtil.objectToLookupItem(completion);
                    usedWords.add(element.getLookupString());
                    result.addElement(element);
                }
            }
        });
        return usedWords;
    }

    private static void addKeywords(CompletionParameters parameters, final CompletionResultSet result) {
        Consumer<LookupElement> noMiddleMatches = new Consumer<LookupElement>(){

            public void consume(LookupElement element) {
                if (element.getLookupString().startsWith(result.getPrefixMatcher().getPrefix())) {
                    result.addElement(element);
                }
            }
        };
        JavaKeywordCompletion.addKeywords(parameters, noMiddleMatches);
    }

    static boolean isClassNamePossible(CompletionParameters parameters) {
        boolean isSecondCompletion = parameters.getInvocationCount() >= 2;
        PsiElement position = parameters.getPosition();
        if (JavaKeywordCompletion.isInstanceofPlace(position)) {
            return false;
        }
        PsiElement parent = position.getParent();
        if (!(parent instanceof PsiJavaCodeReferenceElement)) {
            return isSecondCompletion;
        }
        if (((PsiJavaCodeReferenceElement)parent).getQualifier() != null) {
            return isSecondCompletion;
        }
        if (parent instanceof PsiJavaCodeReferenceElementImpl && ((PsiJavaCodeReferenceElementImpl)parent).getKind(parent.getContainingFile()) == 2) {
            return false;
        }
        PsiElement grand = parent.getParent();
        if (grand instanceof PsiSwitchLabelStatement) {
            return false;
        }
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside(PsiImportStatement.class)).accepts((Object)parent)) {
            return isSecondCompletion;
        }
        if (grand instanceof PsiAnonymousClass) {
            grand = grand.getParent();
        }
        if (grand instanceof PsiNewExpression && ((PsiNewExpression)grand).getQualifier() != null) {
            return false;
        }
        return !JavaKeywordCompletion.isAfterPrimitiveOrArrayType(position);
    }

    public static boolean mayStartClassName(CompletionResultSet result) {
        return StringUtil.isNotEmpty((String)result.getPrefixMatcher().getPrefix());
    }

    private static void completeAnnotationAttributeName(CompletionResultSet result, PsiElement insertedElement, CompletionParameters parameters) {
        PsiElement element;
        PsiNameValuePair pair = (PsiNameValuePair)PsiTreeUtil.getParentOfType((PsiElement)insertedElement, PsiNameValuePair.class);
        PsiAnnotationParameterList parameterList = (PsiAnnotationParameterList)((PsiNameValuePair)ObjectUtils.assertNotNull((Object)pair)).getParent();
        PsiAnnotation anno = (PsiAnnotation)parameterList.getParent();
        boolean showClasses = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"("})).accepts((Object)insertedElement);
        PsiClass annoClass = null;
        PsiJavaCodeReferenceElement referenceElement = anno.getNameReferenceElement();
        if (referenceElement != null && (element = referenceElement.resolve()) instanceof PsiClass && (annoClass = (PsiClass)element).findMethodsByName("value", false).length == 0) {
            showClasses = false;
        }
        if (showClasses && insertedElement.getParent() instanceof PsiReferenceExpression) {
            Set<LookupElement> set = JavaCompletionUtil.processJavaReference(insertedElement, (PsiJavaReference)insertedElement.getParent(), new ElementExtractorFilter(JavaCompletionContributor.createAnnotationFilter(insertedElement)), JavaCompletionProcessor.Options.DEFAULT_OPTIONS, result.getPrefixMatcher(), parameters);
            for (LookupElement element2 : set) {
                result.addElement(element2);
            }
            JavaCompletionContributor.addAllClasses(parameters, result, new InheritorsHolder(result));
        }
        if (annoClass != null) {
            PsiNameValuePair[] existingPairs = parameterList.getAttributes();
            block1: for (PsiMethod method : annoClass.getMethods()) {
                if (!(method instanceof PsiAnnotationMethod)) continue;
                String attrName = method.getName();
                for (PsiNameValuePair existingAttr : existingPairs) {
                    if (PsiTreeUtil.isAncestor((PsiElement)existingAttr, (PsiElement)insertedElement, (boolean)false)) break;
                    if (Comparing.equal((String)existingAttr.getName(), (String)attrName) || "value".equals(attrName) && existingAttr.getName() == null) continue block1;
                }
                LookupElementBuilder element3 = LookupElementBuilder.createWithIcon((PsiNamedElement)method).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                    public void handleInsert(InsertionContext context, LookupElement item) {
                        Editor editor = context.getEditor();
                        TailType.EQ.processTail(editor, editor.getCaretModel().getOffset());
                        context.setAddCompletionChar(false);
                        context.commitDocument();
                        PsiAnnotationParameterList paramList = (PsiAnnotationParameterList)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset(), PsiAnnotationParameterList.class, (boolean)false);
                        if (paramList != null && paramList.getAttributes().length > 0 && paramList.getAttributes()[0].getName() == null) {
                            int valueOffset = paramList.getAttributes()[0].getTextRange().getStartOffset();
                            context.getDocument().insertString(valueOffset, (CharSequence)"value");
                            TailType.EQ.processTail(editor, valueOffset + "value".length());
                        }
                    }
                });
                PsiAnnotationMemberValue defaultValue = ((PsiAnnotationMethod)method).getDefaultValue();
                if (defaultValue != null) {
                    element3 = element3.withTailText(" default " + defaultValue.getText(), true);
                }
                result.addElement((LookupElement)element3);
            }
        }
    }

    public String advertise(@NotNull CompletionParameters parameters) {
        PsiType[] psiTypes;
        String shortcut;
        String shortcut2;
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/JavaCompletionContributor", "advertise"));
        }
        if (!(parameters.getOriginalFile() instanceof PsiJavaFile)) {
            return null;
        }
        if (parameters.getCompletionType() == CompletionType.BASIC && parameters.getInvocationCount() > 0) {
            PsiElement position = parameters.getPosition();
            if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParent((ElementPattern)PsiJavaPatterns.psiReferenceExpression().withFirstChild((ElementPattern)PsiJavaPatterns.psiReferenceExpression().referencing((ElementPattern)PsiJavaPatterns.psiClass())))).accepts((Object)position) && CompletionUtil.shouldShowFeature(parameters, "editing.completion.global.member.name") && StringUtil.isNotEmpty((String)(shortcut2 = JavaCompletionContributor.getActionShortcut((String)"CodeCompletion")))) {
                return "Pressing " + shortcut2 + " twice without a class qualifier would show all accessible static methods";
            }
        }
        if (parameters.getCompletionType() != CompletionType.SMART && JavaCompletionContributor.shouldSuggestSmartCompletion(parameters.getPosition()) && CompletionUtil.shouldShowFeature(parameters, "editing.completion.smarttype.general") && StringUtil.isNotEmpty((String)(shortcut = JavaCompletionContributor.getActionShortcut((String)"SmartTypeCompletion")))) {
            return CompletionBundle.message("completion.smart.hint", shortcut);
        }
        if (parameters.getCompletionType() == CompletionType.SMART && parameters.getInvocationCount() == 1 && (psiTypes = ExpectedTypesGetter.getExpectedTypes(parameters.getPosition(), true)).length > 0) {
            if (CompletionUtil.shouldShowFeature(parameters, "editing.completion.second.smarttype.toar") && StringUtil.isNotEmpty((String)(shortcut2 = JavaCompletionContributor.getActionShortcut((String)"SmartTypeCompletion")))) {
                for (PsiType psiType : psiTypes) {
                    PsiType type = PsiUtil.extractIterableTypeParameter((PsiType)psiType, (boolean)false);
                    if (type == null) continue;
                    return CompletionBundle.message("completion.smart.aslist.hint", shortcut2, type.getPresentableText());
                }
            }
            if (CompletionUtil.shouldShowFeature(parameters, "editing.completion.second.smarttype.aslist") && StringUtil.isNotEmpty((String)(shortcut2 = JavaCompletionContributor.getActionShortcut((String)"SmartTypeCompletion")))) {
                for (PsiType psiType : psiTypes) {
                    PsiType componentType;
                    if (!(psiType instanceof PsiArrayType) || (componentType = ((PsiArrayType)psiType).getComponentType()) instanceof PsiPrimitiveType) continue;
                    return CompletionBundle.message("completion.smart.toar.hint", shortcut2, componentType.getPresentableText());
                }
            }
            if (CompletionUtil.shouldShowFeature(parameters, "editing.completion.second.smarttype.chain") && StringUtil.isNotEmpty((String)(shortcut2 = JavaCompletionContributor.getActionShortcut((String)"SmartTypeCompletion")))) {
                return CompletionBundle.message("completion.smart.chain.hint", shortcut2);
            }
        }
        return null;
    }

    public String handleEmptyLookup(@NotNull CompletionParameters parameters, Editor editor) {
        String suffix;
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/JavaCompletionContributor", "handleEmptyLookup"));
        }
        if (!(parameters.getOriginalFile() instanceof PsiJavaFile)) {
            return null;
        }
        String ad = this.advertise(parameters);
        String string = suffix = ad == null ? "" : "; " + StringUtil.decapitalize((String)ad);
        if (parameters.getCompletionType() == CompletionType.SMART) {
            PsiInstanceOfExpression instanceOfExpression;
            PsiExpression expression = (PsiExpression)PsiTreeUtil.getContextOfType((PsiElement)parameters.getPosition(), PsiExpression.class, (boolean)true);
            if (expression instanceof PsiLiteralExpression) {
                return LangBundle.message("completion.no.suggestions", new Object[0]) + suffix;
            }
            if (expression instanceof PsiInstanceOfExpression && PsiTreeUtil.isAncestor((PsiElement)(instanceOfExpression = (PsiInstanceOfExpression)expression).getCheckType(), (PsiElement)parameters.getPosition(), (boolean)false)) {
                return LangBundle.message("completion.no.suggestions", new Object[0]) + suffix;
            }
            Set<PsiType> expectedTypes = JavaCompletionUtil.getExpectedTypes(parameters);
            if (expectedTypes != null) {
                PsiType type;
                PsiType psiType = type = expectedTypes.size() == 1 ? expectedTypes.iterator().next() : null;
                if (type != null) {
                    PsiType deepComponentType = type.getDeepComponentType();
                    if (deepComponentType instanceof PsiClassType) {
                        if (((PsiClassType)deepComponentType).resolve() != null) {
                            return CompletionBundle.message("completion.no.suggestions.of.type", type.getPresentableText()) + suffix;
                        }
                        return CompletionBundle.message("completion.unknown.type", type.getPresentableText()) + suffix;
                    }
                    if (!PsiType.NULL.equals((Object)type)) {
                        return CompletionBundle.message("completion.no.suggestions.of.type", type.getPresentableText()) + suffix;
                    }
                }
            }
        }
        return LangBundle.message("completion.no.suggestions", new Object[0]) + suffix;
    }

    public boolean invokeAutoPopup(@NotNull PsiElement position, char typeChar) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/codeInsight/completion/JavaCompletionContributor", "invokeAutoPopup"));
        }
        return typeChar == ':' && JavaTokenType.COLON == position.getNode().getElementType();
    }

    private static boolean shouldSuggestSmartCompletion(PsiElement element) {
        if (JavaCompletionContributor.shouldSuggestClassNameCompletion(element)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiReferenceExpression && ((PsiReferenceExpression)parent).getQualifier() != null) {
            return false;
        }
        if (parent instanceof PsiReferenceExpression && parent.getParent() instanceof PsiReferenceExpression) {
            return true;
        }
        return ExpectedTypesGetter.getExpectedTypes(element, false).length > 0;
    }

    private static boolean shouldSuggestClassNameCompletion(PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent == null) {
            return false;
        }
        return parent.getParent() instanceof PsiTypeElement || parent.getParent() instanceof PsiExpressionStatement || parent.getParent() instanceof PsiReferenceList;
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/completion/JavaCompletionContributor", "beforeCompletion"));
        }
        PsiFile file = context.getFile();
        if (file instanceof PsiJavaFile) {
            if (context.getInvocationCount() > 0) {
                PsiType type;
                PsiTypeElement typeElement;
                PsiVariable variable;
                JavaCompletionContributor.autoImport(file, context.getStartOffset() - 1, context.getEditor());
                PsiElement leaf = file.findElementAt(context.getStartOffset() - 1);
                if (leaf != null) {
                    leaf = PsiTreeUtil.prevVisibleLeaf((PsiElement)leaf);
                }
                if ((variable = (PsiVariable)PsiTreeUtil.getParentOfType((PsiElement)leaf, PsiVariable.class)) != null && (typeElement = variable.getTypeElement()) != null && (type = typeElement.getType()) instanceof PsiClassType && ((PsiClassType)type).resolve() == null) {
                    JavaCompletionContributor.autoImportReference(file, context.getEditor(), typeElement.getInnermostComponentReferenceElement());
                }
            }
            if (context.getCompletionType() == CompletionType.BASIC) {
                if (JavaCompletionContributor.semicolonNeeded(context.getEditor(), file, context.getStartOffset())) {
                    context.setDummyIdentifier("IntellijIdeaRulezzz ".trim() + ";");
                    return;
                }
                PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)context.getStartOffset(), PsiJavaCodeReferenceElement.class, (boolean)false);
                if (ref != null && !(ref instanceof PsiReferenceExpression)) {
                    PsiReferenceParameterList paramList;
                    if (JavaSmartCompletionContributor.AFTER_NEW.accepts((Object)ref) && (paramList = ref.getParameterList()) != null && paramList.getTextLength() > 0) {
                        context.getOffsetMap().addOffset(ConstructorInsertHandler.PARAM_LIST_START, paramList.getTextRange().getStartOffset());
                        context.getOffsetMap().addOffset(ConstructorInsertHandler.PARAM_LIST_END, paramList.getTextRange().getEndOffset());
                    }
                    return;
                }
                PsiElement element = file.findElementAt(context.getStartOffset());
                if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside(PsiAnnotation.class)).accepts((Object)element)) {
                    return;
                }
                context.setDummyIdentifier("IntellijIdeaRulezzz");
            }
        }
    }

    public static boolean semicolonNeeded(Editor editor, PsiFile file, int startOffset) {
        PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)startOffset, PsiJavaCodeReferenceElement.class, (boolean)false);
        if (ref != null && !(ref instanceof PsiReferenceExpression) && ref.getParent() instanceof PsiTypeElement) {
            return true;
        }
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(startOffset);
        if (iterator.atEnd()) {
            return false;
        }
        if (iterator.getTokenType() == JavaTokenType.IDENTIFIER) {
            iterator.advance();
        }
        while (!iterator.atEnd() && ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(iterator.getTokenType())) {
            iterator.advance();
        }
        if (!iterator.atEnd() && iterator.getTokenType() == JavaTokenType.LPARENTH) {
            return true;
        }
        if (!iterator.atEnd() && iterator.getTokenType() == JavaTokenType.COLON && null == PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)startOffset, PsiConditionalExpression.class, (boolean)false)) {
            return true;
        }
        while (!iterator.atEnd() && ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(iterator.getTokenType())) {
            iterator.advance();
        }
        if (iterator.atEnd() || iterator.getTokenType() != JavaTokenType.IDENTIFIER) {
            return false;
        }
        iterator.advance();
        while (!iterator.atEnd() && ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(iterator.getTokenType())) {
            iterator.advance();
        }
        if (iterator.atEnd()) {
            return false;
        }
        return iterator.getTokenType() == JavaTokenType.EQ;
    }

    private static void autoImport(@NotNull PsiFile file, int offset, @NotNull Editor editor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/completion/JavaCompletionContributor", "autoImport"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/completion/JavaCompletionContributor", "autoImport"));
        }
        CharSequence text = editor.getDocument().getCharsSequence();
        while (offset > 0 && Character.isJavaIdentifierPart(text.charAt(offset))) {
            --offset;
        }
        if (offset <= 0) {
            return;
        }
        while (offset > 0 && Character.isWhitespace(text.charAt(offset))) {
            --offset;
        }
        if (offset <= 0 || text.charAt(offset) != '.') {
            return;
        }
        --offset;
        while (offset > 0 && Character.isWhitespace(text.charAt(offset))) {
            --offset;
        }
        if (offset <= 0) {
            return;
        }
        JavaCompletionContributor.autoImportReference(file, editor, JavaCompletionContributor.extractReference(PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, PsiExpression.class, (boolean)false)));
    }

    private static void autoImportReference(@NotNull PsiFile file, @NotNull Editor editor, @Nullable PsiJavaCodeReferenceElement element) {
        PsiJavaCodeReferenceElement qualifier;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/completion/JavaCompletionContributor", "autoImportReference"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/completion/JavaCompletionContributor", "autoImportReference"));
        }
        if (element == null) {
            return;
        }
        while ((qualifier = JavaCompletionContributor.extractReference(element.getQualifier())) != null) {
            element = qualifier;
        }
        if (!(element.getParent() instanceof PsiMethodCallExpression) && element.multiResolve(true).length == 0) {
            new ImportClassFix(element).doFix(editor, false, false);
            PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(editor.getDocument());
        }
    }

    @Nullable
    private static PsiJavaCodeReferenceElement extractReference(@Nullable PsiElement expression) {
        if (expression instanceof PsiJavaCodeReferenceElement) {
            return (PsiJavaCodeReferenceElement)expression;
        }
        if (expression instanceof PsiMethodCallExpression) {
            return ((PsiMethodCallExpression)expression).getMethodExpression();
        }
        return null;
    }

    private static class IndentingDecorator
    extends LookupElementDecorator<LookupElement> {
        public IndentingDecorator(LookupElement delegate) {
            super(delegate);
        }

        public void handleInsert(InsertionContext context) {
            super.handleInsert(context);
            Project project = context.getProject();
            Document document = context.getDocument();
            int lineStartOffset = DocumentUtil.getLineStartOffset(context.getStartOffset(), document);
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            CodeStyleManager.getInstance((Project)project).adjustLineIndent(context.getFile(), lineStartOffset);
        }
    }
}

