/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.JavaProjectCodeInsightSettings;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.actions.AddImportAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.AddSingleMemberStaticImportAction;
import com.intellij.ide.util.MethodCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.util.proximity.PsiProximityComparator;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StaticImportMethodFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.StaticImportMethodFix");
    private final SmartPsiElementPointer<PsiMethodCallExpression> myMethodCall;
    private List<PsiMethod> candidates;

    public StaticImportMethodFix(@NotNull PsiMethodCallExpression methodCallExpression) {
        if (methodCallExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCallExpression", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMethodFix", "<init>"));
        }
        this.myMethodCall = SmartPointerManager.getInstance((Project)methodCallExpression.getProject()).createSmartPsiElementPointer((PsiElement)methodCallExpression);
    }

    @NotNull
    public String getText() {
        String text = QuickFixBundle.message("static.import.method.text", new Object[0]);
        text = this.candidates != null && this.candidates.size() == 1 ? text + " '" + PsiFormatUtil.formatMethod((PsiMethod)this.candidates.get(0), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)6145, (int)0) + "'" : text + "...";
        String string = text;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMethodFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMethodFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMethodFix", "isAvailable"));
        }
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file) && file instanceof PsiJavaFile && this.myMethodCall.getElement() != null && ((PsiMethodCallExpression)this.myMethodCall.getElement()).isValid() && ((PsiMethodCallExpression)this.myMethodCall.getElement()).getMethodExpression().getQualifierExpression() == null && file.getManager().isInProject((PsiElement)file) && !(this.candidates == null ? (this.candidates = this.getMethodsToImport()) : this.candidates).isEmpty();
    }

    private PsiType getExpectedType() {
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)this.myMethodCall.getElement();
        if (methodCall == null) {
            return null;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)methodCall.getParent());
        if (parent instanceof PsiVariable) {
            if (methodCall.equals(PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiVariable)parent).getInitializer()))) {
                return ((PsiVariable)parent).getType();
            }
        } else if (parent instanceof PsiAssignmentExpression) {
            if (methodCall.equals(PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiAssignmentExpression)parent).getRExpression()))) {
                return ((PsiAssignmentExpression)parent).getLExpression().getType();
            }
        } else if (parent instanceof PsiReturnStatement) {
            PsiElement psiElement = PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{PsiLambdaExpression.class, PsiMethod.class});
            if (psiElement instanceof PsiLambdaExpression) {
                return LambdaUtil.getFunctionalInterfaceReturnType((PsiType)((PsiLambdaExpression)psiElement).getFunctionalInterfaceType());
            }
            if (psiElement instanceof PsiMethod) {
                return ((PsiMethod)psiElement).getReturnType();
            }
        } else if (parent instanceof PsiExpressionList) {
            JavaResolveResult resolveResult;
            PsiElement psiElement;
            PsiElement pParent = parent.getParent();
            if (pParent instanceof PsiCallExpression && parent.equals(((PsiCallExpression)pParent).getArgumentList()) && (psiElement = (resolveResult = ((PsiCallExpression)pParent).resolveMethodGenerics()).getElement()) instanceof PsiMethod) {
                PsiMethod psiMethod = (PsiMethod)psiElement;
                PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
                int idx = ArrayUtilRt.find((Object[])((PsiExpressionList)parent).getExpressions(), (Object)PsiUtil.skipParenthesizedExprUp((PsiElement)methodCall));
                if (idx > -1 && parameters.length > 0) {
                    PsiParameter lastParameter;
                    PsiType parameterType = parameters[Math.min(idx, parameters.length - 1)].getType();
                    if (idx >= parameters.length - 1 && (lastParameter = parameters[parameters.length - 1]).isVarArgs()) {
                        parameterType = ((PsiEllipsisType)lastParameter.getType()).getComponentType();
                    }
                    return resolveResult.getSubstitutor().substitute(parameterType);
                }
                return null;
            }
        } else if (parent instanceof PsiLambdaExpression) {
            return LambdaUtil.getFunctionalInterfaceReturnType((PsiType)((PsiLambdaExpression)parent).getFunctionalInterfaceType());
        }
        return null;
    }

    @NotNull
    private List<PsiMethod> getMethodsToImport() {
        PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)this.myMethodCall.getProject());
        final PsiMethodCallExpression element = (PsiMethodCallExpression)this.myMethodCall.getElement();
        PsiReferenceExpression reference = element.getMethodExpression();
        final PsiExpressionList argumentList = element.getArgumentList();
        String name = reference.getReferenceName();
        final ArrayList<PsiMethod> list = new ArrayList<PsiMethod>();
        if (name == null) {
            ArrayList<PsiMethod> arrayList = list;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMethodFix", "getMethodsToImport"));
            }
            return arrayList;
        }
        GlobalSearchScope scope = element.getResolveScope();
        final HashMap possibleClasses = new HashMap();
        final PsiType expectedType = this.getExpectedType();
        final ArrayList applicableList = new ArrayList();
        final PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)element.getProject()).getResolveHelper();
        final LinkedHashMap deprecated = new LinkedHashMap();
        final LinkedHashMap suggestions = new LinkedHashMap();
        class RegisterMethodsProcessor {
            RegisterMethodsProcessor() {
            }

            private void registerMethod(PsiClass containingClass, PsiMethod method) {
                PsiSubstitutor substitutorForMethod;
                Boolean alreadyMentioned = (Boolean)possibleClasses.get(containingClass);
                if (alreadyMentioned == Boolean.TRUE) {
                    return;
                }
                if (alreadyMentioned == null) {
                    list.add(method);
                    possibleClasses.put(containingClass, false);
                }
                if (PsiUtil.isApplicable((PsiMethod)method, (PsiSubstitutor)(substitutorForMethod = resolveHelper.inferTypeArguments(method.getTypeParameters(), method.getParameterList().getParameters(), argumentList.getExpressions(), PsiSubstitutor.EMPTY, element.getParent(), (ParameterTypeInferencePolicy)DefaultParameterTypeInferencePolicy.INSTANCE)), (PsiExpressionList)argumentList)) {
                    PsiType returnType = substitutorForMethod.substitute(method.getReturnType());
                    if (expectedType == null || returnType == null || TypeConversionUtil.isAssignable((PsiType)expectedType, (PsiType)returnType)) {
                        applicableList.add(method);
                        possibleClasses.put(containingClass, true);
                    }
                }
            }
        }
        RegisterMethodsProcessor registrar = new RegisterMethodsProcessor();
        cache.processMethodsWithName(name, scope, (Processor)new Processor<PsiMethod>(){

            public boolean process(PsiMethod method) {
                ProgressManager.checkCanceled();
                if (JavaCompletionUtil.isInExcludedPackage((PsiMember)method, false) || !method.hasModifierProperty("static")) {
                    return true;
                }
                PsiFile file = method.getContainingFile();
                PsiClass containingClass = method.getContainingClass();
                if (file instanceof PsiJavaFile && !((PsiJavaFile)file).getPackageName().isEmpty() && PsiUtil.isAccessible((Project)file.getProject(), (PsiMember)method, (PsiElement)element, (PsiClass)containingClass)) {
                    if (this.isEffectivelyDeprecated(method)) {
                        deprecated.put(containingClass, method);
                        return this.processCondition();
                    }
                    suggestions.put(containingClass, method);
                }
                return this.processCondition();
            }

            private boolean isEffectivelyDeprecated(PsiMethod method) {
                if (method.isDeprecated()) {
                    return true;
                }
                for (PsiClass aClass = method.getContainingClass(); aClass != null; aClass = aClass.getContainingClass()) {
                    if (!aClass.isDeprecated()) continue;
                    return true;
                }
                return false;
            }

            private boolean processCondition() {
                return suggestions.size() + deprecated.size() < 50;
            }
        });
        for (Map.Entry methodEntry : suggestions.entrySet()) {
            registrar.registerMethod((PsiClass)methodEntry.getKey(), (PsiMethod)methodEntry.getValue());
        }
        for (Map.Entry deprecatedMethod : deprecated.entrySet()) {
            registrar.registerMethod((PsiClass)deprecatedMethod.getKey(), (PsiMethod)deprecatedMethod.getValue());
        }
        ArrayList<Object> result = applicableList.isEmpty() ? list : applicableList;
        for (int i = result.size() - 1; i >= 0; --i) {
            ProgressManager.checkCanceled();
            PsiMethod method = (PsiMethod)result.get(i);
            if (!StaticImportMethodFix.isExcluded((PsiMember)method)) continue;
            result.remove(i);
        }
        Collections.sort(result, new PsiProximityComparator((PsiElement)argumentList));
        ArrayList<Object> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMethodFix", "getMethodsToImport"));
        }
        return arrayList;
    }

    public static boolean isExcluded(PsiMember method) {
        String name = PsiUtil.getMemberQualifiedName((PsiMember)method);
        return name != null && JavaProjectCodeInsightSettings.getSettings(method.getProject()).isExcluded(name);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMethodFix", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        if (this.candidates.size() == 1) {
            PsiMethod toImport = this.candidates.get(0);
            this.doImport(toImport);
        } else {
            this.chooseAndImport(editor, project);
        }
    }

    private void doImport(final PsiMethod toImport) {
        CommandProcessor.getInstance().executeCommand(toImport.getProject(), new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            PsiMethodCallExpression element = (PsiMethodCallExpression)StaticImportMethodFix.this.myMethodCall.getElement();
                            if (element != null) {
                                AddSingleMemberStaticImportAction.bindAllClassRefs(element.getContainingFile(), (PsiElement)toImport, toImport.getName(), toImport.getContainingClass());
                            }
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                });
            }
        }, this.getText(), (Object)this);
    }

    private void chooseAndImport(Editor editor, final Project project) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.doImport(this.candidates.get(0));
            return;
        }
        BaseListPopupStep<PsiMethod> step = new BaseListPopupStep<PsiMethod>(QuickFixBundle.message("class.to.import.chooser.title", new Object[0]), this.candidates){

            public PopupStep onChosen(PsiMethod selectedValue, boolean finalChoice) {
                if (selectedValue == null) {
                    return FINAL_CHOICE;
                }
                if (finalChoice) {
                    PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                    LOG.assertTrue(selectedValue.isValid());
                    StaticImportMethodFix.this.doImport(selectedValue);
                    return FINAL_CHOICE;
                }
                String qname = PsiUtil.getMemberQualifiedName((PsiMember)selectedValue);
                if (qname == null) {
                    return FINAL_CHOICE;
                }
                List<String> excludableStrings = AddImportAction.getAllExcludableStrings(qname);
                return new BaseListPopupStep<String>(null, excludableStrings){

                    @NotNull
                    public String getTextFor(String value) {
                        String string = "Exclude '" + value + "' from auto-import";
                        if (string == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMethodFix$3$1", "getTextFor"));
                        }
                        return string;
                    }

                    public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                        if (finalChoice) {
                            AddImportAction.excludeFromImport(project, selectedValue);
                        }
                        return super.onChosen((Object)selectedValue, finalChoice);
                    }
                };
            }

            public boolean hasSubstep(PsiMethod selectedValue) {
                return true;
            }

            @NotNull
            public String getTextFor(PsiMethod value) {
                String string = (String)ObjectUtils.assertNotNull((Object)value.getName());
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMethodFix$3", "getTextFor"));
                }
                return string;
            }

            public Icon getIconFor(PsiMethod aValue) {
                return aValue.getIcon(0);
            }
        };
        ListPopupImpl popup = new ListPopupImpl((ListPopupStep)step){
            final PopupListElementRenderer rightArrow;
            {
                this.rightArrow = new PopupListElementRenderer(this);
            }

            @Override
            protected ListCellRenderer getListElementRenderer() {
                return new MethodCellRenderer(true, 1){

                    @Override
                    @Nullable
                    protected TextAttributes getNavigationItemAttributes(Object value) {
                        PsiClass psiClass;
                        TextAttributes attrs = super.getNavigationItemAttributes(value);
                        if (value instanceof PsiMethod && !((PsiMethod)value).isDeprecated() && (psiClass = ((PsiMethod)value).getContainingClass()) != null && psiClass.isDeprecated()) {
                            return TextAttributes.merge((TextAttributes)attrs, (TextAttributes)super.getNavigationItemAttributes(psiClass));
                        }
                        return attrs;
                    }

                    @Override
                    protected DefaultListCellRenderer getRightCellRenderer(Object value) {
                        final DefaultListCellRenderer moduleRenderer = super.getRightCellRenderer(value);
                        return new DefaultListCellRenderer(){

                            @Override
                            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                                JPanel panel = new JPanel(new BorderLayout());
                                if (moduleRenderer != null) {
                                    Component moduleComponent = moduleRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                                    if (!isSelected) {
                                        moduleComponent.setBackground(1.getBackgroundColor(value));
                                    }
                                    panel.add(moduleComponent, "Center");
                                }
                                rightArrow.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                                JLabel rightArrowComponent = rightArrow.getNextStepLabel();
                                panel.add((Component)rightArrowComponent, "East");
                                return panel;
                            }
                        };
                    }
                };
            }
        };
        popup.showInBestPositionFor(editor);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

