/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.ReferenceData;
import com.intellij.codeInsight.editorActions.TextBlockTransferableData;
import java.awt.datatransfer.DataFlavor;
import java.io.Serializable;

public class ReferenceTransferableData
implements TextBlockTransferableData,
Cloneable,
Serializable {
    private final ReferenceData[] myReferenceDatas;

    public ReferenceTransferableData(ReferenceData[] referenceDatas) {
        this.myReferenceDatas = referenceDatas;
    }

    @Override
    public DataFlavor getFlavor() {
        return ReferenceData.getDataFlavor();
    }

    @Override
    public int getOffsetCount() {
        return this.myReferenceDatas.length * 2;
    }

    @Override
    public int getOffsets(int[] offsets, int index) {
        for (ReferenceData data2 : this.myReferenceDatas) {
            offsets[index++] = data2.startOffset;
            offsets[index++] = data2.endOffset;
        }
        return index;
    }

    @Override
    public int setOffsets(int[] offsets, int index) {
        for (ReferenceData data2 : this.myReferenceDatas) {
            data2.startOffset = offsets[index++];
            data2.endOffset = offsets[index++];
        }
        return index;
    }

    public ReferenceTransferableData clone() {
        ReferenceData[] newReferenceData = new ReferenceData[this.myReferenceDatas.length];
        for (int i = 0; i < this.myReferenceDatas.length; ++i) {
            newReferenceData[i] = (ReferenceData)this.myReferenceDatas[i].clone();
        }
        return new ReferenceTransferableData(newReferenceData);
    }

    public ReferenceData[] getData() {
        return this.myReferenceDatas;
    }
}

