/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MissingReturnExpressionFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor, PsiElement psiElement) throws IncorrectOperationException {
        PsiType returnType;
        if (!(psiElement instanceof PsiReturnStatement)) {
            return;
        }
        if (!PsiTreeUtil.hasErrorElements((PsiElement)psiElement)) {
            return;
        }
        PsiReturnStatement retStatement = (PsiReturnStatement)psiElement;
        if (MissingReturnExpressionFixer.fixMethodCallWithoutTrailingSemicolon(retStatement, editor, processor)) {
            return;
        }
        PsiExpression returnValue = retStatement.getReturnValue();
        if (returnValue != null && MissingReturnExpressionFixer.lineNumber(editor, editor.getCaretModel().getOffset()) == MissingReturnExpressionFixer.lineNumber(editor, returnValue.getTextRange().getStartOffset())) {
            return;
        }
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)psiElement, (Class[])new Class[]{PsiClassInitializer.class, PsiMethod.class});
        if (parent instanceof PsiMethod && (returnType = ((PsiMethod)parent).getReturnType()) != null && returnType != PsiType.VOID) {
            int startOffset = retStatement.getTextRange().getStartOffset();
            if (returnValue != null) {
                editor.getDocument().insertString(startOffset + "return".length(), (CharSequence)";");
            }
            processor.registerUnresolvedError(startOffset + "return".length());
        }
    }

    private static boolean fixMethodCallWithoutTrailingSemicolon(@Nullable PsiReturnStatement returnStatement, @NotNull Editor editor, @NotNull JavaSmartEnterProcessor processor) {
        PsiMethod method;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/smartEnter/MissingReturnExpressionFixer", "fixMethodCallWithoutTrailingSemicolon"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInsight/editorActions/smartEnter/MissingReturnExpressionFixer", "fixMethodCallWithoutTrailingSemicolon"));
        }
        if (returnStatement == null) {
            return false;
        }
        PsiElement lastChild = returnStatement.getLastChild();
        if (!(lastChild instanceof PsiErrorElement)) {
            return false;
        }
        PsiElement prev = lastChild.getPrevSibling();
        if (prev instanceof PsiWhiteSpace) {
            prev = prev.getPrevSibling();
        }
        if (!(prev instanceof PsiJavaToken)) {
            int offset = returnStatement.getTextRange().getEndOffset();
            PsiMethod method2 = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)returnStatement, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class});
            if (method2 != null && method2.getReturnType() == PsiType.VOID) {
                offset = returnStatement.getTextRange().getStartOffset() + "return".length();
            }
            editor.getDocument().insertString(offset, (CharSequence)";");
            return true;
        }
        PsiJavaToken prevToken = (PsiJavaToken)prev;
        if (prevToken.getTokenType() == JavaTokenType.SEMICOLON) {
            return false;
        }
        int offset = returnStatement.getTextRange().getEndOffset();
        editor.getDocument().insertString(offset, (CharSequence)";");
        if (prevToken.getTokenType() == JavaTokenType.RETURN_KEYWORD && (method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)returnStatement, PsiMethod.class)) != null && method.getReturnType() != PsiType.VOID) {
            editor.getCaretModel().moveToOffset(offset);
            processor.setSkipEnter(true);
        }
        return true;
    }

    private static int lineNumber(Editor editor, int offset) {
        return editor.getDocument().getLineNumber(offset);
    }
}

