/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionModuleNode;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionPackageNode;
import com.intellij.codeInspection.ui.InspectionResultsViewComparator;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Function;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionRVContentProvider {
    private static final Logger LOG = Logger.getInstance((String)("#" + InspectionRVContentProvider.class.getName()));
    private final Project myProject;

    public InspectionRVContentProvider(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/InspectionRVContentProvider", "<init>"));
        }
        this.myProject = project;
    }

    public abstract boolean checkReportedProblems(@NotNull GlobalInspectionContextImpl var1, @NotNull InspectionToolWrapper var2);

    public boolean hasQuickFixes(InspectionTree tree) {
        TreePath[] treePaths = tree.getSelectionPaths();
        if (treePaths == null) {
            return false;
        }
        for (TreePath selectionPath : treePaths) {
            if (TreeUtil.traverseDepth((TreeNode)((TreeNode)selectionPath.getLastPathComponent()), (TreeUtil.Traverse)new TreeUtil.Traverse(){

                public boolean accept(Object node) {
                    if (!((InspectionTreeNode)node).isValid()) {
                        return true;
                    }
                    if (node instanceof ProblemDescriptionNode) {
                        CommonProblemDescriptor descriptor = ((ProblemDescriptionNode)node).getDescriptor();
                        QuickFix[] fixes = descriptor != null ? descriptor.getFixes() : null;
                        return fixes == null || fixes.length == 0;
                    }
                    return true;
                }
            })) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public abstract QuickFixAction[] getQuickFixes(@NotNull InspectionToolWrapper var1, @NotNull InspectionTree var2);

    public void appendToolNodeContent(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionNode toolNode, @NotNull InspectionTreeNode parentNode, boolean showStructure) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/ex/InspectionRVContentProvider", "appendToolNodeContent"));
        }
        if (toolNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolNode", "com/intellij/codeInspection/ex/InspectionRVContentProvider", "appendToolNodeContent"));
        }
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "com/intellij/codeInspection/ex/InspectionRVContentProvider", "appendToolNodeContent"));
        }
        InspectionToolWrapper wrapper = toolNode.getToolWrapper();
        InspectionToolPresentation presentation = context.getPresentation(wrapper);
        Map<String, Set<RefEntity>> content = presentation.getContent();
        Map<RefEntity, CommonProblemDescriptor[]> problems = presentation.getProblemElements();
        this.appendToolNodeContent(context, toolNode, parentNode, showStructure, content, problems, null);
    }

    public abstract void appendToolNodeContent(@NotNull GlobalInspectionContextImpl var1, @NotNull InspectionNode var2, @NotNull InspectionTreeNode var3, boolean var4, @NotNull Map<String, Set<RefEntity>> var5, @NotNull Map<RefEntity, CommonProblemDescriptor[]> var6, @Nullable DefaultTreeModel var7);

    protected abstract void appendDescriptor(@NotNull GlobalInspectionContextImpl var1, @NotNull InspectionToolWrapper var2, @NotNull UserObjectContainer var3, @NotNull InspectionPackageNode var4, boolean var5);

    public boolean isContentLoaded() {
        return true;
    }

    protected <T> List<InspectionTreeNode> buildTree(@NotNull GlobalInspectionContextImpl context, @NotNull Map<String, Set<T>> packageContents, boolean canPackageRepeat, @NotNull InspectionToolWrapper toolWrapper, @NotNull Function<T, UserObjectContainer<T>> computeContainer, boolean showStructure) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/ex/InspectionRVContentProvider", "buildTree"));
        }
        if (packageContents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageContents", "com/intellij/codeInspection/ex/InspectionRVContentProvider", "buildTree"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/InspectionRVContentProvider", "buildTree"));
        }
        if (computeContainer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computeContainer", "com/intellij/codeInspection/ex/InspectionRVContentProvider", "buildTree"));
        }
        ArrayList<InspectionTreeNode> content = new ArrayList<InspectionTreeNode>();
        HashMap module2PackageMap = new HashMap();
        boolean supportStructure = showStructure;
        for (String string : packageContents.keySet()) {
            Set<T> elements = packageContents.get(string);
            for (Object userObject : elements) {
                InspectionPackageNode pNode;
                UserObjectContainer container = (UserObjectContainer)computeContainer.fun(userObject);
                supportStructure &= container.supportStructure();
                String moduleName = showStructure ? container.getModule() : null;
                HashMap<String, InspectionPackageNode> packageNodes = (HashMap<String, InspectionPackageNode>)module2PackageMap.get(moduleName);
                if (packageNodes == null) {
                    packageNodes = new HashMap<String, InspectionPackageNode>();
                    module2PackageMap.put(moduleName, packageNodes);
                }
                if ((pNode = (InspectionPackageNode)packageNodes.get(string)) == null) {
                    pNode = new InspectionPackageNode(string);
                    packageNodes.put(string, pNode);
                }
                this.appendDescriptor(context, toolWrapper, container, pNode, canPackageRepeat);
            }
        }
        if (supportStructure) {
            HashMap<String, InspectionModuleNode> moduleNodes = new HashMap<String, InspectionModuleNode>();
            block2: for (String moduleName : module2PackageMap.keySet()) {
                Map packageNodes = (Map)module2PackageMap.get(moduleName);
                for (InspectionPackageNode packageNode : packageNodes.values()) {
                    if (packageNode.getChildCount() <= 0) continue;
                    InspectionModuleNode moduleNode = (InspectionModuleNode)moduleNodes.get(moduleName);
                    if (moduleNode == null) {
                        if (moduleName != null) {
                            Module module = ModuleManager.getInstance((Project)this.myProject).findModuleByName(moduleName);
                            if (module == null) continue;
                            moduleNode = new InspectionModuleNode(module);
                            moduleNodes.put(moduleName, moduleNode);
                        } else {
                            content.addAll(packageNodes.values());
                            continue block2;
                        }
                    }
                    if (packageNode.getPackageName() != null) {
                        moduleNode.add(packageNode);
                        continue;
                    }
                    for (int i = packageNode.getChildCount() - 1; i >= 0; --i) {
                        moduleNode.add((MutableTreeNode)packageNode.getChildAt(i));
                    }
                }
            }
            content.addAll(moduleNodes.values());
        } else {
            for (Map map : module2PackageMap.values()) {
                block6: for (InspectionPackageNode pNode : map.values()) {
                    for (int i = 0; i < pNode.getChildCount(); ++i) {
                        TreeNode childNode = pNode.getChildAt(i);
                        if (childNode instanceof ProblemDescriptionNode) {
                            content.add(pNode);
                            continue block6;
                        }
                        LOG.assertTrue(childNode instanceof RefElementNode, (Object)childNode.getClass().getName());
                        RefElementNode elementNode = (RefElementNode)childNode;
                        LinkedHashSet<RefElementNode> parentNodes = new LinkedHashSet<RefElementNode>();
                        if (pNode.getPackageName() != null) {
                            parentNodes.add(elementNode);
                        } else {
                            boolean hasElementNodeUnder = true;
                            for (int e = 0; e < elementNode.getChildCount(); ++e) {
                                TreeNode grandChildNode = elementNode.getChildAt(e);
                                if (grandChildNode instanceof ProblemDescriptionNode) {
                                    hasElementNodeUnder = false;
                                    break;
                                }
                                LOG.assertTrue(grandChildNode instanceof RefElementNode);
                                parentNodes.add((RefElementNode)grandChildNode);
                            }
                            if (!hasElementNodeUnder) {
                                content.add(elementNode);
                                continue;
                            }
                        }
                        for (RefElementNode parentNode : parentNodes) {
                            final ArrayList nodes = new ArrayList();
                            TreeUtil.traverse((TreeNode)parentNode, (TreeUtil.Traverse)new TreeUtil.Traverse(){

                                public boolean accept(Object node) {
                                    if (node instanceof ProblemDescriptionNode) {
                                        nodes.add((ProblemDescriptionNode)node);
                                    }
                                    return true;
                                }
                            });
                            if (nodes.isEmpty()) continue;
                            parentNode.removeAllChildren();
                            for (ProblemDescriptionNode node : nodes) {
                                parentNode.add(node);
                            }
                        }
                        content.addAll(parentNodes);
                    }
                }
            }
        }
        return content;
    }

    @NotNull
    protected static RefElementNode addNodeToParent(@NotNull UserObjectContainer container, @NotNull InspectionToolPresentation presentation, InspectionTreeNode parentNode) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/codeInspection/ex/InspectionRVContentProvider", "addNodeToParent"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/codeInspection/ex/InspectionRVContentProvider", "addNodeToParent"));
        }
        final RefElementNode nodeToBeAdded = container.createNode(presentation);
        final Ref firstLevel = new Ref((Object)true);
        RefElementNode prevNode = null;
        final Ref result = new Ref();
        while (true) {
            UserObjectContainer owner;
            RefElementNode currentNode = (Boolean)firstLevel.get() != false ? nodeToBeAdded : container.createNode(presentation);
            final UserObjectContainer finalContainer = container;
            final RefElementNode finalPrevNode = prevNode;
            TreeUtil.traverseDepth((TreeNode)parentNode, (TreeUtil.Traverse)new TreeUtil.Traverse(){

                public boolean accept(Object node) {
                    if (node instanceof RefElementNode) {
                        RefElementNode refElementNode = (RefElementNode)node;
                        Object userObject = finalContainer.getUserObject();
                        Object object = refElementNode.getUserObject();
                        if ((object == null || userObject.getClass().equals(object.getClass())) && finalContainer.areEqual(object, userObject)) {
                            if (((Boolean)firstLevel.get()).booleanValue()) {
                                result.set((Object)refElementNode);
                                return false;
                            }
                            InspectionRVContentProvider.insertByIndex(finalPrevNode, refElementNode);
                            result.set((Object)nodeToBeAdded);
                            return false;
                        }
                    }
                    return true;
                }
            });
            if (!result.isNull()) {
                RefElementNode refElementNode = (RefElementNode)result.get();
                if (refElementNode == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionRVContentProvider", "addNodeToParent"));
                }
                return refElementNode;
            }
            if (!((Boolean)firstLevel.get()).booleanValue()) {
                InspectionRVContentProvider.insertByIndex(prevNode, currentNode);
            }
            if ((owner = container.getOwner()) == null) {
                InspectionRVContentProvider.insertByIndex(currentNode, parentNode);
                RefElementNode refElementNode = nodeToBeAdded;
                if (refElementNode == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionRVContentProvider", "addNodeToParent"));
                }
                return refElementNode;
            }
            container = owner;
            prevNode = currentNode;
            firstLevel.set((Object)false);
        }
    }

    protected static void merge(@Nullable DefaultTreeModel model, InspectionTreeNode child, InspectionTreeNode parent, boolean merge) {
        if (merge) {
            for (int i = 0; i < parent.getChildCount(); ++i) {
                InspectionTreeNode current = (InspectionTreeNode)parent.getChildAt(i);
                if (child.getClass() != current.getClass()) continue;
                if (current instanceof InspectionPackageNode) {
                    if (((InspectionPackageNode)current).getPackageName().compareTo(((InspectionPackageNode)child).getPackageName()) != 0) continue;
                    InspectionRVContentProvider.processDepth(model, child, current);
                    return;
                }
                if (current instanceof RefElementNode) {
                    if (((RefElementNode)current).getElement().getName().compareTo(((RefElementNode)child).getElement().getName()) != 0) continue;
                    InspectionRVContentProvider.processDepth(model, child, current);
                    return;
                }
                if (current instanceof InspectionNode) {
                    if (((InspectionNode)current).getToolWrapper().getShortName().compareTo(((InspectionNode)child).getToolWrapper().getShortName()) != 0) continue;
                    InspectionRVContentProvider.processDepth(model, child, current);
                    return;
                }
                if (!(current instanceof InspectionModuleNode) || ((InspectionModuleNode)current).getName().compareTo(((InspectionModuleNode)child).getName()) != 0) continue;
                InspectionRVContentProvider.processDepth(model, child, current);
                return;
            }
        }
        InspectionRVContentProvider.add(model, child, parent);
    }

    protected static void add(@Nullable DefaultTreeModel model, InspectionTreeNode child, InspectionTreeNode parent) {
        if (model == null) {
            InspectionRVContentProvider.insertByIndex(child, parent);
        } else if (parent.getIndex(child) < 0) {
            model.insertNodeInto(child, parent, child.getParent() == parent ? parent.getChildCount() - 1 : parent.getChildCount());
        }
    }

    private static void insertByIndex(InspectionTreeNode child, InspectionTreeNode parent) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            parent.add(child);
            return;
        }
        int i = TreeUtil.indexedBinarySearch((TreeNode)parent, (TreeNode)child, (Comparator)InspectionResultsViewComparator.getInstance());
        if (i >= 0) {
            parent.add(child);
            return;
        }
        parent.insert(child, -i - 1);
    }

    private static void processDepth(@Nullable DefaultTreeModel model, InspectionTreeNode child, InspectionTreeNode current) {
        InspectionTreeNode[] children = new InspectionTreeNode[child.getChildCount()];
        for (int i = 0; i < children.length; ++i) {
            children[i] = (InspectionTreeNode)child.getChildAt(i);
        }
        for (InspectionTreeNode node : children) {
            InspectionRVContentProvider.merge(model, node, current, true);
        }
    }

    protected static interface UserObjectContainer<T> {
        @Nullable
        public UserObjectContainer<T> getOwner();

        @NotNull
        public RefElementNode createNode(@NotNull InspectionToolPresentation var1);

        @NotNull
        public T getUserObject();

        @Nullable
        public String getModule();

        public boolean areEqual(T var1, T var2);

        public boolean supportStructure();
    }
}

